-- MySQL dump 10.13  Distrib 8.4.4, for macos15 (arm64)
--
-- Host: 127.0.0.1    Database: ninico
-- ------------------------------------------------------
-- Server version	8.4.4

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'H5IV1hEPoQQS4weLJ1UQye5SSkZDqdXJ',1,'2025-11-18 21:22:33','2025-11-18 21:22:33','2025-11-18 21:22:33');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ads_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_adsense_slot_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
INSERT INTO `ads` VALUES (1,'New Modern & Stylist <br> Crafts','2030-11-19 04:22:41',NULL,'IYHICPADQD5X','sliders/banner-slider-01.jpg','/products',0,1,'published','2025-11-18 21:22:41','2025-11-18 21:22:41',1,NULL,NULL,NULL,NULL),(2,'Popular Energy with our <br> newest collection','2029-11-19 04:22:41',NULL,'R4YAV9FECJUS','sliders/banner-slider-02.jpg','/products',0,2,'published','2025-11-18 21:22:41','2025-11-18 21:22:41',1,NULL,NULL,NULL,NULL),(3,'Winter <br> Exclusive In','2030-11-19 04:22:41',NULL,'QPTCBJBOJOSY','banners/banner-offer-01.jpg','/products',0,3,'published','2025-11-18 21:22:41','2025-11-18 21:22:41',1,NULL,NULL,NULL,NULL),(4,'50% Offer','2029-11-19 04:22:41',NULL,'T2VFLDYYIJEH','banners/banner-offer-02.jpg','/products',0,4,'published','2025-11-18 21:22:41','2025-11-18 21:22:41',1,NULL,NULL,NULL,NULL),(5,'New Modern & Stylist <br> Crafts','2027-11-19 04:22:41',NULL,'JO7LLJHFH1RO','banners/banner-03-01.jpg','/products',0,5,'published','2025-11-18 21:22:41','2025-11-18 21:22:41',1,NULL,NULL,NULL,NULL),(6,'Lamp <br> Collections','2026-11-19 04:22:41',NULL,'L8GDJUBVD2TQ','banners/banner-03-02.jpg','/products',0,6,'published','2025-11-18 21:22:41','2025-11-18 21:22:41',1,NULL,NULL,NULL,NULL),(7,'Minimal Chair','2027-11-19 04:22:41',NULL,'PXJPAXLOCVRS','banners/banner-03-03.jpg','/products',0,7,'published','2025-11-18 21:22:41','2025-11-18 21:22:41',1,NULL,NULL,NULL,NULL),(8,'100% Fresh Product <br> Every Hour','2030-11-19 04:22:41',NULL,'EMRCINED6AX9','sliders/slider-05-banner-1.jpg','/products',0,8,'published','2025-11-18 21:22:41','2025-11-18 21:22:41',1,NULL,NULL,NULL,NULL),(9,'100% Fresh Product <br> Every Hour','2030-11-19 04:22:41',NULL,'JVMDAIB9HO2I','sliders/slider-05-banner-1.jpg','/products',0,9,'published','2025-11-18 21:22:41','2025-11-18 21:22:41',1,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','<strong>Welcome to our international shop! Enjoy free shipping on orders $100 & up</strong>',1,'Shop now','/',0,1,'2025-11-19 04:23:06',NULL,1,'2025-11-18 21:23:06','2025-11-18 21:23:06'),(2,'Announcement 2','<strong>Trendy 25 silver jewelry, save up 35% off today</strong>',1,'Shop now','/',0,1,'2025-11-19 04:23:06',NULL,1,'2025-11-18 21:23:06','2025-11-18 21:23:06'),(3,'Announcement 3','<strong>Black Friday and Cyber Monday 2023 Deals for Motion Designers, grab it now!</strong>',1,'Shop now','/',0,1,'2025-11-19 04:23:06',NULL,1,'2025-11-18 21:23:06','2025-11-18 21:23:06');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Ecommerce',0,'Saepe consectetur occaecati neque aut in repudiandae. Ipsa neque aut qui quod veritatis voluptatem eum.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2025-11-18 21:22:36','2025-11-18 21:22:36'),(2,'Fashion',0,'Reiciendis veniam qui sunt commodi. Ea laudantium totam non esse nesciunt fugit quasi. Vel rerum dolor debitis quam debitis quod laudantium. Placeat qui odit velit in.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-18 21:22:36','2025-11-18 21:22:36'),(3,'Electronic',0,'Officia aspernatur officiis omnis fugiat eum. Illum rem amet fugiat. Qui est est quibusdam molestiae quam. Quam laudantium minus possimus delectus.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-18 21:22:36','2025-11-18 21:22:36'),(4,'Commercial',0,'Qui aperiam voluptas tempore excepturi sunt architecto. Qui vel ut eaque error ducimus commodi ea. Recusandae amet dicta laborum tempora illo. Ex aspernatur voluptatibus ea ex.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-11-18 21:22:36','2025-11-18 21:22:36');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`),
  KEY `idx_cities_name` (`name`),
  KEY `idx_cities_state_status` (`state_id`,`status`),
  KEY `idx_cities_status` (`status`),
  KEY `idx_cities_state_id` (`state_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`),
  KEY `idx_cities_trans_city_lang` (`cities_id`,`lang_code`),
  KEY `idx_cities_trans_name` (`name`),
  KEY `idx_cities_trans_cities_id` (`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_countries_name` (`name`),
  KEY `idx_countries_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`),
  KEY `idx_countries_trans_country_lang` (`countries_id`,`lang_code`),
  KEY `idx_countries_trans_name` (`name`),
  KEY `idx_countries_trans_countries_id` (`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `device_tokens`
--

DROP TABLE IF EXISTS `device_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `device_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `platform` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_version` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `device_tokens_token_unique` (`token`),
  KEY `device_tokens_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `device_tokens_platform_is_active_index` (`platform`,`is_active`),
  KEY `device_tokens_is_active_index` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `device_tokens`
--

LOCK TABLES `device_tokens` WRITE;
/*!40000 ALTER TABLE `device_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `device_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_abandoned_carts`
--

DROP TABLE IF EXISTS `ec_abandoned_carts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_abandoned_carts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `session_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cart_data` json NOT NULL,
  `total_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `items_count` int NOT NULL DEFAULT '0',
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abandoned_at` timestamp NULL DEFAULT NULL,
  `reminder_sent_at` timestamp NULL DEFAULT NULL,
  `reminders_sent` int NOT NULL DEFAULT '0',
  `is_recovered` tinyint(1) NOT NULL DEFAULT '0',
  `recovered_at` timestamp NULL DEFAULT NULL,
  `recovered_order_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_abandoned_carts_abandoned_at_is_recovered_index` (`abandoned_at`,`is_recovered`),
  KEY `ec_abandoned_carts_created_at_is_recovered_index` (`created_at`,`is_recovered`),
  KEY `ec_abandoned_carts_customer_id_index` (`customer_id`),
  KEY `ec_abandoned_carts_session_id_index` (`session_id`),
  KEY `ec_abandoned_carts_email_index` (`email`),
  KEY `ec_abandoned_carts_recovered_order_id_index` (`recovered_order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_abandoned_carts`
--

LOCK TABLES `ec_abandoned_carts` WRITE;
/*!40000 ALTER TABLE `ec_abandoned_carts` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_abandoned_carts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands`
--

DROP TABLE IF EXISTS `ec_brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands`
--

LOCK TABLES `ec_brands` WRITE;
/*!40000 ALTER TABLE `ec_brands` DISABLE KEYS */;
INSERT INTO `ec_brands` VALUES (1,'Fashion live',NULL,NULL,'brands/brand-01.png','published',0,0,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(2,'Hand crafted',NULL,NULL,'brands/brand-02.png','published',1,1,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(3,'Mestonix',NULL,NULL,'brands/brand-03.png','published',2,1,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(4,'Sunshine',NULL,NULL,'brands/brand-04.png','published',3,0,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(5,'Pure',NULL,NULL,'brands/brand-05.png','published',4,1,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(6,'Anfold',NULL,NULL,'brands/brand-06.png','published',5,0,'2025-11-18 21:22:42','2025-11-18 21:22:42');
/*!40000 ALTER TABLE `ec_brands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands_translations`
--

DROP TABLE IF EXISTS `ec_brands_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_brands_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_brands_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands_translations`
--

LOCK TABLES `ec_brands_translations` WRITE;
/*!40000 ALTER TABLE `ec_brands_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_brands_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_cart`
--

DROP TABLE IF EXISTS `ec_cart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_cart` (
  `identifier` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `instance` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`identifier`,`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_cart`
--

LOCK TABLES `ec_cart` WRITE;
/*!40000 ALTER TABLE `ec_cart` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_cart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_currencies`
--

DROP TABLE IF EXISTS `ec_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned DEFAULT '0',
  `number_format_style` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'western',
  `space_between_price_and_currency` tinyint(1) NOT NULL DEFAULT '0',
  `order` int unsigned DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_currencies`
--

LOCK TABLES `ec_currencies` WRITE;
/*!40000 ALTER TABLE `ec_currencies` DISABLE KEYS */;
INSERT INTO `ec_currencies` VALUES (1,'USD','$',1,2,'western',0,0,1,1,'2025-11-18 21:22:33','2025-11-18 21:22:33'),(2,'EUR','€',0,2,'western',0,1,0,0.84,'2025-11-18 21:22:33','2025-11-18 21:22:33'),(3,'VND','₫',0,0,'western',0,2,0,23203,'2025-11-18 21:22:33','2025-11-18 21:22:33'),(4,'NGN','₦',1,2,'western',0,2,0,895.52,'2025-11-18 21:22:33','2025-11-18 21:22:33');
/*!40000 ALTER TABLE `ec_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_addresses`
--

DROP TABLE IF EXISTS `ec_customer_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_addresses`
--

LOCK TABLES `ec_customer_addresses` WRITE;
/*!40000 ALTER TABLE `ec_customer_addresses` DISABLE KEYS */;
INSERT INTO `ec_customer_addresses` VALUES (1,'Blake Glover','customer@botble.com','+12105720444','BT','Massachusetts','Gonzalofurt','376 Lemke Loaf Suite 242',1,1,'2025-11-18 21:23:00','2025-11-18 21:23:00','91165-1909'),(2,'Blake Glover','customer@botble.com','+14639198265','AO','South Dakota','Margaretemouth','93242 Ward Bridge',1,0,'2025-11-18 21:23:00','2025-11-18 21:23:00','80535-6124'),(3,'Tina Bahringer MD','john.smith@botble.com','+19862664289','VC','Utah','North Antonetta','686 Torp Walk',2,1,'2025-11-18 21:23:01','2025-11-18 21:23:01','06885-6038'),(4,'Tina Bahringer MD','john.smith@botble.com','+19545975057','GA','Rhode Island','Wisozkside','528 Carleton Walk',2,0,'2025-11-18 21:23:01','2025-11-18 21:23:01','76463-6780'),(5,'Prof. Maurice Zieme DDS','marcos45@example.org','+15077649454','ZA','West Virginia','Hermistonton','6444 Whitney Mountain',3,1,'2025-11-18 21:23:01','2025-11-18 21:23:01','43425-0713'),(6,'Miss Ashley Little V','croberts@example.org','+14808182704','GL','Connecticut','West Santosshire','7954 Jackeline Rapid',4,1,'2025-11-18 21:23:01','2025-11-18 21:23:01','22126-6301'),(7,'Forest Jacobson','shemar04@example.org','+18146283963','GE','New Hampshire','Reynoldsberg','8722 Ankunding Cliffs',5,1,'2025-11-18 21:23:01','2025-11-18 21:23:01','90007-1810'),(8,'Davin Mayert','harber.audie@example.net','+17407652586','MM','Oregon','Trompton','93313 Bayer Island',6,1,'2025-11-18 21:23:02','2025-11-18 21:23:02','70081-1626'),(9,'Jorge Murphy PhD','grady.kody@example.com','+13418970781','TL','Arkansas','Dewayneland','2261 Barton Highway',7,1,'2025-11-18 21:23:02','2025-11-18 21:23:02','83475-9096'),(10,'Prof. Heath Abbott II','hilton36@example.com','+13132464608','FI','Illinois','West Winfield','21530 Darrick Cliff',8,1,'2025-11-18 21:23:02','2025-11-18 21:23:02','44231'),(11,'Prof. Giovanna Langosh','pkovacek@example.com','+14589180088','GL','Arizona','South Bell','580 Schaden Manor Apt. 654',9,1,'2025-11-18 21:23:02','2025-11-18 21:23:02','78286'),(12,'Cynthia Gleichner','wendy35@example.net','+12163752193','EH','Colorado','Zulaufmouth','91234 Gerald Cliff Suite 009',10,1,'2025-11-18 21:23:02','2025-11-18 21:23:02','39498');
/*!40000 ALTER TABLE `ec_customer_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_deletion_requests`
--

DROP TABLE IF EXISTS `ec_customer_deletion_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_deletion_requests` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `verification_code` varchar(6) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_expires_at` timestamp NULL DEFAULT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'waiting_for_confirmation',
  `reason` text COLLATE utf8mb4_unicode_ci,
  `confirmed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_customer_deletion_requests_token_unique` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_deletion_requests`
--

LOCK TABLES `ec_customer_deletion_requests` WRITE;
/*!40000 ALTER TABLE `ec_customer_deletion_requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_deletion_requests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_password_resets`
--

DROP TABLE IF EXISTS `ec_customer_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `ec_customer_password_resets_email_index` (`email`),
  KEY `ec_customer_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_password_resets`
--

LOCK TABLES `ec_customer_password_resets` WRITE;
/*!40000 ALTER TABLE `ec_customer_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_recently_viewed_products`
--

DROP TABLE IF EXISTS `ec_customer_recently_viewed_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_recently_viewed_products` (
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`customer_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_recently_viewed_products`
--

LOCK TABLES `ec_customer_recently_viewed_products` WRITE;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_used_coupons`
--

DROP TABLE IF EXISTS `ec_customer_used_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_used_coupons` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_used_coupons`
--

LOCK TABLES `ec_customer_used_coupons` WRITE;
/*!40000 ALTER TABLE `ec_customer_used_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_used_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customers`
--

DROP TABLE IF EXISTS `ec_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `private_notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customers`
--

LOCK TABLES `ec_customers` WRITE;
/*!40000 ALTER TABLE `ec_customers` DISABLE KEYS */;
INSERT INTO `ec_customers` VALUES (1,'Blake Glover','customer@botble.com','$2y$12$UuKf.mfRjD.qRW98SwNffOYRYb3/HxGAkOwynW7X6F/RTDD81BaW2','customers/3.jpg','1976-10-24','+17084743900',NULL,'2025-11-18 21:23:00','2025-11-18 21:23:00','2025-11-19 04:23:00',NULL,'activated',NULL),(2,'Tina Bahringer MD','john.smith@botble.com','$2y$12$tHUleUEailinQsncKtjZseATOajCiMNnYSpF/..C4xheN3sfAKDM2','customers/6.jpg','1991-11-05','+16014601516',NULL,'2025-11-18 21:23:01','2025-11-18 21:23:01','2025-11-19 04:23:01',NULL,'activated',NULL),(3,'Prof. Maurice Zieme DDS','marcos45@example.org','$2y$12$sgS/KoJAA8xLy3fjdzr8FeF0gs9WodbqG9zPRYalKLa/5Fy1w7yPK','customers/1.jpg','1986-11-09','+18179199576',NULL,'2025-11-18 21:23:01','2025-11-18 21:23:01','2025-11-19 04:23:01',NULL,'activated',NULL),(4,'Miss Ashley Little V','croberts@example.org','$2y$12$N51RRJbm9r5ooA.QOAGOrOmHhvTMgpizrHCVxqbMMVmiSHzZCcpaC','customers/2.jpg','1998-11-10','+19597806886',NULL,'2025-11-18 21:23:01','2025-11-18 21:23:01','2025-11-19 04:23:01',NULL,'activated',NULL),(5,'Forest Jacobson','shemar04@example.org','$2y$12$2vqhnqjEvWwMNvc2evwp2Ov2KbrOvoUiy8wPMVEvYRVlXcV2LWMQC','customers/3.jpg','1979-11-09','+16163853278',NULL,'2025-11-18 21:23:01','2025-11-18 21:23:01','2025-11-19 04:23:01',NULL,'activated',NULL),(6,'Davin Mayert','harber.audie@example.net','$2y$12$zArgZ1MqK97Wy2o/8rivT.9UIiuc1rkVBHcz3YM5BAQihtDQuMQsa','customers/4.jpg','1985-11-04','+19363294252',NULL,'2025-11-18 21:23:02','2025-11-18 21:23:02','2025-11-19 04:23:02',NULL,'activated',NULL),(7,'Jorge Murphy PhD','grady.kody@example.com','$2y$12$mI5N.B8AutuOf11ciLzafOE/bbU3Shc5vYxIGARKNALZf41xua6QK','customers/5.jpg','1980-11-08','+14807641257',NULL,'2025-11-18 21:23:02','2025-11-18 21:23:02','2025-11-19 04:23:02',NULL,'activated',NULL),(8,'Prof. Heath Abbott II','hilton36@example.com','$2y$12$3ACx.pmegRDAiklsN9gzjOK7u1FFJZEJYqz8SIG1gFUv0.SRq.gvi','customers/6.jpg','1993-10-29','+16828156552',NULL,'2025-11-18 21:23:02','2025-11-18 21:23:02','2025-11-19 04:23:02',NULL,'activated',NULL),(9,'Prof. Giovanna Langosh','pkovacek@example.com','$2y$12$8Eqa8lqUf8U/d.ysPqZJBOPT3SAgrw2rCz3rlU/WRZS6/P8zFEOg6','customers/7.jpg','1993-11-10','+16787191559',NULL,'2025-11-18 21:23:02','2025-11-18 21:23:02','2025-11-19 04:23:02',NULL,'activated',NULL),(10,'Cynthia Gleichner','wendy35@example.net','$2y$12$sR71e1rZhrCepOVcgm3QnOjkBN4yibyILVK5ZsdIJptfpQeJqdu8m','customers/8.jpg','1982-10-29','+13527127026',NULL,'2025-11-18 21:23:02','2025-11-18 21:23:02','2025-11-19 04:23:02',NULL,'activated',NULL);
/*!40000 ALTER TABLE `ec_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_customers`
--

DROP TABLE IF EXISTS `ec_discount_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_customers` (
  `discount_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_customers`
--

LOCK TABLES `ec_discount_customers` WRITE;
/*!40000 ALTER TABLE `ec_discount_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_categories`
--

DROP TABLE IF EXISTS `ec_discount_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_categories` (
  `discount_id` bigint unsigned NOT NULL,
  `product_category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_categories`
--

LOCK TABLES `ec_discount_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_collections`
--

DROP TABLE IF EXISTS `ec_discount_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_collections` (
  `discount_id` bigint unsigned NOT NULL,
  `product_collection_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_collection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_collections`
--

LOCK TABLES `ec_discount_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_collections` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_products`
--

DROP TABLE IF EXISTS `ec_discount_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_products` (
  `discount_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_products`
--

LOCK TABLES `ec_discount_products` WRITE;
/*!40000 ALTER TABLE `ec_discount_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discounts`
--

DROP TABLE IF EXISTS `ec_discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `value` double DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'coupon',
  `can_use_with_promotion` tinyint(1) NOT NULL DEFAULT '0',
  `can_use_with_flash_sale` tinyint(1) NOT NULL DEFAULT '0',
  `discount_on` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_quantity` int unsigned DEFAULT NULL,
  `type_option` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'amount',
  `target` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'all-orders',
  `min_order_price` decimal(15,2) DEFAULT NULL,
  `apply_via_url` tinyint(1) NOT NULL DEFAULT '0',
  `display_at_checkout` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_discounts_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discounts`
--

LOCK TABLES `ec_discounts` WRITE;
/*!40000 ALTER TABLE `ec_discounts` DISABLE KEYS */;
INSERT INTO `ec_discounts` VALUES (1,'Discount 1','XHUJKFADN0RW','2025-11-18 04:23:05','2025-12-05 04:23:05',NULL,0,771,'coupon',0,0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(2,'Discount 2','XZCZZXAAXWSL','2025-11-18 04:23:05','2025-11-26 04:23:05',NULL,0,679,'coupon',0,0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(3,'Discount 3','NZBT6QTIFN3G','2025-11-18 04:23:05',NULL,NULL,0,50,'coupon',0,0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(4,'Discount 4','ZONJJ7BDUZVQ','2025-11-18 04:23:05','2025-12-19 04:23:05',NULL,0,47,'coupon',0,0,NULL,NULL,'amount','all-orders',NULL,0,1,'2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(5,'Discount 5','4PALMDTAHZYD','2025-11-18 04:23:05',NULL,NULL,0,621,'coupon',0,0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(6,'Discount 6','YAIPW50C3EFX','2025-11-18 04:23:05','2025-12-16 04:23:05',NULL,0,9,'coupon',0,0,NULL,NULL,'percentage','all-orders',NULL,0,1,'2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(7,'Discount 7','J8UDRNWJONK4','2025-11-18 04:23:05','2025-12-04 04:23:05',NULL,0,915,'coupon',0,0,NULL,NULL,'amount','all-orders',NULL,0,1,'2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(8,'Discount 8','MQXLSQVJC1VP','2025-11-18 04:23:05',NULL,NULL,0,62,'coupon',0,0,NULL,NULL,'shipping','all-orders',NULL,0,1,'2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(9,'Discount 9','GDXKDFDLA0A0','2025-11-18 04:23:05','2025-12-06 04:23:05',NULL,0,849,'coupon',0,0,NULL,NULL,'same-price','all-orders',NULL,0,1,'2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(10,'Discount 10','EB1AVSPBJTKQ','2025-11-18 04:23:05','2025-12-15 04:23:05',NULL,0,624,'coupon',0,0,NULL,NULL,'amount','all-orders',NULL,0,1,'2025-11-18 21:23:05','2025-11-18 21:23:05',NULL);
/*!40000 ALTER TABLE `ec_discounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sale_products`
--

DROP TABLE IF EXISTS `ec_flash_sale_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sale_products` (
  `flash_sale_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `price` double unsigned DEFAULT NULL,
  `quantity` int unsigned DEFAULT NULL,
  `sold` int unsigned NOT NULL DEFAULT '0',
  KEY `ec_flash_sale_products_product_id_flash_sale_id_index` (`product_id`,`flash_sale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sale_products`
--

LOCK TABLES `ec_flash_sale_products` WRITE;
/*!40000 ALTER TABLE `ec_flash_sale_products` DISABLE KEYS */;
INSERT INTO `ec_flash_sale_products` VALUES (1,1,131.01,13,5),(1,2,127.28,11,5),(1,3,387.2,18,2),(1,4,120.7552,16,2),(1,5,142.2,15,4),(1,6,218.29,11,3),(1,7,242.56,13,2),(1,8,342.1338,13,2),(1,9,194.02,19,4),(1,10,233.22,7,3),(2,1,100,10,5);
/*!40000 ALTER TABLE `ec_flash_sale_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales`
--

DROP TABLE IF EXISTS `ec_flash_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `end_date` datetime NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales`
--

LOCK TABLES `ec_flash_sales` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales` DISABLE KEYS */;
INSERT INTO `ec_flash_sales` VALUES (1,'Winter Sale','2026-03-15 00:00:00','published','2025-11-18 21:23:05','2025-11-18 21:23:05'),(2,'Cosmetics Sale','2026-07-12 00:00:00','published','2025-11-18 21:23:05','2025-11-18 21:23:05');
/*!40000 ALTER TABLE `ec_flash_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales_translations`
--

DROP TABLE IF EXISTS `ec_flash_sales_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_flash_sales_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_flash_sales_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales_translations`
--

LOCK TABLES `ec_flash_sales_translations` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_flash_sales_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value`
--

DROP TABLE IF EXISTS `ec_global_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value`
--

LOCK TABLES `ec_global_option_value` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value` DISABLE KEYS */;
INSERT INTO `ec_global_option_value` VALUES (1,1,'1 Year',0,9999,0,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(2,1,'2 Year',10,9999,0,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(3,1,'3 Year',20,9999,0,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(4,2,'4GB',0,9999,0,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(5,2,'8GB',10,9999,0,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(6,2,'16GB',20,9999,0,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(7,3,'Core i5',0,9999,0,'2025-11-18 21:22:43','2025-11-18 21:22:43'),(8,3,'Core i7',10,9999,0,'2025-11-18 21:22:43','2025-11-18 21:22:43'),(9,3,'Core i9',20,9999,0,'2025-11-18 21:22:43','2025-11-18 21:22:43'),(10,4,'128GB',0,9999,0,'2025-11-18 21:22:43','2025-11-18 21:22:43'),(11,4,'256GB',10,9999,0,'2025-11-18 21:22:43','2025-11-18 21:22:43'),(12,4,'512GB',20,9999,0,'2025-11-18 21:22:43','2025-11-18 21:22:43');
/*!40000 ALTER TABLE `ec_global_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value_translations`
--

DROP TABLE IF EXISTS `ec_global_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value_translations`
--

LOCK TABLES `ec_global_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options`
--

DROP TABLE IF EXISTS `ec_global_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'option type',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options`
--

LOCK TABLES `ec_global_options` WRITE;
/*!40000 ALTER TABLE `ec_global_options` DISABLE KEYS */;
INSERT INTO `ec_global_options` VALUES (1,'Warranty','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(2,'RAM','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(3,'CPU','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2025-11-18 21:22:43','2025-11-18 21:22:43'),(4,'HDD','Botble\\Ecommerce\\Option\\OptionType\\Dropdown',0,'2025-11-18 21:22:43','2025-11-18 21:22:43');
/*!40000 ALTER TABLE `ec_global_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options_translations`
--

DROP TABLE IF EXISTS `ec_global_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_global_options_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_global_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options_translations`
--

LOCK TABLES `ec_global_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_global_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_global_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_grouped_products`
--

DROP TABLE IF EXISTS `ec_grouped_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_grouped_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_product_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `fixed_qty` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_grouped_products`
--

LOCK TABLES `ec_grouped_products` WRITE;
/*!40000 ALTER TABLE `ec_grouped_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_grouped_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoice_items`
--

DROP TABLE IF EXISTS `ec_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `amount` decimal(15,2) unsigned NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoice_items`
--

LOCK TABLES `ec_invoice_items` WRITE;
/*!40000 ALTER TABLE `ec_invoice_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoices`
--

DROP TABLE IF EXISTS `ec_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_zip_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_address_line` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_tax_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) DEFAULT '0.00',
  `shipping_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_invoices_code_unique` (`code`),
  KEY `ec_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `ec_invoices_payment_id_index` (`payment_id`),
  KEY `ec_invoices_status_index` (`status`),
  KEY `ec_invoices_reference_id_reference_type_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoices`
--

LOCK TABLES `ec_invoices` WRITE;
/*!40000 ALTER TABLE `ec_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value`
--

DROP TABLE IF EXISTS `ec_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_id` bigint unsigned NOT NULL COMMENT 'option id',
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value`
--

LOCK TABLES `ec_option_value` WRITE;
/*!40000 ALTER TABLE `ec_option_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value_translations`
--

DROP TABLE IF EXISTS `ec_option_value_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_option_value_id` bigint unsigned NOT NULL,
  `option_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value_translations`
--

LOCK TABLES `ec_option_value_translations` WRITE;
/*!40000 ALTER TABLE `ec_option_value_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options`
--

DROP TABLE IF EXISTS `ec_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'option type',
  `product_id` bigint unsigned NOT NULL DEFAULT '0',
  `order` int NOT NULL DEFAULT '9999',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options`
--

LOCK TABLES `ec_options` WRITE;
/*!40000 ALTER TABLE `ec_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options_translations`
--

DROP TABLE IF EXISTS `ec_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_options_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options_translations`
--

LOCK TABLES `ec_options_translations` WRITE;
/*!40000 ALTER TABLE `ec_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_addresses`
--

DROP TABLE IF EXISTS `ec_order_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'shipping_address',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_order_addresses_order_id_type_unique` (`order_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_addresses`
--

LOCK TABLES `ec_order_addresses` WRITE;
/*!40000 ALTER TABLE `ec_order_addresses` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_histories`
--

DROP TABLE IF EXISTS `ec_order_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL,
  `extras` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_histories`
--

LOCK TABLES `ec_order_histories` WRITE;
/*!40000 ALTER TABLE `ec_order_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_metadata`
--

DROP TABLE IF EXISTS `ec_order_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_metadata` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_metadata_order_id_meta_key_index` (`order_id`,`meta_key`),
  KEY `ec_order_metadata_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_metadata`
--

LOCK TABLES `ec_order_metadata` WRITE;
/*!40000 ALTER TABLE `ec_order_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_product`
--

DROP TABLE IF EXISTS `ec_order_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_product` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `qty` int NOT NULL,
  `price` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) DEFAULT '0.00',
  `options` text COLLATE utf8mb4_unicode_ci,
  `product_options` text COLLATE utf8mb4_unicode_ci COMMENT 'product option data',
  `product_id` bigint unsigned DEFAULT NULL,
  `product_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` double DEFAULT '0',
  `restock_quantity` int unsigned DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'physical',
  `times_downloaded` int NOT NULL DEFAULT '0',
  `license_code` text COLLATE utf8mb4_unicode_ci,
  `downloaded_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_product_order_id_product_id_index` (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_product`
--

LOCK TABLES `ec_order_product` WRITE;
/*!40000 ALTER TABLE `ec_order_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_referrals`
--

DROP TABLE IF EXISTS `ec_order_referrals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_referrals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_page` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_params` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referral` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gclid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fclid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_campaign` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_medium` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_term` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_content` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer_url` text COLLATE utf8mb4_unicode_ci,
  `referrer_domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_referrals_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_referrals`
--

LOCK TABLES `ec_order_referrals` WRITE;
/*!40000 ALTER TABLE `ec_order_referrals` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_referrals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_return_histories`
--

DROP TABLE IF EXISTS `ec_order_return_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_return_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `order_return_id` bigint unsigned NOT NULL,
  `action` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reason` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_return_histories`
--

LOCK TABLES `ec_order_return_histories` WRITE;
/*!40000 ALTER TABLE `ec_order_return_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_return_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_return_items`
--

DROP TABLE IF EXISTS `ec_order_return_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_return_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_return_id` bigint unsigned NOT NULL COMMENT 'Order return id',
  `order_product_id` bigint unsigned NOT NULL COMMENT 'Order product id',
  `product_id` bigint unsigned NOT NULL COMMENT 'Product id',
  `product_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int NOT NULL COMMENT 'Quantity return',
  `price` decimal(15,2) NOT NULL COMMENT 'Price Product',
  `reason` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `refund_amount` decimal(12,2) DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_return_items`
--

LOCK TABLES `ec_order_return_items` WRITE;
/*!40000 ALTER TABLE `ec_order_return_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_return_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_returns`
--

DROP TABLE IF EXISTS `ec_order_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_returns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint unsigned NOT NULL COMMENT 'Order ID',
  `store_id` bigint unsigned DEFAULT NULL COMMENT 'Store ID',
  `user_id` bigint unsigned NOT NULL COMMENT 'Customer ID',
  `reason` text COLLATE utf8mb4_unicode_ci COMMENT 'Reason return order',
  `order_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Order current status',
  `return_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Return status',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_order_returns_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_returns`
--

LOCK TABLES `ec_order_returns` WRITE;
/*!40000 ALTER TABLE `ec_order_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_returns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_tax_information`
--

DROP TABLE IF EXISTS `ec_order_tax_information`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_tax_information` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `company_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_tax_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `company_email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_tax_information_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_tax_information`
--

LOCK TABLES `ec_order_tax_information` WRITE;
/*!40000 ALTER TABLE `ec_order_tax_information` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_tax_information` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_orders`
--

DROP TABLE IF EXISTS `ec_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) DEFAULT '0.00',
  `shipping_amount` decimal(15,2) DEFAULT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `description` text COLLATE utf8mb4_unicode_ci,
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(15,2) DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `is_confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `discount_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_finished` tinyint(1) DEFAULT '0',
  `cancellation_reason` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cancellation_reason_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `completed_at` timestamp NULL DEFAULT NULL,
  `token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `proof_file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `private_notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_orders_code_unique` (`code`),
  KEY `ec_orders_user_id_status_created_at_index` (`user_id`,`status`,`created_at`),
  KEY `ec_orders_status_created_at_index` (`status`,`created_at`),
  KEY `ec_orders_user_id_is_finished_index` (`user_id`,`is_finished`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_orders`
--

LOCK TABLES `ec_orders` WRITE;
/*!40000 ALTER TABLE `ec_orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_layout` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'dropdown',
  `is_searchable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_comparable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_use_in_product_listing` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `use_image_from_product_variation` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_order_id` (`order`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets`
--

LOCK TABLES `ec_product_attribute_sets` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets` DISABLE KEYS */;
INSERT INTO `ec_product_attribute_sets` VALUES (1,'Color','color','visual',1,1,1,'published',0,'2025-11-18 21:22:42','2025-11-18 21:22:42',1),(2,'Size','size','text',1,1,1,'published',1,'2025-11-18 21:22:42','2025-11-18 21:22:42',0);
/*!40000 ALTER TABLE `ec_product_attribute_sets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets_translations`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attribute_sets_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attribute_sets_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets_translations`
--

LOCK TABLES `ec_product_attribute_sets_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes`
--

DROP TABLE IF EXISTS `ec_product_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_set_id` bigint unsigned NOT NULL,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attribute_set_status_index` (`attribute_set_id`),
  KEY `idx_attribute_set_id` (`attribute_set_id`),
  KEY `idx_attribute_set_order_id` (`attribute_set_id`,`order`,`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes`
--

LOCK TABLES `ec_product_attributes` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes` DISABLE KEYS */;
INSERT INTO `ec_product_attributes` VALUES (1,1,'Green','green','#5FB7D4',NULL,1,1,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(2,1,'Blue','blue','#333333',NULL,0,2,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(3,1,'Red','red','#DA323F',NULL,0,3,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(4,1,'Black','black','#2F366C',NULL,0,4,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(5,1,'Brown','brown','#87554B',NULL,0,5,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(6,2,'S','s',NULL,NULL,1,1,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(7,2,'M','m',NULL,NULL,0,2,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(8,2,'L','l',NULL,NULL,0,3,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(9,2,'XL','xl',NULL,NULL,0,4,'2025-11-18 21:22:42','2025-11-18 21:22:42'),(10,2,'XXL','xxl',NULL,NULL,0,5,'2025-11-18 21:22:42','2025-11-18 21:22:42');
/*!40000 ALTER TABLE `ec_product_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes_translations`
--

DROP TABLE IF EXISTS `ec_product_attributes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attributes_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attributes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes_translations`
--

LOCK TABLES `ec_product_attributes_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_attributes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories`
--

DROP TABLE IF EXISTS `ec_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` int unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_categories_parent_id_status_created_at_index` (`parent_id`,`status`,`created_at`),
  KEY `ec_product_categories_parent_id_status_index` (`parent_id`,`status`),
  KEY `idx_categories_status_order` (`status`,`order`),
  KEY `idx_categories_order` (`order`),
  KEY `ec_product_categories_slug_index` (`slug`),
  KEY `idx_ec_product_categories_status` (`status`),
  KEY `idx_ec_product_categories_parent_id` (`parent_id`),
  KEY `idx_ec_product_categories_status_parent_order` (`status`,`parent_id`,`order`),
  KEY `idx_ec_product_categories_is_featured` (`is_featured`),
  KEY `idx_ec_product_categories_name` (`name`),
  KEY `idx_ec_product_categories_slug` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories`
--

LOCK TABLES `ec_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_product_categories` DISABLE KEYS */;
INSERT INTO `ec_product_categories` VALUES (1,'Pro Glasses',NULL,0,NULL,'published',0,'banners/banner-2-01.jpg',1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL),(2,'Casual Shoes',NULL,0,NULL,'published',0,'banners/banner-2-02.jpg',1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL),(3,'Winter Jacket',NULL,2,NULL,'published',0,'banners/banner-2-03.jpg',1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL),(4,'New Added',NULL,2,NULL,'published',0,'banners/banner-2-04.jpg',1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL),(5,'Wooden',NULL,2,NULL,'published',0,NULL,1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL),(6,'Furniture',NULL,2,NULL,'published',0,NULL,1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL),(7,'Clock',NULL,2,NULL,'published',0,NULL,1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL),(8,'Gifts',NULL,2,NULL,'published',0,NULL,1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL),(9,'Crafts',NULL,2,NULL,'published',0,NULL,1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL),(10,'Gift Sets',NULL,0,NULL,'published',0,'features/feature-icon-01.png',1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL),(11,'Plastic Gifts',NULL,0,NULL,'published',0,'features/feature-icon-02.png',1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL),(12,'Handy Cream',NULL,0,NULL,'published',0,'features/feature-icon-03.png',1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL),(13,'Cosmetics',NULL,0,NULL,'published',0,'features/feature-icon-04.png',1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL),(14,'Silk Accessories',NULL,0,NULL,'published',0,'features/feature-icon-05.png',1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL),(15,'Finest Skincare Lotions',NULL,0,NULL,'published',0,'features/feature-icon-06.png',1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL),(16,'Bags & Purses',NULL,0,NULL,'published',0,NULL,1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL),(17,'Sunglasses',NULL,0,NULL,'published',0,NULL,1,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,NULL);
/*!40000 ALTER TABLE `ec_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories_translations`
--

DROP TABLE IF EXISTS `ec_product_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_product_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories_translations`
--

LOCK TABLES `ec_product_categories_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categorizables`
--

DROP TABLE IF EXISTS `ec_product_categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categorizables` (
  `category_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`category_id`,`reference_id`,`reference_type`),
  KEY `ec_product_categorizables_category_id_index` (`category_id`),
  KEY `ec_product_categorizables_reference_id_index` (`reference_id`),
  KEY `ec_product_categorizables_reference_type_index` (`reference_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categorizables`
--

LOCK TABLES `ec_product_categorizables` WRITE;
/*!40000 ALTER TABLE `ec_product_categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_categorizables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_category_product`
--

DROP TABLE IF EXISTS `ec_product_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_category_product` (
  `category_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`category_id`),
  KEY `ec_product_category_product_category_id_index` (`category_id`),
  KEY `ec_product_category_product_product_id_index` (`product_id`),
  KEY `idx_product_category` (`product_id`,`category_id`),
  KEY `idx_product_id_category_id` (`product_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_category_product`
--

LOCK TABLES `ec_product_category_product` WRITE;
/*!40000 ALTER TABLE `ec_product_category_product` DISABLE KEYS */;
INSERT INTO `ec_product_category_product` VALUES (1,3),(1,12),(1,13),(1,15),(1,25),(1,26),(1,50),(1,51),(1,75),(2,64),(2,71),(2,74),(3,7),(3,9),(3,20),(3,38),(3,65),(4,4),(4,18),(4,22),(4,32),(4,39),(4,40),(4,56),(5,19),(5,43),(5,58),(5,70),(6,5),(6,53),(6,62),(6,72),(7,14),(7,23),(7,31),(7,37),(7,55),(7,67),(7,69),(8,2),(9,6),(9,11),(9,29),(9,33),(9,44),(9,52),(9,60),(9,61),(9,66),(10,1),(10,27),(10,28),(10,35),(10,36),(10,41),(10,54),(10,57),(11,8),(11,10),(11,42),(11,45),(11,73),(12,21),(12,24),(12,47),(12,48),(12,68),(13,16),(13,17),(13,30),(13,34),(14,46),(14,49),(14,59),(14,63);
/*!40000 ALTER TABLE `ec_product_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collection_products`
--

DROP TABLE IF EXISTS `ec_product_collection_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collection_products` (
  `product_collection_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`product_collection_id`),
  KEY `ec_product_collection_products_product_collection_id_index` (`product_collection_id`),
  KEY `ec_product_collection_products_product_id_index` (`product_id`),
  KEY `idx_product_id_collection_id` (`product_id`,`product_collection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collection_products`
--

LOCK TABLES `ec_product_collection_products` WRITE;
/*!40000 ALTER TABLE `ec_product_collection_products` DISABLE KEYS */;
INSERT INTO `ec_product_collection_products` VALUES (1,1),(1,4),(1,8),(1,9),(1,10),(1,11),(1,13),(1,14),(1,15),(1,21),(1,26),(1,28),(1,29),(1,30),(1,32),(1,33),(1,39),(1,44),(1,51),(1,55),(1,60),(1,63),(1,64),(1,67),(1,68),(1,72),(1,73),(2,3),(2,5),(2,18),(2,19),(2,20),(2,23),(2,24),(2,25),(2,27),(2,31),(2,40),(2,42),(2,47),(2,48),(2,50),(2,52),(2,54),(2,56),(2,57),(2,58),(2,59),(2,66),(2,69),(2,70),(2,71),(2,75),(3,2),(3,6),(3,7),(3,12),(3,16),(3,17),(3,22),(3,34),(3,35),(3,36),(3,37),(3,38),(3,41),(3,43),(3,45),(3,46),(3,49),(3,53),(3,61),(3,62),(3,65),(3,74);
/*!40000 ALTER TABLE `ec_product_collection_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections`
--

DROP TABLE IF EXISTS `ec_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections`
--

LOCK TABLES `ec_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_product_collections` DISABLE KEYS */;
INSERT INTO `ec_product_collections` VALUES (1,'New Arrival','new-arrival',NULL,NULL,'published','2025-11-18 21:22:42','2025-11-18 21:22:42',0),(2,'Best Sellers','best-sellers',NULL,NULL,'published','2025-11-18 21:22:42','2025-11-18 21:22:42',0),(3,'Special Offer','special-offer',NULL,NULL,'published','2025-11-18 21:22:42','2025-11-18 21:22:42',0),(4,'Reactive Providence Hair Color','reactive-providence-hair-color',NULL,'banners/thumb-01.jpg','published','2025-11-18 21:22:42','2025-11-18 21:22:42',0),(5,'New Modern &amp; Stylist Makeup','new-modern-stylist-makeup',NULL,'banners/thumb-02.jpg','published','2025-11-18 21:22:42','2025-11-18 21:22:42',0),(6,'Intensive Glow C+ Serum','intensive-glow-c-serum',NULL,'banners/thumb-03.jpg','published','2025-11-18 21:22:42','2025-11-18 21:22:42',0),(7,'Vogue','vogue',NULL,'banners/thumb-04.jpg','published','2025-11-18 21:22:42','2025-11-18 21:22:42',0);
/*!40000 ALTER TABLE `ec_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections_translations`
--

DROP TABLE IF EXISTS `ec_product_collections_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_collections_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_collections_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections_translations`
--

LOCK TABLES `ec_product_collections_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_collections_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_collections_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_cross_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_cross_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_cross_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  `is_variant` tinyint(1) NOT NULL DEFAULT '0',
  `price` decimal(15,2) DEFAULT '0.00',
  `price_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fixed',
  `apply_to_all_variations` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_cross_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_cross_sale_relations_to_product_id_index` (`to_product_id`),
  KEY `idx_product_cross_sale` (`from_product_id`,`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_cross_sale_relations`
--

LOCK TABLES `ec_product_cross_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` DISABLE KEYS */;
INSERT INTO `ec_product_cross_sale_relations` VALUES (1,7,0,0.00,'fixed',1),(1,12,0,0.00,'fixed',1),(1,24,0,0.00,'fixed',1),(1,55,0,0.00,'fixed',1),(2,9,0,0.00,'fixed',1),(2,42,0,0.00,'fixed',1),(2,44,0,0.00,'fixed',1),(2,57,0,0.00,'fixed',1),(3,27,0,0.00,'fixed',1),(3,46,0,0.00,'fixed',1),(3,57,0,0.00,'fixed',1),(3,72,0,0.00,'fixed',1),(4,25,0,0.00,'fixed',1),(4,36,0,0.00,'fixed',1),(4,41,0,0.00,'fixed',1),(4,47,0,0.00,'fixed',1),(5,22,0,0.00,'fixed',1),(5,32,0,0.00,'fixed',1),(5,44,0,0.00,'fixed',1),(5,68,0,0.00,'fixed',1),(6,14,0,0.00,'fixed',1),(6,16,0,0.00,'fixed',1),(6,17,0,0.00,'fixed',1),(6,74,0,0.00,'fixed',1),(7,44,0,0.00,'fixed',1),(7,46,0,0.00,'fixed',1),(7,47,0,0.00,'fixed',1),(7,66,0,0.00,'fixed',1),(8,27,0,0.00,'fixed',1),(8,29,0,0.00,'fixed',1),(8,35,0,0.00,'fixed',1),(8,53,0,0.00,'fixed',1),(9,1,0,0.00,'fixed',1),(9,22,0,0.00,'fixed',1),(9,36,0,0.00,'fixed',1),(9,56,0,0.00,'fixed',1),(10,2,0,0.00,'fixed',1),(10,5,0,0.00,'fixed',1),(10,52,0,0.00,'fixed',1),(10,56,0,0.00,'fixed',1),(11,12,0,0.00,'fixed',1),(11,30,0,0.00,'fixed',1),(11,31,0,0.00,'fixed',1),(11,42,0,0.00,'fixed',1),(12,9,0,0.00,'fixed',1),(12,22,0,0.00,'fixed',1),(12,58,0,0.00,'fixed',1),(12,68,0,0.00,'fixed',1),(13,12,0,0.00,'fixed',1),(13,20,0,0.00,'fixed',1),(13,37,0,0.00,'fixed',1),(13,44,0,0.00,'fixed',1),(14,33,0,0.00,'fixed',1),(14,40,0,0.00,'fixed',1),(14,63,0,0.00,'fixed',1),(14,68,0,0.00,'fixed',1),(15,29,0,0.00,'fixed',1),(15,58,0,0.00,'fixed',1),(15,67,0,0.00,'fixed',1),(15,69,0,0.00,'fixed',1),(16,21,0,0.00,'fixed',1),(16,28,0,0.00,'fixed',1),(16,29,0,0.00,'fixed',1),(16,43,0,0.00,'fixed',1),(17,8,0,0.00,'fixed',1),(17,24,0,0.00,'fixed',1),(17,30,0,0.00,'fixed',1),(17,53,0,0.00,'fixed',1),(18,34,0,0.00,'fixed',1),(18,42,0,0.00,'fixed',1),(18,53,0,0.00,'fixed',1),(18,60,0,0.00,'fixed',1),(19,10,0,0.00,'fixed',1),(19,11,0,0.00,'fixed',1),(19,31,0,0.00,'fixed',1),(19,38,0,0.00,'fixed',1),(20,24,0,0.00,'fixed',1),(20,26,0,0.00,'fixed',1),(20,38,0,0.00,'fixed',1),(20,46,0,0.00,'fixed',1),(21,6,0,0.00,'fixed',1),(21,28,0,0.00,'fixed',1),(21,30,0,0.00,'fixed',1),(21,49,0,0.00,'fixed',1),(22,14,0,0.00,'fixed',1),(22,39,0,0.00,'fixed',1),(22,54,0,0.00,'fixed',1),(22,69,0,0.00,'fixed',1),(23,72,0,0.00,'fixed',1),(23,74,0,0.00,'fixed',1),(23,75,0,0.00,'fixed',1),(24,7,0,0.00,'fixed',1),(24,34,0,0.00,'fixed',1),(24,37,0,0.00,'fixed',1),(24,54,0,0.00,'fixed',1),(25,20,0,0.00,'fixed',1),(25,36,0,0.00,'fixed',1),(25,58,0,0.00,'fixed',1),(25,65,0,0.00,'fixed',1),(26,32,0,0.00,'fixed',1),(26,45,0,0.00,'fixed',1),(26,58,0,0.00,'fixed',1),(26,69,0,0.00,'fixed',1),(27,23,0,0.00,'fixed',1),(27,46,0,0.00,'fixed',1),(27,60,0,0.00,'fixed',1),(27,73,0,0.00,'fixed',1),(28,12,0,0.00,'fixed',1),(28,14,0,0.00,'fixed',1),(28,30,0,0.00,'fixed',1),(28,34,0,0.00,'fixed',1),(29,2,0,0.00,'fixed',1),(29,30,0,0.00,'fixed',1),(29,38,0,0.00,'fixed',1),(29,58,0,0.00,'fixed',1),(30,21,0,0.00,'fixed',1),(30,57,0,0.00,'fixed',1),(30,65,0,0.00,'fixed',1),(30,70,0,0.00,'fixed',1),(31,7,0,0.00,'fixed',1),(31,14,0,0.00,'fixed',1),(31,37,0,0.00,'fixed',1),(31,44,0,0.00,'fixed',1),(32,10,0,0.00,'fixed',1),(32,17,0,0.00,'fixed',1),(32,22,0,0.00,'fixed',1),(32,45,0,0.00,'fixed',1),(33,12,0,0.00,'fixed',1),(33,15,0,0.00,'fixed',1),(33,42,0,0.00,'fixed',1),(33,54,0,0.00,'fixed',1),(34,2,0,0.00,'fixed',1),(34,5,0,0.00,'fixed',1),(34,31,0,0.00,'fixed',1),(34,50,0,0.00,'fixed',1),(35,2,0,0.00,'fixed',1),(35,8,0,0.00,'fixed',1),(35,12,0,0.00,'fixed',1),(35,22,0,0.00,'fixed',1),(36,4,0,0.00,'fixed',1),(36,26,0,0.00,'fixed',1),(36,44,0,0.00,'fixed',1),(36,63,0,0.00,'fixed',1),(37,9,0,0.00,'fixed',1),(37,29,0,0.00,'fixed',1),(37,53,0,0.00,'fixed',1),(38,39,0,0.00,'fixed',1),(38,44,0,0.00,'fixed',1),(38,53,0,0.00,'fixed',1),(38,63,0,0.00,'fixed',1),(39,14,0,0.00,'fixed',1),(39,20,0,0.00,'fixed',1),(39,51,0,0.00,'fixed',1),(39,75,0,0.00,'fixed',1),(40,15,0,0.00,'fixed',1),(40,30,0,0.00,'fixed',1),(40,44,0,0.00,'fixed',1),(40,51,0,0.00,'fixed',1),(41,2,0,0.00,'fixed',1),(41,7,0,0.00,'fixed',1),(41,42,0,0.00,'fixed',1),(41,67,0,0.00,'fixed',1),(42,45,0,0.00,'fixed',1),(42,51,0,0.00,'fixed',1),(42,70,0,0.00,'fixed',1),(42,73,0,0.00,'fixed',1),(43,4,0,0.00,'fixed',1),(43,24,0,0.00,'fixed',1),(43,39,0,0.00,'fixed',1),(43,49,0,0.00,'fixed',1),(44,24,0,0.00,'fixed',1),(44,57,0,0.00,'fixed',1),(44,59,0,0.00,'fixed',1),(44,75,0,0.00,'fixed',1),(45,15,0,0.00,'fixed',1),(45,41,0,0.00,'fixed',1),(45,51,0,0.00,'fixed',1),(45,66,0,0.00,'fixed',1),(46,21,0,0.00,'fixed',1),(46,47,0,0.00,'fixed',1),(46,62,0,0.00,'fixed',1),(46,71,0,0.00,'fixed',1),(47,16,0,0.00,'fixed',1),(47,60,0,0.00,'fixed',1),(47,68,0,0.00,'fixed',1),(47,74,0,0.00,'fixed',1),(48,1,0,0.00,'fixed',1),(48,5,0,0.00,'fixed',1),(48,52,0,0.00,'fixed',1),(48,74,0,0.00,'fixed',1),(49,10,0,0.00,'fixed',1),(49,23,0,0.00,'fixed',1),(49,42,0,0.00,'fixed',1),(49,67,0,0.00,'fixed',1),(50,11,0,0.00,'fixed',1),(50,23,0,0.00,'fixed',1),(50,38,0,0.00,'fixed',1),(50,66,0,0.00,'fixed',1),(51,9,0,0.00,'fixed',1),(51,19,0,0.00,'fixed',1),(51,47,0,0.00,'fixed',1),(52,22,0,0.00,'fixed',1),(52,45,0,0.00,'fixed',1),(52,68,0,0.00,'fixed',1),(52,75,0,0.00,'fixed',1),(53,44,0,0.00,'fixed',1),(53,60,0,0.00,'fixed',1),(53,61,0,0.00,'fixed',1),(53,71,0,0.00,'fixed',1),(54,9,0,0.00,'fixed',1),(54,24,0,0.00,'fixed',1),(54,44,0,0.00,'fixed',1),(54,73,0,0.00,'fixed',1),(55,13,0,0.00,'fixed',1),(55,33,0,0.00,'fixed',1),(55,41,0,0.00,'fixed',1),(55,75,0,0.00,'fixed',1),(56,13,0,0.00,'fixed',1),(56,25,0,0.00,'fixed',1),(56,54,0,0.00,'fixed',1),(56,68,0,0.00,'fixed',1),(57,2,0,0.00,'fixed',1),(57,12,0,0.00,'fixed',1),(57,15,0,0.00,'fixed',1),(57,16,0,0.00,'fixed',1),(58,6,0,0.00,'fixed',1),(58,42,0,0.00,'fixed',1),(58,53,0,0.00,'fixed',1),(58,62,0,0.00,'fixed',1),(59,3,0,0.00,'fixed',1),(59,29,0,0.00,'fixed',1),(59,68,0,0.00,'fixed',1),(59,69,0,0.00,'fixed',1),(60,21,0,0.00,'fixed',1),(60,29,0,0.00,'fixed',1),(60,30,0,0.00,'fixed',1),(60,73,0,0.00,'fixed',1),(61,1,0,0.00,'fixed',1),(61,10,0,0.00,'fixed',1),(61,25,0,0.00,'fixed',1),(61,74,0,0.00,'fixed',1),(62,34,0,0.00,'fixed',1),(62,46,0,0.00,'fixed',1),(62,59,0,0.00,'fixed',1),(63,15,0,0.00,'fixed',1),(63,22,0,0.00,'fixed',1),(63,25,0,0.00,'fixed',1),(63,55,0,0.00,'fixed',1),(64,11,0,0.00,'fixed',1),(64,21,0,0.00,'fixed',1),(64,51,0,0.00,'fixed',1),(64,73,0,0.00,'fixed',1),(65,8,0,0.00,'fixed',1),(65,28,0,0.00,'fixed',1),(65,34,0,0.00,'fixed',1),(65,49,0,0.00,'fixed',1),(66,33,0,0.00,'fixed',1),(66,65,0,0.00,'fixed',1),(66,67,0,0.00,'fixed',1),(66,68,0,0.00,'fixed',1),(67,1,0,0.00,'fixed',1),(67,6,0,0.00,'fixed',1),(67,47,0,0.00,'fixed',1),(67,56,0,0.00,'fixed',1),(68,24,0,0.00,'fixed',1),(68,25,0,0.00,'fixed',1),(68,29,0,0.00,'fixed',1),(68,33,0,0.00,'fixed',1),(69,56,0,0.00,'fixed',1),(69,67,0,0.00,'fixed',1),(69,72,0,0.00,'fixed',1),(70,7,0,0.00,'fixed',1),(70,18,0,0.00,'fixed',1),(70,20,0,0.00,'fixed',1),(70,60,0,0.00,'fixed',1),(71,26,0,0.00,'fixed',1),(71,31,0,0.00,'fixed',1),(71,39,0,0.00,'fixed',1),(71,75,0,0.00,'fixed',1),(72,5,0,0.00,'fixed',1),(72,45,0,0.00,'fixed',1),(72,53,0,0.00,'fixed',1),(72,62,0,0.00,'fixed',1),(73,13,0,0.00,'fixed',1),(73,43,0,0.00,'fixed',1),(73,45,0,0.00,'fixed',1),(73,48,0,0.00,'fixed',1),(74,9,0,0.00,'fixed',1),(74,20,0,0.00,'fixed',1),(74,44,0,0.00,'fixed',1),(74,49,0,0.00,'fixed',1),(75,11,0,0.00,'fixed',1),(75,18,0,0.00,'fixed',1),(75,28,0,0.00,'fixed',1),(75,35,0,0.00,'fixed',1);
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_files`
--

DROP TABLE IF EXISTS `ec_product_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extras` mediumtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_files_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=421 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_files`
--

LOCK TABLES `ec_product_files` WRITE;
/*!40000 ALTER TABLE `ec_product_files` DISABLE KEYS */;
INSERT INTO `ec_product_files` VALUES (1,76,'ecommerce/digital-product-files/product-72.jpg','{\"filename\":\"product-72.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-72.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-72\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(2,76,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(3,76,'ecommerce/digital-product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(4,76,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(5,76,'ecommerce/digital-product-files/product-68.jpg','{\"filename\":\"product-68.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-68.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-68\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(6,76,'ecommerce/digital-product-files/product-79.jpg','{\"filename\":\"product-79.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-79.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-79\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(7,76,'ecommerce/digital-product-files/product-71.jpg','{\"filename\":\"product-71.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-71.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-71\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(8,76,'ecommerce/digital-product-files/product-80.jpg','{\"filename\":\"product-80.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-80.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-80\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(9,76,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(10,77,'ecommerce/digital-product-files/product-72.jpg','{\"filename\":\"product-72.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-72.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-72\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(11,77,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(12,77,'ecommerce/digital-product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(13,77,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(14,77,'ecommerce/digital-product-files/product-68.jpg','{\"filename\":\"product-68.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-68.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-68\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(15,77,'ecommerce/digital-product-files/product-79.jpg','{\"filename\":\"product-79.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-79.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-79\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(16,77,'ecommerce/digital-product-files/product-71.jpg','{\"filename\":\"product-71.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-71.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-71\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(17,77,'ecommerce/digital-product-files/product-80.jpg','{\"filename\":\"product-80.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-80.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-80\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(18,77,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(19,78,'ecommerce/digital-product-files/product-72.jpg','{\"filename\":\"product-72.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-72.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-72\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(20,78,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(21,78,'ecommerce/digital-product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(22,78,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(23,78,'ecommerce/digital-product-files/product-68.jpg','{\"filename\":\"product-68.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-68.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-68\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(24,78,'ecommerce/digital-product-files/product-79.jpg','{\"filename\":\"product-79.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-79.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-79\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(25,78,'ecommerce/digital-product-files/product-71.jpg','{\"filename\":\"product-71.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-71.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-71\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(26,78,'ecommerce/digital-product-files/product-80.jpg','{\"filename\":\"product-80.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-80.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-80\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(27,78,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:50\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2025-11-18 21:22:50','2025-11-18 21:22:50'),(28,84,'ecommerce/digital-product-files/product-82.jpg','{\"filename\":\"product-82.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-82.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-82\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(29,84,'ecommerce/digital-product-files/product-47.jpg','{\"filename\":\"product-47.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-47.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-47\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(30,84,'ecommerce/digital-product-files/product-38.jpg','{\"filename\":\"product-38.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-38.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-38\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(31,84,'ecommerce/digital-product-files/product-66.jpg','{\"filename\":\"product-66.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-66.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-66\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(32,84,'ecommerce/digital-product-files/product-42.jpg','{\"filename\":\"product-42.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-42.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-42\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(33,93,'ecommerce/digital-product-files/product-22.jpg','{\"filename\":\"product-22.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-22.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-22\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(34,93,'ecommerce/digital-product-files/product-61.jpg','{\"filename\":\"product-61.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-61.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-61\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(35,93,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(36,93,'ecommerce/digital-product-files/product-87.jpg','{\"filename\":\"product-87.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-87.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-87\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(37,93,'ecommerce/digital-product-files/product-39.jpg','{\"filename\":\"product-39.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-39.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-39\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(38,93,'ecommerce/digital-product-files/product-76.jpg','{\"filename\":\"product-76.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-76.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-76\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(39,93,'ecommerce/digital-product-files/product-60.jpg','{\"filename\":\"product-60.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-60.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-60\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(40,93,'ecommerce/digital-product-files/product-71.jpg','{\"filename\":\"product-71.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-71.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-71\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(41,93,'ecommerce/digital-product-files/product-42.jpg','{\"filename\":\"product-42.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-42.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-42\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(42,93,'ecommerce/digital-product-files/product-46.jpg','{\"filename\":\"product-46.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-46.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-46\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(43,93,'ecommerce/digital-product-files/product-95.jpg','{\"filename\":\"product-95.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-95.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-95\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(44,104,'ecommerce/digital-product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(45,104,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(46,104,'ecommerce/digital-product-files/product-91.jpg','{\"filename\":\"product-91.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-91.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-91\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(47,104,'ecommerce/digital-product-files/product-11.jpg','{\"filename\":\"product-11.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-11.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-11\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(48,104,'ecommerce/digital-product-files/product-36.jpg','{\"filename\":\"product-36.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-36.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-36\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(49,104,'ecommerce/digital-product-files/product-58.jpg','{\"filename\":\"product-58.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-58.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-58\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(50,113,'ecommerce/digital-product-files/product-14.jpg','{\"filename\":\"product-14.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-14.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-14\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(51,113,'ecommerce/digital-product-files/product-44.jpg','{\"filename\":\"product-44.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-44.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-44\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(52,113,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(53,113,'ecommerce/digital-product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(54,113,'ecommerce/digital-product-files/product-3.jpg','{\"filename\":\"product-3.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-3.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-3\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(55,114,'ecommerce/digital-product-files/product-14.jpg','{\"filename\":\"product-14.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-14.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-14\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(56,114,'ecommerce/digital-product-files/product-44.jpg','{\"filename\":\"product-44.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-44.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-44\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(57,114,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(58,114,'ecommerce/digital-product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(59,114,'ecommerce/digital-product-files/product-3.jpg','{\"filename\":\"product-3.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-3.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-3\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(60,115,'ecommerce/digital-product-files/product-14.jpg','{\"filename\":\"product-14.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-14.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-14\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(61,115,'ecommerce/digital-product-files/product-44.jpg','{\"filename\":\"product-44.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-44.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-44\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(62,115,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(63,115,'ecommerce/digital-product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(64,115,'ecommerce/digital-product-files/product-3.jpg','{\"filename\":\"product-3.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-3.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:51\",\"name\":\"product-3\",\"extension\":\"jpg\"}','2025-11-18 21:22:51','2025-11-18 21:22:51'),(65,122,'ecommerce/digital-product-files/product-83.jpg','{\"filename\":\"product-83.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-83.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-83\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(66,122,'ecommerce/digital-product-files/product-71.jpg','{\"filename\":\"product-71.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-71.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-71\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(67,122,'ecommerce/digital-product-files/product-49.jpg','{\"filename\":\"product-49.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-49.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-49\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(68,122,'ecommerce/digital-product-files/product-95.jpg','{\"filename\":\"product-95.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-95.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-95\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(69,122,'ecommerce/digital-product-files/product-74.jpg','{\"filename\":\"product-74.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-74.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-74\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(70,122,'ecommerce/digital-product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(71,122,'ecommerce/digital-product-files/product-43.jpg','{\"filename\":\"product-43.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-43.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-43\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(72,122,'ecommerce/digital-product-files/product-51.jpg','{\"filename\":\"product-51.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-51.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-51\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(73,131,'ecommerce/digital-product-files/product-77.jpg','{\"filename\":\"product-77.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-77.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-77\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(74,131,'ecommerce/digital-product-files/product-50.jpg','{\"filename\":\"product-50.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-50.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-50\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(75,131,'ecommerce/digital-product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(76,131,'ecommerce/digital-product-files/product-25.jpg','{\"filename\":\"product-25.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-25.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-25\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(77,131,'ecommerce/digital-product-files/product-56.jpg','{\"filename\":\"product-56.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-56.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-56\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(78,131,'ecommerce/digital-product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(79,131,'ecommerce/digital-product-files/product-93.jpg','{\"filename\":\"product-93.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-93.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-93\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(80,131,'ecommerce/digital-product-files/product-87.jpg','{\"filename\":\"product-87.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-87.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-87\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(81,131,'ecommerce/digital-product-files/product-49.jpg','{\"filename\":\"product-49.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-49.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-49\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(82,139,'ecommerce/digital-product-files/product-49.jpg','{\"filename\":\"product-49.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-49.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-49\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(83,139,'ecommerce/digital-product-files/product-87.jpg','{\"filename\":\"product-87.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-87.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-87\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(84,139,'ecommerce/digital-product-files/product-59.jpg','{\"filename\":\"product-59.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-59.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-59\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(85,139,'ecommerce/digital-product-files/product-95.jpg','{\"filename\":\"product-95.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-95.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-95\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(86,139,'ecommerce/digital-product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(87,139,'ecommerce/digital-product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(88,139,'ecommerce/digital-product-files/product-60.jpg','{\"filename\":\"product-60.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-60.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-60\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(89,139,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(90,139,'ecommerce/digital-product-files/product-28.jpg','{\"filename\":\"product-28.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-28.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-28\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(91,139,'ecommerce/digital-product-files/product-27.jpg','{\"filename\":\"product-27.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-27.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-27\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(92,139,'ecommerce/digital-product-files/product-75.jpg','{\"filename\":\"product-75.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-75.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-75\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(93,139,'ecommerce/digital-product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(94,140,'ecommerce/digital-product-files/product-49.jpg','{\"filename\":\"product-49.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-49.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-49\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(95,140,'ecommerce/digital-product-files/product-87.jpg','{\"filename\":\"product-87.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-87.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-87\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(96,140,'ecommerce/digital-product-files/product-59.jpg','{\"filename\":\"product-59.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-59.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-59\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(97,140,'ecommerce/digital-product-files/product-95.jpg','{\"filename\":\"product-95.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-95.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-95\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(98,140,'ecommerce/digital-product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(99,140,'ecommerce/digital-product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(100,140,'ecommerce/digital-product-files/product-60.jpg','{\"filename\":\"product-60.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-60.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-60\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(101,140,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(102,140,'ecommerce/digital-product-files/product-28.jpg','{\"filename\":\"product-28.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-28.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-28\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(103,140,'ecommerce/digital-product-files/product-27.jpg','{\"filename\":\"product-27.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-27.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-27\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(104,140,'ecommerce/digital-product-files/product-75.jpg','{\"filename\":\"product-75.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-75.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-75\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(105,140,'ecommerce/digital-product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(106,141,'ecommerce/digital-product-files/product-49.jpg','{\"filename\":\"product-49.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-49.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-49\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(107,141,'ecommerce/digital-product-files/product-87.jpg','{\"filename\":\"product-87.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-87.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-87\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(108,141,'ecommerce/digital-product-files/product-59.jpg','{\"filename\":\"product-59.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-59.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-59\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(109,141,'ecommerce/digital-product-files/product-95.jpg','{\"filename\":\"product-95.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-95.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-95\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(110,141,'ecommerce/digital-product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(111,141,'ecommerce/digital-product-files/product-8.jpg','{\"filename\":\"product-8.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-8.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-8\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(112,141,'ecommerce/digital-product-files/product-60.jpg','{\"filename\":\"product-60.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-60.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-60\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(113,141,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(114,141,'ecommerce/digital-product-files/product-28.jpg','{\"filename\":\"product-28.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-28.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-28\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(115,141,'ecommerce/digital-product-files/product-27.jpg','{\"filename\":\"product-27.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-27.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-27\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(116,141,'ecommerce/digital-product-files/product-75.jpg','{\"filename\":\"product-75.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-75.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-75\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(117,141,'ecommerce/digital-product-files/product-12.jpg','{\"filename\":\"product-12.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-12.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:52\",\"name\":\"product-12\",\"extension\":\"jpg\"}','2025-11-18 21:22:52','2025-11-18 21:22:52'),(118,150,'ecommerce/digital-product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(119,150,'ecommerce/digital-product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(120,150,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(121,150,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(122,150,'ecommerce/digital-product-files/product-79.jpg','{\"filename\":\"product-79.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-79.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-79\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(123,150,'ecommerce/digital-product-files/product-78.jpg','{\"filename\":\"product-78.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-78.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-78\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(124,150,'ecommerce/digital-product-files/product-72.jpg','{\"filename\":\"product-72.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-72.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-72\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(125,150,'ecommerce/digital-product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(126,150,'ecommerce/digital-product-files/product-49.jpg','{\"filename\":\"product-49.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-49.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-49\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(127,150,'ecommerce/digital-product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(128,150,'ecommerce/digital-product-files/product-94.jpg','{\"filename\":\"product-94.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-94.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-94\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(129,151,'ecommerce/digital-product-files/product-9.jpg','{\"filename\":\"product-9.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-9\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(130,151,'ecommerce/digital-product-files/product-5.jpg','{\"filename\":\"product-5.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-5\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(131,151,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(132,151,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(133,151,'ecommerce/digital-product-files/product-79.jpg','{\"filename\":\"product-79.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-79.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-79\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(134,151,'ecommerce/digital-product-files/product-78.jpg','{\"filename\":\"product-78.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-78.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-78\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(135,151,'ecommerce/digital-product-files/product-72.jpg','{\"filename\":\"product-72.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-72.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-72\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(136,151,'ecommerce/digital-product-files/product-2.jpg','{\"filename\":\"product-2.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-2\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(137,151,'ecommerce/digital-product-files/product-49.jpg','{\"filename\":\"product-49.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-49.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-49\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(138,151,'ecommerce/digital-product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(139,151,'ecommerce/digital-product-files/product-94.jpg','{\"filename\":\"product-94.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-94.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-94\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(140,162,'ecommerce/digital-product-files/product-48.jpg','{\"filename\":\"product-48.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-48.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-48\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(141,162,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(142,162,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(143,162,'ecommerce/digital-product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(144,162,'ecommerce/digital-product-files/product-32.jpg','{\"filename\":\"product-32.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-32.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-32\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(145,162,'ecommerce/digital-product-files/product-26.jpg','{\"filename\":\"product-26.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-26.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-26\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(146,162,'ecommerce/digital-product-files/product-91.jpg','{\"filename\":\"product-91.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-91.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-91\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(147,162,'ecommerce/digital-product-files/product-46.jpg','{\"filename\":\"product-46.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-46.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-46\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(148,162,'ecommerce/digital-product-files/product-94.jpg','{\"filename\":\"product-94.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-94.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-94\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(149,162,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(150,162,'ecommerce/digital-product-files/product-23.jpg','{\"filename\":\"product-23.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-23.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-23\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(151,162,'ecommerce/digital-product-files/product-50.jpg','{\"filename\":\"product-50.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-50.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-50\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(152,163,'ecommerce/digital-product-files/product-48.jpg','{\"filename\":\"product-48.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-48.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-48\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(153,163,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(154,163,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(155,163,'ecommerce/digital-product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(156,163,'ecommerce/digital-product-files/product-32.jpg','{\"filename\":\"product-32.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-32.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-32\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(157,163,'ecommerce/digital-product-files/product-26.jpg','{\"filename\":\"product-26.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-26.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-26\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(158,163,'ecommerce/digital-product-files/product-91.jpg','{\"filename\":\"product-91.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-91.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-91\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(159,163,'ecommerce/digital-product-files/product-46.jpg','{\"filename\":\"product-46.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-46.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-46\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(160,163,'ecommerce/digital-product-files/product-94.jpg','{\"filename\":\"product-94.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-94.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-94\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(161,163,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(162,163,'ecommerce/digital-product-files/product-23.jpg','{\"filename\":\"product-23.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-23.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-23\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(163,163,'ecommerce/digital-product-files/product-50.jpg','{\"filename\":\"product-50.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-50.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-50\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(164,164,'ecommerce/digital-product-files/product-48.jpg','{\"filename\":\"product-48.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-48.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-48\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(165,164,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(166,164,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(167,164,'ecommerce/digital-product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(168,164,'ecommerce/digital-product-files/product-32.jpg','{\"filename\":\"product-32.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-32.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-32\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(169,164,'ecommerce/digital-product-files/product-26.jpg','{\"filename\":\"product-26.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-26.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-26\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(170,164,'ecommerce/digital-product-files/product-91.jpg','{\"filename\":\"product-91.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-91.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-91\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(171,164,'ecommerce/digital-product-files/product-46.jpg','{\"filename\":\"product-46.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-46.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-46\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(172,164,'ecommerce/digital-product-files/product-94.jpg','{\"filename\":\"product-94.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-94.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-94\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(173,164,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(174,164,'ecommerce/digital-product-files/product-23.jpg','{\"filename\":\"product-23.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-23.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-23\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(175,164,'ecommerce/digital-product-files/product-50.jpg','{\"filename\":\"product-50.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-50.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-50\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(176,165,'ecommerce/digital-product-files/product-48.jpg','{\"filename\":\"product-48.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-48.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-48\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(177,165,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(178,165,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(179,165,'ecommerce/digital-product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(180,165,'ecommerce/digital-product-files/product-32.jpg','{\"filename\":\"product-32.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-32.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-32\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(181,165,'ecommerce/digital-product-files/product-26.jpg','{\"filename\":\"product-26.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-26.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-26\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(182,165,'ecommerce/digital-product-files/product-91.jpg','{\"filename\":\"product-91.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-91.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-91\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(183,165,'ecommerce/digital-product-files/product-46.jpg','{\"filename\":\"product-46.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-46.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-46\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(184,165,'ecommerce/digital-product-files/product-94.jpg','{\"filename\":\"product-94.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-94.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-94\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(185,165,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(186,165,'ecommerce/digital-product-files/product-23.jpg','{\"filename\":\"product-23.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-23.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-23\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(187,165,'ecommerce/digital-product-files/product-50.jpg','{\"filename\":\"product-50.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-50.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-50\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(188,166,'ecommerce/digital-product-files/product-48.jpg','{\"filename\":\"product-48.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-48.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-48\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(189,166,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(190,166,'ecommerce/digital-product-files/product-16.jpg','{\"filename\":\"product-16.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-16.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-16\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(191,166,'ecommerce/digital-product-files/product-18.jpg','{\"filename\":\"product-18.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-18.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-18\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(192,166,'ecommerce/digital-product-files/product-32.jpg','{\"filename\":\"product-32.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-32.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-32\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(193,166,'ecommerce/digital-product-files/product-26.jpg','{\"filename\":\"product-26.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-26.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-26\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(194,166,'ecommerce/digital-product-files/product-91.jpg','{\"filename\":\"product-91.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-91.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-91\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(195,166,'ecommerce/digital-product-files/product-46.jpg','{\"filename\":\"product-46.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-46.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-46\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(196,166,'ecommerce/digital-product-files/product-94.jpg','{\"filename\":\"product-94.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-94.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-94\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(197,166,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(198,166,'ecommerce/digital-product-files/product-23.jpg','{\"filename\":\"product-23.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-23.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-23\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(199,166,'ecommerce/digital-product-files/product-50.jpg','{\"filename\":\"product-50.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-50.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:53\",\"name\":\"product-50\",\"extension\":\"jpg\"}','2025-11-18 21:22:53','2025-11-18 21:22:53'),(200,173,'ecommerce/digital-product-files/product-89.jpg','{\"filename\":\"product-89.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-89.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-89\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(201,173,'ecommerce/digital-product-files/product-72.jpg','{\"filename\":\"product-72.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-72.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-72\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(202,173,'ecommerce/digital-product-files/product-44.jpg','{\"filename\":\"product-44.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-44.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-44\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(203,173,'ecommerce/digital-product-files/product-39.jpg','{\"filename\":\"product-39.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-39.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-39\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(204,173,'ecommerce/digital-product-files/product-50.jpg','{\"filename\":\"product-50.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-50.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-50\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(205,173,'ecommerce/digital-product-files/product-35.jpg','{\"filename\":\"product-35.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-35.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-35\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(206,173,'ecommerce/digital-product-files/product-80.jpg','{\"filename\":\"product-80.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-80.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-80\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(207,173,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(208,182,'ecommerce/digital-product-files/product-63.jpg','{\"filename\":\"product-63.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-63.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-63\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(209,182,'ecommerce/digital-product-files/product-52.jpg','{\"filename\":\"product-52.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-52.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-52\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(210,182,'ecommerce/digital-product-files/product-29.jpg','{\"filename\":\"product-29.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-29.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-29\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(211,182,'ecommerce/digital-product-files/product-36.jpg','{\"filename\":\"product-36.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-36.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-36\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(212,182,'ecommerce/digital-product-files/product-41.jpg','{\"filename\":\"product-41.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-41.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-41\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(213,183,'ecommerce/digital-product-files/product-63.jpg','{\"filename\":\"product-63.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-63.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-63\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(214,183,'ecommerce/digital-product-files/product-52.jpg','{\"filename\":\"product-52.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-52.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-52\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(215,183,'ecommerce/digital-product-files/product-29.jpg','{\"filename\":\"product-29.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-29.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-29\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(216,183,'ecommerce/digital-product-files/product-36.jpg','{\"filename\":\"product-36.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-36.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-36\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(217,183,'ecommerce/digital-product-files/product-41.jpg','{\"filename\":\"product-41.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-41.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-41\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(218,191,'ecommerce/digital-product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(219,191,'ecommerce/digital-product-files/product-64.jpg','{\"filename\":\"product-64.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-64.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-64\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(220,191,'ecommerce/digital-product-files/product-37.jpg','{\"filename\":\"product-37.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-37.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-37\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(221,191,'ecommerce/digital-product-files/product-7.jpg','{\"filename\":\"product-7.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-7.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-7\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(222,191,'ecommerce/digital-product-files/product-35.jpg','{\"filename\":\"product-35.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-35.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-35\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(223,191,'ecommerce/digital-product-files/product-60.jpg','{\"filename\":\"product-60.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-60.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-60\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(224,191,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(225,191,'ecommerce/digital-product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(226,191,'ecommerce/digital-product-files/product-33.jpg','{\"filename\":\"product-33.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-33.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-33\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(227,191,'ecommerce/digital-product-files/product-88.jpg','{\"filename\":\"product-88.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-88.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-88\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(228,192,'ecommerce/digital-product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(229,192,'ecommerce/digital-product-files/product-64.jpg','{\"filename\":\"product-64.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-64.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-64\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(230,192,'ecommerce/digital-product-files/product-37.jpg','{\"filename\":\"product-37.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-37.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-37\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(231,192,'ecommerce/digital-product-files/product-7.jpg','{\"filename\":\"product-7.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-7.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-7\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(232,192,'ecommerce/digital-product-files/product-35.jpg','{\"filename\":\"product-35.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-35.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-35\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(233,192,'ecommerce/digital-product-files/product-60.jpg','{\"filename\":\"product-60.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-60.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-60\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(234,192,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(235,192,'ecommerce/digital-product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(236,192,'ecommerce/digital-product-files/product-33.jpg','{\"filename\":\"product-33.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-33.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-33\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(237,192,'ecommerce/digital-product-files/product-88.jpg','{\"filename\":\"product-88.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-88.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-88\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(238,193,'ecommerce/digital-product-files/product-17.jpg','{\"filename\":\"product-17.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-17\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(239,193,'ecommerce/digital-product-files/product-64.jpg','{\"filename\":\"product-64.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-64.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-64\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(240,193,'ecommerce/digital-product-files/product-37.jpg','{\"filename\":\"product-37.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-37.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-37\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(241,193,'ecommerce/digital-product-files/product-7.jpg','{\"filename\":\"product-7.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-7.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-7\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(242,193,'ecommerce/digital-product-files/product-35.jpg','{\"filename\":\"product-35.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-35.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-35\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(243,193,'ecommerce/digital-product-files/product-60.jpg','{\"filename\":\"product-60.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-60.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-60\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(244,193,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(245,193,'ecommerce/digital-product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(246,193,'ecommerce/digital-product-files/product-33.jpg','{\"filename\":\"product-33.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-33.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-33\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(247,193,'ecommerce/digital-product-files/product-88.jpg','{\"filename\":\"product-88.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-88.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:54\",\"name\":\"product-88\",\"extension\":\"jpg\"}','2025-11-18 21:22:54','2025-11-18 21:22:54'),(248,200,'ecommerce/digital-product-files/product-47.jpg','{\"filename\":\"product-47.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-47.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-47\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(249,200,'ecommerce/digital-product-files/product-81.jpg','{\"filename\":\"product-81.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-81.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-81\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(250,200,'ecommerce/digital-product-files/product-93.jpg','{\"filename\":\"product-93.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-93.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-93\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(251,200,'ecommerce/digital-product-files/product-52.jpg','{\"filename\":\"product-52.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-52.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-52\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(252,200,'ecommerce/digital-product-files/product-58.jpg','{\"filename\":\"product-58.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-58.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-58\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(253,201,'ecommerce/digital-product-files/product-47.jpg','{\"filename\":\"product-47.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-47.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-47\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(254,201,'ecommerce/digital-product-files/product-81.jpg','{\"filename\":\"product-81.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-81.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-81\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(255,201,'ecommerce/digital-product-files/product-93.jpg','{\"filename\":\"product-93.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-93.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-93\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(256,201,'ecommerce/digital-product-files/product-52.jpg','{\"filename\":\"product-52.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-52.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-52\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(257,201,'ecommerce/digital-product-files/product-58.jpg','{\"filename\":\"product-58.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-58.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-58\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(258,202,'ecommerce/digital-product-files/product-47.jpg','{\"filename\":\"product-47.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-47.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-47\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(259,202,'ecommerce/digital-product-files/product-81.jpg','{\"filename\":\"product-81.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-81.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-81\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(260,202,'ecommerce/digital-product-files/product-93.jpg','{\"filename\":\"product-93.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-93.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-93\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(261,202,'ecommerce/digital-product-files/product-52.jpg','{\"filename\":\"product-52.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-52.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-52\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(262,202,'ecommerce/digital-product-files/product-58.jpg','{\"filename\":\"product-58.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-58.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-58\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(263,203,'ecommerce/digital-product-files/product-47.jpg','{\"filename\":\"product-47.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-47.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-47\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(264,203,'ecommerce/digital-product-files/product-81.jpg','{\"filename\":\"product-81.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-81.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-81\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(265,203,'ecommerce/digital-product-files/product-93.jpg','{\"filename\":\"product-93.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-93.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-93\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(266,203,'ecommerce/digital-product-files/product-52.jpg','{\"filename\":\"product-52.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-52.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-52\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(267,203,'ecommerce/digital-product-files/product-58.jpg','{\"filename\":\"product-58.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-58.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-58\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(268,211,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(269,211,'ecommerce/digital-product-files/product-70.jpg','{\"filename\":\"product-70.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-70.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-70\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(270,211,'ecommerce/digital-product-files/product-24.jpg','{\"filename\":\"product-24.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-24.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-24\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(271,211,'ecommerce/digital-product-files/product-59.jpg','{\"filename\":\"product-59.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-59.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-59\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(272,211,'ecommerce/digital-product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(273,211,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(274,211,'ecommerce/digital-product-files/product-43.jpg','{\"filename\":\"product-43.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-43.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-43\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(275,211,'ecommerce/digital-product-files/product-84.jpg','{\"filename\":\"product-84.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-84.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-84\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(276,211,'ecommerce/digital-product-files/product-95.jpg','{\"filename\":\"product-95.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-95.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-95\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(277,211,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(278,212,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(279,212,'ecommerce/digital-product-files/product-70.jpg','{\"filename\":\"product-70.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-70.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-70\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(280,212,'ecommerce/digital-product-files/product-24.jpg','{\"filename\":\"product-24.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-24.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-24\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(281,212,'ecommerce/digital-product-files/product-59.jpg','{\"filename\":\"product-59.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-59.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-59\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(282,212,'ecommerce/digital-product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(283,212,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(284,212,'ecommerce/digital-product-files/product-43.jpg','{\"filename\":\"product-43.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-43.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-43\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(285,212,'ecommerce/digital-product-files/product-84.jpg','{\"filename\":\"product-84.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-84.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-84\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(286,212,'ecommerce/digital-product-files/product-95.jpg','{\"filename\":\"product-95.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-95.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-95\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(287,212,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(288,213,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(289,213,'ecommerce/digital-product-files/product-70.jpg','{\"filename\":\"product-70.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-70.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-70\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(290,213,'ecommerce/digital-product-files/product-24.jpg','{\"filename\":\"product-24.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-24.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-24\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(291,213,'ecommerce/digital-product-files/product-59.jpg','{\"filename\":\"product-59.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-59.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-59\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(292,213,'ecommerce/digital-product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(293,213,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(294,213,'ecommerce/digital-product-files/product-43.jpg','{\"filename\":\"product-43.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-43.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-43\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(295,213,'ecommerce/digital-product-files/product-84.jpg','{\"filename\":\"product-84.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-84.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-84\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(296,213,'ecommerce/digital-product-files/product-95.jpg','{\"filename\":\"product-95.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-95.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-95\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(297,213,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(298,214,'ecommerce/digital-product-files/product-10.jpg','{\"filename\":\"product-10.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-10.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-10\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(299,214,'ecommerce/digital-product-files/product-70.jpg','{\"filename\":\"product-70.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-70.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-70\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(300,214,'ecommerce/digital-product-files/product-24.jpg','{\"filename\":\"product-24.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-24.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-24\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(301,214,'ecommerce/digital-product-files/product-59.jpg','{\"filename\":\"product-59.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-59.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-59\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(302,214,'ecommerce/digital-product-files/product-1.jpg','{\"filename\":\"product-1.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-1\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(303,214,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(304,214,'ecommerce/digital-product-files/product-43.jpg','{\"filename\":\"product-43.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-43.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-43\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(305,214,'ecommerce/digital-product-files/product-84.jpg','{\"filename\":\"product-84.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-84.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-84\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(306,214,'ecommerce/digital-product-files/product-95.jpg','{\"filename\":\"product-95.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-95.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-95\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(307,214,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:55\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2025-11-18 21:22:55','2025-11-18 21:22:55'),(308,221,'ecommerce/digital-product-files/product-26.jpg','{\"filename\":\"product-26.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-26.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-26\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(309,221,'ecommerce/digital-product-files/product-60.jpg','{\"filename\":\"product-60.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-60.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-60\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(310,221,'ecommerce/digital-product-files/product-82.jpg','{\"filename\":\"product-82.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-82.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-82\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(311,221,'ecommerce/digital-product-files/product-32.jpg','{\"filename\":\"product-32.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-32.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-32\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(312,221,'ecommerce/digital-product-files/product-51.jpg','{\"filename\":\"product-51.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-51.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-51\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(313,221,'ecommerce/digital-product-files/product-22.jpg','{\"filename\":\"product-22.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-22.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-22\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(314,221,'ecommerce/digital-product-files/product-61.jpg','{\"filename\":\"product-61.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-61.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-61\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(315,231,'ecommerce/digital-product-files/product-19.jpg','{\"filename\":\"product-19.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-19.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-19\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(316,231,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(317,231,'ecommerce/digital-product-files/product-39.jpg','{\"filename\":\"product-39.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-39.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-39\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(318,231,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(319,231,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(320,231,'ecommerce/digital-product-files/product-85.jpg','{\"filename\":\"product-85.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-85.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-85\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(321,231,'ecommerce/digital-product-files/product-21.jpg','{\"filename\":\"product-21.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-21.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-21\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(322,231,'ecommerce/digital-product-files/product-52.jpg','{\"filename\":\"product-52.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-52.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-52\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(323,231,'ecommerce/digital-product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(324,231,'ecommerce/digital-product-files/product-91.jpg','{\"filename\":\"product-91.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-91.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-91\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(325,231,'ecommerce/digital-product-files/product-42.jpg','{\"filename\":\"product-42.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-42.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-42\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(326,231,'ecommerce/digital-product-files/product-65.jpg','{\"filename\":\"product-65.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-65.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-65\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(327,232,'ecommerce/digital-product-files/product-19.jpg','{\"filename\":\"product-19.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-19.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-19\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(328,232,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(329,232,'ecommerce/digital-product-files/product-39.jpg','{\"filename\":\"product-39.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-39.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-39\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(330,232,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(331,232,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(332,232,'ecommerce/digital-product-files/product-85.jpg','{\"filename\":\"product-85.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-85.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-85\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(333,232,'ecommerce/digital-product-files/product-21.jpg','{\"filename\":\"product-21.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-21.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-21\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(334,232,'ecommerce/digital-product-files/product-52.jpg','{\"filename\":\"product-52.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-52.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-52\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(335,232,'ecommerce/digital-product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(336,232,'ecommerce/digital-product-files/product-91.jpg','{\"filename\":\"product-91.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-91.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-91\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(337,232,'ecommerce/digital-product-files/product-42.jpg','{\"filename\":\"product-42.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-42.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-42\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(338,232,'ecommerce/digital-product-files/product-65.jpg','{\"filename\":\"product-65.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-65.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-65\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(339,233,'ecommerce/digital-product-files/product-19.jpg','{\"filename\":\"product-19.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-19.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-19\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(340,233,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(341,233,'ecommerce/digital-product-files/product-39.jpg','{\"filename\":\"product-39.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-39.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-39\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(342,233,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(343,233,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(344,233,'ecommerce/digital-product-files/product-85.jpg','{\"filename\":\"product-85.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-85.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-85\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(345,233,'ecommerce/digital-product-files/product-21.jpg','{\"filename\":\"product-21.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-21.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-21\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(346,233,'ecommerce/digital-product-files/product-52.jpg','{\"filename\":\"product-52.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-52.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-52\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(347,233,'ecommerce/digital-product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(348,233,'ecommerce/digital-product-files/product-91.jpg','{\"filename\":\"product-91.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-91.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-91\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(349,233,'ecommerce/digital-product-files/product-42.jpg','{\"filename\":\"product-42.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-42.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-42\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(350,233,'ecommerce/digital-product-files/product-65.jpg','{\"filename\":\"product-65.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-65.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-65\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(351,234,'ecommerce/digital-product-files/product-19.jpg','{\"filename\":\"product-19.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-19.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-19\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(352,234,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(353,234,'ecommerce/digital-product-files/product-39.jpg','{\"filename\":\"product-39.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-39.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-39\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(354,234,'ecommerce/digital-product-files/product-4.jpg','{\"filename\":\"product-4.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-4.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-4\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(355,234,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(356,234,'ecommerce/digital-product-files/product-85.jpg','{\"filename\":\"product-85.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-85.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-85\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(357,234,'ecommerce/digital-product-files/product-21.jpg','{\"filename\":\"product-21.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-21.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-21\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(358,234,'ecommerce/digital-product-files/product-52.jpg','{\"filename\":\"product-52.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-52.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-52\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(359,234,'ecommerce/digital-product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(360,234,'ecommerce/digital-product-files/product-91.jpg','{\"filename\":\"product-91.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-91.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-91\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(361,234,'ecommerce/digital-product-files/product-42.jpg','{\"filename\":\"product-42.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-42.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-42\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(362,234,'ecommerce/digital-product-files/product-65.jpg','{\"filename\":\"product-65.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-65.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:56\",\"name\":\"product-65\",\"extension\":\"jpg\"}','2025-11-18 21:22:56','2025-11-18 21:22:56'),(363,247,'ecommerce/digital-product-files/product-94.jpg','{\"filename\":\"product-94.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-94.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-94\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(364,247,'ecommerce/digital-product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(365,247,'ecommerce/digital-product-files/product-24.jpg','{\"filename\":\"product-24.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-24.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-24\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(366,247,'ecommerce/digital-product-files/product-23.jpg','{\"filename\":\"product-23.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-23.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-23\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(367,247,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(368,248,'ecommerce/digital-product-files/product-94.jpg','{\"filename\":\"product-94.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-94.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-94\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(369,248,'ecommerce/digital-product-files/product-13.jpg','{\"filename\":\"product-13.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-13\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(370,248,'ecommerce/digital-product-files/product-24.jpg','{\"filename\":\"product-24.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-24.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-24\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(371,248,'ecommerce/digital-product-files/product-23.jpg','{\"filename\":\"product-23.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-23.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-23\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(372,248,'ecommerce/digital-product-files/product-67.jpg','{\"filename\":\"product-67.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-67.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-67\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(373,256,'ecommerce/digital-product-files/product-74.jpg','{\"filename\":\"product-74.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-74.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-74\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(374,256,'ecommerce/digital-product-files/product-6.jpg','{\"filename\":\"product-6.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-6.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-6\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(375,256,'ecommerce/digital-product-files/product-44.jpg','{\"filename\":\"product-44.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-44.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-44\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(376,256,'ecommerce/digital-product-files/product-55.jpg','{\"filename\":\"product-55.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-55.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-55\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(377,256,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(378,256,'ecommerce/digital-product-files/product-39.jpg','{\"filename\":\"product-39.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-39.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-39\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(379,256,'ecommerce/digital-product-files/product-87.jpg','{\"filename\":\"product-87.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-87.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-87\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(380,256,'ecommerce/digital-product-files/product-62.jpg','{\"filename\":\"product-62.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-62.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-62\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(381,256,'ecommerce/digital-product-files/product-79.jpg','{\"filename\":\"product-79.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-79.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-79\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(382,256,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(383,256,'ecommerce/digital-product-files/product-43.jpg','{\"filename\":\"product-43.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-43.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-43\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(384,256,'ecommerce/digital-product-files/product-71.jpg','{\"filename\":\"product-71.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-71.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-71\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(385,257,'ecommerce/digital-product-files/product-74.jpg','{\"filename\":\"product-74.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-74.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-74\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(386,257,'ecommerce/digital-product-files/product-6.jpg','{\"filename\":\"product-6.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-6.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-6\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(387,257,'ecommerce/digital-product-files/product-44.jpg','{\"filename\":\"product-44.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-44.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-44\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(388,257,'ecommerce/digital-product-files/product-55.jpg','{\"filename\":\"product-55.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-55.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-55\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(389,257,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(390,257,'ecommerce/digital-product-files/product-39.jpg','{\"filename\":\"product-39.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-39.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-39\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(391,257,'ecommerce/digital-product-files/product-87.jpg','{\"filename\":\"product-87.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-87.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-87\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(392,257,'ecommerce/digital-product-files/product-62.jpg','{\"filename\":\"product-62.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-62.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-62\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(393,257,'ecommerce/digital-product-files/product-79.jpg','{\"filename\":\"product-79.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-79.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-79\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(394,257,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(395,257,'ecommerce/digital-product-files/product-43.jpg','{\"filename\":\"product-43.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-43.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-43\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(396,257,'ecommerce/digital-product-files/product-71.jpg','{\"filename\":\"product-71.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-71.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-71\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(397,258,'ecommerce/digital-product-files/product-74.jpg','{\"filename\":\"product-74.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-74.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-74\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(398,258,'ecommerce/digital-product-files/product-6.jpg','{\"filename\":\"product-6.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-6.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-6\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(399,258,'ecommerce/digital-product-files/product-44.jpg','{\"filename\":\"product-44.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-44.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-44\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(400,258,'ecommerce/digital-product-files/product-55.jpg','{\"filename\":\"product-55.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-55.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-55\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(401,258,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(402,258,'ecommerce/digital-product-files/product-39.jpg','{\"filename\":\"product-39.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-39.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-39\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(403,258,'ecommerce/digital-product-files/product-87.jpg','{\"filename\":\"product-87.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-87.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-87\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(404,258,'ecommerce/digital-product-files/product-62.jpg','{\"filename\":\"product-62.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-62.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-62\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(405,258,'ecommerce/digital-product-files/product-79.jpg','{\"filename\":\"product-79.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-79.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-79\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(406,258,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(407,258,'ecommerce/digital-product-files/product-43.jpg','{\"filename\":\"product-43.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-43.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-43\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(408,258,'ecommerce/digital-product-files/product-71.jpg','{\"filename\":\"product-71.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-71.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-71\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(409,259,'ecommerce/digital-product-files/product-74.jpg','{\"filename\":\"product-74.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-74.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-74\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(410,259,'ecommerce/digital-product-files/product-6.jpg','{\"filename\":\"product-6.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-6.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-6\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(411,259,'ecommerce/digital-product-files/product-44.jpg','{\"filename\":\"product-44.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-44.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-44\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(412,259,'ecommerce/digital-product-files/product-55.jpg','{\"filename\":\"product-55.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-55.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-55\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(413,259,'ecommerce/digital-product-files/product-20.jpg','{\"filename\":\"product-20.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-20.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-20\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(414,259,'ecommerce/digital-product-files/product-39.jpg','{\"filename\":\"product-39.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-39.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-39\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(415,259,'ecommerce/digital-product-files/product-87.jpg','{\"filename\":\"product-87.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-87.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-87\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(416,259,'ecommerce/digital-product-files/product-62.jpg','{\"filename\":\"product-62.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-62.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-62\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(417,259,'ecommerce/digital-product-files/product-79.jpg','{\"filename\":\"product-79.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-79.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-79\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(418,259,'ecommerce/digital-product-files/product-31.jpg','{\"filename\":\"product-31.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-31.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-31\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(419,259,'ecommerce/digital-product-files/product-43.jpg','{\"filename\":\"product-43.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-43.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-43\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57'),(420,259,'ecommerce/digital-product-files/product-71.jpg','{\"filename\":\"product-71.jpg\",\"url\":\"ecommerce\\/digital-product-files\\/product-71.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":9730,\"modified\":\"2025-11-19 04:22:57\",\"name\":\"product-71\",\"extension\":\"jpg\"}','2025-11-18 21:22:57','2025-11-18 21:22:57');
/*!40000 ALTER TABLE `ec_product_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_label_products`
--

DROP TABLE IF EXISTS `ec_product_label_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_label_products` (
  `product_label_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_label_id`,`product_id`),
  KEY `ec_product_label_products_product_label_id_index` (`product_label_id`),
  KEY `ec_product_label_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_label_products`
--

LOCK TABLES `ec_product_label_products` WRITE;
/*!40000 ALTER TABLE `ec_product_label_products` DISABLE KEYS */;
INSERT INTO `ec_product_label_products` VALUES (1,49),(1,70),(2,7),(2,14),(2,28),(2,35),(2,42),(2,56),(3,21),(3,63);
/*!40000 ALTER TABLE `ec_product_label_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels`
--

DROP TABLE IF EXISTS `ec_product_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `text_color` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels`
--

LOCK TABLES `ec_product_labels` WRITE;
/*!40000 ALTER TABLE `ec_product_labels` DISABLE KEYS */;
INSERT INTO `ec_product_labels` VALUES (1,'Hot','#d71e2d','published','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL),(2,'New','#02856e','published','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL),(3,'Sale','#fe9931','published','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL);
/*!40000 ALTER TABLE `ec_product_labels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels_translations`
--

DROP TABLE IF EXISTS `ec_product_labels_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_labels_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_labels_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels_translations`
--

LOCK TABLES `ec_product_labels_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_labels_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_labels_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_license_codes`
--

DROP TABLE IF EXISTS `ec_product_license_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_license_codes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `license_code` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'available',
  `assigned_order_product_id` bigint unsigned DEFAULT NULL,
  `assigned_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_license_codes_product_id_status_index` (`product_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_license_codes`
--

LOCK TABLES `ec_product_license_codes` WRITE;
/*!40000 ALTER TABLE `ec_product_license_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_license_codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_related_relations`
--

DROP TABLE IF EXISTS `ec_product_related_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_related_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_related_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_related_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_related_relations`
--

LOCK TABLES `ec_product_related_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_related_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_related_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_specification_attribute`
--

DROP TABLE IF EXISTS `ec_product_specification_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_specification_attribute` (
  `product_id` bigint unsigned NOT NULL,
  `attribute_id` bigint unsigned NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  `order` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`attribute_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_specification_attribute`
--

LOCK TABLES `ec_product_specification_attribute` WRITE;
/*!40000 ALTER TABLE `ec_product_specification_attribute` DISABLE KEYS */;
INSERT INTO `ec_product_specification_attribute` VALUES (1,1,'49.12 cm',0,0),(1,2,'61.98 cm',0,0),(1,3,'41.49 cm',0,0),(1,4,'34.35 cm',0,0),(1,5,'73.08 cm',0,0),(2,1,'24.61 cm',0,0),(2,2,'74.93 cm',0,0),(2,3,'60.38 cm',0,0),(2,4,'71.89 cm',0,0),(2,5,'59.26 cm',0,0),(3,1,'51.15 cm',0,0),(3,2,'19.66 cm',0,0),(3,3,'26.52 cm',0,0),(3,4,'12.04 cm',0,0),(3,5,'4.04 cm',0,0),(4,6,'25.84 cm',0,0),(4,7,'50.69 cm',0,0),(4,8,'3840x2160',0,0),(5,1,'10.28 cm',0,0),(5,2,'63.89 cm',0,0),(5,3,'81.31 cm',0,0),(5,4,'60.02 cm',0,0),(5,5,'40.02 cm',0,0),(6,1,'9.68 cm',0,0),(6,2,'60.82 cm',0,0),(6,3,'19.89 cm',0,0),(6,4,'81.55 cm',0,0),(6,5,'46.93 cm',0,0),(7,6,'27.57 cm',0,0),(7,7,'52.61 cm',0,0),(7,8,'1920x1080',0,0),(8,6,'64.99 cm',0,0),(8,7,'9.92 cm',0,0),(8,8,'3840x2160',0,0),(9,1,'22.23 cm',0,0),(9,2,'25.14 cm',0,0),(9,3,'78.88 cm',0,0),(9,4,'20.96 cm',0,0),(9,5,'54.9 cm',0,0),(10,6,'85.53 cm',0,0),(10,7,'46.71 cm',0,0),(10,8,'1920x1080',0,0),(11,6,'88.3 cm',0,0),(11,7,'36.08 cm',0,0),(11,8,'2560x1440',0,0),(12,1,'97.99 cm',0,0),(12,2,'26.83 cm',0,0),(12,3,'25.49 cm',0,0),(12,4,'95.04 cm',0,0),(12,5,'30.85 cm',0,0),(13,1,'33.8 cm',0,0),(13,2,'2.91 cm',0,0),(13,3,'24.24 cm',0,0),(13,4,'59.5 cm',0,0),(13,5,'98.37 cm',0,0),(14,1,'16.98 cm',0,0),(14,2,'70.26 cm',0,0),(14,3,'45.81 cm',0,0),(14,4,'12.89 cm',0,0),(14,5,'7.84 cm',0,0),(15,1,'54.9 cm',0,0),(15,2,'16.5 cm',0,0),(15,3,'71.05 cm',0,0),(15,4,'28.65 cm',0,0),(15,5,'98.55 cm',0,0),(16,1,'51.17 cm',0,0),(16,2,'66.24 cm',0,0),(16,3,'29.33 cm',0,0),(16,4,'65.33 cm',0,0),(16,5,'28.31 cm',0,0),(17,1,'17.87 cm',0,0),(17,2,'20.67 cm',0,0),(17,3,'75.66 cm',0,0),(17,4,'91.71 cm',0,0),(17,5,'15.82 cm',0,0),(18,6,'34.33 cm',0,0),(18,7,'14.09 cm',0,0),(18,8,'2560x1440',0,0),(19,6,'5.94 cm',0,0),(19,7,'37.36 cm',0,0),(19,8,'2560x1440',0,0),(20,1,'88.56 cm',0,0),(20,2,'52.44 cm',0,0),(20,3,'3.05 cm',0,0),(20,4,'10.04 cm',0,0),(20,5,'35.95 cm',0,0),(21,6,'6.93 cm',0,0),(21,7,'80.16 cm',0,0),(21,8,'2560x1440',0,0),(22,6,'44.47 cm',0,0),(22,7,'84.17 cm',0,0),(22,8,'3840x2160',0,0),(23,6,'91.23 cm',0,0),(23,7,'66.3 cm',0,0),(23,8,'1920x1080',0,0),(24,6,'38.81 cm',0,0),(24,7,'67.66 cm',0,0),(24,8,'1920x1080',0,0),(25,1,'79.08 cm',0,0),(25,2,'9.04 cm',0,0),(25,3,'17.25 cm',0,0),(25,4,'30.75 cm',0,0),(25,5,'50.51 cm',0,0),(26,6,'79.47 cm',0,0),(26,7,'27.45 cm',0,0),(26,8,'3840x2160',0,0),(27,6,'51.08 cm',0,0),(27,7,'38.17 cm',0,0),(27,8,'3840x2160',0,0),(28,6,'7.45 cm',0,0),(28,7,'13.06 cm',0,0),(28,8,'1920x1080',0,0),(29,1,'54.33 cm',0,0),(29,2,'11.49 cm',0,0),(29,3,'27.52 cm',0,0),(29,4,'73.79 cm',0,0),(29,5,'40.52 cm',0,0),(30,1,'34.07 cm',0,0),(30,2,'27.81 cm',0,0),(30,3,'7.19 cm',0,0),(30,4,'22.71 cm',0,0),(30,5,'36.22 cm',0,0),(31,6,'97.94 cm',0,0),(31,7,'39.95 cm',0,0),(31,8,'2560x1440',0,0),(32,6,'35.46 cm',0,0),(32,7,'44.95 cm',0,0),(32,8,'2560x1440',0,0),(33,1,'95.23 cm',0,0),(33,2,'87.14 cm',0,0),(33,3,'20.15 cm',0,0),(33,4,'67.6 cm',0,0),(33,5,'12.89 cm',0,0),(34,6,'68.42 cm',0,0),(34,7,'10.69 cm',0,0),(34,8,'2560x1440',0,0),(35,6,'56.9 cm',0,0),(35,7,'8.23 cm',0,0),(35,8,'2560x1440',0,0),(36,1,'3.35 cm',0,0),(36,2,'58.1 cm',0,0),(36,3,'17.91 cm',0,0),(36,4,'37.8 cm',0,0),(36,5,'85.63 cm',0,0),(37,1,'87.02 cm',0,0),(37,2,'27.81 cm',0,0),(37,3,'76.86 cm',0,0),(37,4,'7.99 cm',0,0),(37,5,'82.91 cm',0,0),(38,1,'63.66 cm',0,0),(38,2,'71.64 cm',0,0),(38,3,'83.57 cm',0,0),(38,4,'27.03 cm',0,0),(38,5,'51.96 cm',0,0),(39,1,'70.16 cm',0,0),(39,2,'43.14 cm',0,0),(39,3,'55.1 cm',0,0),(39,4,'65.52 cm',0,0),(39,5,'74.38 cm',0,0),(40,1,'9.23 cm',0,0),(40,2,'69.55 cm',0,0),(40,3,'47.23 cm',0,0),(40,4,'21.3 cm',0,0),(40,5,'1.84 cm',0,0),(41,6,'5.79 cm',0,0),(41,7,'1.25 cm',0,0),(41,8,'2560x1440',0,0),(42,6,'92.34 cm',0,0),(42,7,'4.73 cm',0,0),(42,8,'2560x1440',0,0),(43,6,'53.58 cm',0,0),(43,7,'75.46 cm',0,0),(43,8,'3840x2160',0,0),(44,1,'89.12 cm',0,0),(44,2,'53.03 cm',0,0),(44,3,'26.59 cm',0,0),(44,4,'49.69 cm',0,0),(44,5,'6.03 cm',0,0),(45,6,'42.32 cm',0,0),(45,7,'57.62 cm',0,0),(45,8,'3840x2160',0,0),(46,1,'24.76 cm',0,0),(46,2,'48.24 cm',0,0),(46,3,'46.96 cm',0,0),(46,4,'15.37 cm',0,0),(46,5,'45.02 cm',0,0),(47,1,'28.15 cm',0,0),(47,2,'44.9 cm',0,0),(47,3,'73.62 cm',0,0),(47,4,'67.82 cm',0,0),(47,5,'43.6 cm',0,0),(48,6,'22.02 cm',0,0),(48,7,'61.35 cm',0,0),(48,8,'3840x2160',0,0),(49,1,'35.57 cm',0,0),(49,2,'50.63 cm',0,0),(49,3,'78.78 cm',0,0),(49,4,'2.94 cm',0,0),(49,5,'56.63 cm',0,0),(50,1,'5.94 cm',0,0),(50,2,'53.92 cm',0,0),(50,3,'28.44 cm',0,0),(50,4,'54.59 cm',0,0),(50,5,'90.9 cm',0,0),(51,1,'85.51 cm',0,0),(51,2,'82.19 cm',0,0),(51,3,'64.67 cm',0,0),(51,4,'17.42 cm',0,0),(51,5,'22.25 cm',0,0),(52,6,'38.59 cm',0,0),(52,7,'42.28 cm',0,0),(52,8,'2560x1440',0,0),(53,6,'24.35 cm',0,0),(53,7,'69.38 cm',0,0),(53,8,'3840x2160',0,0),(54,1,'25.73 cm',0,0),(54,2,'5.09 cm',0,0),(54,3,'78.11 cm',0,0),(54,4,'78.11 cm',0,0),(54,5,'35.73 cm',0,0),(55,6,'14.36 cm',0,0),(55,7,'77.69 cm',0,0),(55,8,'2560x1440',0,0),(56,6,'33.35 cm',0,0),(56,7,'74.52 cm',0,0),(56,8,'1920x1080',0,0),(57,1,'76.14 cm',0,0),(57,2,'96.13 cm',0,0),(57,3,'69.6 cm',0,0),(57,4,'53.86 cm',0,0),(57,5,'59.43 cm',0,0),(58,1,'22.76 cm',0,0),(58,2,'29.69 cm',0,0),(58,3,'75.99 cm',0,0),(58,4,'59.86 cm',0,0),(58,5,'89.9 cm',0,0),(59,6,'60.28 cm',0,0),(59,7,'77.31 cm',0,0),(59,8,'3840x2160',0,0),(60,1,'91.73 cm',0,0),(60,2,'85.82 cm',0,0),(60,3,'90.87 cm',0,0),(60,4,'24.34 cm',0,0),(60,5,'79.75 cm',0,0),(61,6,'69.63 cm',0,0),(61,7,'61.79 cm',0,0),(61,8,'1920x1080',0,0),(62,6,'28.05 cm',0,0),(62,7,'7.29 cm',0,0),(62,8,'1920x1080',0,0),(63,1,'23.93 cm',0,0),(63,2,'26.16 cm',0,0),(63,3,'93.92 cm',0,0),(63,4,'18.48 cm',0,0),(63,5,'3.53 cm',0,0),(64,1,'15.62 cm',0,0),(64,2,'61.34 cm',0,0),(64,3,'7.27 cm',0,0),(64,4,'74.44 cm',0,0),(64,5,'64.23 cm',0,0),(65,1,'7.59 cm',0,0),(65,2,'35.68 cm',0,0),(65,3,'81.69 cm',0,0),(65,4,'81.41 cm',0,0),(65,5,'58.22 cm',0,0),(66,1,'86.12 cm',0,0),(66,2,'41.07 cm',0,0),(66,3,'88.68 cm',0,0),(66,4,'93.2 cm',0,0),(66,5,'26.79 cm',0,0),(67,6,'95.61 cm',0,0),(67,7,'20.1 cm',0,0),(67,8,'1920x1080',0,0),(68,1,'67.58 cm',0,0),(68,2,'96.91 cm',0,0),(68,3,'88.19 cm',0,0),(68,4,'87.51 cm',0,0),(68,5,'76.89 cm',0,0),(69,6,'8.61 cm',0,0),(69,7,'57.5 cm',0,0),(69,8,'2560x1440',0,0),(70,1,'72.54 cm',0,0),(70,2,'9.73 cm',0,0),(70,3,'25.98 cm',0,0),(70,4,'48.16 cm',0,0),(70,5,'16.38 cm',0,0),(71,6,'18.16 cm',0,0),(71,7,'11.47 cm',0,0),(71,8,'2560x1440',0,0),(72,1,'82.01 cm',0,0),(72,2,'28.59 cm',0,0),(72,3,'54.25 cm',0,0),(72,4,'84.59 cm',0,0),(72,5,'6.59 cm',0,0),(73,1,'51.68 cm',0,0),(73,2,'35.87 cm',0,0),(73,3,'2.07 cm',0,0),(73,4,'79.12 cm',0,0),(73,5,'43.2 cm',0,0),(74,1,'81.07 cm',0,0),(74,2,'57.76 cm',0,0),(74,3,'16.75 cm',0,0),(74,4,'67.38 cm',0,0),(74,5,'58.57 cm',0,0),(75,1,'44.54 cm',0,0),(75,2,'85.77 cm',0,0),(75,3,'24.24 cm',0,0),(75,4,'50.1 cm',0,0),(75,5,'98.49 cm',0,0);
/*!40000 ALTER TABLE `ec_product_specification_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_specification_attribute_translations`
--

DROP TABLE IF EXISTS `ec_product_specification_attribute_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_specification_attribute_translations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `attribute_id` bigint unsigned NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `psat_unique` (`product_id`,`attribute_id`,`lang_code`),
  KEY `psat_product_attribute_index` (`product_id`,`attribute_id`),
  KEY `psat_product_id_index` (`product_id`),
  KEY `psat_attribute_id_index` (`attribute_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_specification_attribute_translations`
--

LOCK TABLES `ec_product_specification_attribute_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_specification_attribute_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_specification_attribute_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tag_product`
--

DROP TABLE IF EXISTS `ec_product_tag_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tag_product` (
  `product_id` bigint unsigned NOT NULL,
  `tag_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tag_id`),
  KEY `ec_product_tag_product_product_id_index` (`product_id`),
  KEY `ec_product_tag_product_tag_id_index` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tag_product`
--

LOCK TABLES `ec_product_tag_product` WRITE;
/*!40000 ALTER TABLE `ec_product_tag_product` DISABLE KEYS */;
INSERT INTO `ec_product_tag_product` VALUES (1,2),(1,4),(1,6),(2,5),(2,6),(3,2),(3,5),(4,5),(4,6),(5,3),(5,5),(6,1),(6,2),(6,4),(7,1),(7,4),(8,2),(8,5),(8,6),(9,3),(9,5),(10,1),(10,4),(10,5),(11,1),(11,2),(11,3),(12,1),(12,2),(13,2),(13,3),(13,6),(14,1),(14,2),(14,4),(15,2),(15,3),(15,4),(16,3),(16,4),(16,5),(17,3),(17,5),(17,6),(18,4),(19,1),(19,5),(20,2),(20,4),(20,6),(21,3),(21,6),(22,2),(22,4),(22,6),(23,2),(23,5),(24,2),(24,3),(24,4),(25,1),(25,4),(26,1),(26,2),(26,6),(27,1),(27,2),(27,6),(28,1),(28,3),(28,4),(29,2),(29,5),(30,2),(30,3),(30,5),(31,2),(31,5),(31,6),(32,1),(32,4),(32,5),(33,1),(33,2),(33,4),(34,2),(34,3),(35,2),(35,6),(36,2),(36,5),(37,3),(37,6),(38,1),(38,3),(38,4),(39,2),(39,3),(39,6),(40,3),(41,3),(41,6),(42,1),(42,3),(43,1),(43,2),(43,4),(44,4),(44,6),(45,2),(45,4),(46,1),(46,4),(46,6),(47,1),(47,3),(48,5),(48,6),(49,1),(49,3),(49,6),(50,1),(50,2),(50,5),(51,1),(51,2),(51,4),(52,2),(52,5),(53,2),(53,4),(53,5),(54,1),(54,6),(55,1),(55,3),(55,6),(56,1),(56,4),(57,3),(57,4),(58,4),(58,6),(59,2),(59,4),(59,6),(60,1),(61,2),(61,5),(61,6),(62,2),(62,4),(62,5),(63,3),(63,4),(63,5),(64,2),(64,3),(64,5),(65,1),(65,2),(65,6),(66,5),(66,6),(67,2),(67,4),(67,6),(68,2),(68,6),(69,1),(69,5),(69,6),(70,2),(70,6),(71,4),(71,5),(72,3),(72,4),(72,5),(73,1),(73,2),(73,3),(74,3),(74,5),(75,3),(75,5),(75,6);
/*!40000 ALTER TABLE `ec_product_tag_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags`
--

DROP TABLE IF EXISTS `ec_product_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags`
--

LOCK TABLES `ec_product_tags` WRITE;
/*!40000 ALTER TABLE `ec_product_tags` DISABLE KEYS */;
INSERT INTO `ec_product_tags` VALUES (1,'Electronic',NULL,'published','2025-11-18 21:22:42','2025-11-18 21:22:42'),(2,'Mobile',NULL,'published','2025-11-18 21:22:42','2025-11-18 21:22:42'),(3,'Iphone',NULL,'published','2025-11-18 21:22:42','2025-11-18 21:22:42'),(4,'Printer',NULL,'published','2025-11-18 21:22:42','2025-11-18 21:22:42'),(5,'Office',NULL,'published','2025-11-18 21:22:42','2025-11-18 21:22:42'),(6,'IT',NULL,'published','2025-11-18 21:22:42','2025-11-18 21:22:42');
/*!40000 ALTER TABLE `ec_product_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags_translations`
--

DROP TABLE IF EXISTS `ec_product_tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags_translations`
--

LOCK TABLES `ec_product_tags_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_up_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_up_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_up_sale_relations` (
  `from_product_id` bigint unsigned NOT NULL,
  `to_product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`from_product_id`,`to_product_id`),
  KEY `ec_product_up_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_up_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_up_sale_relations`
--

LOCK TABLES `ec_product_up_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variation_items`
--

DROP TABLE IF EXISTS `ec_product_variation_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variation_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_variation_items_attribute_id_variation_id_unique` (`attribute_id`,`variation_id`),
  KEY `attribute_variation_index` (`attribute_id`,`variation_id`),
  KEY `idx_variation_id` (`variation_id`),
  KEY `idx_variation_attribute_covering` (`variation_id`,`attribute_id`),
  KEY `ec_product_variation_items_variation_id_attribute_id_index` (`variation_id`,`attribute_id`)
) ENGINE=InnoDB AUTO_INCREMENT=379 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variation_items`
--

LOCK TABLES `ec_product_variation_items` WRITE;
/*!40000 ALTER TABLE `ec_product_variation_items` DISABLE KEYS */;
INSERT INTO `ec_product_variation_items` VALUES (1,1,1),(3,1,2),(11,1,6),(25,1,13),(29,1,15),(47,1,24),(53,1,27),(77,1,39),(87,1,44),(91,1,46),(93,1,47),(95,1,48),(115,1,58),(123,1,62),(139,1,70),(169,1,85),(183,1,92),(187,1,94),(195,1,98),(211,1,106),(225,1,113),(227,1,114),(231,1,116),(235,1,118),(241,1,121),(245,1,123),(249,1,125),(259,1,130),(261,1,131),(265,1,133),(273,1,137),(283,1,142),(299,1,150),(301,1,151),(307,1,154),(311,1,156),(315,1,158),(329,1,165),(343,1,172),(359,1,180),(15,2,8),(27,2,14),(33,2,17),(45,2,23),(59,2,30),(63,2,32),(71,2,36),(73,2,37),(75,2,38),(81,2,41),(89,2,45),(103,2,52),(105,2,53),(113,2,57),(117,2,59),(129,2,65),(133,2,67),(145,2,73),(149,2,75),(151,2,76),(155,2,78),(157,2,79),(159,2,80),(167,2,84),(175,2,88),(191,2,96),(203,2,102),(209,2,105),(213,2,107),(219,2,110),(229,2,115),(239,2,120),(263,2,132),(277,2,139),(285,2,143),(287,2,144),(295,2,148),(297,2,149),(305,2,153),(309,2,155),(313,2,157),(325,2,163),(331,2,166),(347,2,174),(371,2,186),(373,2,187),(377,2,189),(5,3,3),(7,3,4),(9,3,5),(43,3,22),(67,3,34),(69,3,35),(107,3,54),(109,3,55),(121,3,61),(163,3,82),(171,3,86),(185,3,93),(215,3,108),(223,3,112),(243,3,122),(255,3,128),(267,3,134),(323,3,162),(327,3,164),(337,3,169),(17,4,9),(35,4,18),(37,4,19),(39,4,20),(41,4,21),(49,4,25),(51,4,26),(55,4,28),(85,4,43),(97,4,49),(99,4,50),(101,4,51),(119,4,60),(131,4,66),(137,4,69),(141,4,71),(165,4,83),(173,4,87),(177,4,89),(179,4,90),(199,4,100),(205,4,103),(217,4,109),(237,4,119),(253,4,127),(269,4,135),(271,4,136),(275,4,138),(291,4,146),(303,4,152),(341,4,171),(351,4,176),(357,4,179),(361,4,181),(363,4,182),(375,4,188),(13,5,7),(19,5,10),(21,5,11),(23,5,12),(31,5,16),(57,5,29),(61,5,31),(65,5,33),(79,5,40),(83,5,42),(111,5,56),(125,5,63),(127,5,64),(135,5,68),(143,5,72),(147,5,74),(153,5,77),(161,5,81),(181,5,91),(189,5,95),(193,5,97),(197,5,99),(201,5,101),(207,5,104),(221,5,111),(233,5,117),(247,5,124),(251,5,126),(257,5,129),(279,5,140),(281,5,141),(289,5,145),(293,5,147),(317,5,159),(319,5,160),(321,5,161),(333,5,167),(335,5,168),(339,5,170),(345,5,173),(349,5,175),(353,5,177),(355,5,178),(365,5,183),(367,5,184),(369,5,185),(20,6,10),(32,6,16),(36,6,18),(68,6,34),(76,6,38),(80,6,40),(84,6,42),(88,6,44),(104,6,52),(112,6,56),(122,6,61),(140,6,70),(160,6,80),(162,6,81),(170,6,85),(172,6,86),(190,6,95),(196,6,98),(200,6,100),(210,6,105),(220,6,110),(320,6,160),(326,6,163),(336,6,168),(342,6,171),(344,6,172),(8,7,4),(16,7,8),(22,7,11),(26,7,13),(34,7,17),(44,7,22),(50,7,25),(54,7,27),(90,7,45),(92,7,46),(96,7,48),(98,7,49),(100,7,50),(106,7,53),(110,7,55),(116,7,58),(124,7,62),(128,7,64),(142,7,71),(188,7,94),(198,7,99),(212,7,106),(216,7,108),(218,7,109),(236,7,118),(256,7,128),(258,7,129),(260,7,130),(264,7,132),(272,7,136),(282,7,141),(288,7,144),(290,7,145),(296,7,148),(298,7,149),(306,7,153),(310,7,155),(348,7,174),(350,7,175),(2,8,1),(4,8,2),(6,8,3),(10,8,5),(40,8,20),(42,8,21),(46,8,23),(48,8,24),(52,8,26),(56,8,28),(58,8,29),(62,8,31),(70,8,35),(72,8,36),(74,8,37),(102,8,51),(120,8,60),(134,8,67),(146,8,73),(150,8,75),(154,8,77),(158,8,79),(176,8,88),(182,8,91),(186,8,93),(192,8,96),(194,8,97),(202,8,101),(206,8,103),(226,8,113),(228,8,114),(230,8,115),(238,8,119),(240,8,120),(246,8,123),(248,8,124),(250,8,125),(252,8,126),(262,8,131),(266,8,133),(284,8,142),(286,8,143),(294,8,147),(302,8,151),(312,8,156),(316,8,158),(330,8,165),(340,8,170),(362,8,181),(364,8,182),(368,8,184),(372,8,186),(378,8,189),(14,9,7),(18,9,9),(66,9,33),(78,9,39),(86,9,43),(94,9,47),(108,9,54),(118,9,59),(130,9,65),(136,9,68),(148,9,74),(156,9,78),(164,9,82),(174,9,87),(180,9,90),(184,9,92),(204,9,102),(214,9,107),(222,9,111),(224,9,112),(232,9,116),(234,9,117),(244,9,122),(270,9,135),(274,9,137),(276,9,138),(278,9,139),(280,9,140),(300,9,150),(304,9,152),(322,9,161),(332,9,166),(338,9,169),(352,9,176),(356,9,178),(358,9,179),(370,9,185),(374,9,187),(12,10,6),(24,10,12),(28,10,14),(30,10,15),(38,10,19),(60,10,30),(64,10,32),(82,10,41),(114,10,57),(126,10,63),(132,10,66),(138,10,69),(144,10,72),(152,10,76),(166,10,83),(168,10,84),(178,10,89),(208,10,104),(242,10,121),(254,10,127),(268,10,134),(292,10,146),(308,10,154),(314,10,157),(318,10,159),(324,10,162),(328,10,164),(334,10,167),(346,10,173),(354,10,177),(360,10,180),(366,10,183),(376,10,188);
/*!40000 ALTER TABLE `ec_product_variation_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variations`
--

DROP TABLE IF EXISTS `ec_product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned DEFAULT NULL,
  `configurable_product_id` bigint unsigned NOT NULL,
  `is_default` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_variations_product_id_configurable_product_id_unique` (`product_id`,`configurable_product_id`),
  KEY `configurable_product_index` (`product_id`,`configurable_product_id`),
  KEY `idx_configurable_product_id` (`configurable_product_id`),
  KEY `idx_product_variations_config` (`configurable_product_id`,`is_default`),
  KEY `ec_product_variations_product_id_index` (`product_id`),
  KEY `ec_product_variations_configurable_product_id_index` (`configurable_product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=190 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variations`
--

LOCK TABLES `ec_product_variations` WRITE;
/*!40000 ALTER TABLE `ec_product_variations` DISABLE KEYS */;
INSERT INTO `ec_product_variations` VALUES (1,76,1,1),(2,77,1,0),(3,78,1,0),(4,79,2,1),(5,80,2,0),(6,81,3,1),(7,82,4,1),(8,83,4,0),(9,84,5,1),(10,85,6,1),(11,86,7,1),(12,87,7,0),(13,88,7,0),(14,89,7,0),(15,90,8,1),(16,91,8,0),(17,92,8,0),(18,93,9,1),(19,94,10,1),(20,95,10,0),(21,96,10,0),(22,97,11,1),(23,98,11,0),(24,99,11,0),(25,100,11,0),(26,101,12,1),(27,102,12,0),(28,103,12,0),(29,104,13,1),(30,105,14,1),(31,106,14,0),(32,107,14,0),(33,108,14,0),(34,109,15,1),(35,110,15,0),(36,111,16,1),(37,112,16,0),(38,113,17,1),(39,114,17,0),(40,115,17,0),(41,116,18,1),(42,117,18,0),(43,118,19,1),(44,119,19,0),(45,120,19,0),(46,121,20,1),(47,122,21,1),(48,123,22,1),(49,124,22,0),(50,125,22,0),(51,126,22,0),(52,127,23,1),(53,128,23,0),(54,129,24,1),(55,130,24,0),(56,131,25,1),(57,132,26,1),(58,133,26,0),(59,134,26,0),(60,135,26,0),(61,136,27,1),(62,137,28,1),(63,138,28,0),(64,139,29,1),(65,140,29,0),(66,141,29,0),(67,142,30,1),(68,143,30,0),(69,144,31,1),(70,145,31,0),(71,146,31,0),(72,147,32,1),(73,148,32,0),(74,149,32,0),(75,150,33,1),(76,151,33,0),(77,152,34,1),(78,153,34,0),(79,154,34,0),(80,155,35,1),(81,156,35,0),(82,157,35,0),(83,158,36,1),(84,159,36,0),(85,160,36,0),(86,161,36,0),(87,162,37,1),(88,163,37,0),(89,164,37,0),(90,165,37,0),(91,166,37,0),(92,167,38,1),(93,168,38,0),(94,169,38,0),(95,170,39,1),(96,171,40,1),(97,172,40,0),(98,173,41,1),(99,174,42,1),(100,175,43,1),(101,176,43,0),(102,177,43,0),(103,178,43,0),(104,179,44,1),(105,180,44,0),(106,181,44,0),(107,182,45,1),(108,183,45,0),(109,184,46,1),(110,185,46,0),(111,186,46,0),(112,187,47,1),(113,188,48,1),(114,189,48,0),(115,190,48,0),(116,191,49,1),(117,192,49,0),(118,193,49,0),(119,194,50,1),(120,195,50,0),(121,196,51,1),(122,197,51,0),(123,198,52,1),(124,199,52,0),(125,200,53,1),(126,201,53,0),(127,202,53,0),(128,203,53,0),(129,204,54,1),(130,205,55,1),(131,206,55,0),(132,207,56,1),(133,208,56,0),(134,209,56,0),(135,210,56,0),(136,211,57,1),(137,212,57,0),(138,213,57,0),(139,214,57,0),(140,215,58,1),(141,216,59,1),(142,217,59,0),(143,218,60,1),(144,219,60,0),(145,220,60,0),(146,221,61,1),(147,222,62,1),(148,223,62,0),(149,224,62,0),(150,225,62,0),(151,226,63,1),(152,227,63,0),(153,228,63,0),(154,229,64,1),(155,230,64,0),(156,231,65,1),(157,232,65,0),(158,233,65,0),(159,234,65,0),(160,235,66,1),(161,236,66,0),(162,237,66,0),(163,238,66,0),(164,239,67,1),(165,240,67,0),(166,241,67,0),(167,242,67,0),(168,243,68,1),(169,244,68,0),(170,245,68,0),(171,246,68,0),(172,247,69,1),(173,248,69,0),(174,249,70,1),(175,250,70,0),(176,251,71,1),(177,252,72,1),(178,253,72,0),(179,254,72,0),(180,255,72,0),(181,256,73,1),(182,257,73,0),(183,258,73,0),(184,259,73,0),(185,260,74,1),(186,261,74,0),(187,262,74,0),(188,263,75,1),(189,264,75,0);
/*!40000 ALTER TABLE `ec_product_variations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_views`
--

DROP TABLE IF EXISTS `ec_product_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_views` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `views` int NOT NULL DEFAULT '1',
  `date` date NOT NULL DEFAULT '2025-11-19',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_product_views_product_id_date_unique` (`product_id`,`date`),
  KEY `ec_product_views_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_views`
--

LOCK TABLES `ec_product_views` WRITE;
/*!40000 ALTER TABLE `ec_product_views` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_with_attribute_set`
--

DROP TABLE IF EXISTS `ec_product_with_attribute_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_with_attribute_set` (
  `attribute_set_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`attribute_set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_with_attribute_set`
--

LOCK TABLES `ec_product_with_attribute_set` WRITE;
/*!40000 ALTER TABLE `ec_product_with_attribute_set` DISABLE KEYS */;
INSERT INTO `ec_product_with_attribute_set` VALUES (1,1,0),(2,1,0),(1,2,0),(2,2,0),(1,3,0),(2,3,0),(1,4,0),(2,4,0),(1,5,0),(2,5,0),(1,6,0),(2,6,0),(1,7,0),(2,7,0),(1,8,0),(2,8,0),(1,9,0),(2,9,0),(1,10,0),(2,10,0),(1,11,0),(2,11,0),(1,12,0),(2,12,0),(1,13,0),(2,13,0),(1,14,0),(2,14,0),(1,15,0),(2,15,0),(1,16,0),(2,16,0),(1,17,0),(2,17,0),(1,18,0),(2,18,0),(1,19,0),(2,19,0),(1,20,0),(2,20,0),(1,21,0),(2,21,0),(1,22,0),(2,22,0),(1,23,0),(2,23,0),(1,24,0),(2,24,0),(1,25,0),(2,25,0),(1,26,0),(2,26,0),(1,27,0),(2,27,0),(1,28,0),(2,28,0),(1,29,0),(2,29,0),(1,30,0),(2,30,0),(1,31,0),(2,31,0),(1,32,0),(2,32,0),(1,33,0),(2,33,0),(1,34,0),(2,34,0),(1,35,0),(2,35,0),(1,36,0),(2,36,0),(1,37,0),(2,37,0),(1,38,0),(2,38,0),(1,39,0),(2,39,0),(1,40,0),(2,40,0),(1,41,0),(2,41,0),(1,42,0),(2,42,0),(1,43,0),(2,43,0),(1,44,0),(2,44,0),(1,45,0),(2,45,0),(1,46,0),(2,46,0),(1,47,0),(2,47,0),(1,48,0),(2,48,0),(1,49,0),(2,49,0),(1,50,0),(2,50,0),(1,51,0),(2,51,0),(1,52,0),(2,52,0),(1,53,0),(2,53,0),(1,54,0),(2,54,0),(1,55,0),(2,55,0),(1,56,0),(2,56,0),(1,57,0),(2,57,0),(1,58,0),(2,58,0),(1,59,0),(2,59,0),(1,60,0),(2,60,0),(1,61,0),(2,61,0),(1,62,0),(2,62,0),(1,63,0),(2,63,0),(1,64,0),(2,64,0),(1,65,0),(2,65,0),(1,66,0),(2,66,0),(1,67,0),(2,67,0),(1,68,0),(2,68,0),(1,69,0),(2,69,0),(1,70,0),(2,70,0),(1,71,0),(2,71,0),(1,72,0),(2,72,0),(1,73,0),(2,73,0),(1,74,0),(2,74,0),(1,75,0),(2,75,0);
/*!40000 ALTER TABLE `ec_product_with_attribute_set` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products`
--

DROP TABLE IF EXISTS `ec_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `images` text COLLATE utf8mb4_unicode_ci,
  `video_media` text COLLATE utf8mb4_unicode_ci,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `quantity` int unsigned DEFAULT NULL,
  `allow_checkout_when_out_of_stock` tinyint unsigned NOT NULL DEFAULT '0',
  `with_storehouse_management` tinyint unsigned NOT NULL DEFAULT '0',
  `stock_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'in_stock',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `brand_id` bigint unsigned DEFAULT NULL,
  `is_variation` tinyint NOT NULL DEFAULT '0',
  `variations_count` int unsigned NOT NULL DEFAULT '0',
  `reviews_count` int unsigned NOT NULL DEFAULT '0',
  `reviews_avg` decimal(3,2) NOT NULL DEFAULT '0.00',
  `sale_type` tinyint NOT NULL DEFAULT '0',
  `price` double unsigned DEFAULT NULL,
  `sale_price` double unsigned DEFAULT NULL,
  `start_date` timestamp NULL DEFAULT NULL,
  `end_date` timestamp NULL DEFAULT NULL,
  `length` double DEFAULT NULL,
  `wide` double DEFAULT NULL,
  `height` double DEFAULT NULL,
  `weight` double DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `views` bigint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by_id` bigint unsigned DEFAULT '0',
  `created_by_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'physical',
  `barcode` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cost_per_item` double DEFAULT NULL,
  `price_includes_tax` tinyint(1) NOT NULL DEFAULT '0',
  `generate_license_code` tinyint(1) NOT NULL DEFAULT '0',
  `license_code_type` enum('auto_generate','pick_from_list') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'auto_generate',
  `minimum_order_quantity` int unsigned DEFAULT '0',
  `maximum_order_quantity` int unsigned DEFAULT '0',
  `notify_attachment_updated` tinyint(1) NOT NULL DEFAULT '0',
  `specification_table_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_products_brand_id_status_is_variation_created_at_index` (`brand_id`,`status`,`is_variation`,`created_at`),
  KEY `sale_type_index` (`sale_type`),
  KEY `start_date_index` (`start_date`),
  KEY `end_date_index` (`end_date`),
  KEY `sale_price_index` (`sale_price`),
  KEY `is_variation_index` (`is_variation`),
  KEY `ec_products_sku_index` (`sku`),
  KEY `idx_products_export` (`id`,`is_variation`),
  KEY `idx_variation_name_id` (`is_variation`,`name`,`id`),
  KEY `ec_products_variations_count_index` (`variations_count`),
  KEY `ec_products_slug_index` (`slug`),
  KEY `idx_products_status_variation` (`status`,`is_variation`,`id`),
  KEY `idx_products_price_sale` (`sale_type`,`sale_price`,`price`),
  KEY `idx_products_order_created` (`order`,`created_at`),
  KEY `idx_products_stock` (`with_storehouse_management`,`stock_status`,`quantity`),
  KEY `ec_products_reviews_count_index` (`reviews_count`),
  KEY `ec_products_reviews_avg_index` (`reviews_avg`),
  KEY `ec_products_status_is_variation_index` (`status`,`is_variation`),
  KEY `ec_products_storehouse_quantity_index` (`with_storehouse_management`,`quantity`)
) ENGINE=InnoDB AUTO_INCREMENT=265 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products`
--

LOCK TABLES `ec_products` WRITE;
/*!40000 ALTER TABLE `ec_products` DISABLE KEYS */;
INSERT INTO `ec_products` VALUES (1,'Miko Wooden Bluetooth Speaker',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-72.jpg\",\"products\\/product-10.jpg\",\"products\\/product-2.jpg\",\"products\\/product-16.jpg\",\"products\\/product-68.jpg\",\"products\\/product-79.jpg\",\"products\\/product-71.jpg\",\"products\\/product-80.jpg\",\"products\\/product-67.jpg\"]',NULL,'NC-142-A0',0,18,0,1,'in_stock',1,4,0,3,9,2.11,0,397,NULL,NULL,NULL,14,15,17,560,NULL,152037,'2025-11-18 21:22:49','2025-11-18 21:22:57',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,1),(2,'Gorgeous Wooden Gloves',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-48.jpg\",\"products\\/product-59.jpg\",\"products\\/product-17.jpg\",\"products\\/product-55.jpg\",\"products\\/product-10.jpg\",\"products\\/product-24.jpg\",\"products\\/product-86.jpg\"]',NULL,'NC-104-A0',0,11,0,1,'in_stock',0,6,0,2,9,2.44,0,296,NULL,NULL,NULL,10,14,19,897,NULL,61679,'2025-11-18 21:22:49','2025-11-18 21:22:57',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(3,'Pinkol Enormous Granite Bottle',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-35.jpg\",\"products\\/product-67.jpg\",\"products\\/product-21.jpg\",\"products\\/product-53.jpg\",\"products\\/product-6.jpg\",\"products\\/product-87.jpg\"]',NULL,'NC-152-A0',0,11,0,1,'in_stock',1,6,0,1,10,3.00,0,440,NULL,NULL,NULL,15,15,15,720,NULL,124519,'2025-11-18 21:22:49','2025-11-18 21:22:57',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(4,'Gorgeous Aluminum Table',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-66.jpg\",\"products\\/product-2.jpg\",\"products\\/product-18.jpg\",\"products\\/product-90.jpg\",\"products\\/product-12.jpg\",\"products\\/product-61.jpg\",\"products\\/product-35.jpg\",\"products\\/product-75.jpg\"]',NULL,'NC-198-A0',0,13,0,1,'in_stock',0,3,0,2,9,3.11,0,212,188.68,NULL,NULL,14,13,17,854,NULL,159502,'2025-11-18 21:22:49','2025-11-18 21:22:57',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(5,'Evo Lightweight Granite Shirt',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-82.jpg\",\"products\\/product-47.jpg\",\"products\\/product-38.jpg\",\"products\\/product-66.jpg\",\"products\\/product-42.jpg\"]',NULL,'NC-104-A0',0,13,0,1,'in_stock',0,5,0,1,10,3.20,0,474,NULL,NULL,NULL,14,12,10,573,NULL,141210,'2025-11-18 21:22:49','2025-11-18 21:22:57',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,1),(6,'CLCo. Incredible Paper Car',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-87.jpg\",\"products\\/product-70.jpg\",\"products\\/product-95.jpg\",\"products\\/product-52.jpg\",\"products\\/product-25.jpg\",\"products\\/product-36.jpg\",\"products\\/product-22.jpg\",\"products\\/product-60.jpg\"]',NULL,'NC-165-A0',0,15,0,1,'in_stock',1,3,0,1,10,2.60,0,263,NULL,NULL,NULL,13,14,13,852,NULL,52579,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(7,'Progash Durable Granite Hat',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-9.jpg\",\"products\\/product-86.jpg\",\"products\\/product-28.jpg\",\"products\\/product-30.jpg\",\"products\\/product-84.jpg\",\"products\\/product-95.jpg\",\"products\\/product-29.jpg\",\"products\\/product-17.jpg\",\"products\\/product-49.jpg\"]',NULL,'NC-147-A0',0,18,0,1,'in_stock',0,7,0,4,10,3.50,0,379,NULL,NULL,NULL,11,10,13,560,NULL,55305,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(8,'Purab Enormous Miranda Bottle',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-14.jpg\",\"products\\/product-67.jpg\",\"products\\/product-93.jpg\",\"products\\/product-36.jpg\",\"products\\/product-40.jpg\",\"products\\/product-84.jpg\",\"products\\/product-86.jpg\",\"products\\/product-73.jpg\",\"products\\/product-17.jpg\",\"products\\/product-60.jpg\",\"products\\/product-78.jpg\",\"products\\/product-85.jpg\"]',NULL,'NC-129-A0',0,16,0,1,'in_stock',0,5,0,3,9,3.33,0,447,384.42,NULL,NULL,16,12,11,707,NULL,149983,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(9,'Miklonda Co. Crafted Candles',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-22.jpg\",\"products\\/product-61.jpg\",\"products\\/product-4.jpg\",\"products\\/product-87.jpg\",\"products\\/product-39.jpg\",\"products\\/product-76.jpg\",\"products\\/product-60.jpg\",\"products\\/product-71.jpg\",\"products\\/product-42.jpg\",\"products\\/product-46.jpg\",\"products\\/product-95.jpg\"]',NULL,'NC-196-A0',0,20,0,1,'in_stock',0,4,0,1,10,3.00,0,218,NULL,NULL,NULL,18,20,17,819,NULL,116402,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,1),(10,'Pinkol Enormous Granite Bottle',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-44.jpg\",\"products\\/product-82.jpg\",\"products\\/product-52.jpg\",\"products\\/product-5.jpg\",\"products\\/product-60.jpg\",\"products\\/product-12.jpg\",\"products\\/product-22.jpg\",\"products\\/product-13.jpg\",\"products\\/product-46.jpg\",\"products\\/product-4.jpg\",\"products\\/product-53.jpg\"]',NULL,'NC-183-A0',0,16,0,1,'in_stock',0,4,0,3,9,2.67,0,299,NULL,NULL,NULL,13,13,12,896,NULL,137422,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(11,'Dual Camera 20MP',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-94.jpg\",\"products\\/product-8.jpg\",\"products\\/product-40.jpg\",\"products\\/product-92.jpg\",\"products\\/product-45.jpg\",\"products\\/product-6.jpg\",\"products\\/product-77.jpg\"]',NULL,'NC-127-A0',0,17,0,1,'in_stock',0,2,0,4,10,3.50,0,411,NULL,NULL,NULL,11,13,12,691,NULL,156727,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(12,'Smart Watches',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-45.jpg\",\"products\\/product-47.jpg\",\"products\\/product-10.jpg\",\"products\\/product-26.jpg\",\"products\\/product-40.jpg\",\"products\\/product-14.jpg\"]',NULL,'NC-113-A0',0,20,0,1,'in_stock',1,1,0,3,10,2.50,0,411,337.02,NULL,NULL,16,18,10,851,NULL,2355,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(13,'Beat Headphone',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-17.jpg\",\"products\\/product-31.jpg\",\"products\\/product-91.jpg\",\"products\\/product-11.jpg\",\"products\\/product-36.jpg\",\"products\\/product-58.jpg\"]',NULL,'NC-122-A0',0,13,0,1,'in_stock',1,4,0,1,9,3.33,0,240,NULL,NULL,NULL,15,18,18,578,NULL,39022,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,1),(14,'Red &amp; Black Headphone',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-26.jpg\",\"products\\/product-40.jpg\",\"products\\/product-77.jpg\",\"products\\/product-90.jpg\",\"products\\/product-11.jpg\",\"products\\/product-35.jpg\",\"products\\/product-50.jpg\",\"products\\/product-51.jpg\",\"products\\/product-59.jpg\"]',NULL,'NC-192-A0',0,12,0,1,'in_stock',1,1,0,4,9,4.22,0,440,NULL,NULL,NULL,18,15,15,680,NULL,88992,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(15,'Smart Watch External',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-53.jpg\",\"products\\/product-89.jpg\",\"products\\/product-69.jpg\",\"products\\/product-67.jpg\",\"products\\/product-2.jpg\"]',NULL,'NC-140-A0',0,20,0,1,'in_stock',1,6,0,2,9,2.89,0,347,NULL,NULL,NULL,14,18,11,664,NULL,89077,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(16,'Nikon HD camera',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-6.jpg\",\"products\\/product-44.jpg\",\"products\\/product-71.jpg\",\"products\\/product-69.jpg\",\"products\\/product-75.jpg\",\"products\\/product-48.jpg\",\"products\\/product-31.jpg\",\"products\\/product-54.jpg\"]',NULL,'NC-160-A0',0,15,0,1,'in_stock',0,1,0,2,10,2.30,0,385,342.65,NULL,NULL,17,12,18,703,NULL,63954,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(17,'Audio Equipment',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-14.jpg\",\"products\\/product-44.jpg\",\"products\\/product-20.jpg\",\"products\\/product-9.jpg\",\"products\\/product-3.jpg\"]',NULL,'NC-151-A0',0,11,0,1,'in_stock',0,1,0,3,9,3.78,0,237,NULL,NULL,NULL,11,17,15,536,NULL,63953,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,1),(18,'Smart Televisions',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-58.jpg\",\"products\\/product-36.jpg\",\"products\\/product-47.jpg\",\"products\\/product-15.jpg\",\"products\\/product-91.jpg\",\"products\\/product-79.jpg\",\"products\\/product-39.jpg\",\"products\\/product-67.jpg\",\"products\\/product-10.jpg\",\"products\\/product-62.jpg\",\"products\\/product-43.jpg\",\"products\\/product-95.jpg\"]',NULL,'NC-181-A0',0,15,0,1,'in_stock',1,2,0,2,10,2.80,0,394,NULL,NULL,NULL,15,14,11,559,NULL,64398,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(19,'Samsung Smart Phone',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-53.jpg\",\"products\\/product-4.jpg\",\"products\\/product-81.jpg\",\"products\\/product-11.jpg\",\"products\\/product-85.jpg\",\"products\\/product-38.jpg\",\"products\\/product-43.jpg\",\"products\\/product-45.jpg\",\"products\\/product-21.jpg\"]',NULL,'NC-163-A0',0,17,0,1,'in_stock',0,4,0,3,10,3.10,0,294,NULL,NULL,NULL,10,17,10,662,NULL,40372,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(20,'Herschel Leather Duffle Bag In Brown Color',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-86.jpg\",\"products\\/product-15.jpg\",\"products\\/product-53.jpg\",\"products\\/product-6.jpg\",\"products\\/product-61.jpg\"]',NULL,'NC-168-A0',0,15,0,1,'in_stock',1,5,0,1,7,2.14,0,277,210.52,NULL,NULL,15,14,20,742,NULL,142378,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(21,'Xbox One Wireless Controller Black Color',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-83.jpg\",\"products\\/product-71.jpg\",\"products\\/product-49.jpg\",\"products\\/product-95.jpg\",\"products\\/product-74.jpg\",\"products\\/product-18.jpg\",\"products\\/product-43.jpg\",\"products\\/product-51.jpg\"]',NULL,'NC-115-A0',0,17,0,1,'in_stock',1,1,0,1,8,3.13,0,360,NULL,NULL,NULL,11,16,18,862,NULL,167185,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,2),(22,'EPSION Plaster Printer',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-43.jpg\",\"products\\/product-4.jpg\",\"products\\/product-51.jpg\",\"products\\/product-19.jpg\",\"products\\/product-11.jpg\"]',NULL,'NC-148-A0',0,11,0,1,'in_stock',0,1,0,4,10,3.10,0,300,NULL,NULL,NULL,19,12,13,781,NULL,6005,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(23,'Sound Intone I65 Earphone White Version',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-23.jpg\",\"products\\/product-40.jpg\",\"products\\/product-66.jpg\",\"products\\/product-41.jpg\",\"products\\/product-76.jpg\",\"products\\/product-5.jpg\",\"products\\/product-1.jpg\",\"products\\/product-32.jpg\"]',NULL,'NC-155-A0',0,16,0,1,'in_stock',0,7,0,2,9,3.22,0,380,NULL,NULL,NULL,18,15,15,585,NULL,68687,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(24,'B&amp;O Play Mini Bluetooth Speaker',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-47.jpg\",\"products\\/product-87.jpg\",\"products\\/product-25.jpg\",\"products\\/product-14.jpg\",\"products\\/product-67.jpg\",\"products\\/product-69.jpg\",\"products\\/product-66.jpg\",\"products\\/product-37.jpg\",\"products\\/product-94.jpg\",\"products\\/product-92.jpg\",\"products\\/product-43.jpg\",\"products\\/product-91.jpg\"]',NULL,'NC-166-A0',0,18,0,1,'in_stock',0,4,0,2,10,2.90,0,341,289.85,NULL,NULL,17,19,14,696,NULL,165139,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(25,'Apple MacBook Air Retina 13.3-Inch Laptop',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-77.jpg\",\"products\\/product-50.jpg\",\"products\\/product-17.jpg\",\"products\\/product-25.jpg\",\"products\\/product-56.jpg\",\"products\\/product-9.jpg\",\"products\\/product-93.jpg\",\"products\\/product-87.jpg\",\"products\\/product-49.jpg\"]',NULL,'NC-106-A0',0,17,0,1,'in_stock',1,2,0,1,10,3.10,0,205,NULL,NULL,NULL,12,13,19,789,NULL,98183,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,1),(26,'Apple MacBook Air Retina 12-Inch Laptop',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-12.jpg\",\"products\\/product-81.jpg\",\"products\\/product-84.jpg\",\"products\\/product-32.jpg\",\"products\\/product-56.jpg\",\"products\\/product-59.jpg\",\"products\\/product-22.jpg\",\"products\\/product-87.jpg\"]',NULL,'NC-167-A0',0,10,0,1,'in_stock',0,6,0,4,10,3.20,0,453,NULL,NULL,NULL,14,15,11,776,NULL,49275,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(27,'Samsung Gear VR Virtual Reality Headset',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-72.jpg\",\"products\\/product-21.jpg\",\"products\\/product-32.jpg\",\"products\\/product-12.jpg\",\"products\\/product-77.jpg\",\"products\\/product-39.jpg\",\"products\\/product-15.jpg\",\"products\\/product-67.jpg\",\"products\\/product-62.jpg\"]',NULL,'NC-130-A0',0,16,0,1,'in_stock',0,2,0,1,10,3.00,0,209,NULL,NULL,NULL,12,12,14,540,NULL,175915,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(28,'Aveeno Moisturizing Body Shower 450ml',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-40.jpg\",\"products\\/product-81.jpg\",\"products\\/product-72.jpg\",\"products\\/product-94.jpg\",\"products\\/product-32.jpg\",\"products\\/product-47.jpg\",\"products\\/product-31.jpg\",\"products\\/product-23.jpg\",\"products\\/product-46.jpg\"]',NULL,'NC-187-A0',0,19,0,1,'in_stock',1,4,0,2,10,2.60,0,308,264.88,NULL,NULL,17,20,17,700,NULL,56664,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(29,'NYX Beauty Couton Pallete Makeup 12',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-49.jpg\",\"products\\/product-87.jpg\",\"products\\/product-59.jpg\",\"products\\/product-95.jpg\",\"products\\/product-2.jpg\",\"products\\/product-8.jpg\",\"products\\/product-60.jpg\",\"products\\/product-20.jpg\",\"products\\/product-28.jpg\",\"products\\/product-27.jpg\",\"products\\/product-75.jpg\",\"products\\/product-12.jpg\"]',NULL,'NC-117-A0',0,16,0,1,'in_stock',1,1,0,3,9,2.11,0,275,NULL,NULL,NULL,11,15,10,747,NULL,24050,'2025-11-18 21:22:49','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,1),(30,'NYX Beauty Couton Pallete Makeup 12',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-63.jpg\",\"products\\/product-47.jpg\",\"products\\/product-58.jpg\",\"products\\/product-6.jpg\",\"products\\/product-80.jpg\",\"products\\/product-91.jpg\",\"products\\/product-36.jpg\",\"products\\/product-21.jpg\",\"products\\/product-61.jpg\"]',NULL,'NC-114-A0',0,10,0,1,'in_stock',0,3,0,2,10,2.80,0,343,NULL,NULL,NULL,13,18,11,531,NULL,148207,'2025-11-18 21:22:50','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(31,'MVMTH Classical Leather Watch In Black',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-91.jpg\",\"products\\/product-34.jpg\",\"products\\/product-59.jpg\",\"products\\/product-5.jpg\",\"products\\/product-11.jpg\",\"products\\/product-47.jpg\"]',NULL,'NC-126-A0',0,13,0,1,'in_stock',0,4,0,3,9,2.67,0,325,NULL,NULL,NULL,13,12,19,875,NULL,188739,'2025-11-18 21:22:50','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(32,'Baxter Care Hair Kit For Bearded Mens',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-49.jpg\",\"products\\/product-45.jpg\",\"products\\/product-76.jpg\",\"products\\/product-15.jpg\",\"products\\/product-75.jpg\",\"products\\/product-39.jpg\",\"products\\/product-55.jpg\"]',NULL,'NC-177-A0',0,17,0,1,'in_stock',1,1,0,3,10,2.70,0,365,302.95,NULL,NULL,16,12,13,835,NULL,12181,'2025-11-18 21:22:50','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(33,'Ciate Palemore Lipstick Bold Red Color',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-9.jpg\",\"products\\/product-5.jpg\",\"products\\/product-4.jpg\",\"products\\/product-20.jpg\",\"products\\/product-79.jpg\",\"products\\/product-78.jpg\",\"products\\/product-72.jpg\",\"products\\/product-2.jpg\",\"products\\/product-49.jpg\",\"products\\/product-13.jpg\",\"products\\/product-94.jpg\"]',NULL,'NC-119-A0',0,18,0,1,'in_stock',1,6,0,2,9,2.78,0,270,NULL,NULL,NULL,20,20,11,518,NULL,169668,'2025-11-18 21:22:50','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,1),(34,'Vimto Squash Remix Apple 1.5 Litres',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-6.jpg\",\"products\\/product-56.jpg\",\"products\\/product-23.jpg\",\"products\\/product-25.jpg\",\"products\\/product-89.jpg\",\"products\\/product-95.jpg\",\"products\\/product-79.jpg\",\"products\\/product-78.jpg\",\"products\\/product-55.jpg\",\"products\\/product-5.jpg\"]',NULL,'NC-156-A0',0,16,0,1,'in_stock',1,1,0,3,10,3.10,0,287,NULL,NULL,NULL,19,15,20,567,NULL,144803,'2025-11-18 21:22:50','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(35,'Crock Pot Slow Cooker',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-47.jpg\",\"products\\/product-70.jpg\",\"products\\/product-86.jpg\",\"products\\/product-75.jpg\",\"products\\/product-85.jpg\",\"products\\/product-26.jpg\",\"products\\/product-22.jpg\",\"products\\/product-60.jpg\",\"products\\/product-55.jpg\",\"products\\/product-18.jpg\",\"products\\/product-21.jpg\"]',NULL,'NC-153-A0',0,17,0,1,'in_stock',1,7,0,3,9,3.00,0,253,NULL,NULL,NULL,20,11,18,821,NULL,89604,'2025-11-18 21:22:50','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(36,'Taylors of Harrogate Yorkshire Coffee',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-68.jpg\",\"products\\/product-12.jpg\",\"products\\/product-65.jpg\",\"products\\/product-54.jpg\",\"products\\/product-42.jpg\",\"products\\/product-85.jpg\",\"products\\/product-74.jpg\",\"products\\/product-22.jpg\",\"products\\/product-4.jpg\",\"products\\/product-44.jpg\",\"products\\/product-59.jpg\",\"products\\/product-92.jpg\"]',NULL,'NC-192-A0',0,11,0,1,'in_stock',1,5,0,4,10,3.40,0,369,324.72,NULL,NULL,11,16,11,766,NULL,70078,'2025-11-18 21:22:50','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(37,'Soft Mochi &amp; Galeto Ice Cream',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-48.jpg\",\"products\\/product-31.jpg\",\"products\\/product-16.jpg\",\"products\\/product-18.jpg\",\"products\\/product-32.jpg\",\"products\\/product-26.jpg\",\"products\\/product-91.jpg\",\"products\\/product-46.jpg\",\"products\\/product-94.jpg\",\"products\\/product-4.jpg\",\"products\\/product-23.jpg\",\"products\\/product-50.jpg\"]',NULL,'NC-146-A0',0,10,0,1,'in_stock',1,2,0,5,8,2.63,0,324,NULL,NULL,NULL,19,19,10,600,NULL,46344,'2025-11-18 21:22:50','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,1),(38,'Naked Noodle Egg Noodles Singapore',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-56.jpg\",\"products\\/product-29.jpg\",\"products\\/product-12.jpg\",\"products\\/product-76.jpg\",\"products\\/product-61.jpg\",\"products\\/product-88.jpg\",\"products\\/product-92.jpg\"]',NULL,'NC-181-A0',0,14,0,1,'in_stock',0,7,0,3,8,2.75,0,326,NULL,NULL,NULL,15,12,11,570,NULL,199690,'2025-11-18 21:22:50','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(39,'Saute Pan Silver',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-26.jpg\",\"products\\/product-55.jpg\",\"products\\/product-49.jpg\",\"products\\/product-75.jpg\",\"products\\/product-44.jpg\",\"products\\/product-94.jpg\",\"products\\/product-86.jpg\",\"products\\/product-50.jpg\"]',NULL,'NC-165-A0',0,15,0,1,'in_stock',1,6,0,1,9,3.00,0,245,NULL,NULL,NULL,20,17,16,875,NULL,158632,'2025-11-18 21:22:50','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(40,'Bar S – Classic Bun Length Franks',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-70.jpg\",\"products\\/product-17.jpg\",\"products\\/product-37.jpg\",\"products\\/product-56.jpg\",\"products\\/product-43.jpg\",\"products\\/product-44.jpg\",\"products\\/product-83.jpg\",\"products\\/product-60.jpg\",\"products\\/product-3.jpg\",\"products\\/product-10.jpg\",\"products\\/product-67.jpg\",\"products\\/product-22.jpg\"]',NULL,'NC-166-A0',0,17,0,1,'in_stock',0,2,0,2,9,2.89,0,413,367.57,NULL,NULL,19,12,11,860,NULL,176787,'2025-11-18 21:22:50','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(41,'Broccoli Crowns',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-89.jpg\",\"products\\/product-72.jpg\",\"products\\/product-44.jpg\",\"products\\/product-39.jpg\",\"products\\/product-50.jpg\",\"products\\/product-35.jpg\",\"products\\/product-80.jpg\",\"products\\/product-31.jpg\"]',NULL,'NC-177-A0',0,13,0,1,'in_stock',0,6,0,1,10,2.70,0,481,NULL,NULL,NULL,10,12,15,705,NULL,33085,'2025-11-18 21:22:50','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,2),(42,'Slimming World Vegan Mac Greens',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-69.jpg\",\"products\\/product-5.jpg\",\"products\\/product-11.jpg\",\"products\\/product-65.jpg\",\"products\\/product-47.jpg\",\"products\\/product-10.jpg\",\"products\\/product-92.jpg\",\"products\\/product-4.jpg\",\"products\\/product-61.jpg\",\"products\\/product-77.jpg\",\"products\\/product-85.jpg\",\"products\\/product-43.jpg\"]',NULL,'NC-190-A0',0,13,0,1,'in_stock',1,3,0,1,10,2.80,0,419,NULL,NULL,NULL,13,18,10,771,NULL,71444,'2025-11-18 21:22:50','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(43,'Häagen-Dazs Salted Caramel',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-25.jpg\",\"products\\/product-69.jpg\",\"products\\/product-24.jpg\",\"products\\/product-14.jpg\",\"products\\/product-56.jpg\",\"products\\/product-83.jpg\",\"products\\/product-66.jpg\"]',NULL,'NC-109-A0',0,17,0,1,'in_stock',0,2,0,4,10,3.20,0,500,NULL,NULL,NULL,16,18,11,598,NULL,22254,'2025-11-18 21:22:50','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(44,'Iceland 3 Solo Exotic Burst',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-43.jpg\",\"products\\/product-4.jpg\",\"products\\/product-29.jpg\",\"products\\/product-26.jpg\",\"products\\/product-52.jpg\",\"products\\/product-20.jpg\",\"products\\/product-28.jpg\",\"products\\/product-82.jpg\",\"products\\/product-71.jpg\"]',NULL,'NC-164-A0',0,16,0,1,'in_stock',1,1,0,3,10,2.40,0,339,288.15,NULL,NULL,11,20,15,884,NULL,69351,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(45,'Extreme Budweiser Light Can',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-63.jpg\",\"products\\/product-52.jpg\",\"products\\/product-29.jpg\",\"products\\/product-36.jpg\",\"products\\/product-41.jpg\"]',NULL,'NC-189-A0',0,18,0,1,'in_stock',0,4,0,2,10,3.30,0,444,NULL,NULL,NULL,20,11,18,594,NULL,55872,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,2),(46,'Iceland Macaroni Cheese Traybake',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-5.jpg\",\"products\\/product-9.jpg\",\"products\\/product-64.jpg\",\"products\\/product-1.jpg\",\"products\\/product-42.jpg\",\"products\\/product-73.jpg\",\"products\\/product-94.jpg\",\"products\\/product-48.jpg\",\"products\\/product-35.jpg\",\"products\\/product-93.jpg\",\"products\\/product-74.jpg\",\"products\\/product-19.jpg\"]',NULL,'NC-176-A0',0,17,0,1,'in_stock',1,1,0,3,10,3.50,0,456,NULL,NULL,NULL,16,18,12,557,NULL,198906,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(47,'Dolmio Bolognese Pasta Sauce',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-81.jpg\",\"products\\/product-95.jpg\",\"products\\/product-73.jpg\",\"products\\/product-68.jpg\",\"products\\/product-30.jpg\",\"products\\/product-12.jpg\",\"products\\/product-44.jpg\"]',NULL,'NC-162-A0',0,10,0,1,'in_stock',0,1,0,1,10,2.90,0,324,NULL,NULL,NULL,20,14,17,857,NULL,98003,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(48,'Sitema BakeIT Plastic Box',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-78.jpg\",\"products\\/product-37.jpg\",\"products\\/product-74.jpg\",\"products\\/product-84.jpg\",\"products\\/product-27.jpg\",\"products\\/product-17.jpg\"]',NULL,'NC-192-A0',0,13,0,1,'in_stock',0,1,0,3,10,2.70,0,251,220.88,NULL,NULL,10,16,12,742,NULL,64635,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(49,'Wayfair Basics Dinner Plate Storage',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-17.jpg\",\"products\\/product-64.jpg\",\"products\\/product-37.jpg\",\"products\\/product-7.jpg\",\"products\\/product-35.jpg\",\"products\\/product-60.jpg\",\"products\\/product-20.jpg\",\"products\\/product-1.jpg\",\"products\\/product-33.jpg\",\"products\\/product-88.jpg\"]',NULL,'NC-177-A0',0,11,0,1,'in_stock',0,7,0,3,10,2.70,0,329,NULL,NULL,NULL,16,13,14,635,NULL,136171,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,1),(50,'Miko The Panda Water Bottle',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-56.jpg\",\"products\\/product-88.jpg\",\"products\\/product-32.jpg\",\"products\\/product-85.jpg\",\"products\\/product-2.jpg\",\"products\\/product-31.jpg\",\"products\\/product-36.jpg\",\"products\\/product-35.jpg\",\"products\\/product-58.jpg\",\"products\\/product-48.jpg\",\"products\\/product-3.jpg\"]',NULL,'NC-172-A0',0,18,0,1,'in_stock',0,4,0,2,10,2.80,0,306,NULL,NULL,NULL,20,17,18,844,NULL,29385,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(51,'Sesame Seed Bread',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-38.jpg\",\"products\\/product-28.jpg\",\"products\\/product-85.jpg\",\"products\\/product-61.jpg\",\"products\\/product-19.jpg\",\"products\\/product-65.jpg\",\"products\\/product-20.jpg\",\"products\\/product-21.jpg\",\"products\\/product-63.jpg\",\"products\\/product-12.jpg\",\"products\\/product-66.jpg\"]',NULL,'NC-135-A0',0,13,0,1,'in_stock',1,1,0,2,10,2.60,0,467,NULL,NULL,NULL,14,10,15,666,NULL,75808,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(52,'Morrisons The Best Beef',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-21.jpg\",\"products\\/product-11.jpg\",\"products\\/product-31.jpg\",\"products\\/product-19.jpg\",\"products\\/product-61.jpg\",\"products\\/product-37.jpg\",\"products\\/product-30.jpg\"]',NULL,'NC-144-A0',0,10,0,1,'in_stock',1,4,0,2,8,2.25,0,411,328.8,NULL,NULL,13,15,13,668,NULL,161294,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(53,'Avocado, Hass Large',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-47.jpg\",\"products\\/product-81.jpg\",\"products\\/product-93.jpg\",\"products\\/product-52.jpg\",\"products\\/product-58.jpg\"]',NULL,'NC-149-A0',0,19,0,1,'in_stock',1,2,0,4,9,2.67,0,364,NULL,NULL,NULL,16,18,10,862,NULL,187359,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,2),(54,'Italia Beef Lasagne',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-5.jpg\",\"products\\/product-33.jpg\",\"products\\/product-74.jpg\",\"products\\/product-71.jpg\",\"products\\/product-49.jpg\",\"products\\/product-83.jpg\",\"products\\/product-79.jpg\",\"products\\/product-16.jpg\"]',NULL,'NC-172-A0',0,19,0,1,'in_stock',1,3,0,1,10,2.90,0,311,NULL,NULL,NULL,14,13,17,855,NULL,59546,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(55,'Maxwell House Classic Roast Mocha',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-11.jpg\",\"products\\/product-53.jpg\",\"products\\/product-87.jpg\",\"products\\/product-46.jpg\",\"products\\/product-76.jpg\",\"products\\/product-62.jpg\",\"products\\/product-15.jpg\",\"products\\/product-94.jpg\",\"products\\/product-89.jpg\",\"products\\/product-47.jpg\",\"products\\/product-85.jpg\"]',NULL,'NC-195-A0',0,19,0,1,'in_stock',1,1,0,2,10,3.00,0,437,NULL,NULL,NULL,14,16,20,598,NULL,102206,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(56,'Bottled Pure Water 500ml',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-72.jpg\",\"products\\/product-19.jpg\",\"products\\/product-76.jpg\",\"products\\/product-49.jpg\",\"products\\/product-48.jpg\",\"products\\/product-54.jpg\",\"products\\/product-84.jpg\",\"products\\/product-69.jpg\"]',NULL,'NC-106-A0',0,11,0,1,'in_stock',0,7,0,4,9,3.78,0,394,350.66,NULL,NULL,16,19,16,511,NULL,77825,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(57,'Famart Farmhouse Soft White',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-10.jpg\",\"products\\/product-70.jpg\",\"products\\/product-24.jpg\",\"products\\/product-59.jpg\",\"products\\/product-1.jpg\",\"products\\/product-20.jpg\",\"products\\/product-43.jpg\",\"products\\/product-84.jpg\",\"products\\/product-95.jpg\",\"products\\/product-67.jpg\"]',NULL,'NC-178-A0',0,17,0,1,'in_stock',0,3,0,4,9,2.33,0,430,NULL,NULL,NULL,11,19,19,684,NULL,179249,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,1),(58,'Coca-Cola Original Taste',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-40.jpg\",\"products\\/product-49.jpg\",\"products\\/product-42.jpg\",\"products\\/product-44.jpg\",\"products\\/product-50.jpg\",\"products\\/product-10.jpg\",\"products\\/product-7.jpg\",\"products\\/product-58.jpg\",\"products\\/product-43.jpg\",\"products\\/product-12.jpg\",\"products\\/product-37.jpg\",\"products\\/product-59.jpg\"]',NULL,'NC-173-A0',0,16,0,1,'in_stock',0,1,0,1,10,2.60,0,226,NULL,NULL,NULL,19,11,12,654,NULL,149665,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(59,'Casillero Diablo Cabernet Sauvignon',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-31.jpg\",\"products\\/product-83.jpg\",\"products\\/product-18.jpg\",\"products\\/product-85.jpg\",\"products\\/product-2.jpg\",\"products\\/product-87.jpg\",\"products\\/product-19.jpg\",\"products\\/product-77.jpg\",\"products\\/product-33.jpg\",\"products\\/product-10.jpg\",\"products\\/product-37.jpg\",\"products\\/product-12.jpg\"]',NULL,'NC-138-A0',0,15,0,1,'in_stock',1,7,0,2,9,3.78,0,316,NULL,NULL,NULL,17,13,15,779,NULL,198642,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(60,'Arla Organic Free Range Milk',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-19.jpg\",\"products\\/product-50.jpg\",\"products\\/product-21.jpg\",\"products\\/product-45.jpg\",\"products\\/product-57.jpg\",\"products\\/product-17.jpg\",\"products\\/product-5.jpg\",\"products\\/product-84.jpg\",\"products\\/product-79.jpg\",\"products\\/product-82.jpg\",\"products\\/product-87.jpg\",\"products\\/product-41.jpg\"]',NULL,'NC-191-A0',0,16,0,1,'in_stock',1,2,0,3,9,3.22,0,339,298.32,NULL,NULL,17,19,19,637,NULL,94627,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(61,'Aptamil Follow On Baby Milk',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-26.jpg\",\"products\\/product-60.jpg\",\"products\\/product-82.jpg\",\"products\\/product-32.jpg\",\"products\\/product-51.jpg\",\"products\\/product-22.jpg\",\"products\\/product-61.jpg\"]',NULL,'NC-161-A0',0,13,0,1,'in_stock',0,2,0,1,10,2.90,0,452,NULL,NULL,NULL,15,10,10,831,NULL,195013,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,2),(62,'Cuisinart Chef’S Classic Hard-Anodized',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-62.jpg\",\"products\\/product-4.jpg\",\"products\\/product-27.jpg\",\"products\\/product-84.jpg\",\"products\\/product-49.jpg\",\"products\\/product-58.jpg\",\"products\\/product-38.jpg\",\"products\\/product-65.jpg\",\"products\\/product-63.jpg\"]',NULL,'NC-182-A0',0,10,0,1,'in_stock',0,2,0,4,9,2.33,0,252,NULL,NULL,NULL,16,11,15,551,NULL,19497,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(63,'Corn, Yellow Sweet',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-40.jpg\",\"products\\/product-5.jpg\",\"products\\/product-53.jpg\",\"products\\/product-3.jpg\",\"products\\/product-37.jpg\",\"products\\/product-21.jpg\"]',NULL,'NC-117-A0',0,18,0,1,'in_stock',0,4,0,3,10,3.70,0,329,NULL,NULL,NULL,20,13,15,503,NULL,93079,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(64,'Hobnobs The Nobbly Biscuit',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-9.jpg\",\"products\\/product-23.jpg\",\"products\\/product-63.jpg\",\"products\\/product-61.jpg\",\"products\\/product-41.jpg\",\"products\\/product-88.jpg\",\"products\\/product-93.jpg\",\"products\\/product-30.jpg\",\"products\\/product-34.jpg\",\"products\\/product-74.jpg\"]',NULL,'NC-113-A0',0,12,0,1,'in_stock',0,4,0,2,8,2.50,0,341,255.75,NULL,NULL,19,19,16,701,NULL,101643,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(65,'Honest Organic Still Lemonade',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-19.jpg\",\"products\\/product-31.jpg\",\"products\\/product-39.jpg\",\"products\\/product-4.jpg\",\"products\\/product-67.jpg\",\"products\\/product-85.jpg\",\"products\\/product-21.jpg\",\"products\\/product-52.jpg\",\"products\\/product-13.jpg\",\"products\\/product-91.jpg\",\"products\\/product-42.jpg\",\"products\\/product-65.jpg\"]',NULL,'NC-102-A0',0,10,0,1,'in_stock',0,7,0,4,10,3.30,0,307,NULL,NULL,NULL,18,19,12,593,NULL,28915,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,1),(66,'Ice Beck’s Beer 350ml x 24 Pieces',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-53.jpg\",\"products\\/product-21.jpg\",\"products\\/product-11.jpg\",\"products\\/product-91.jpg\",\"products\\/product-58.jpg\",\"products\\/product-3.jpg\",\"products\\/product-50.jpg\",\"products\\/product-18.jpg\",\"products\\/product-56.jpg\",\"products\\/product-37.jpg\",\"products\\/product-42.jpg\"]',NULL,'NC-124-A0',0,18,0,1,'in_stock',0,7,0,4,10,3.50,0,332,NULL,NULL,NULL,11,19,14,851,NULL,116563,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(67,'Iceland 6 Hot Cross Buns',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-52.jpg\",\"products\\/product-76.jpg\",\"products\\/product-88.jpg\",\"products\\/product-59.jpg\",\"products\\/product-85.jpg\",\"products\\/product-69.jpg\",\"products\\/product-87.jpg\",\"products\\/product-46.jpg\"]',NULL,'NC-138-A0',0,11,0,1,'in_stock',0,1,0,4,10,2.60,0,338,NULL,NULL,NULL,14,11,16,677,NULL,188042,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(68,'Iceland Luxury 4 Panini Rolls',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-26.jpg\",\"products\\/product-55.jpg\",\"products\\/product-86.jpg\",\"products\\/product-63.jpg\",\"products\\/product-1.jpg\",\"products\\/product-46.jpg\"]',NULL,'NC-182-A0',0,12,0,1,'in_stock',1,1,0,4,9,2.56,0,345,279.45,NULL,NULL,20,16,11,611,NULL,154882,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(69,'Iceland Soft Scoop Vanilla',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-94.jpg\",\"products\\/product-13.jpg\",\"products\\/product-24.jpg\",\"products\\/product-23.jpg\",\"products\\/product-67.jpg\"]',NULL,'NC-146-A0',0,15,0,1,'in_stock',1,3,0,2,10,2.50,0,490,NULL,NULL,NULL,17,10,14,626,NULL,20073,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,2),(70,'Iceland Spaghetti Bolognese',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-73.jpg\",\"products\\/product-17.jpg\",\"products\\/product-57.jpg\",\"products\\/product-71.jpg\",\"products\\/product-87.jpg\"]',NULL,'NC-141-A0',0,11,0,1,'in_stock',0,1,0,2,9,3.22,0,227,NULL,NULL,NULL,12,10,20,543,NULL,143984,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(71,'Kellogg’s Coco Pops Cereal',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-76.jpg\",\"products\\/product-74.jpg\",\"products\\/product-77.jpg\",\"products\\/product-36.jpg\",\"products\\/product-71.jpg\",\"products\\/product-7.jpg\",\"products\\/product-87.jpg\",\"products\\/product-8.jpg\",\"products\\/product-79.jpg\",\"products\\/product-25.jpg\",\"products\\/product-31.jpg\"]',NULL,'NC-105-A0',0,12,0,1,'in_stock',0,2,0,1,10,3.20,0,334,NULL,NULL,NULL,16,19,14,619,NULL,115783,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,2),(72,'Kit Kat Chunky Milk Chocolate',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-77.jpg\",\"products\\/product-21.jpg\",\"products\\/product-91.jpg\",\"products\\/product-60.jpg\",\"products\\/product-94.jpg\"]',NULL,'NC-165-A0',0,17,0,1,'in_stock',1,6,0,4,10,3.70,0,344,264.88,NULL,NULL,12,10,13,565,NULL,36988,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(73,'Large Green Bell Pepper',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-74.jpg\",\"products\\/product-6.jpg\",\"products\\/product-44.jpg\",\"products\\/product-55.jpg\",\"products\\/product-20.jpg\",\"products\\/product-39.jpg\",\"products\\/product-87.jpg\",\"products\\/product-62.jpg\",\"products\\/product-79.jpg\",\"products\\/product-31.jpg\",\"products\\/product-43.jpg\",\"products\\/product-71.jpg\"]',NULL,'NC-143-A0',0,11,0,1,'in_stock',1,2,0,4,10,2.90,0,236,NULL,NULL,NULL,20,17,13,599,NULL,21208,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,1),(74,'Pice 94w Beasley Journal',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-31.jpg\",\"products\\/product-22.jpg\",\"products\\/product-75.jpg\",\"products\\/product-67.jpg\",\"products\\/product-60.jpg\",\"products\\/product-48.jpg\",\"products\\/product-56.jpg\",\"products\\/product-32.jpg\",\"products\\/product-86.jpg\"]',NULL,'NC-164-A0',0,17,0,1,'in_stock',1,1,0,3,10,2.60,0,337,NULL,NULL,NULL,17,19,18,811,NULL,192807,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(75,'Province Piece Glass Drinking Glass',NULL,'<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline.</p>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains’ signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/product-31.jpg\",\"products\\/product-36.jpg\",\"products\\/product-12.jpg\",\"products\\/product-15.jpg\",\"products\\/product-67.jpg\",\"products\\/product-2.jpg\",\"products\\/product-62.jpg\",\"products\\/product-60.jpg\",\"products\\/product-39.jpg\"]',NULL,'NC-193-A0',0,11,0,1,'in_stock',0,1,0,2,9,2.22,0,331,NULL,NULL,NULL,10,14,17,889,NULL,96400,'2025-11-18 21:22:50','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,1),(76,'Miko Wooden Bluetooth Speaker',NULL,NULL,NULL,'published','[\"products\\/product-72.jpg\"]',NULL,'NC-142-A0',0,18,0,1,'in_stock',0,4,1,0,0,0.00,0,397,NULL,NULL,NULL,14,15,17,560,NULL,0,'2025-11-18 21:22:50','2025-11-18 21:22:57',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(77,'Miko Wooden Bluetooth Speaker',NULL,NULL,NULL,'published','[\"products\\/product-10.jpg\"]',NULL,'NC-142-A0-A1',0,18,0,1,'in_stock',0,4,1,0,0,0.00,0,397,NULL,NULL,NULL,14,15,17,560,NULL,0,'2025-11-18 21:22:50','2025-11-18 21:22:57',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(78,'Miko Wooden Bluetooth Speaker',NULL,NULL,NULL,'published','[\"products\\/product-2.jpg\"]',NULL,'NC-142-A0-A2',0,18,0,1,'in_stock',0,4,1,0,0,0.00,0,397,NULL,NULL,NULL,14,15,17,560,NULL,0,'2025-11-18 21:22:50','2025-11-18 21:22:57',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(79,'Gorgeous Wooden Gloves',NULL,NULL,NULL,'published','[\"products\\/product-48.jpg\"]',NULL,'NC-104-A0',0,11,0,1,'in_stock',0,6,1,0,0,0.00,0,296,NULL,NULL,NULL,10,14,19,897,NULL,0,'2025-11-18 21:22:50','2025-11-18 21:22:57',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(80,'Gorgeous Wooden Gloves',NULL,NULL,NULL,'published','[\"products\\/product-59.jpg\"]',NULL,'NC-104-A0-A1',0,11,0,1,'in_stock',0,6,1,0,0,0.00,0,296,NULL,NULL,NULL,10,14,19,897,NULL,0,'2025-11-18 21:22:50','2025-11-18 21:22:57',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(81,'Pinkol Enormous Granite Bottle',NULL,NULL,NULL,'published','[\"products\\/product-35.jpg\"]',NULL,'NC-152-A0',0,11,0,1,'in_stock',0,6,1,0,0,0.00,0,440,NULL,NULL,NULL,15,15,15,720,NULL,0,'2025-11-18 21:22:50','2025-11-18 21:22:57',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(82,'Gorgeous Aluminum Table',NULL,NULL,NULL,'published','[\"products\\/product-66.jpg\"]',NULL,'NC-198-A0',0,13,0,1,'in_stock',0,3,1,0,0,0.00,0,212,188.68,NULL,NULL,14,13,17,854,NULL,0,'2025-11-18 21:22:50','2025-11-18 21:22:57',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(83,'Gorgeous Aluminum Table',NULL,NULL,NULL,'published','[\"products\\/product-2.jpg\"]',NULL,'NC-198-A0-A1',0,13,0,1,'in_stock',0,3,1,0,0,0.00,0,212,188.68,NULL,NULL,14,13,17,854,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:57',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(84,'Evo Lightweight Granite Shirt',NULL,NULL,NULL,'published','[\"products\\/product-82.jpg\"]',NULL,'NC-104-A0',0,13,0,1,'in_stock',0,5,1,0,0,0.00,0,474,NULL,NULL,NULL,14,12,10,573,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:57',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(85,'CLCo. Incredible Paper Car',NULL,NULL,NULL,'published','[\"products\\/product-87.jpg\"]',NULL,'NC-165-A0',0,15,0,1,'in_stock',0,3,1,0,0,0.00,0,263,NULL,NULL,NULL,13,14,13,852,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(86,'Progash Durable Granite Hat',NULL,NULL,NULL,'published','[\"products\\/product-9.jpg\"]',NULL,'NC-147-A0',0,18,0,1,'in_stock',0,7,1,0,0,0.00,0,379,NULL,NULL,NULL,11,10,13,560,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(87,'Progash Durable Granite Hat',NULL,NULL,NULL,'published','[\"products\\/product-86.jpg\"]',NULL,'NC-147-A0-A1',0,18,0,1,'in_stock',0,7,1,0,0,0.00,0,379,NULL,NULL,NULL,11,10,13,560,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(88,'Progash Durable Granite Hat',NULL,NULL,NULL,'published','[\"products\\/product-28.jpg\"]',NULL,'NC-147-A0-A2',0,18,0,1,'in_stock',0,7,1,0,0,0.00,0,379,NULL,NULL,NULL,11,10,13,560,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(89,'Progash Durable Granite Hat',NULL,NULL,NULL,'published','[\"products\\/product-30.jpg\"]',NULL,'NC-147-A0-A3',0,18,0,1,'in_stock',0,7,1,0,0,0.00,0,379,NULL,NULL,NULL,11,10,13,560,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(90,'Purab Enormous Miranda Bottle',NULL,NULL,NULL,'published','[\"products\\/product-14.jpg\"]',NULL,'NC-129-A0',0,16,0,1,'in_stock',0,5,1,0,0,0.00,0,447,384.42,NULL,NULL,16,12,11,707,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(91,'Purab Enormous Miranda Bottle',NULL,NULL,NULL,'published','[\"products\\/product-67.jpg\"]',NULL,'NC-129-A0-A1',0,16,0,1,'in_stock',0,5,1,0,0,0.00,0,447,379.95,NULL,NULL,16,12,11,707,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(92,'Purab Enormous Miranda Bottle',NULL,NULL,NULL,'published','[\"products\\/product-93.jpg\"]',NULL,'NC-129-A0-A2',0,16,0,1,'in_stock',0,5,1,0,0,0.00,0,447,371.01,NULL,NULL,16,12,11,707,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(93,'Miklonda Co. Crafted Candles',NULL,NULL,NULL,'published','[\"products\\/product-22.jpg\"]',NULL,'NC-196-A0',0,20,0,1,'in_stock',0,4,1,0,0,0.00,0,218,NULL,NULL,NULL,18,20,17,819,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(94,'Pinkol Enormous Granite Bottle',NULL,NULL,NULL,'published','[\"products\\/product-44.jpg\"]',NULL,'NC-183-A0',0,16,0,1,'in_stock',0,4,1,0,0,0.00,0,299,NULL,NULL,NULL,13,13,12,896,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(95,'Pinkol Enormous Granite Bottle',NULL,NULL,NULL,'published','[\"products\\/product-82.jpg\"]',NULL,'NC-183-A0-A1',0,16,0,1,'in_stock',0,4,1,0,0,0.00,0,299,NULL,NULL,NULL,13,13,12,896,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(96,'Pinkol Enormous Granite Bottle',NULL,NULL,NULL,'published','[\"products\\/product-52.jpg\"]',NULL,'NC-183-A0-A2',0,16,0,1,'in_stock',0,4,1,0,0,0.00,0,299,NULL,NULL,NULL,13,13,12,896,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(97,'Dual Camera 20MP',NULL,NULL,NULL,'published','[\"products\\/product-94.jpg\"]',NULL,'NC-127-A0',0,17,0,1,'in_stock',0,2,1,0,0,0.00,0,411,NULL,NULL,NULL,11,13,12,691,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(98,'Dual Camera 20MP',NULL,NULL,NULL,'published','[\"products\\/product-8.jpg\"]',NULL,'NC-127-A0-A1',0,17,0,1,'in_stock',0,2,1,0,0,0.00,0,411,NULL,NULL,NULL,11,13,12,691,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(99,'Dual Camera 20MP',NULL,NULL,NULL,'published','[\"products\\/product-40.jpg\"]',NULL,'NC-127-A0-A2',0,17,0,1,'in_stock',0,2,1,0,0,0.00,0,411,NULL,NULL,NULL,11,13,12,691,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(100,'Dual Camera 20MP',NULL,NULL,NULL,'published','[\"products\\/product-92.jpg\"]',NULL,'NC-127-A0-A3',0,17,0,1,'in_stock',0,2,1,0,0,0.00,0,411,NULL,NULL,NULL,11,13,12,691,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(101,'Smart Watches',NULL,NULL,NULL,'published','[\"products\\/product-45.jpg\"]',NULL,'NC-113-A0',0,20,0,1,'in_stock',0,1,1,0,0,0.00,0,411,337.02,NULL,NULL,16,18,10,851,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(102,'Smart Watches',NULL,NULL,NULL,'published','[\"products\\/product-47.jpg\"]',NULL,'NC-113-A0-A1',0,20,0,1,'in_stock',0,1,1,0,0,0.00,0,411,369.9,NULL,NULL,16,18,10,851,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(103,'Smart Watches',NULL,NULL,NULL,'published','[\"products\\/product-10.jpg\"]',NULL,'NC-113-A0-A2',0,20,0,1,'in_stock',0,1,1,0,0,0.00,0,411,365.79,NULL,NULL,16,18,10,851,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(104,'Beat Headphone',NULL,NULL,NULL,'published','[\"products\\/product-17.jpg\"]',NULL,'NC-122-A0',0,13,0,1,'in_stock',0,4,1,0,0,0.00,0,240,NULL,NULL,NULL,15,18,18,578,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(105,'Red & Black Headphone',NULL,NULL,NULL,'published','[\"products\\/product-26.jpg\"]',NULL,'NC-192-A0',0,12,0,1,'in_stock',0,1,1,0,0,0.00,0,440,NULL,NULL,NULL,18,15,15,680,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(106,'Red & Black Headphone',NULL,NULL,NULL,'published','[\"products\\/product-40.jpg\"]',NULL,'NC-192-A0-A1',0,12,0,1,'in_stock',0,1,1,0,0,0.00,0,440,NULL,NULL,NULL,18,15,15,680,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(107,'Red & Black Headphone',NULL,NULL,NULL,'published','[\"products\\/product-77.jpg\"]',NULL,'NC-192-A0-A2',0,12,0,1,'in_stock',0,1,1,0,0,0.00,0,440,NULL,NULL,NULL,18,15,15,680,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(108,'Red & Black Headphone',NULL,NULL,NULL,'published','[\"products\\/product-90.jpg\"]',NULL,'NC-192-A0-A3',0,12,0,1,'in_stock',0,1,1,0,0,0.00,0,440,NULL,NULL,NULL,18,15,15,680,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(109,'Smart Watch External',NULL,NULL,NULL,'published','[\"products\\/product-53.jpg\"]',NULL,'NC-140-A0',0,20,0,1,'in_stock',0,6,1,0,0,0.00,0,347,NULL,NULL,NULL,14,18,11,664,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(110,'Smart Watch External',NULL,NULL,NULL,'published','[\"products\\/product-89.jpg\"]',NULL,'NC-140-A0-A1',0,20,0,1,'in_stock',0,6,1,0,0,0.00,0,347,NULL,NULL,NULL,14,18,11,664,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(111,'Nikon HD camera',NULL,NULL,NULL,'published','[\"products\\/product-6.jpg\"]',NULL,'NC-160-A0',0,15,0,1,'in_stock',0,1,1,0,0,0.00,0,385,342.65,NULL,NULL,17,12,18,703,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(112,'Nikon HD camera',NULL,NULL,NULL,'published','[\"products\\/product-44.jpg\"]',NULL,'NC-160-A0-A1',0,15,0,1,'in_stock',0,1,1,0,0,0.00,0,385,304.15,NULL,NULL,17,12,18,703,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(113,'Audio Equipment',NULL,NULL,NULL,'published','[\"products\\/product-14.jpg\"]',NULL,'NC-151-A0',0,11,0,1,'in_stock',0,1,1,0,0,0.00,0,237,NULL,NULL,NULL,11,17,15,536,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(114,'Audio Equipment',NULL,NULL,NULL,'published','[\"products\\/product-44.jpg\"]',NULL,'NC-151-A0-A1',0,11,0,1,'in_stock',0,1,1,0,0,0.00,0,237,NULL,NULL,NULL,11,17,15,536,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(115,'Audio Equipment',NULL,NULL,NULL,'published','[\"products\\/product-20.jpg\"]',NULL,'NC-151-A0-A2',0,11,0,1,'in_stock',0,1,1,0,0,0.00,0,237,NULL,NULL,NULL,11,17,15,536,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(116,'Smart Televisions',NULL,NULL,NULL,'published','[\"products\\/product-58.jpg\"]',NULL,'NC-181-A0',0,15,0,1,'in_stock',0,2,1,0,0,0.00,0,394,NULL,NULL,NULL,15,14,11,559,NULL,0,'2025-11-18 21:22:51','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(117,'Smart Televisions',NULL,NULL,NULL,'published','[\"products\\/product-36.jpg\"]',NULL,'NC-181-A0-A1',0,15,0,1,'in_stock',0,2,1,0,0,0.00,0,394,NULL,NULL,NULL,15,14,11,559,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(118,'Samsung Smart Phone',NULL,NULL,NULL,'published','[\"products\\/product-53.jpg\"]',NULL,'NC-163-A0',0,17,0,1,'in_stock',0,4,1,0,0,0.00,0,294,NULL,NULL,NULL,10,17,10,662,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(119,'Samsung Smart Phone',NULL,NULL,NULL,'published','[\"products\\/product-4.jpg\"]',NULL,'NC-163-A0-A1',0,17,0,1,'in_stock',0,4,1,0,0,0.00,0,294,NULL,NULL,NULL,10,17,10,662,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(120,'Samsung Smart Phone',NULL,NULL,NULL,'published','[\"products\\/product-81.jpg\"]',NULL,'NC-163-A0-A2',0,17,0,1,'in_stock',0,4,1,0,0,0.00,0,294,NULL,NULL,NULL,10,17,10,662,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(121,'Herschel Leather Duffle Bag In Brown Color',NULL,NULL,NULL,'published','[\"products\\/product-86.jpg\"]',NULL,'NC-168-A0',0,15,0,1,'in_stock',0,5,1,0,0,0.00,0,277,210.52,NULL,NULL,15,14,20,742,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(122,'Xbox One Wireless Controller Black Color',NULL,NULL,NULL,'published','[\"products\\/product-83.jpg\"]',NULL,'NC-115-A0',0,17,0,1,'in_stock',0,1,1,0,0,0.00,0,360,NULL,NULL,NULL,11,16,18,862,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(123,'EPSION Plaster Printer',NULL,NULL,NULL,'published','[\"products\\/product-43.jpg\"]',NULL,'NC-148-A0',0,11,0,1,'in_stock',0,1,1,0,0,0.00,0,300,NULL,NULL,NULL,19,12,13,781,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(124,'EPSION Plaster Printer',NULL,NULL,NULL,'published','[\"products\\/product-4.jpg\"]',NULL,'NC-148-A0-A1',0,11,0,1,'in_stock',0,1,1,0,0,0.00,0,300,NULL,NULL,NULL,19,12,13,781,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(125,'EPSION Plaster Printer',NULL,NULL,NULL,'published','[\"products\\/product-51.jpg\"]',NULL,'NC-148-A0-A2',0,11,0,1,'in_stock',0,1,1,0,0,0.00,0,300,NULL,NULL,NULL,19,12,13,781,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(126,'EPSION Plaster Printer',NULL,NULL,NULL,'published','[\"products\\/product-19.jpg\"]',NULL,'NC-148-A0-A3',0,11,0,1,'in_stock',0,1,1,0,0,0.00,0,300,NULL,NULL,NULL,19,12,13,781,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(127,'Sound Intone I65 Earphone White Version',NULL,NULL,NULL,'published','[\"products\\/product-23.jpg\"]',NULL,'NC-155-A0',0,16,0,1,'in_stock',0,7,1,0,0,0.00,0,380,NULL,NULL,NULL,18,15,15,585,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(128,'Sound Intone I65 Earphone White Version',NULL,NULL,NULL,'published','[\"products\\/product-40.jpg\"]',NULL,'NC-155-A0-A1',0,16,0,1,'in_stock',0,7,1,0,0,0.00,0,380,NULL,NULL,NULL,18,15,15,585,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(129,'B&O Play Mini Bluetooth Speaker',NULL,NULL,NULL,'published','[\"products\\/product-47.jpg\"]',NULL,'NC-166-A0',0,18,0,1,'in_stock',0,4,1,0,0,0.00,0,341,289.85,NULL,NULL,17,19,14,696,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(130,'B&O Play Mini Bluetooth Speaker',NULL,NULL,NULL,'published','[\"products\\/product-87.jpg\"]',NULL,'NC-166-A0-A1',0,18,0,1,'in_stock',0,4,1,0,0,0.00,0,341,238.7,NULL,NULL,17,19,14,696,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(131,'Apple MacBook Air Retina 13.3-Inch Laptop',NULL,NULL,NULL,'published','[\"products\\/product-77.jpg\"]',NULL,'NC-106-A0',0,17,0,1,'in_stock',0,2,1,0,0,0.00,0,205,NULL,NULL,NULL,12,13,19,789,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(132,'Apple MacBook Air Retina 12-Inch Laptop',NULL,NULL,NULL,'published','[\"products\\/product-12.jpg\"]',NULL,'NC-167-A0',0,10,0,1,'in_stock',0,6,1,0,0,0.00,0,453,NULL,NULL,NULL,14,15,11,776,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(133,'Apple MacBook Air Retina 12-Inch Laptop',NULL,NULL,NULL,'published','[\"products\\/product-81.jpg\"]',NULL,'NC-167-A0-A1',0,10,0,1,'in_stock',0,6,1,0,0,0.00,0,453,NULL,NULL,NULL,14,15,11,776,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(134,'Apple MacBook Air Retina 12-Inch Laptop',NULL,NULL,NULL,'published','[\"products\\/product-84.jpg\"]',NULL,'NC-167-A0-A2',0,10,0,1,'in_stock',0,6,1,0,0,0.00,0,453,NULL,NULL,NULL,14,15,11,776,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(135,'Apple MacBook Air Retina 12-Inch Laptop',NULL,NULL,NULL,'published','[\"products\\/product-32.jpg\"]',NULL,'NC-167-A0-A3',0,10,0,1,'in_stock',0,6,1,0,0,0.00,0,453,NULL,NULL,NULL,14,15,11,776,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(136,'Samsung Gear VR Virtual Reality Headset',NULL,NULL,NULL,'published','[\"products\\/product-72.jpg\"]',NULL,'NC-130-A0',0,16,0,1,'in_stock',0,2,1,0,0,0.00,0,209,NULL,NULL,NULL,12,12,14,540,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(137,'Aveeno Moisturizing Body Shower 450ml',NULL,NULL,NULL,'published','[\"products\\/product-40.jpg\"]',NULL,'NC-187-A0',0,19,0,1,'in_stock',0,4,1,0,0,0.00,0,308,264.88,NULL,NULL,17,20,17,700,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(138,'Aveeno Moisturizing Body Shower 450ml',NULL,NULL,NULL,'published','[\"products\\/product-81.jpg\"]',NULL,'NC-187-A0-A1',0,19,0,1,'in_stock',0,4,1,0,0,0.00,0,308,237.16,NULL,NULL,17,20,17,700,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(139,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL,NULL,'published','[\"products\\/product-49.jpg\"]',NULL,'NC-117-A0',0,16,0,1,'in_stock',0,1,1,0,0,0.00,0,275,NULL,NULL,NULL,11,15,10,747,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(140,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL,NULL,'published','[\"products\\/product-87.jpg\"]',NULL,'NC-117-A0-A1',0,16,0,1,'in_stock',0,1,1,0,0,0.00,0,275,NULL,NULL,NULL,11,15,10,747,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(141,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL,NULL,'published','[\"products\\/product-59.jpg\"]',NULL,'NC-117-A0-A2',0,16,0,1,'in_stock',0,1,1,0,0,0.00,0,275,NULL,NULL,NULL,11,15,10,747,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(142,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL,NULL,'published','[\"products\\/product-63.jpg\"]',NULL,'NC-114-A0',0,10,0,1,'in_stock',0,3,1,0,0,0.00,0,343,NULL,NULL,NULL,13,18,11,531,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(143,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL,NULL,'published','[\"products\\/product-47.jpg\"]',NULL,'NC-114-A0-A1',0,10,0,1,'in_stock',0,3,1,0,0,0.00,0,343,NULL,NULL,NULL,13,18,11,531,NULL,0,'2025-11-18 21:22:52','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(144,'MVMTH Classical Leather Watch In Black',NULL,NULL,NULL,'published','[\"products\\/product-91.jpg\"]',NULL,'NC-126-A0',0,13,0,1,'in_stock',0,4,1,0,0,0.00,0,325,NULL,NULL,NULL,13,12,19,875,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(145,'MVMTH Classical Leather Watch In Black',NULL,NULL,NULL,'published','[\"products\\/product-34.jpg\"]',NULL,'NC-126-A0-A1',0,13,0,1,'in_stock',0,4,1,0,0,0.00,0,325,NULL,NULL,NULL,13,12,19,875,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(146,'MVMTH Classical Leather Watch In Black',NULL,NULL,NULL,'published','[\"products\\/product-59.jpg\"]',NULL,'NC-126-A0-A2',0,13,0,1,'in_stock',0,4,1,0,0,0.00,0,325,NULL,NULL,NULL,13,12,19,875,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(147,'Baxter Care Hair Kit For Bearded Mens',NULL,NULL,NULL,'published','[\"products\\/product-49.jpg\"]',NULL,'NC-177-A0',0,17,0,1,'in_stock',0,1,1,0,0,0.00,0,365,302.95,NULL,NULL,16,12,13,835,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(148,'Baxter Care Hair Kit For Bearded Mens',NULL,NULL,NULL,'published','[\"products\\/product-45.jpg\"]',NULL,'NC-177-A0-A1',0,17,0,1,'in_stock',0,1,1,0,0,0.00,0,365,306.6,NULL,NULL,16,12,13,835,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(149,'Baxter Care Hair Kit For Bearded Mens',NULL,NULL,NULL,'published','[\"products\\/product-76.jpg\"]',NULL,'NC-177-A0-A2',0,17,0,1,'in_stock',0,1,1,0,0,0.00,0,365,288.35,NULL,NULL,16,12,13,835,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(150,'Ciate Palemore Lipstick Bold Red Color',NULL,NULL,NULL,'published','[\"products\\/product-9.jpg\"]',NULL,'NC-119-A0',0,18,0,1,'in_stock',0,6,1,0,0,0.00,0,270,NULL,NULL,NULL,20,20,11,518,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(151,'Ciate Palemore Lipstick Bold Red Color',NULL,NULL,NULL,'published','[\"products\\/product-5.jpg\"]',NULL,'NC-119-A0-A1',0,18,0,1,'in_stock',0,6,1,0,0,0.00,0,270,NULL,NULL,NULL,20,20,11,518,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(152,'Vimto Squash Remix Apple 1.5 Litres',NULL,NULL,NULL,'published','[\"products\\/product-6.jpg\"]',NULL,'NC-156-A0',0,16,0,1,'in_stock',0,1,1,0,0,0.00,0,287,NULL,NULL,NULL,19,15,20,567,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(153,'Vimto Squash Remix Apple 1.5 Litres',NULL,NULL,NULL,'published','[\"products\\/product-56.jpg\"]',NULL,'NC-156-A0-A1',0,16,0,1,'in_stock',0,1,1,0,0,0.00,0,287,NULL,NULL,NULL,19,15,20,567,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(154,'Vimto Squash Remix Apple 1.5 Litres',NULL,NULL,NULL,'published','[\"products\\/product-23.jpg\"]',NULL,'NC-156-A0-A2',0,16,0,1,'in_stock',0,1,1,0,0,0.00,0,287,NULL,NULL,NULL,19,15,20,567,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(155,'Crock Pot Slow Cooker',NULL,NULL,NULL,'published','[\"products\\/product-47.jpg\"]',NULL,'NC-153-A0',0,17,0,1,'in_stock',0,7,1,0,0,0.00,0,253,NULL,NULL,NULL,20,11,18,821,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(156,'Crock Pot Slow Cooker',NULL,NULL,NULL,'published','[\"products\\/product-70.jpg\"]',NULL,'NC-153-A0-A1',0,17,0,1,'in_stock',0,7,1,0,0,0.00,0,253,NULL,NULL,NULL,20,11,18,821,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(157,'Crock Pot Slow Cooker',NULL,NULL,NULL,'published','[\"products\\/product-86.jpg\"]',NULL,'NC-153-A0-A2',0,17,0,1,'in_stock',0,7,1,0,0,0.00,0,253,NULL,NULL,NULL,20,11,18,821,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(158,'Taylors of Harrogate Yorkshire Coffee',NULL,NULL,NULL,'published','[\"products\\/product-68.jpg\"]',NULL,'NC-192-A0',0,11,0,1,'in_stock',0,5,1,0,0,0.00,0,369,324.72,NULL,NULL,11,16,11,766,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(159,'Taylors of Harrogate Yorkshire Coffee',NULL,NULL,NULL,'published','[\"products\\/product-12.jpg\"]',NULL,'NC-192-A0-A1',0,11,0,1,'in_stock',0,5,1,0,0,0.00,0,369,280.44,NULL,NULL,11,16,11,766,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(160,'Taylors of Harrogate Yorkshire Coffee',NULL,NULL,NULL,'published','[\"products\\/product-65.jpg\"]',NULL,'NC-192-A0-A2',0,11,0,1,'in_stock',0,5,1,0,0,0.00,0,369,261.99,NULL,NULL,11,16,11,766,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(161,'Taylors of Harrogate Yorkshire Coffee',NULL,NULL,NULL,'published','[\"products\\/product-54.jpg\"]',NULL,'NC-192-A0-A3',0,11,0,1,'in_stock',0,5,1,0,0,0.00,0,369,302.58,NULL,NULL,11,16,11,766,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(162,'Soft Mochi & Galeto Ice Cream',NULL,NULL,NULL,'published','[\"products\\/product-48.jpg\"]',NULL,'NC-146-A0',0,10,0,1,'in_stock',0,2,1,0,0,0.00,0,324,NULL,NULL,NULL,19,19,10,600,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(163,'Soft Mochi & Galeto Ice Cream',NULL,NULL,NULL,'published','[\"products\\/product-31.jpg\"]',NULL,'NC-146-A0-A1',0,10,0,1,'in_stock',0,2,1,0,0,0.00,0,324,NULL,NULL,NULL,19,19,10,600,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(164,'Soft Mochi & Galeto Ice Cream',NULL,NULL,NULL,'published','[\"products\\/product-16.jpg\"]',NULL,'NC-146-A0-A2',0,10,0,1,'in_stock',0,2,1,0,0,0.00,0,324,NULL,NULL,NULL,19,19,10,600,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(165,'Soft Mochi & Galeto Ice Cream',NULL,NULL,NULL,'published','[\"products\\/product-18.jpg\"]',NULL,'NC-146-A0-A3',0,10,0,1,'in_stock',0,2,1,0,0,0.00,0,324,NULL,NULL,NULL,19,19,10,600,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(166,'Soft Mochi & Galeto Ice Cream',NULL,NULL,NULL,'published','[\"products\\/product-32.jpg\"]',NULL,'NC-146-A0-A4',0,10,0,1,'in_stock',0,2,1,0,0,0.00,0,324,NULL,NULL,NULL,19,19,10,600,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(167,'Naked Noodle Egg Noodles Singapore',NULL,NULL,NULL,'published','[\"products\\/product-56.jpg\"]',NULL,'NC-181-A0',0,14,0,1,'in_stock',0,7,1,0,0,0.00,0,326,NULL,NULL,NULL,15,12,11,570,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(168,'Naked Noodle Egg Noodles Singapore',NULL,NULL,NULL,'published','[\"products\\/product-29.jpg\"]',NULL,'NC-181-A0-A1',0,14,0,1,'in_stock',0,7,1,0,0,0.00,0,326,NULL,NULL,NULL,15,12,11,570,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(169,'Naked Noodle Egg Noodles Singapore',NULL,NULL,NULL,'published','[\"products\\/product-12.jpg\"]',NULL,'NC-181-A0-A2',0,14,0,1,'in_stock',0,7,1,0,0,0.00,0,326,NULL,NULL,NULL,15,12,11,570,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(170,'Saute Pan Silver',NULL,NULL,NULL,'published','[\"products\\/product-26.jpg\"]',NULL,'NC-165-A0',0,15,0,1,'in_stock',0,6,1,0,0,0.00,0,245,NULL,NULL,NULL,20,17,16,875,NULL,0,'2025-11-18 21:22:53','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(171,'Bar S – Classic Bun Length Franks',NULL,NULL,NULL,'published','[\"products\\/product-70.jpg\"]',NULL,'NC-166-A0',0,17,0,1,'in_stock',0,2,1,0,0,0.00,0,413,367.57,NULL,NULL,19,12,11,860,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(172,'Bar S – Classic Bun Length Franks',NULL,NULL,NULL,'published','[\"products\\/product-17.jpg\"]',NULL,'NC-166-A0-A1',0,17,0,1,'in_stock',0,2,1,0,0,0.00,0,413,363.44,NULL,NULL,19,12,11,860,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(173,'Broccoli Crowns',NULL,NULL,NULL,'published','[\"products\\/product-89.jpg\"]',NULL,'NC-177-A0',0,13,0,1,'in_stock',0,6,1,0,0,0.00,0,481,NULL,NULL,NULL,10,12,15,705,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(174,'Slimming World Vegan Mac Greens',NULL,NULL,NULL,'published','[\"products\\/product-69.jpg\"]',NULL,'NC-190-A0',0,13,0,1,'in_stock',0,3,1,0,0,0.00,0,419,NULL,NULL,NULL,13,18,10,771,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(175,'Häagen-Dazs Salted Caramel',NULL,NULL,NULL,'published','[\"products\\/product-25.jpg\"]',NULL,'NC-109-A0',0,17,0,1,'in_stock',0,2,1,0,0,0.00,0,500,NULL,NULL,NULL,16,18,11,598,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(176,'Häagen-Dazs Salted Caramel',NULL,NULL,NULL,'published','[\"products\\/product-69.jpg\"]',NULL,'NC-109-A0-A1',0,17,0,1,'in_stock',0,2,1,0,0,0.00,0,500,NULL,NULL,NULL,16,18,11,598,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(177,'Häagen-Dazs Salted Caramel',NULL,NULL,NULL,'published','[\"products\\/product-24.jpg\"]',NULL,'NC-109-A0-A2',0,17,0,1,'in_stock',0,2,1,0,0,0.00,0,500,NULL,NULL,NULL,16,18,11,598,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(178,'Häagen-Dazs Salted Caramel',NULL,NULL,NULL,'published','[\"products\\/product-14.jpg\"]',NULL,'NC-109-A0-A3',0,17,0,1,'in_stock',0,2,1,0,0,0.00,0,500,NULL,NULL,NULL,16,18,11,598,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:58',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(179,'Iceland 3 Solo Exotic Burst',NULL,NULL,NULL,'published','[\"products\\/product-43.jpg\"]',NULL,'NC-164-A0',0,16,0,1,'in_stock',0,1,1,0,0,0.00,0,339,288.15,NULL,NULL,11,20,15,884,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(180,'Iceland 3 Solo Exotic Burst',NULL,NULL,NULL,'published','[\"products\\/product-4.jpg\"]',NULL,'NC-164-A0-A1',0,16,0,1,'in_stock',0,1,1,0,0,0.00,0,339,254.25,NULL,NULL,11,20,15,884,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(181,'Iceland 3 Solo Exotic Burst',NULL,NULL,NULL,'published','[\"products\\/product-29.jpg\"]',NULL,'NC-164-A0-A2',0,16,0,1,'in_stock',0,1,1,0,0,0.00,0,339,250.86,NULL,NULL,11,20,15,884,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(182,'Extreme Budweiser Light Can',NULL,NULL,NULL,'published','[\"products\\/product-63.jpg\"]',NULL,'NC-189-A0',0,18,0,1,'in_stock',0,4,1,0,0,0.00,0,444,NULL,NULL,NULL,20,11,18,594,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(183,'Extreme Budweiser Light Can',NULL,NULL,NULL,'published','[\"products\\/product-52.jpg\"]',NULL,'NC-189-A0-A1',0,18,0,1,'in_stock',0,4,1,0,0,0.00,0,444,NULL,NULL,NULL,20,11,18,594,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(184,'Iceland Macaroni Cheese Traybake',NULL,NULL,NULL,'published','[\"products\\/product-5.jpg\"]',NULL,'NC-176-A0',0,17,0,1,'in_stock',0,1,1,0,0,0.00,0,456,NULL,NULL,NULL,16,18,12,557,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(185,'Iceland Macaroni Cheese Traybake',NULL,NULL,NULL,'published','[\"products\\/product-9.jpg\"]',NULL,'NC-176-A0-A1',0,17,0,1,'in_stock',0,1,1,0,0,0.00,0,456,NULL,NULL,NULL,16,18,12,557,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(186,'Iceland Macaroni Cheese Traybake',NULL,NULL,NULL,'published','[\"products\\/product-64.jpg\"]',NULL,'NC-176-A0-A2',0,17,0,1,'in_stock',0,1,1,0,0,0.00,0,456,NULL,NULL,NULL,16,18,12,557,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(187,'Dolmio Bolognese Pasta Sauce',NULL,NULL,NULL,'published','[\"products\\/product-81.jpg\"]',NULL,'NC-162-A0',0,10,0,1,'in_stock',0,1,1,0,0,0.00,0,324,NULL,NULL,NULL,20,14,17,857,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(188,'Sitema BakeIT Plastic Box',NULL,NULL,NULL,'published','[\"products\\/product-78.jpg\"]',NULL,'NC-192-A0',0,13,0,1,'in_stock',0,1,1,0,0,0.00,0,251,220.88,NULL,NULL,10,16,12,742,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(189,'Sitema BakeIT Plastic Box',NULL,NULL,NULL,'published','[\"products\\/product-37.jpg\"]',NULL,'NC-192-A0-A1',0,13,0,1,'in_stock',0,1,1,0,0,0.00,0,251,183.23,NULL,NULL,10,16,12,742,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(190,'Sitema BakeIT Plastic Box',NULL,NULL,NULL,'published','[\"products\\/product-74.jpg\"]',NULL,'NC-192-A0-A2',0,13,0,1,'in_stock',0,1,1,0,0,0.00,0,251,215.86,NULL,NULL,10,16,12,742,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(191,'Wayfair Basics Dinner Plate Storage',NULL,NULL,NULL,'published','[\"products\\/product-17.jpg\"]',NULL,'NC-177-A0',0,11,0,1,'in_stock',0,7,1,0,0,0.00,0,329,NULL,NULL,NULL,16,13,14,635,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(192,'Wayfair Basics Dinner Plate Storage',NULL,NULL,NULL,'published','[\"products\\/product-64.jpg\"]',NULL,'NC-177-A0-A1',0,11,0,1,'in_stock',0,7,1,0,0,0.00,0,329,NULL,NULL,NULL,16,13,14,635,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(193,'Wayfair Basics Dinner Plate Storage',NULL,NULL,NULL,'published','[\"products\\/product-37.jpg\"]',NULL,'NC-177-A0-A2',0,11,0,1,'in_stock',0,7,1,0,0,0.00,0,329,NULL,NULL,NULL,16,13,14,635,NULL,0,'2025-11-18 21:22:54','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(194,'Miko The Panda Water Bottle',NULL,NULL,NULL,'published','[\"products\\/product-56.jpg\"]',NULL,'NC-172-A0',0,18,0,1,'in_stock',0,4,1,0,0,0.00,0,306,NULL,NULL,NULL,20,17,18,844,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(195,'Miko The Panda Water Bottle',NULL,NULL,NULL,'published','[\"products\\/product-88.jpg\"]',NULL,'NC-172-A0-A1',0,18,0,1,'in_stock',0,4,1,0,0,0.00,0,306,NULL,NULL,NULL,20,17,18,844,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(196,'Sesame Seed Bread',NULL,NULL,NULL,'published','[\"products\\/product-38.jpg\"]',NULL,'NC-135-A0',0,13,0,1,'in_stock',0,1,1,0,0,0.00,0,467,NULL,NULL,NULL,14,10,15,666,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(197,'Sesame Seed Bread',NULL,NULL,NULL,'published','[\"products\\/product-28.jpg\"]',NULL,'NC-135-A0-A1',0,13,0,1,'in_stock',0,1,1,0,0,0.00,0,467,NULL,NULL,NULL,14,10,15,666,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(198,'Morrisons The Best Beef',NULL,NULL,NULL,'published','[\"products\\/product-21.jpg\"]',NULL,'NC-144-A0',0,10,0,1,'in_stock',0,4,1,0,0,0.00,0,411,328.8,NULL,NULL,13,15,13,668,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(199,'Morrisons The Best Beef',NULL,NULL,NULL,'published','[\"products\\/product-11.jpg\"]',NULL,'NC-144-A0-A1',0,10,0,1,'in_stock',0,4,1,0,0,0.00,0,411,316.47,NULL,NULL,13,15,13,668,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(200,'Avocado, Hass Large',NULL,NULL,NULL,'published','[\"products\\/product-47.jpg\"]',NULL,'NC-149-A0',0,19,0,1,'in_stock',0,2,1,0,0,0.00,0,364,NULL,NULL,NULL,16,18,10,862,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(201,'Avocado, Hass Large',NULL,NULL,NULL,'published','[\"products\\/product-81.jpg\"]',NULL,'NC-149-A0-A1',0,19,0,1,'in_stock',0,2,1,0,0,0.00,0,364,NULL,NULL,NULL,16,18,10,862,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(202,'Avocado, Hass Large',NULL,NULL,NULL,'published','[\"products\\/product-93.jpg\"]',NULL,'NC-149-A0-A2',0,19,0,1,'in_stock',0,2,1,0,0,0.00,0,364,NULL,NULL,NULL,16,18,10,862,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(203,'Avocado, Hass Large',NULL,NULL,NULL,'published','[\"products\\/product-52.jpg\"]',NULL,'NC-149-A0-A3',0,19,0,1,'in_stock',0,2,1,0,0,0.00,0,364,NULL,NULL,NULL,16,18,10,862,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(204,'Italia Beef Lasagne',NULL,NULL,NULL,'published','[\"products\\/product-5.jpg\"]',NULL,'NC-172-A0',0,19,0,1,'in_stock',0,3,1,0,0,0.00,0,311,NULL,NULL,NULL,14,13,17,855,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(205,'Maxwell House Classic Roast Mocha',NULL,NULL,NULL,'published','[\"products\\/product-11.jpg\"]',NULL,'NC-195-A0',0,19,0,1,'in_stock',0,1,1,0,0,0.00,0,437,NULL,NULL,NULL,14,16,20,598,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(206,'Maxwell House Classic Roast Mocha',NULL,NULL,NULL,'published','[\"products\\/product-53.jpg\"]',NULL,'NC-195-A0-A1',0,19,0,1,'in_stock',0,1,1,0,0,0.00,0,437,NULL,NULL,NULL,14,16,20,598,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(207,'Bottled Pure Water 500ml',NULL,NULL,NULL,'published','[\"products\\/product-72.jpg\"]',NULL,'NC-106-A0',0,11,0,1,'in_stock',0,7,1,0,0,0.00,0,394,350.66,NULL,NULL,16,19,16,511,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(208,'Bottled Pure Water 500ml',NULL,NULL,NULL,'published','[\"products\\/product-19.jpg\"]',NULL,'NC-106-A0-A1',0,11,0,1,'in_stock',0,7,1,0,0,0.00,0,394,299.44,NULL,NULL,16,19,16,511,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(209,'Bottled Pure Water 500ml',NULL,NULL,NULL,'published','[\"products\\/product-76.jpg\"]',NULL,'NC-106-A0-A2',0,11,0,1,'in_stock',0,7,1,0,0,0.00,0,394,283.68,NULL,NULL,16,19,16,511,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(210,'Bottled Pure Water 500ml',NULL,NULL,NULL,'published','[\"products\\/product-49.jpg\"]',NULL,'NC-106-A0-A3',0,11,0,1,'in_stock',0,7,1,0,0,0.00,0,394,287.62,NULL,NULL,16,19,16,511,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(211,'Famart Farmhouse Soft White',NULL,NULL,NULL,'published','[\"products\\/product-10.jpg\"]',NULL,'NC-178-A0',0,17,0,1,'in_stock',0,3,1,0,0,0.00,0,430,NULL,NULL,NULL,11,19,19,684,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(212,'Famart Farmhouse Soft White',NULL,NULL,NULL,'published','[\"products\\/product-70.jpg\"]',NULL,'NC-178-A0-A1',0,17,0,1,'in_stock',0,3,1,0,0,0.00,0,430,NULL,NULL,NULL,11,19,19,684,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(213,'Famart Farmhouse Soft White',NULL,NULL,NULL,'published','[\"products\\/product-24.jpg\"]',NULL,'NC-178-A0-A2',0,17,0,1,'in_stock',0,3,1,0,0,0.00,0,430,NULL,NULL,NULL,11,19,19,684,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(214,'Famart Farmhouse Soft White',NULL,NULL,NULL,'published','[\"products\\/product-59.jpg\"]',NULL,'NC-178-A0-A3',0,17,0,1,'in_stock',0,3,1,0,0,0.00,0,430,NULL,NULL,NULL,11,19,19,684,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(215,'Coca-Cola Original Taste',NULL,NULL,NULL,'published','[\"products\\/product-40.jpg\"]',NULL,'NC-173-A0',0,16,0,1,'in_stock',0,1,1,0,0,0.00,0,226,NULL,NULL,NULL,19,11,12,654,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(216,'Casillero Diablo Cabernet Sauvignon',NULL,NULL,NULL,'published','[\"products\\/product-31.jpg\"]',NULL,'NC-138-A0',0,15,0,1,'in_stock',0,7,1,0,0,0.00,0,316,NULL,NULL,NULL,17,13,15,779,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(217,'Casillero Diablo Cabernet Sauvignon',NULL,NULL,NULL,'published','[\"products\\/product-83.jpg\"]',NULL,'NC-138-A0-A1',0,15,0,1,'in_stock',0,7,1,0,0,0.00,0,316,NULL,NULL,NULL,17,13,15,779,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(218,'Arla Organic Free Range Milk',NULL,NULL,NULL,'published','[\"products\\/product-19.jpg\"]',NULL,'NC-191-A0',0,16,0,1,'in_stock',0,2,1,0,0,0.00,0,339,298.32,NULL,NULL,17,19,19,637,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(219,'Arla Organic Free Range Milk',NULL,NULL,NULL,'published','[\"products\\/product-50.jpg\"]',NULL,'NC-191-A0-A1',0,16,0,1,'in_stock',0,2,1,0,0,0.00,0,339,281.37,NULL,NULL,17,19,19,637,NULL,0,'2025-11-18 21:22:55','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(220,'Arla Organic Free Range Milk',NULL,NULL,NULL,'published','[\"products\\/product-21.jpg\"]',NULL,'NC-191-A0-A2',0,16,0,1,'in_stock',0,2,1,0,0,0.00,0,339,267.81,NULL,NULL,17,19,19,637,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(221,'Aptamil Follow On Baby Milk',NULL,NULL,NULL,'published','[\"products\\/product-26.jpg\"]',NULL,'NC-161-A0',0,13,0,1,'in_stock',0,2,1,0,0,0.00,0,452,NULL,NULL,NULL,15,10,10,831,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(222,'Cuisinart Chef’S Classic Hard-Anodized',NULL,NULL,NULL,'published','[\"products\\/product-62.jpg\"]',NULL,'NC-182-A0',0,10,0,1,'in_stock',0,2,1,0,0,0.00,0,252,NULL,NULL,NULL,16,11,15,551,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(223,'Cuisinart Chef’S Classic Hard-Anodized',NULL,NULL,NULL,'published','[\"products\\/product-4.jpg\"]',NULL,'NC-182-A0-A1',0,10,0,1,'in_stock',0,2,1,0,0,0.00,0,252,NULL,NULL,NULL,16,11,15,551,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(224,'Cuisinart Chef’S Classic Hard-Anodized',NULL,NULL,NULL,'published','[\"products\\/product-27.jpg\"]',NULL,'NC-182-A0-A2',0,10,0,1,'in_stock',0,2,1,0,0,0.00,0,252,NULL,NULL,NULL,16,11,15,551,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(225,'Cuisinart Chef’S Classic Hard-Anodized',NULL,NULL,NULL,'published','[\"products\\/product-84.jpg\"]',NULL,'NC-182-A0-A3',0,10,0,1,'in_stock',0,2,1,0,0,0.00,0,252,NULL,NULL,NULL,16,11,15,551,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(226,'Corn, Yellow Sweet',NULL,NULL,NULL,'published','[\"products\\/product-40.jpg\"]',NULL,'NC-117-A0',0,18,0,1,'in_stock',0,4,1,0,0,0.00,0,329,NULL,NULL,NULL,20,13,15,503,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(227,'Corn, Yellow Sweet',NULL,NULL,NULL,'published','[\"products\\/product-5.jpg\"]',NULL,'NC-117-A0-A1',0,18,0,1,'in_stock',0,4,1,0,0,0.00,0,329,NULL,NULL,NULL,20,13,15,503,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(228,'Corn, Yellow Sweet',NULL,NULL,NULL,'published','[\"products\\/product-53.jpg\"]',NULL,'NC-117-A0-A2',0,18,0,1,'in_stock',0,4,1,0,0,0.00,0,329,NULL,NULL,NULL,20,13,15,503,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(229,'Hobnobs The Nobbly Biscuit',NULL,NULL,NULL,'published','[\"products\\/product-9.jpg\"]',NULL,'NC-113-A0',0,12,0,1,'in_stock',0,4,1,0,0,0.00,0,341,255.75,NULL,NULL,19,19,16,701,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(230,'Hobnobs The Nobbly Biscuit',NULL,NULL,NULL,'published','[\"products\\/product-23.jpg\"]',NULL,'NC-113-A0-A1',0,12,0,1,'in_stock',0,4,1,0,0,0.00,0,341,259.16,NULL,NULL,19,19,16,701,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(231,'Honest Organic Still Lemonade',NULL,NULL,NULL,'published','[\"products\\/product-19.jpg\"]',NULL,'NC-102-A0',0,10,0,1,'in_stock',0,7,1,0,0,0.00,0,307,NULL,NULL,NULL,18,19,12,593,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(232,'Honest Organic Still Lemonade',NULL,NULL,NULL,'published','[\"products\\/product-31.jpg\"]',NULL,'NC-102-A0-A1',0,10,0,1,'in_stock',0,7,1,0,0,0.00,0,307,NULL,NULL,NULL,18,19,12,593,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(233,'Honest Organic Still Lemonade',NULL,NULL,NULL,'published','[\"products\\/product-39.jpg\"]',NULL,'NC-102-A0-A2',0,10,0,1,'in_stock',0,7,1,0,0,0.00,0,307,NULL,NULL,NULL,18,19,12,593,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(234,'Honest Organic Still Lemonade',NULL,NULL,NULL,'published','[\"products\\/product-4.jpg\"]',NULL,'NC-102-A0-A3',0,10,0,1,'in_stock',0,7,1,0,0,0.00,0,307,NULL,NULL,NULL,18,19,12,593,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(235,'Ice Beck’s Beer 350ml x 24 Pieces',NULL,NULL,NULL,'published','[\"products\\/product-53.jpg\"]',NULL,'NC-124-A0',0,18,0,1,'in_stock',0,7,1,0,0,0.00,0,332,NULL,NULL,NULL,11,19,14,851,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(236,'Ice Beck’s Beer 350ml x 24 Pieces',NULL,NULL,NULL,'published','[\"products\\/product-21.jpg\"]',NULL,'NC-124-A0-A1',0,18,0,1,'in_stock',0,7,1,0,0,0.00,0,332,NULL,NULL,NULL,11,19,14,851,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(237,'Ice Beck’s Beer 350ml x 24 Pieces',NULL,NULL,NULL,'published','[\"products\\/product-11.jpg\"]',NULL,'NC-124-A0-A2',0,18,0,1,'in_stock',0,7,1,0,0,0.00,0,332,NULL,NULL,NULL,11,19,14,851,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(238,'Ice Beck’s Beer 350ml x 24 Pieces',NULL,NULL,NULL,'published','[\"products\\/product-91.jpg\"]',NULL,'NC-124-A0-A3',0,18,0,1,'in_stock',0,7,1,0,0,0.00,0,332,NULL,NULL,NULL,11,19,14,851,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(239,'Iceland 6 Hot Cross Buns',NULL,NULL,NULL,'published','[\"products\\/product-52.jpg\"]',NULL,'NC-138-A0',0,11,0,1,'in_stock',0,1,1,0,0,0.00,0,338,NULL,NULL,NULL,14,11,16,677,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(240,'Iceland 6 Hot Cross Buns',NULL,NULL,NULL,'published','[\"products\\/product-76.jpg\"]',NULL,'NC-138-A0-A1',0,11,0,1,'in_stock',0,1,1,0,0,0.00,0,338,NULL,NULL,NULL,14,11,16,677,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(241,'Iceland 6 Hot Cross Buns',NULL,NULL,NULL,'published','[\"products\\/product-88.jpg\"]',NULL,'NC-138-A0-A2',0,11,0,1,'in_stock',0,1,1,0,0,0.00,0,338,NULL,NULL,NULL,14,11,16,677,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(242,'Iceland 6 Hot Cross Buns',NULL,NULL,NULL,'published','[\"products\\/product-59.jpg\"]',NULL,'NC-138-A0-A3',0,11,0,1,'in_stock',0,1,1,0,0,0.00,0,338,NULL,NULL,NULL,14,11,16,677,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(243,'Iceland Luxury 4 Panini Rolls',NULL,NULL,NULL,'published','[\"products\\/product-26.jpg\"]',NULL,'NC-182-A0',0,12,0,1,'in_stock',0,1,1,0,0,0.00,0,345,279.45,NULL,NULL,20,16,11,611,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(244,'Iceland Luxury 4 Panini Rolls',NULL,NULL,NULL,'published','[\"products\\/product-55.jpg\"]',NULL,'NC-182-A0-A1',0,12,0,1,'in_stock',0,1,1,0,0,0.00,0,345,310.5,NULL,NULL,20,16,11,611,NULL,0,'2025-11-18 21:22:56','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(245,'Iceland Luxury 4 Panini Rolls',NULL,NULL,NULL,'published','[\"products\\/product-86.jpg\"]',NULL,'NC-182-A0-A2',0,12,0,1,'in_stock',0,1,1,0,0,0.00,0,345,289.8,NULL,NULL,20,16,11,611,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(246,'Iceland Luxury 4 Panini Rolls',NULL,NULL,NULL,'published','[\"products\\/product-63.jpg\"]',NULL,'NC-182-A0-A3',0,12,0,1,'in_stock',0,1,1,0,0,0.00,0,345,307.05,NULL,NULL,20,16,11,611,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(247,'Iceland Soft Scoop Vanilla',NULL,NULL,NULL,'published','[\"products\\/product-94.jpg\"]',NULL,'NC-146-A0',0,15,0,1,'in_stock',0,3,1,0,0,0.00,0,490,NULL,NULL,NULL,17,10,14,626,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(248,'Iceland Soft Scoop Vanilla',NULL,NULL,NULL,'published','[\"products\\/product-13.jpg\"]',NULL,'NC-146-A0-A1',0,15,0,1,'in_stock',0,3,1,0,0,0.00,0,490,NULL,NULL,NULL,17,10,14,626,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(249,'Iceland Spaghetti Bolognese',NULL,NULL,NULL,'published','[\"products\\/product-73.jpg\"]',NULL,'NC-141-A0',0,11,0,1,'in_stock',0,1,1,0,0,0.00,0,227,NULL,NULL,NULL,12,10,20,543,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(250,'Iceland Spaghetti Bolognese',NULL,NULL,NULL,'published','[\"products\\/product-17.jpg\"]',NULL,'NC-141-A0-A1',0,11,0,1,'in_stock',0,1,1,0,0,0.00,0,227,NULL,NULL,NULL,12,10,20,543,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(251,'Kellogg’s Coco Pops Cereal',NULL,NULL,NULL,'published','[\"products\\/product-76.jpg\"]',NULL,'NC-105-A0',0,12,0,1,'in_stock',0,2,1,0,0,0.00,0,334,NULL,NULL,NULL,16,19,14,619,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(252,'Kit Kat Chunky Milk Chocolate',NULL,NULL,NULL,'published','[\"products\\/product-77.jpg\"]',NULL,'NC-165-A0',0,17,0,1,'in_stock',0,6,1,0,0,0.00,0,344,264.88,NULL,NULL,12,10,13,565,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(253,'Kit Kat Chunky Milk Chocolate',NULL,NULL,NULL,'published','[\"products\\/product-21.jpg\"]',NULL,'NC-165-A0-A1',0,17,0,1,'in_stock',0,6,1,0,0,0.00,0,344,244.24,NULL,NULL,12,10,13,565,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(254,'Kit Kat Chunky Milk Chocolate',NULL,NULL,NULL,'published','[\"products\\/product-91.jpg\"]',NULL,'NC-165-A0-A2',0,17,0,1,'in_stock',0,6,1,0,0,0.00,0,344,306.16,NULL,NULL,12,10,13,565,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(255,'Kit Kat Chunky Milk Chocolate',NULL,NULL,NULL,'published','[\"products\\/product-60.jpg\"]',NULL,'NC-165-A0-A3',0,17,0,1,'in_stock',0,6,1,0,0,0.00,0,344,251.12,NULL,NULL,12,10,13,565,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(256,'Large Green Bell Pepper',NULL,NULL,NULL,'published','[\"products\\/product-74.jpg\"]',NULL,'NC-143-A0',0,11,0,1,'in_stock',0,2,1,0,0,0.00,0,236,NULL,NULL,NULL,20,17,13,599,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(257,'Large Green Bell Pepper',NULL,NULL,NULL,'published','[\"products\\/product-6.jpg\"]',NULL,'NC-143-A0-A1',0,11,0,1,'in_stock',0,2,1,0,0,0.00,0,236,NULL,NULL,NULL,20,17,13,599,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(258,'Large Green Bell Pepper',NULL,NULL,NULL,'published','[\"products\\/product-44.jpg\"]',NULL,'NC-143-A0-A2',0,11,0,1,'in_stock',0,2,1,0,0,0.00,0,236,NULL,NULL,NULL,20,17,13,599,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(259,'Large Green Bell Pepper',NULL,NULL,NULL,'published','[\"products\\/product-55.jpg\"]',NULL,'NC-143-A0-A3',0,11,0,1,'in_stock',0,2,1,0,0,0.00,0,236,NULL,NULL,NULL,20,17,13,599,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(260,'Pice 94w Beasley Journal',NULL,NULL,NULL,'published','[\"products\\/product-31.jpg\"]',NULL,'NC-164-A0',0,17,0,1,'in_stock',0,1,1,0,0,0.00,0,337,NULL,NULL,NULL,17,19,18,811,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(261,'Pice 94w Beasley Journal',NULL,NULL,NULL,'published','[\"products\\/product-22.jpg\"]',NULL,'NC-164-A0-A1',0,17,0,1,'in_stock',0,1,1,0,0,0.00,0,337,NULL,NULL,NULL,17,19,18,811,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(262,'Pice 94w Beasley Journal',NULL,NULL,NULL,'published','[\"products\\/product-75.jpg\"]',NULL,'NC-164-A0-A2',0,17,0,1,'in_stock',0,1,1,0,0,0.00,0,337,NULL,NULL,NULL,17,19,18,811,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(263,'Province Piece Glass Drinking Glass',NULL,NULL,NULL,'published','[\"products\\/product-31.jpg\"]',NULL,'NC-193-A0',0,11,0,1,'in_stock',0,1,1,0,0,0.00,0,331,NULL,NULL,NULL,10,14,17,889,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL),(264,'Province Piece Glass Drinking Glass',NULL,NULL,NULL,'published','[\"products\\/product-36.jpg\"]',NULL,'NC-193-A0-A1',0,11,0,1,'in_stock',0,1,1,0,0,0.00,0,331,NULL,NULL,NULL,10,14,17,889,NULL,0,'2025-11-18 21:22:57','2025-11-18 21:22:59',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,NULL,0,0,'auto_generate',0,0,0,NULL);
/*!40000 ALTER TABLE `ec_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products_translations`
--

DROP TABLE IF EXISTS `ec_products_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_products_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products_translations`
--

LOCK TABLES `ec_products_translations` WRITE;
/*!40000 ALTER TABLE `ec_products_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_products_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_review_replies`
--

DROP TABLE IF EXISTS `ec_review_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_review_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `review_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_review_replies_review_id_user_id_unique` (`review_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_review_replies`
--

LOCK TABLES `ec_review_replies` WRITE;
/*!40000 ALTER TABLE `ec_review_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_review_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_reviews`
--

DROP TABLE IF EXISTS `ec_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_id` bigint unsigned NOT NULL,
  `star` double NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_reviews_product_id_customer_id_unique` (`product_id`,`customer_id`),
  KEY `ec_reviews_product_id_customer_id_status_created_at_index` (`product_id`,`customer_id`,`status`,`created_at`),
  KEY `review_relation_index` (`product_id`,`customer_id`,`status`),
  KEY `ec_reviews_product_id_status_index` (`product_id`,`status`),
  KEY `ec_reviews_customer_id_status_index` (`customer_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=713 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_reviews`
--

LOCK TABLES `ec_reviews` WRITE;
/*!40000 ALTER TABLE `ec_reviews` DISABLE KEYS */;
INSERT INTO `ec_reviews` VALUES (1,6,NULL,NULL,75,3,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(2,1,NULL,NULL,70,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(3,5,NULL,NULL,65,3,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(4,5,NULL,NULL,6,3,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(5,4,NULL,NULL,72,4,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(6,2,NULL,NULL,50,5,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(7,9,NULL,NULL,32,2,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(8,5,NULL,NULL,62,4,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(9,4,NULL,NULL,26,4,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(10,7,NULL,NULL,26,5,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(11,9,NULL,NULL,46,5,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(12,9,NULL,NULL,58,4,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(13,5,NULL,NULL,38,4,'Best ecommerce CMS online store!','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(14,3,NULL,NULL,63,5,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(15,8,NULL,NULL,36,3,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(16,8,NULL,NULL,16,3,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(17,4,NULL,NULL,60,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(18,3,NULL,NULL,6,1,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(19,7,NULL,NULL,44,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(20,10,NULL,NULL,14,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(21,6,NULL,NULL,4,4,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(22,7,NULL,NULL,37,1,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(23,9,NULL,NULL,11,1,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(24,2,NULL,NULL,39,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(25,10,NULL,NULL,49,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(26,1,NULL,NULL,32,4,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(27,8,NULL,NULL,32,1,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(28,9,NULL,NULL,52,2,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(29,8,NULL,NULL,54,4,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(30,9,NULL,NULL,41,1,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(31,2,NULL,NULL,4,3,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(32,10,NULL,NULL,51,1,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(33,4,NULL,NULL,39,5,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:02','2025-11-18 21:23:02',NULL),(34,6,NULL,NULL,11,4,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(35,3,NULL,NULL,45,5,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(36,8,NULL,NULL,30,3,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(37,9,NULL,NULL,51,3,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(38,1,NULL,NULL,46,5,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(39,6,NULL,NULL,22,5,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(40,8,NULL,NULL,21,2,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(41,7,NULL,NULL,75,2,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(42,5,NULL,NULL,56,4,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(43,8,NULL,NULL,26,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(44,6,NULL,NULL,5,5,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(45,2,NULL,NULL,15,4,'Best ecommerce CMS online store!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(46,3,NULL,NULL,50,1,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(47,7,NULL,NULL,29,2,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(48,3,NULL,NULL,40,5,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(49,1,NULL,NULL,58,3,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(50,8,NULL,NULL,25,4,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(51,6,NULL,NULL,48,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(52,9,NULL,NULL,5,1,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(53,8,NULL,NULL,64,1,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(54,1,NULL,NULL,55,2,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(55,4,NULL,NULL,18,2,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(56,9,NULL,NULL,54,2,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(57,10,NULL,NULL,45,5,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(58,3,NULL,NULL,28,4,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(59,2,NULL,NULL,56,5,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(60,5,NULL,NULL,41,5,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(61,4,NULL,NULL,31,2,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(62,10,NULL,NULL,52,4,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(63,1,NULL,NULL,54,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(64,9,NULL,NULL,73,1,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(65,8,NULL,NULL,19,2,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(66,4,NULL,NULL,69,3,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(67,1,NULL,NULL,1,5,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(68,6,NULL,NULL,24,2,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(69,8,NULL,NULL,42,5,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(70,2,NULL,NULL,30,2,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(71,4,NULL,NULL,37,1,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(72,8,NULL,NULL,38,3,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(73,9,NULL,NULL,64,1,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(74,6,NULL,NULL,60,4,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(75,8,NULL,NULL,39,1,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(76,2,NULL,NULL,40,4,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(77,6,NULL,NULL,59,5,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(78,6,NULL,NULL,70,4,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(79,3,NULL,NULL,58,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(80,8,NULL,NULL,27,5,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(81,5,NULL,NULL,36,5,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(82,9,NULL,NULL,20,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(83,6,NULL,NULL,68,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(84,1,NULL,NULL,65,5,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(85,6,NULL,NULL,10,2,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(86,9,NULL,NULL,6,5,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(87,1,NULL,NULL,45,1,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(88,3,NULL,NULL,9,5,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(89,3,NULL,NULL,67,2,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(90,3,NULL,NULL,38,5,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(91,5,NULL,NULL,7,3,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(92,3,NULL,NULL,7,1,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(93,6,NULL,NULL,21,3,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(94,2,NULL,NULL,7,4,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(95,4,NULL,NULL,11,5,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(96,2,NULL,NULL,29,1,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(97,6,NULL,NULL,62,1,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(98,1,NULL,NULL,7,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(99,7,NULL,NULL,8,1,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(100,1,NULL,NULL,67,3,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(101,8,NULL,NULL,18,4,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(102,9,NULL,NULL,61,5,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(103,7,NULL,NULL,46,4,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(104,3,NULL,NULL,54,4,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(105,9,NULL,NULL,15,4,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(106,4,NULL,NULL,23,3,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(107,8,NULL,NULL,6,2,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(108,8,NULL,NULL,31,4,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(109,9,NULL,NULL,71,5,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(110,9,NULL,NULL,50,3,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(111,8,NULL,NULL,69,4,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(112,5,NULL,NULL,16,3,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(113,10,NULL,NULL,5,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(114,6,NULL,NULL,35,5,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(115,3,NULL,NULL,53,3,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(116,6,NULL,NULL,32,2,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(117,4,NULL,NULL,75,1,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(118,2,NULL,NULL,37,2,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(119,5,NULL,NULL,11,5,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(120,8,NULL,NULL,58,2,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(121,10,NULL,NULL,54,1,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(122,10,NULL,NULL,26,3,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(123,6,NULL,NULL,25,5,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(124,8,NULL,NULL,45,4,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(125,3,NULL,NULL,32,3,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(126,5,NULL,NULL,67,1,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(127,5,NULL,NULL,21,5,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(128,3,NULL,NULL,21,5,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(129,7,NULL,NULL,60,5,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(130,7,NULL,NULL,61,3,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(131,4,NULL,NULL,2,1,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(132,4,NULL,NULL,17,2,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(133,1,NULL,NULL,62,4,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(134,4,NULL,NULL,56,5,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(135,1,NULL,NULL,59,5,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(136,7,NULL,NULL,32,2,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(137,1,NULL,NULL,9,2,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(138,7,NULL,NULL,69,1,'Best ecommerce CMS online store!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(139,9,NULL,NULL,70,3,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(140,5,NULL,NULL,8,5,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(141,10,NULL,NULL,15,2,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(142,4,NULL,NULL,41,3,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(143,9,NULL,NULL,33,3,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(144,6,NULL,NULL,52,4,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(145,1,NULL,NULL,66,4,'Best ecommerce CMS online store!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(146,4,NULL,NULL,19,3,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(147,6,NULL,NULL,46,3,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(148,10,NULL,NULL,11,4,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(149,5,NULL,NULL,52,1,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(150,4,NULL,NULL,50,1,'Best ecommerce CMS online store!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(151,2,NULL,NULL,33,1,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(152,1,NULL,NULL,4,5,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(153,4,NULL,NULL,63,5,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(154,2,NULL,NULL,62,1,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(155,8,NULL,NULL,68,3,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(156,1,NULL,NULL,64,5,'Best ecommerce CMS online store!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(157,2,NULL,NULL,34,4,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(158,8,NULL,NULL,59,5,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(159,8,NULL,NULL,33,1,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(160,10,NULL,NULL,17,4,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(161,10,NULL,NULL,9,4,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(162,2,NULL,NULL,6,3,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(163,10,NULL,NULL,24,3,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(164,5,NULL,NULL,15,3,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(165,10,NULL,NULL,32,1,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(166,1,NULL,NULL,56,3,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(167,2,NULL,NULL,65,4,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(168,3,NULL,NULL,36,1,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(169,9,NULL,NULL,26,3,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(170,3,NULL,NULL,71,2,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(171,10,NULL,NULL,57,2,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(172,10,NULL,NULL,25,5,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(173,8,NULL,NULL,48,1,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(174,6,NULL,NULL,17,3,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(175,1,NULL,NULL,73,1,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(176,1,NULL,NULL,61,4,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(177,10,NULL,NULL,55,3,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(178,2,NULL,NULL,42,5,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(179,7,NULL,NULL,45,4,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(180,9,NULL,NULL,40,2,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(181,3,NULL,NULL,26,2,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(182,8,NULL,NULL,70,3,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(183,9,NULL,NULL,1,3,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(184,3,NULL,NULL,25,2,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(185,4,NULL,NULL,35,5,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(186,7,NULL,NULL,59,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(187,4,NULL,NULL,53,2,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(188,9,NULL,NULL,72,5,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(189,6,NULL,NULL,72,4,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(190,1,NULL,NULL,23,4,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(191,4,NULL,NULL,13,2,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(192,8,NULL,NULL,43,2,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(193,8,NULL,NULL,13,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(194,6,NULL,NULL,36,2,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(195,10,NULL,NULL,19,5,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(196,3,NULL,NULL,66,3,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(197,3,NULL,NULL,55,4,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(198,9,NULL,NULL,36,4,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(199,1,NULL,NULL,28,3,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(200,10,NULL,NULL,39,5,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(201,1,NULL,NULL,63,3,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(202,2,NULL,NULL,28,1,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(203,7,NULL,NULL,34,2,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(204,7,NULL,NULL,57,2,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(205,5,NULL,NULL,57,3,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(206,2,NULL,NULL,32,4,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(207,6,NULL,NULL,15,1,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(208,1,NULL,NULL,24,2,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(209,4,NULL,NULL,29,2,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(210,5,NULL,NULL,51,2,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(211,8,NULL,NULL,55,5,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(212,1,NULL,NULL,25,1,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(213,3,NULL,NULL,31,4,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(214,5,NULL,NULL,2,5,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(215,5,NULL,NULL,66,5,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(216,2,NULL,NULL,51,5,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(217,10,NULL,NULL,67,5,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(218,2,NULL,NULL,43,4,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(219,2,NULL,NULL,24,3,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(220,5,NULL,NULL,50,4,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(221,9,NULL,NULL,65,2,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(222,8,NULL,NULL,72,1,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(223,8,NULL,NULL,12,1,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(224,9,NULL,NULL,55,5,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(225,2,NULL,NULL,54,4,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(226,10,NULL,NULL,53,3,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(227,9,NULL,NULL,18,4,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(228,8,NULL,NULL,75,2,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(229,9,NULL,NULL,42,2,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(230,5,NULL,NULL,73,4,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(231,5,NULL,NULL,34,2,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(232,10,NULL,NULL,74,3,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(233,1,NULL,NULL,74,2,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(234,1,NULL,NULL,33,5,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(235,7,NULL,NULL,7,3,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(236,5,NULL,NULL,9,2,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(237,2,NULL,NULL,64,5,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(238,5,NULL,NULL,32,5,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(239,1,NULL,NULL,16,2,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(240,4,NULL,NULL,28,1,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(241,4,NULL,NULL,9,3,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(242,4,NULL,NULL,12,5,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(243,7,NULL,NULL,49,1,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(244,1,NULL,NULL,26,4,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(245,1,NULL,NULL,38,1,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(246,6,NULL,NULL,44,1,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(247,5,NULL,NULL,47,3,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(248,4,NULL,NULL,4,1,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(249,3,NULL,NULL,59,3,'Best ecommerce CMS online store!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(250,8,NULL,NULL,3,2,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(251,1,NULL,NULL,60,2,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(252,1,NULL,NULL,19,4,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(253,5,NULL,NULL,68,1,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(254,5,NULL,NULL,64,3,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(255,1,NULL,NULL,31,1,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(256,2,NULL,NULL,58,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(257,4,NULL,NULL,67,3,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(258,6,NULL,NULL,45,2,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(259,3,NULL,NULL,34,4,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(260,2,NULL,NULL,55,1,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(261,4,NULL,NULL,64,1,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(262,2,NULL,NULL,59,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(263,1,NULL,NULL,49,2,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(264,4,NULL,NULL,45,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(265,8,NULL,NULL,44,5,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(266,10,NULL,NULL,12,1,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(267,2,NULL,NULL,25,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(268,6,NULL,NULL,67,2,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(269,4,NULL,NULL,40,2,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(270,7,NULL,NULL,23,4,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(271,4,NULL,NULL,62,1,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(272,7,NULL,NULL,70,1,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(273,2,NULL,NULL,9,4,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(274,5,NULL,NULL,58,5,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(275,3,NULL,NULL,27,1,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(276,1,NULL,NULL,71,1,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(277,10,NULL,NULL,10,3,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(278,6,NULL,NULL,69,2,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(279,2,NULL,NULL,20,1,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(280,4,NULL,NULL,54,1,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(281,1,NULL,NULL,8,3,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(282,9,NULL,NULL,44,1,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(283,1,NULL,NULL,12,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(284,8,NULL,NULL,56,2,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(285,4,NULL,NULL,5,4,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(286,3,NULL,NULL,35,4,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(287,10,NULL,NULL,16,1,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(288,8,NULL,NULL,34,5,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(289,5,NULL,NULL,39,1,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(290,3,NULL,NULL,19,1,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(291,6,NULL,NULL,54,2,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(292,5,NULL,NULL,75,3,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(293,1,NULL,NULL,43,3,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(294,7,NULL,NULL,66,2,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(295,4,NULL,NULL,48,2,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(296,4,NULL,NULL,3,2,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(297,4,NULL,NULL,30,3,'Best ecommerce CMS online store!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(298,8,NULL,NULL,2,2,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(299,2,NULL,NULL,48,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(300,3,NULL,NULL,33,2,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(301,6,NULL,NULL,30,1,'Best ecommerce CMS online store!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(302,10,NULL,NULL,73,3,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(303,6,NULL,NULL,18,5,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(304,1,NULL,NULL,5,3,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(305,6,NULL,NULL,28,2,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(306,6,NULL,NULL,40,4,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(307,7,NULL,NULL,18,3,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(308,7,NULL,NULL,3,1,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(309,1,NULL,NULL,39,3,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(310,4,NULL,NULL,14,5,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(311,9,NULL,NULL,2,1,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(312,4,NULL,NULL,57,2,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(313,9,NULL,NULL,35,1,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(314,9,NULL,NULL,57,2,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(315,8,NULL,NULL,28,1,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(316,10,NULL,NULL,43,4,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(317,3,NULL,NULL,47,4,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(318,7,NULL,NULL,40,1,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(319,4,NULL,NULL,34,3,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(320,9,NULL,NULL,75,1,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(321,8,NULL,NULL,1,1,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(322,9,NULL,NULL,19,3,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(323,6,NULL,NULL,6,4,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(324,2,NULL,NULL,38,1,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(325,1,NULL,NULL,44,2,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(326,6,NULL,NULL,39,2,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(327,10,NULL,NULL,29,1,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(328,5,NULL,NULL,69,1,'Best ecommerce CMS online store!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(329,9,NULL,NULL,12,2,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(330,4,NULL,NULL,1,4,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(331,8,NULL,NULL,67,4,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(332,6,NULL,NULL,9,4,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(333,2,NULL,NULL,68,3,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(334,9,NULL,NULL,22,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(335,5,NULL,NULL,54,1,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(336,10,NULL,NULL,46,4,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(337,2,NULL,NULL,44,5,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(338,3,NULL,NULL,16,5,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(339,10,NULL,NULL,42,1,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(340,10,NULL,NULL,71,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(341,7,NULL,NULL,2,2,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(342,7,NULL,NULL,31,1,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(343,3,NULL,NULL,11,1,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(344,4,NULL,NULL,42,1,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(345,4,NULL,NULL,21,2,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(346,2,NULL,NULL,13,4,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(347,8,NULL,NULL,51,1,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(348,7,NULL,NULL,48,3,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(349,3,NULL,NULL,51,4,'Best ecommerce CMS online store!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(350,9,NULL,NULL,21,2,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(351,4,NULL,NULL,61,5,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(352,9,NULL,NULL,39,2,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(353,3,NULL,NULL,24,3,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(354,4,NULL,NULL,51,4,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(355,2,NULL,NULL,63,3,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(356,5,NULL,NULL,55,1,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(357,7,NULL,NULL,12,2,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(358,10,NULL,NULL,47,3,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(359,2,NULL,NULL,19,4,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(360,5,NULL,NULL,49,1,'Best ecommerce CMS online store!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(361,1,NULL,NULL,40,1,'Best ecommerce CMS online store!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(362,9,NULL,NULL,9,2,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(363,1,NULL,NULL,72,2,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(364,1,NULL,NULL,27,5,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(365,2,NULL,NULL,3,4,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(366,8,NULL,NULL,66,5,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(367,10,NULL,NULL,18,1,'Best ecommerce CMS online store!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(368,9,NULL,NULL,13,2,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(369,3,NULL,NULL,44,3,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(370,8,NULL,NULL,63,2,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(371,3,NULL,NULL,13,4,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(372,8,NULL,NULL,65,1,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(373,1,NULL,NULL,48,2,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(374,8,NULL,NULL,62,3,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(375,3,NULL,NULL,56,5,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(376,1,NULL,NULL,6,1,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(377,8,NULL,NULL,57,3,'Clean & perfect source code','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(378,7,NULL,NULL,55,2,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(379,8,NULL,NULL,35,3,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(380,8,NULL,NULL,4,2,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(381,3,NULL,NULL,75,1,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(382,7,NULL,NULL,27,5,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(383,3,NULL,NULL,60,3,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(384,7,NULL,NULL,15,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(385,9,NULL,NULL,68,2,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(386,5,NULL,NULL,61,3,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(387,5,NULL,NULL,35,3,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(388,7,NULL,NULL,71,5,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(389,2,NULL,NULL,27,3,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(390,6,NULL,NULL,50,3,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(391,3,NULL,NULL,43,4,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(392,4,NULL,NULL,27,5,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(393,1,NULL,NULL,34,2,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(394,3,NULL,NULL,39,3,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(395,6,NULL,NULL,56,4,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(396,9,NULL,NULL,23,3,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(397,5,NULL,NULL,3,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(398,5,NULL,NULL,29,3,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(399,8,NULL,NULL,14,5,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(400,10,NULL,NULL,36,4,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(401,6,NULL,NULL,63,5,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(402,6,NULL,NULL,26,1,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(403,1,NULL,NULL,11,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(404,7,NULL,NULL,53,2,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(405,2,NULL,NULL,47,1,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(406,2,NULL,NULL,5,4,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(407,8,NULL,NULL,74,1,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(408,10,NULL,NULL,72,5,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(409,10,NULL,NULL,59,2,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(410,9,NULL,NULL,67,3,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(411,5,NULL,NULL,19,4,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(412,3,NULL,NULL,61,1,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(413,4,NULL,NULL,47,3,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(414,2,NULL,NULL,73,3,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(415,1,NULL,NULL,41,5,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(416,8,NULL,NULL,61,3,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(417,7,NULL,NULL,50,3,'Best ecommerce CMS online store!','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(418,10,NULL,NULL,28,3,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:03','2025-11-18 21:23:03',NULL),(419,7,NULL,NULL,43,4,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(420,1,NULL,NULL,10,3,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(421,1,NULL,NULL,36,2,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(422,9,NULL,NULL,53,3,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(423,2,NULL,NULL,22,5,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(424,6,NULL,NULL,34,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(425,10,NULL,NULL,30,2,'Best ecommerce CMS online store!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(426,7,NULL,NULL,67,1,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(427,3,NULL,NULL,18,3,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(428,7,NULL,NULL,42,4,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(429,4,NULL,NULL,43,1,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(430,7,NULL,NULL,5,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(431,2,NULL,NULL,46,1,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(432,1,NULL,NULL,35,1,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(433,7,NULL,NULL,24,5,'Best ecommerce CMS online store!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(434,3,NULL,NULL,52,3,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(435,10,NULL,NULL,8,4,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(436,2,NULL,NULL,61,1,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(437,6,NULL,NULL,7,5,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(438,6,NULL,NULL,20,2,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(439,5,NULL,NULL,33,4,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(440,8,NULL,NULL,41,1,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(441,7,NULL,NULL,10,1,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(442,5,NULL,NULL,40,2,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(443,5,NULL,NULL,10,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(444,5,NULL,NULL,1,1,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(445,9,NULL,NULL,25,3,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(446,3,NULL,NULL,73,4,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(447,4,NULL,NULL,68,2,'Clean & perfect source code','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(448,2,NULL,NULL,72,3,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(449,2,NULL,NULL,11,3,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(450,10,NULL,NULL,65,3,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(451,5,NULL,NULL,42,1,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(452,4,NULL,NULL,15,3,'Clean & perfect source code','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(453,10,NULL,NULL,66,2,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(454,7,NULL,NULL,28,3,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(455,9,NULL,NULL,59,5,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(456,6,NULL,NULL,31,5,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(457,1,NULL,NULL,29,4,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(458,10,NULL,NULL,41,1,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(459,1,NULL,NULL,18,2,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(460,9,NULL,NULL,48,5,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(461,7,NULL,NULL,68,2,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(462,6,NULL,NULL,66,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(463,3,NULL,NULL,30,3,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(464,5,NULL,NULL,5,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(465,9,NULL,NULL,27,1,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(466,9,NULL,NULL,24,4,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(467,8,NULL,NULL,5,5,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(468,4,NULL,NULL,59,4,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(469,10,NULL,NULL,50,1,'Best ecommerce CMS online store!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(470,3,NULL,NULL,10,2,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(471,5,NULL,NULL,25,5,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(472,7,NULL,NULL,62,3,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(473,2,NULL,NULL,16,2,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(474,10,NULL,NULL,58,2,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(475,6,NULL,NULL,1,2,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(476,10,NULL,NULL,48,2,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(477,8,NULL,NULL,7,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(478,5,NULL,NULL,27,2,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(479,2,NULL,NULL,8,2,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(480,5,NULL,NULL,44,1,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(481,6,NULL,NULL,71,3,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(482,7,NULL,NULL,65,5,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(483,4,NULL,NULL,58,1,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(484,6,NULL,NULL,42,3,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(485,6,NULL,NULL,19,2,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(486,5,NULL,NULL,20,2,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(487,2,NULL,NULL,57,5,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(488,4,NULL,NULL,8,2,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(489,5,NULL,NULL,28,3,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(490,2,NULL,NULL,1,1,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(491,8,NULL,NULL,10,3,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(492,6,NULL,NULL,74,2,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(493,7,NULL,NULL,72,4,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(494,9,NULL,NULL,49,3,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(495,4,NULL,NULL,74,4,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(496,9,NULL,NULL,10,2,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(497,2,NULL,NULL,2,1,'Clean & perfect source code','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(498,1,NULL,NULL,52,1,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(499,3,NULL,NULL,48,3,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(500,4,NULL,NULL,24,2,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(501,4,NULL,NULL,46,4,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(502,4,NULL,NULL,52,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(503,5,NULL,NULL,22,1,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(504,7,NULL,NULL,4,4,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(505,8,NULL,NULL,52,1,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(506,5,NULL,NULL,46,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(507,9,NULL,NULL,43,4,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(508,6,NULL,NULL,3,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(509,7,NULL,NULL,16,4,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(510,10,NULL,NULL,6,2,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(511,10,NULL,NULL,2,4,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(512,10,NULL,NULL,1,1,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(513,10,NULL,NULL,70,2,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(514,9,NULL,NULL,28,5,'Clean & perfect source code','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(515,3,NULL,NULL,17,5,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(516,10,NULL,NULL,27,2,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(517,5,NULL,NULL,24,1,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(518,6,NULL,NULL,55,3,'Clean & perfect source code','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(519,3,NULL,NULL,46,1,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(520,5,NULL,NULL,70,3,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(521,10,NULL,NULL,75,2,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(522,7,NULL,NULL,74,1,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(523,7,NULL,NULL,36,4,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(524,4,NULL,NULL,7,4,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(525,5,NULL,NULL,72,4,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(526,1,NULL,NULL,21,1,'Best ecommerce CMS online store!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(527,10,NULL,NULL,61,1,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(528,8,NULL,NULL,49,5,'Clean & perfect source code','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(529,6,NULL,NULL,27,1,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(530,7,NULL,NULL,25,1,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(531,4,NULL,NULL,65,4,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(532,6,NULL,NULL,8,3,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(533,1,NULL,NULL,51,2,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(534,9,NULL,NULL,56,2,'Best ecommerce CMS online store!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(535,10,NULL,NULL,22,5,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(536,2,NULL,NULL,18,2,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(537,7,NULL,NULL,58,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(538,9,NULL,NULL,69,1,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(539,5,NULL,NULL,71,5,'Clean & perfect source code','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(540,2,NULL,NULL,36,5,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(541,6,NULL,NULL,47,5,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(542,9,NULL,NULL,47,5,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(543,7,NULL,NULL,22,1,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(544,2,NULL,NULL,23,3,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(545,4,NULL,NULL,71,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(546,10,NULL,NULL,69,1,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(547,10,NULL,NULL,31,2,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(548,7,NULL,NULL,41,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(549,1,NULL,NULL,68,3,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(550,7,NULL,NULL,73,2,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(551,5,NULL,NULL,17,4,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(552,7,NULL,NULL,54,5,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(553,1,NULL,NULL,57,1,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(554,3,NULL,NULL,5,4,'Best ecommerce CMS online store!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(555,4,NULL,NULL,44,1,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(556,8,NULL,NULL,22,2,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(557,6,NULL,NULL,23,4,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(558,6,NULL,NULL,41,5,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(559,2,NULL,NULL,49,2,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(560,7,NULL,NULL,13,3,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(561,6,NULL,NULL,64,1,'Best ecommerce CMS online store!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(562,7,NULL,NULL,51,2,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(563,2,NULL,NULL,12,3,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(564,9,NULL,NULL,74,5,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(565,4,NULL,NULL,36,4,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(566,10,NULL,NULL,4,4,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(567,9,NULL,NULL,45,1,'Clean & perfect source code','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(568,2,NULL,NULL,74,5,'Clean & perfect source code','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(569,9,NULL,NULL,17,3,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(570,8,NULL,NULL,46,3,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(571,2,NULL,NULL,70,4,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(572,2,NULL,NULL,45,5,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(573,2,NULL,NULL,69,3,'Best ecommerce CMS online store!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(574,3,NULL,NULL,22,5,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(575,5,NULL,NULL,63,5,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(576,4,NULL,NULL,55,4,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(577,5,NULL,NULL,74,2,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(578,6,NULL,NULL,13,4,'Clean & perfect source code','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(579,7,NULL,NULL,35,3,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(580,6,NULL,NULL,58,2,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(581,9,NULL,NULL,4,1,'Best ecommerce CMS online store!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(582,7,NULL,NULL,64,3,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(583,8,NULL,NULL,8,5,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(584,6,NULL,NULL,65,5,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(585,8,NULL,NULL,24,4,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(586,6,NULL,NULL,61,3,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(587,1,NULL,NULL,20,5,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(588,3,NULL,NULL,42,5,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(589,3,NULL,NULL,23,4,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(590,9,NULL,NULL,63,2,'Best ecommerce CMS online store!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(591,7,NULL,NULL,38,1,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(592,6,NULL,NULL,37,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(593,7,NULL,NULL,19,3,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(594,9,NULL,NULL,16,1,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(595,8,NULL,NULL,40,5,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(596,1,NULL,NULL,53,2,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(597,10,NULL,NULL,7,1,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(598,8,NULL,NULL,71,4,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(599,5,NULL,NULL,14,5,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(600,4,NULL,NULL,25,2,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(601,7,NULL,NULL,14,4,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(602,1,NULL,NULL,42,1,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(603,7,NULL,NULL,30,2,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(604,3,NULL,NULL,14,3,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(605,3,NULL,NULL,15,1,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(606,9,NULL,NULL,34,5,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(607,2,NULL,NULL,14,4,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(608,2,NULL,NULL,17,4,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(609,5,NULL,NULL,18,2,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(610,2,NULL,NULL,41,2,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(611,1,NULL,NULL,50,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(612,8,NULL,NULL,17,4,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(613,4,NULL,NULL,22,4,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(614,3,NULL,NULL,12,3,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(615,10,NULL,NULL,44,2,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(616,5,NULL,NULL,48,1,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(617,9,NULL,NULL,29,3,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(618,10,NULL,NULL,37,1,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(619,1,NULL,NULL,69,5,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(620,5,NULL,NULL,12,4,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(621,2,NULL,NULL,26,3,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(622,3,NULL,NULL,3,1,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(623,9,NULL,NULL,38,3,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(624,4,NULL,NULL,10,5,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(625,8,NULL,NULL,29,2,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(626,8,NULL,NULL,60,3,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(627,4,NULL,NULL,32,3,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(628,2,NULL,NULL,60,1,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(629,7,NULL,NULL,1,1,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(630,8,NULL,NULL,50,2,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(631,7,NULL,NULL,17,5,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(632,6,NULL,NULL,57,1,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(633,2,NULL,NULL,66,1,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(634,6,NULL,NULL,43,2,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(635,1,NULL,NULL,22,1,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(636,8,NULL,NULL,47,2,'Best ecommerce CMS online store!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(637,8,NULL,NULL,37,5,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(638,9,NULL,NULL,7,4,'Best ecommerce CMS online store!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(639,8,NULL,NULL,9,3,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(640,8,NULL,NULL,73,3,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(641,1,NULL,NULL,14,4,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(642,7,NULL,NULL,6,4,'Best ecommerce CMS online store!','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(643,4,NULL,NULL,33,3,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(644,4,NULL,NULL,20,2,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(645,6,NULL,NULL,12,1,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(646,4,NULL,NULL,6,1,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(647,5,NULL,NULL,60,2,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(648,7,NULL,NULL,47,1,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(649,10,NULL,NULL,33,1,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(650,3,NULL,NULL,62,1,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(651,10,NULL,NULL,68,2,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(652,10,NULL,NULL,13,4,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:04','2025-11-18 21:23:04',NULL),(653,3,NULL,NULL,29,1,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(654,7,NULL,NULL,63,3,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(655,5,NULL,NULL,4,4,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(656,6,NULL,NULL,51,2,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(657,1,NULL,NULL,2,5,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(658,9,NULL,NULL,30,4,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(659,1,NULL,NULL,3,4,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(660,2,NULL,NULL,53,3,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(661,6,NULL,NULL,49,1,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(662,3,NULL,NULL,72,5,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(663,4,NULL,NULL,66,3,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(664,4,NULL,NULL,16,1,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(665,1,NULL,NULL,30,5,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(666,2,NULL,NULL,31,3,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(667,5,NULL,NULL,30,3,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(668,7,NULL,NULL,9,1,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(669,8,NULL,NULL,20,1,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(670,10,NULL,NULL,35,2,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(671,3,NULL,NULL,49,3,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(672,3,NULL,NULL,74,1,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(673,1,NULL,NULL,13,5,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(674,8,NULL,NULL,23,2,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(675,10,NULL,NULL,3,4,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(676,10,NULL,NULL,62,3,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(677,2,NULL,NULL,75,5,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(678,6,NULL,NULL,53,4,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(679,8,NULL,NULL,53,2,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(680,3,NULL,NULL,65,1,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(681,5,NULL,NULL,45,3,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(682,5,NULL,NULL,37,4,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(683,3,NULL,NULL,69,4,'Best ecommerce CMS online store!','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(684,3,NULL,NULL,2,1,'Clean & perfect source code','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(685,3,NULL,NULL,8,5,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(686,1,NULL,NULL,47,2,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(687,8,NULL,NULL,11,4,'Best ecommerce CMS online store!','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(688,10,NULL,NULL,60,4,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(689,9,NULL,NULL,31,2,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(690,3,NULL,NULL,70,4,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(691,5,NULL,NULL,26,5,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(692,10,NULL,NULL,56,4,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(693,4,NULL,NULL,73,3,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(694,3,NULL,NULL,41,2,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(695,2,NULL,NULL,67,2,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(696,5,NULL,NULL,23,2,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(697,1,NULL,NULL,15,3,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(698,7,NULL,NULL,21,5,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(699,6,NULL,NULL,73,5,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(700,4,NULL,NULL,49,4,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(701,7,NULL,NULL,33,5,'Good app, good backup service and support. Good documentation.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(702,10,NULL,NULL,63,4,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(703,5,NULL,NULL,43,4,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(704,6,NULL,NULL,16,1,'Best ecommerce CMS online store!','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(705,10,NULL,NULL,38,4,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(706,7,NULL,NULL,11,3,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(707,9,NULL,NULL,3,4,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(708,9,NULL,NULL,14,3,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(709,1,NULL,NULL,37,4,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(710,9,NULL,NULL,66,5,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(711,2,NULL,NULL,71,1,'The code is good, in general, if you like it, can you give it 5 stars?','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(712,10,NULL,NULL,34,2,'Best ecommerce CMS online store!','published','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL);
/*!40000 ALTER TABLE `ec_reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shared_wishlists`
--

DROP TABLE IF EXISTS `ec_shared_wishlists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shared_wishlists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_ids` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_shared_wishlists_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shared_wishlists`
--

LOCK TABLES `ec_shared_wishlists` WRITE;
/*!40000 ALTER TABLE `ec_shared_wishlists` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_shared_wishlists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipment_histories`
--

DROP TABLE IF EXISTS `ec_shipment_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipment_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `shipment_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipment_histories`
--

LOCK TABLES `ec_shipment_histories` WRITE;
/*!40000 ALTER TABLE `ec_shipment_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_shipment_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipments`
--

DROP TABLE IF EXISTS `ec_shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `weight` double DEFAULT '0',
  `shipment_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rate_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cod_amount` decimal(15,2) DEFAULT '0.00',
  `cod_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cross_checking_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `price` decimal(15,2) DEFAULT '0.00',
  `store_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tracking_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tracking_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estimate_date_shipped` datetime DEFAULT NULL,
  `date_shipped` datetime DEFAULT NULL,
  `customer_delivered_confirmed_at` timestamp NULL DEFAULT NULL,
  `label_url` text COLLATE utf8mb4_unicode_ci,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_shipments_order_id_unique` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipments`
--

LOCK TABLES `ec_shipments` WRITE;
/*!40000 ALTER TABLE `ec_shipments` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_shipments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping`
--

DROP TABLE IF EXISTS `ec_shipping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping`
--

LOCK TABLES `ec_shipping` WRITE;
/*!40000 ALTER TABLE `ec_shipping` DISABLE KEYS */;
INSERT INTO `ec_shipping` VALUES (1,'All',NULL,'2025-11-18 21:22:41','2025-11-18 21:22:41');
/*!40000 ALTER TABLE `ec_shipping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rule_items`
--

DROP TABLE IF EXISTS `ec_shipping_rule_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rule_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `shipping_rule_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_price` decimal(15,2) DEFAULT '0.00',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rule_items`
--

LOCK TABLES `ec_shipping_rule_items` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rule_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_shipping_rule_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rules`
--

DROP TABLE IF EXISTS `ec_shipping_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_id` bigint unsigned NOT NULL,
  `type` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT 'based_on_price',
  `from` decimal(15,2) DEFAULT '0.00',
  `to` decimal(15,2) DEFAULT '0.00',
  `price` decimal(15,2) DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rules`
--

LOCK TABLES `ec_shipping_rules` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rules` DISABLE KEYS */;
INSERT INTO `ec_shipping_rules` VALUES (1,'Free delivery',1,'based_on_price',1000.00,NULL,0.00,'2025-11-18 21:22:41','2025-11-18 21:22:41'),(2,'Flat Rate',1,'based_on_price',0.00,NULL,20.00,'2025-11-18 21:22:41','2025-11-18 21:22:41'),(3,'Local Pickup',1,'based_on_price',0.00,NULL,0.00,'2025-11-18 21:22:41','2025-11-18 21:22:41');
/*!40000 ALTER TABLE `ec_shipping_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_specification_attributes`
--

DROP TABLE IF EXISTS `ec_specification_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_specification_attributes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `group_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `default_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_specification_attributes_author_type_author_id_index` (`author_type`,`author_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_specification_attributes`
--

LOCK TABLES `ec_specification_attributes` WRITE;
/*!40000 ALTER TABLE `ec_specification_attributes` DISABLE KEYS */;
INSERT INTO `ec_specification_attributes` VALUES (1,1,'Height','text',NULL,NULL,'2025-11-18 21:22:57','2025-11-18 21:22:57',NULL,NULL),(2,1,'Width','text',NULL,NULL,'2025-11-18 21:22:57','2025-11-18 21:22:57',NULL,NULL),(3,1,'Weight','text',NULL,NULL,'2025-11-18 21:22:57','2025-11-18 21:22:57',NULL,NULL),(4,2,'Power','text',NULL,NULL,'2025-11-18 21:22:57','2025-11-18 21:22:57',NULL,NULL),(5,2,'Speed','text',NULL,NULL,'2025-11-18 21:22:57','2025-11-18 21:22:57',NULL,NULL),(6,3,'Battery Life','text',NULL,NULL,'2025-11-18 21:22:57','2025-11-18 21:22:57',NULL,NULL),(7,4,'Screen Size','text',NULL,NULL,'2025-11-18 21:22:57','2025-11-18 21:22:57',NULL,NULL),(8,4,'Resolution','select','[\"1920x1080\",\"2560x1440\",\"3840x2160\"]',NULL,'2025-11-18 21:22:57','2025-11-18 21:22:57',NULL,NULL);
/*!40000 ALTER TABLE `ec_specification_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_specification_attributes_translations`
--

DROP TABLE IF EXISTS `ec_specification_attributes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_specification_attributes_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_specification_attributes_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `default_value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_specification_attributes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_specification_attributes_translations`
--

LOCK TABLES `ec_specification_attributes_translations` WRITE;
/*!40000 ALTER TABLE `ec_specification_attributes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_specification_attributes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_specification_groups`
--

DROP TABLE IF EXISTS `ec_specification_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_specification_groups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_specification_groups_author_type_author_id_index` (`author_type`,`author_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_specification_groups`
--

LOCK TABLES `ec_specification_groups` WRITE;
/*!40000 ALTER TABLE `ec_specification_groups` DISABLE KEYS */;
INSERT INTO `ec_specification_groups` VALUES (1,'Dimensions',NULL,'2025-11-18 21:22:57','2025-11-18 21:22:57',NULL,NULL),(2,'Performance',NULL,'2025-11-18 21:22:57','2025-11-18 21:22:57',NULL,NULL),(3,'Battery',NULL,'2025-11-18 21:22:57','2025-11-18 21:22:57',NULL,NULL),(4,'Display',NULL,'2025-11-18 21:22:57','2025-11-18 21:22:57',NULL,NULL);
/*!40000 ALTER TABLE `ec_specification_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_specification_groups_translations`
--

DROP TABLE IF EXISTS `ec_specification_groups_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_specification_groups_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_specification_groups_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_specification_groups_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_specification_groups_translations`
--

LOCK TABLES `ec_specification_groups_translations` WRITE;
/*!40000 ALTER TABLE `ec_specification_groups_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_specification_groups_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_specification_table_group`
--

DROP TABLE IF EXISTS `ec_specification_table_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_specification_table_group` (
  `table_id` bigint unsigned NOT NULL,
  `group_id` bigint unsigned NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`table_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_specification_table_group`
--

LOCK TABLES `ec_specification_table_group` WRITE;
/*!40000 ALTER TABLE `ec_specification_table_group` DISABLE KEYS */;
INSERT INTO `ec_specification_table_group` VALUES (1,1,0),(1,2,0),(2,3,0),(2,4,0);
/*!40000 ALTER TABLE `ec_specification_table_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_specification_tables`
--

DROP TABLE IF EXISTS `ec_specification_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_specification_tables` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_specification_tables_author_type_author_id_index` (`author_type`,`author_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_specification_tables`
--

LOCK TABLES `ec_specification_tables` WRITE;
/*!40000 ALTER TABLE `ec_specification_tables` DISABLE KEYS */;
INSERT INTO `ec_specification_tables` VALUES (1,'General Specification',NULL,'2025-11-18 21:22:57','2025-11-18 21:22:57',NULL,NULL),(2,'Technical Specification',NULL,'2025-11-18 21:22:57','2025-11-18 21:22:57',NULL,NULL);
/*!40000 ALTER TABLE `ec_specification_tables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_specification_tables_translations`
--

DROP TABLE IF EXISTS `ec_specification_tables_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_specification_tables_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_specification_tables_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_specification_tables_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_specification_tables_translations`
--

LOCK TABLES `ec_specification_tables_translations` WRITE;
/*!40000 ALTER TABLE `ec_specification_tables_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_specification_tables_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_store_locators`
--

DROP TABLE IF EXISTS `ec_store_locators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_store_locators` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_primary` tinyint(1) DEFAULT '0',
  `is_shipping_location` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_store_locators`
--

LOCK TABLES `ec_store_locators` WRITE;
/*!40000 ALTER TABLE `ec_store_locators` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_store_locators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_products`
--

DROP TABLE IF EXISTS `ec_tax_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_products` (
  `tax_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tax_id`),
  KEY `ec_tax_products_tax_id_index` (`tax_id`),
  KEY `ec_tax_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_products`
--

LOCK TABLES `ec_tax_products` WRITE;
/*!40000 ALTER TABLE `ec_tax_products` DISABLE KEYS */;
INSERT INTO `ec_tax_products` VALUES (1,1),(1,2),(1,3),(1,4),(1,5),(1,6),(1,7),(1,8),(1,9),(1,10),(1,11),(1,12),(1,13),(1,14),(1,15),(1,16),(1,17),(1,18),(1,19),(1,20),(1,21),(1,22),(1,23),(1,24),(1,25),(1,26),(1,27),(1,28),(1,29),(1,30),(1,31),(1,32),(1,33),(1,34),(1,35),(1,36),(1,37),(1,38),(1,39),(1,40),(1,41),(1,42),(1,43),(1,44),(1,45),(1,46),(1,47),(1,48),(1,49),(1,50),(1,51),(1,52),(1,53),(1,54),(1,55),(1,56),(1,57),(1,58),(1,59),(1,60),(1,61),(1,62),(1,63),(1,64),(1,65),(1,66),(1,67),(1,68),(1,69),(1,70),(1,71),(1,72),(1,73),(1,74),(1,75);
/*!40000 ALTER TABLE `ec_tax_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_tax_rules`
--

DROP TABLE IF EXISTS `ec_tax_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_tax_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_id` bigint unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_tax_rules`
--

LOCK TABLES `ec_tax_rules` WRITE;
/*!40000 ALTER TABLE `ec_tax_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_tax_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_taxes`
--

DROP TABLE IF EXISTS `ec_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_taxes`
--

LOCK TABLES `ec_taxes` WRITE;
/*!40000 ALTER TABLE `ec_taxes` DISABLE KEYS */;
INSERT INTO `ec_taxes` VALUES (1,'VAT',10,1,'published','2025-11-18 21:22:43','2025-11-18 21:22:43'),(2,'None',0,2,'published','2025-11-18 21:22:43','2025-11-18 21:22:43'),(3,'Import Tax',15,3,'published','2025-11-18 21:22:43','2025-11-18 21:22:43');
/*!40000 ALTER TABLE `ec_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_taxes_translations`
--

DROP TABLE IF EXISTS `ec_taxes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_taxes_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_taxes_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_taxes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_taxes_translations`
--

LOCK TABLES `ec_taxes_translations` WRITE;
/*!40000 ALTER TABLE `ec_taxes_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_taxes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_wish_lists`
--

DROP TABLE IF EXISTS `ec_wish_lists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_wish_lists` (
  `customer_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`customer_id`,`product_id`),
  KEY `wishlist_relation_index` (`product_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_wish_lists`
--

LOCK TABLES `ec_wish_lists` WRITE;
/*!40000 ALTER TABLE `ec_wish_lists` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_wish_lists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'Ordering Process',0,'published','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL),(2,'Product Returns',1,'published','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL),(3,'Product Availability',2,'published','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL);
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'How do I place an order?','To place an order, navigate to the product page, select the desired options, and click the \"Add to Cart\" button.',2,'published','2025-11-18 21:22:43','2025-11-18 21:22:43'),(2,'What are the shipping options?','We offer standard and expedited shipping options. Shipping costs and delivery times vary based on your location and chosen shipping method.',1,'published','2025-11-18 21:22:43','2025-11-18 21:22:43'),(3,'How can I return a product?','If you are not satisfied with your purchase, you can initiate a return within 30 days of receiving the product. Contact our customer service for further instructions.',2,'published','2025-11-18 21:22:43','2025-11-18 21:22:43'),(4,'What payment methods do you accept?','We accept major credit cards, PayPal, and other secure payment methods.',2,'published','2025-11-18 21:22:43','2025-11-18 21:22:43'),(5,'How can I update my account information?','Log in to your account and go to the \"Account Settings\" page to update your information, including your password and shipping address.',1,'published','2025-11-18 21:22:43','2025-11-18 21:22:43'),(6,'Are there any ongoing promotions or discounts?','Check our \"Promotions\" page for information on current discounts, special offers, and ongoing promotions.',1,'published','2025-11-18 21:22:43','2025-11-18 21:22:43'),(7,'Is the product in stock?','Product availability is indicated on each product page. If a product is out of stock, you may choose to be notified when it becomes available.',1,'published','2025-11-18 21:22:43','2025-11-18 21:22:43'),(8,'How is my personal information secured?','We take the security and privacy of your information seriously. Our website uses encryption technology to protect your personal data.',1,'published','2025-11-18 21:22:43','2025-11-18 21:22:43'),(9,'How do I get technical support?','For technical issues or assistance, contact our customer support team through the \"Contact Us\" page, and we will help you resolve any problems.',3,'published','2025-11-18 21:22:43','2025-11-18 21:22:43'),(10,'Do you offer international shipping?','Yes, we offer international shipping to many countries. Shipping costs and delivery times vary based on the destination.',1,'published','2025-11-18 21:22:43','2025-11-18 21:22:43'),(11,'Can I purchase a gift card?','Yes, we offer gift cards of varying denominations. Gift cards can be purchased on our website and make for a great gift for friends and family.',2,'published','2025-11-18 21:22:43','2025-11-18 21:22:43'),(12,'What is the warranty on your products?','Our products come with a standard warranty. Check the product documentation or contact our customer service for details on specific product warranties.',1,'published','2025-11-18 21:22:43','2025-11-18 21:22:43');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Perfect','Qui quas consequatur sunt error. Iure ut dolores temporibus beatae quidem. Minus aut illum quod minus nisi animi quia.',1,0,'galleries/1.jpg',1,'published','2025-11-18 21:23:06','2025-11-18 21:23:06'),(2,'New Day','Nisi possimus molestiae et eos laudantium nostrum est. Sit consequatur consequatur eum soluta eum ea.',1,0,'galleries/2.jpg',1,'published','2025-11-18 21:23:06','2025-11-18 21:23:06'),(3,'Happy Day','Et dolorum ut asperiores saepe et dolor aut. Sit autem et sed hic ea incidunt. Sit omnis quia enim.',1,0,'galleries/3.jpg',1,'published','2025-11-18 21:23:06','2025-11-18 21:23:06'),(4,'Nature','Animi occaecati optio recusandae tenetur nam sint. Iure quidem sit atque. Dolorem magni quo temporibus omnis. Id nisi et sint officia.',1,0,'galleries/4.jpg',1,'published','2025-11-18 21:23:06','2025-11-18 21:23:06'),(5,'Morning','Voluptatem eaque ipsa aut numquam dolores facere. Corrupti aut quasi amet iusto. Sapiente qui est ipsa sapiente libero.',1,0,'galleries/5.jpg',1,'published','2025-11-18 21:23:06','2025-11-18 21:23:06'),(6,'Photography','Esse non ut ad provident fuga facilis et. Enim veniam aut ut vero. Quos magnam vitae ut ea qui aut.',1,0,'galleries/6.jpg',1,'published','2025-11-18 21:23:06','2025-11-18 21:23:06');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"Adipisci expedita sit culpa. Architecto culpa eaque eum. Tempore placeat voluptatum et natus odit fuga beatae aut.\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"Fugit vero beatae omnis odit quisquam beatae ad. Dolores rerum et eveniet labore nulla. Delectus ut corporis et fugiat.\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"Amet ad natus vel non dolorum repellat. Quia et eos eos eum omnis. Iste rerum perferendis ea aut. Iste sit et aut qui voluptates distinctio.\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"Omnis est explicabo voluptatem nobis. Dolorem aut id sint possimus. Ut ut magni consectetur.\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"Porro reprehenderit rerum est sit ut et. Voluptas et iure ullam minima. Quas praesentium voluptas culpa pariatur molestias.\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"Distinctio consectetur minima occaecati ratione quidem. Voluptatem mollitia voluptatem ut et ut optio dolorum.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2025-11-18 21:23:06','2025-11-18 21:23:06'),(2,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"Adipisci expedita sit culpa. Architecto culpa eaque eum. Tempore placeat voluptatum et natus odit fuga beatae aut.\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"Fugit vero beatae omnis odit quisquam beatae ad. Dolores rerum et eveniet labore nulla. Delectus ut corporis et fugiat.\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"Amet ad natus vel non dolorum repellat. Quia et eos eos eum omnis. Iste rerum perferendis ea aut. Iste sit et aut qui voluptates distinctio.\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"Omnis est explicabo voluptatem nobis. Dolorem aut id sint possimus. Ut ut magni consectetur.\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"Porro reprehenderit rerum est sit ut et. Voluptas et iure ullam minima. Quas praesentium voluptas culpa pariatur molestias.\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"Distinctio consectetur minima occaecati ratione quidem. Voluptatem mollitia voluptatem ut et ut optio dolorum.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2025-11-18 21:23:06','2025-11-18 21:23:06'),(3,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"Adipisci expedita sit culpa. Architecto culpa eaque eum. Tempore placeat voluptatum et natus odit fuga beatae aut.\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"Fugit vero beatae omnis odit quisquam beatae ad. Dolores rerum et eveniet labore nulla. Delectus ut corporis et fugiat.\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"Amet ad natus vel non dolorum repellat. Quia et eos eos eum omnis. Iste rerum perferendis ea aut. Iste sit et aut qui voluptates distinctio.\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"Omnis est explicabo voluptatem nobis. Dolorem aut id sint possimus. Ut ut magni consectetur.\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"Porro reprehenderit rerum est sit ut et. Voluptas et iure ullam minima. Quas praesentium voluptas culpa pariatur molestias.\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"Distinctio consectetur minima occaecati ratione quidem. Voluptatem mollitia voluptatem ut et ut optio dolorum.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2025-11-18 21:23:06','2025-11-18 21:23:06'),(4,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"Adipisci expedita sit culpa. Architecto culpa eaque eum. Tempore placeat voluptatum et natus odit fuga beatae aut.\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"Fugit vero beatae omnis odit quisquam beatae ad. Dolores rerum et eveniet labore nulla. Delectus ut corporis et fugiat.\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"Amet ad natus vel non dolorum repellat. Quia et eos eos eum omnis. Iste rerum perferendis ea aut. Iste sit et aut qui voluptates distinctio.\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"Omnis est explicabo voluptatem nobis. Dolorem aut id sint possimus. Ut ut magni consectetur.\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"Porro reprehenderit rerum est sit ut et. Voluptas et iure ullam minima. Quas praesentium voluptas culpa pariatur molestias.\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"Distinctio consectetur minima occaecati ratione quidem. Voluptatem mollitia voluptatem ut et ut optio dolorum.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2025-11-18 21:23:06','2025-11-18 21:23:06'),(5,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"Adipisci expedita sit culpa. Architecto culpa eaque eum. Tempore placeat voluptatum et natus odit fuga beatae aut.\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"Fugit vero beatae omnis odit quisquam beatae ad. Dolores rerum et eveniet labore nulla. Delectus ut corporis et fugiat.\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"Amet ad natus vel non dolorum repellat. Quia et eos eos eum omnis. Iste rerum perferendis ea aut. Iste sit et aut qui voluptates distinctio.\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"Omnis est explicabo voluptatem nobis. Dolorem aut id sint possimus. Ut ut magni consectetur.\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"Porro reprehenderit rerum est sit ut et. Voluptas et iure ullam minima. Quas praesentium voluptas culpa pariatur molestias.\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"Distinctio consectetur minima occaecati ratione quidem. Voluptatem mollitia voluptatem ut et ut optio dolorum.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2025-11-18 21:23:06','2025-11-18 21:23:06'),(6,'[{\"img\":\"galleries\\/1.jpg\",\"description\":\"Adipisci expedita sit culpa. Architecto culpa eaque eum. Tempore placeat voluptatum et natus odit fuga beatae aut.\"},{\"img\":\"galleries\\/2.jpg\",\"description\":\"Fugit vero beatae omnis odit quisquam beatae ad. Dolores rerum et eveniet labore nulla. Delectus ut corporis et fugiat.\"},{\"img\":\"galleries\\/3.jpg\",\"description\":\"Amet ad natus vel non dolorum repellat. Quia et eos eos eum omnis. Iste rerum perferendis ea aut. Iste sit et aut qui voluptates distinctio.\"},{\"img\":\"galleries\\/4.jpg\",\"description\":\"Omnis est explicabo voluptatem nobis. Dolorem aut id sint possimus. Ut ut magni consectetur.\"},{\"img\":\"galleries\\/5.jpg\",\"description\":\"Porro reprehenderit rerum est sit ut et. Voluptas et iure ullam minima. Quas praesentium voluptas culpa pariatur molestias.\"},{\"img\":\"galleries\\/6.jpg\",\"description\":\"Distinctio consectetur minima occaecati ratione quidem. Voluptatem mollitia voluptatem ut et ut optio dolorum.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2025-11-18 21:23:06','2025-11-18 21:23:06');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','a2e8a6d1e59992c20d88eeb4b4bf5341',1,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(2,'en_US','63d816f50c6aeacfe8a35c986bd81cba',2,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(3,'en_US','b03fb9175edb69b0031ff3e78441af7c',3,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(4,'en_US','85b290b75c55f87590bc1b1ad9f185cb',4,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(5,'en_US','b0208ff2c8d99e51bbefb31911f3016d',5,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(6,'en_US','338c7de023546c2279769273fe76fb51',1,'Botble\\Menu\\Models\\MenuLocation'),(7,'en_US','228d21825e277a30560780f7a5a61fc1',1,'Botble\\Menu\\Models\\Menu'),(8,'en_US','8ec54fae0a28859f4a95614f05193c9d',2,'Botble\\Menu\\Models\\MenuLocation'),(9,'en_US','4ee1ecb27df3abfb38c2b2d9e43e5505',2,'Botble\\Menu\\Models\\Menu'),(10,'en_US','dc7738fb1c16efcc40a4a3de45ec3da5',3,'Botble\\Menu\\Models\\MenuLocation'),(11,'en_US','540ae10e93fef8e2d9aa816eeecd7418',3,'Botble\\Menu\\Models\\Menu'),(12,'en_US','7636e3107ecd71615fce2ef5ac89befd',4,'Botble\\Menu\\Models\\MenuLocation'),(13,'en_US','1531ed8a2aa41f1f2dab6bfb33a7281c',4,'Botble\\Menu\\Models\\Menu');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=285 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (1,0,'f-app','f-app',1,'image/jpeg',617,'general/f-app.jpg','[]','2025-11-18 21:22:33','2025-11-18 21:22:33',NULL,'public'),(2,0,'f-brand-icon-01','f-brand-icon-01',1,'image/png',448,'general/f-brand-icon-01.png','[]','2025-11-18 21:22:33','2025-11-18 21:22:33',NULL,'public'),(3,0,'f-google','f-google',1,'image/jpeg',617,'general/f-google.jpg','[]','2025-11-18 21:22:34','2025-11-18 21:22:34',NULL,'public'),(4,0,'favicon','favicon',1,'image/png',15233,'general/favicon.png','[]','2025-11-18 21:22:34','2025-11-18 21:22:34',NULL,'public'),(5,0,'logo-white','logo-white',1,'image/png',860,'general/logo-white.png','[]','2025-11-18 21:22:34','2025-11-18 21:22:34',NULL,'public'),(6,0,'logo','logo',1,'image/png',934,'general/logo.png','[]','2025-11-18 21:22:34','2025-11-18 21:22:34',NULL,'public'),(7,0,'newsletter-popup','newsletter-popup',1,'image/png',28834,'general/newsletter-popup.png','[]','2025-11-18 21:22:34','2025-11-18 21:22:34',NULL,'public'),(8,0,'cod','cod',2,'image/png',12121,'payments/cod.png','[]','2025-11-18 21:22:34','2025-11-18 21:22:34',NULL,'public'),(9,0,'bank-transfer','bank-transfer',2,'image/png',29089,'payments/bank-transfer.png','[]','2025-11-18 21:22:34','2025-11-18 21:22:34',NULL,'public'),(10,0,'stripe','stripe',2,'image/webp',7516,'payments/stripe.webp','[]','2025-11-18 21:22:34','2025-11-18 21:22:34',NULL,'public'),(11,0,'paypal','paypal',2,'image/png',3001,'payments/paypal.png','[]','2025-11-18 21:22:34','2025-11-18 21:22:34',NULL,'public'),(12,0,'mollie','mollie',2,'image/png',8968,'payments/mollie.png','[]','2025-11-18 21:22:34','2025-11-18 21:22:34',NULL,'public'),(13,0,'paystack','paystack',2,'image/png',31015,'payments/paystack.png','[]','2025-11-18 21:22:34','2025-11-18 21:22:34',NULL,'public'),(14,0,'razorpay','razorpay',2,'image/png',8489,'payments/razorpay.png','[]','2025-11-18 21:22:34','2025-11-18 21:22:34',NULL,'public'),(15,0,'sslcommerz','sslcommerz',2,'image/png',3482,'payments/sslcommerz.png','[]','2025-11-18 21:22:34','2025-11-18 21:22:34',NULL,'public'),(16,0,'1','1',3,'image/jpeg',3319,'blog/1.jpg','[]','2025-11-18 21:22:34','2025-11-18 21:22:34',NULL,'public'),(17,0,'10','10',3,'image/jpeg',3319,'blog/10.jpg','[]','2025-11-18 21:22:34','2025-11-18 21:22:34',NULL,'public'),(18,0,'11','11',3,'image/jpeg',3319,'blog/11.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(19,0,'2','2',3,'image/jpeg',3319,'blog/2.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(20,0,'3','3',3,'image/jpeg',3319,'blog/3.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(21,0,'4','4',3,'image/jpeg',3319,'blog/4.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(22,0,'5','5',3,'image/jpeg',3319,'blog/5.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(23,0,'6','6',3,'image/jpeg',3319,'blog/6.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(24,0,'7','7',3,'image/jpeg',3319,'blog/7.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(25,0,'8','8',3,'image/jpeg',3319,'blog/8.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(26,0,'9','9',3,'image/jpeg',3319,'blog/9.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(27,0,'blog-in-01','blog-in-01',3,'image/jpeg',9623,'blog/blog-in-01.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(28,0,'blog-in-02','blog-in-02',3,'image/jpeg',9623,'blog/blog-in-02.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(29,0,'blog-in-03','blog-in-03',3,'image/jpeg',9623,'blog/blog-in-03.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(30,0,'blog-in-04','blog-in-04',3,'image/jpeg',9623,'blog/blog-in-04.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(31,0,'blog-in-05','blog-in-05',3,'image/jpeg',9623,'blog/blog-in-05.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(32,0,'blog-in-06','blog-in-06',3,'image/jpeg',9623,'blog/blog-in-06.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(33,0,'blog-sm-1','blog-sm-1',3,'image/jpeg',9623,'blog/blog-sm-1.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(34,0,'blog-sm-2','blog-sm-2',3,'image/jpeg',9623,'blog/blog-sm-2.jpg','[]','2025-11-18 21:22:35','2025-11-18 21:22:35',NULL,'public'),(35,0,'blog-sm-3','blog-sm-3',3,'image/jpeg',9623,'blog/blog-sm-3.jpg','[]','2025-11-18 21:22:36','2025-11-18 21:22:36',NULL,'public'),(36,0,'blog-sm-4','blog-sm-4',3,'image/jpeg',9623,'blog/blog-sm-4.jpg','[]','2025-11-18 21:22:36','2025-11-18 21:22:36',NULL,'public'),(37,0,'comment-1','comment-1',3,'image/jpeg',9803,'blog/comment-1.jpg','[]','2025-11-18 21:22:36','2025-11-18 21:22:36',NULL,'public'),(38,0,'comment-2','comment-2',3,'image/jpeg',9803,'blog/comment-2.jpg','[]','2025-11-18 21:22:36','2025-11-18 21:22:36',NULL,'public'),(39,0,'location-1','location-1',4,'image/png',5309,'shop/location-1.png','[]','2025-11-18 21:22:36','2025-11-18 21:22:36',NULL,'public'),(40,0,'location-2','location-2',4,'image/png',5309,'shop/location-2.png','[]','2025-11-18 21:22:36','2025-11-18 21:22:36',NULL,'public'),(41,0,'location-3','location-3',4,'image/png',5309,'shop/location-3.png','[]','2025-11-18 21:22:36','2025-11-18 21:22:36',NULL,'public'),(42,0,'location-4','location-4',4,'image/png',5309,'shop/location-4.png','[]','2025-11-18 21:22:36','2025-11-18 21:22:36',NULL,'public'),(43,0,'login_bg','login_bg',4,'image/jpeg',5443,'shop/login-bg.jpg','[]','2025-11-18 21:22:36','2025-11-18 21:22:36',NULL,'public'),(44,0,'reviewer-01','reviewer-01',4,'image/png',1070,'shop/reviewer-01.png','[]','2025-11-18 21:22:36','2025-11-18 21:22:36',NULL,'public'),(45,0,'reviewer-02','reviewer-02',4,'image/png',1070,'shop/reviewer-02.png','[]','2025-11-18 21:22:36','2025-11-18 21:22:36',NULL,'public'),(46,0,'reviewer-03','reviewer-03',4,'image/png',1070,'shop/reviewer-03.png','[]','2025-11-18 21:22:36','2025-11-18 21:22:36',NULL,'public'),(47,0,'s-thumb-01','s-thumb-01',4,'image/jpeg',2813,'shop/s-thumb-01.jpg','[]','2025-11-18 21:22:36','2025-11-18 21:22:36',NULL,'public'),(48,0,'s-thumb-02','s-thumb-02',4,'image/jpeg',2813,'shop/s-thumb-02.jpg','[]','2025-11-18 21:22:36','2025-11-18 21:22:36',NULL,'public'),(49,0,'s-thumb-03','s-thumb-03',4,'image/jpeg',2813,'shop/s-thumb-03.jpg','[]','2025-11-18 21:22:36','2025-11-18 21:22:36',NULL,'public'),(50,0,'s-thumb-04','s-thumb-04',4,'image/jpeg',2813,'shop/s-thumb-04.jpg','[]','2025-11-18 21:22:36','2025-11-18 21:22:36',NULL,'public'),(51,0,'s-thumb-05','s-thumb-05',4,'image/jpeg',2813,'shop/s-thumb-05.jpg','[]','2025-11-18 21:22:37','2025-11-18 21:22:37',NULL,'public'),(52,0,'s-thumb-06','s-thumb-06',4,'image/jpeg',2813,'shop/s-thumb-06.jpg','[]','2025-11-18 21:22:37','2025-11-18 21:22:37',NULL,'public'),(53,0,'sign_bg','sign_bg',4,'image/jpeg',5443,'shop/sign-bg.jpg','[]','2025-11-18 21:22:37','2025-11-18 21:22:37',NULL,'public'),(54,0,'track_bg','track_bg',4,'image/jpeg',6224,'shop/track-bg.jpg','[]','2025-11-18 21:22:37','2025-11-18 21:22:37',NULL,'public'),(55,0,'w-product-01','w-product-01',4,'image/jpeg',5528,'shop/w-product-01.jpg','[]','2025-11-18 21:22:37','2025-11-18 21:22:37',NULL,'public'),(56,0,'w-product-02','w-product-02',4,'image/jpeg',5528,'shop/w-product-02.jpg','[]','2025-11-18 21:22:37','2025-11-18 21:22:37',NULL,'public'),(57,0,'w-product-03','w-product-03',4,'image/jpeg',5528,'shop/w-product-03.jpg','[]','2025-11-18 21:22:37','2025-11-18 21:22:37',NULL,'public'),(58,0,'w-product-04','w-product-04',4,'image/jpeg',5528,'shop/w-product-04.jpg','[]','2025-11-18 21:22:37','2025-11-18 21:22:37',NULL,'public'),(59,0,'w-product-05','w-product-05',4,'image/jpeg',5528,'shop/w-product-05.jpg','[]','2025-11-18 21:22:37','2025-11-18 21:22:37',NULL,'public'),(60,0,'about-banner-1','about-banner-1',5,'image/jpeg',8335,'banners/about-banner-1.jpg','[]','2025-11-18 21:22:37','2025-11-18 21:22:37',NULL,'public'),(61,0,'about-banner-2','about-banner-2',5,'image/jpeg',8335,'banners/about-banner-2.jpg','[]','2025-11-18 21:22:37','2025-11-18 21:22:37',NULL,'public'),(62,0,'about-img-1','about-img-1',5,'image/jpeg',8914,'banners/about-img-1.jpg','[]','2025-11-18 21:22:37','2025-11-18 21:22:37',NULL,'public'),(63,0,'about-img-2','about-img-2',5,'image/jpeg',8914,'banners/about-img-2.jpg','[]','2025-11-18 21:22:37','2025-11-18 21:22:37',NULL,'public'),(64,0,'about-img-3','about-img-3',5,'image/png',6373,'banners/about-img-3.png','[]','2025-11-18 21:22:37','2025-11-18 21:22:37',NULL,'public'),(65,0,'banner-03-01','banner-03-01',5,'image/jpeg',6612,'banners/banner-03-01.jpg','[]','2025-11-18 21:22:37','2025-11-18 21:22:37',NULL,'public'),(66,0,'banner-03-02','banner-03-02',5,'image/jpeg',5283,'banners/banner-03-02.jpg','[]','2025-11-18 21:22:37','2025-11-18 21:22:37',NULL,'public'),(67,0,'banner-03-03','banner-03-03',5,'image/jpeg',5077,'banners/banner-03-03.jpg','[]','2025-11-18 21:22:38','2025-11-18 21:22:38',NULL,'public'),(68,0,'banner-2-01','banner-2-01',5,'image/jpeg',5452,'banners/banner-2-01.jpg','[]','2025-11-18 21:22:38','2025-11-18 21:22:38',NULL,'public'),(69,0,'banner-2-02','banner-2-02',5,'image/jpeg',5452,'banners/banner-2-02.jpg','[]','2025-11-18 21:22:38','2025-11-18 21:22:38',NULL,'public'),(70,0,'banner-2-03','banner-2-03',5,'image/jpeg',12296,'banners/banner-2-03.jpg','[]','2025-11-18 21:22:38','2025-11-18 21:22:38',NULL,'public'),(71,0,'banner-2-04','banner-2-04',5,'image/jpeg',7318,'banners/banner-2-04.jpg','[]','2025-11-18 21:22:38','2025-11-18 21:22:38',NULL,'public'),(72,0,'banner-bg-05','banner-bg-05',5,'image/jpeg',23672,'banners/banner-bg-05.jpg','[]','2025-11-18 21:22:38','2025-11-18 21:22:38',NULL,'public'),(73,0,'banner-offer-01','banner-offer-01',5,'image/jpeg',10330,'banners/banner-offer-01.jpg','[]','2025-11-18 21:22:38','2025-11-18 21:22:38',NULL,'public'),(74,0,'banner-offer-02','banner-offer-02',5,'image/jpeg',9086,'banners/banner-offer-02.jpg','[]','2025-11-18 21:22:38','2025-11-18 21:22:38',NULL,'public'),(75,0,'breadcrumb-01','breadcrumb-01',5,'image/jpeg',5276,'banners/breadcrumb-01.jpg','[]','2025-11-18 21:22:38','2025-11-18 21:22:38',NULL,'public'),(76,0,'coming-soon','coming-soon',5,'image/jpeg',27345,'banners/coming-soon.jpg','[]','2025-11-18 21:22:38','2025-11-18 21:22:38',NULL,'public'),(77,0,'login-bg','login-bg',5,'image/jpeg',5443,'banners/login-bg.jpg','[]','2025-11-18 21:22:38','2025-11-18 21:22:38',NULL,'public'),(78,0,'product-shape-01','product-shape-01',5,'image/png',3220,'banners/product-shape-01.png','[]','2025-11-18 21:22:38','2025-11-18 21:22:38',NULL,'public'),(79,0,'product-shape-02','product-shape-02',5,'image/png',2285,'banners/product-shape-02.png','[]','2025-11-18 21:22:38','2025-11-18 21:22:38',NULL,'public'),(80,0,'sign-bg','sign-bg',5,'image/jpeg',5443,'banners/sign-bg.jpg','[]','2025-11-18 21:22:38','2025-11-18 21:22:38',NULL,'public'),(81,0,'thumb-01','thumb-01',5,'image/jpeg',16230,'banners/thumb-01.jpg','[]','2025-11-18 21:22:38','2025-11-18 21:22:38',NULL,'public'),(82,0,'thumb-02','thumb-02',5,'image/jpeg',7655,'banners/thumb-02.jpg','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(83,0,'thumb-03','thumb-03',5,'image/jpeg',7655,'banners/thumb-03.jpg','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(84,0,'thumb-04','thumb-04',5,'image/jpeg',16230,'banners/thumb-04.jpg','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(85,0,'track-bg','track-bg',5,'image/jpeg',6224,'banners/track-bg.jpg','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(86,0,'box','box',6,'image/png',949,'icons/box.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(87,0,'car','car',6,'image/png',855,'icons/car.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(88,0,'cash-on-delivery','cash-on-delivery',6,'image/png',2426,'icons/cash-on-delivery.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(89,0,'cat-icon-01','cat-icon-01',6,'image/png',146,'icons/cat-icon-01.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(90,0,'cat-icon-02','cat-icon-02',6,'image/png',164,'icons/cat-icon-02.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(91,0,'cat-icon-03','cat-icon-03',6,'image/png',164,'icons/cat-icon-03.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(92,0,'cat-icon-04','cat-icon-04',6,'image/png',160,'icons/cat-icon-04.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(93,0,'cat-icon-05','cat-icon-05',6,'image/png',151,'icons/cat-icon-05.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(94,0,'cat-icon-06','cat-icon-06',6,'image/png',1665,'icons/cat-icon-06.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(95,0,'error','error',6,'image/png',3971,'icons/error.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(96,0,'fast-delivery','fast-delivery',6,'image/png',3347,'icons/fast-delivery.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(97,0,'hours','hours',6,'image/png',1034,'icons/hours.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(98,0,'lang-flag','lang-flag',6,'image/png',1602,'icons/lang-flag.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(99,0,'payment','payment',6,'image/png',800,'icons/payment.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(100,0,'product-det-1','product-det-1',6,'image/png',974,'icons/product-det-1.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(101,0,'product-det-2','product-det-2',6,'image/png',1080,'icons/product-det-2.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(102,0,'product-det-3','product-det-3',6,'image/png',735,'icons/product-det-3.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(103,0,'product-det-4','product-det-4',6,'image/png',1202,'icons/product-det-4.png','[]','2025-11-18 21:22:39','2025-11-18 21:22:39',NULL,'public'),(104,0,'support','support',6,'image/png',3574,'icons/support.png','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(105,0,'title-shape-02','title-shape-02',6,'image/jpeg',737,'icons/title-shape-02.jpg','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(106,0,'track-1','track-1',6,'image/png',339,'icons/track-1.png','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(107,0,'verified','verified',6,'image/png',2564,'icons/verified.png','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(108,0,'banner-1','banner-1',7,'image/jpeg',9766,'sliders/banner-1.jpg','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(109,0,'banner-2','banner-2',7,'image/jpeg',9766,'sliders/banner-2.jpg','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(110,0,'banner-3','banner-3',7,'image/jpeg',9766,'sliders/banner-3.jpg','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(111,0,'banner-slider-01','banner-slider-01',7,'image/jpeg',4081,'sliders/banner-slider-01.jpg','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(112,0,'banner-slider-02','banner-slider-02',7,'image/jpeg',4081,'sliders/banner-slider-02.jpg','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(113,0,'fasion-tag-01','fasion-tag-01',7,'image/png',2647,'sliders/fasion-tag-01.png','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(114,0,'fasion-tag-02','fasion-tag-02',7,'image/png',2675,'sliders/fasion-tag-02.png','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(115,0,'fasion-tag-03','fasion-tag-03',7,'image/png',2675,'sliders/fasion-tag-03.png','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(116,0,'slider-01','slider-01',7,'image/png',13507,'sliders/slider-01.png','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(117,0,'slider-02','slider-02',7,'image/png',13507,'sliders/slider-02.png','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(118,0,'slider-03','slider-03',7,'image/png',13507,'sliders/slider-03.png','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(119,0,'slider-04','slider-04',7,'image/png',11780,'sliders/slider-04.png','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(120,0,'slider-05-banner-1','slider-05-banner-1',7,'image/jpeg',3724,'sliders/slider-05-banner-1.jpg','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(121,0,'slider-05-banner-2','slider-05-banner-2',7,'image/jpeg',3724,'sliders/slider-05-banner-2.jpg','[]','2025-11-18 21:22:40','2025-11-18 21:22:40',NULL,'public'),(122,0,'slider-05-bg-1','slider-05-bg-1',7,'image/jpeg',11103,'sliders/slider-05-bg-1.jpg','[]','2025-11-18 21:22:41','2025-11-18 21:22:41',NULL,'public'),(123,0,'slider-05-bg-2','slider-05-bg-2',7,'image/jpeg',11103,'sliders/slider-05-bg-2.jpg','[]','2025-11-18 21:22:41','2025-11-18 21:22:41',NULL,'public'),(124,0,'slider-05-bg-3','slider-05-bg-3',7,'image/jpeg',11103,'sliders/slider-05-bg-3.jpg','[]','2025-11-18 21:22:41','2025-11-18 21:22:41',NULL,'public'),(125,0,'slider-05-bg-4','slider-05-bg-4',7,'image/jpeg',11103,'sliders/slider-05-bg-4.jpg','[]','2025-11-18 21:22:41','2025-11-18 21:22:41',NULL,'public'),(126,0,'slider-05','slider-05',7,'image/png',11780,'sliders/slider-05.png','[]','2025-11-18 21:22:41','2025-11-18 21:22:41',NULL,'public'),(127,0,'slider-06','slider-06',7,'image/png',11780,'sliders/slider-06.png','[]','2025-11-18 21:22:41','2025-11-18 21:22:41',NULL,'public'),(128,0,'slider-bg-04','slider-bg-04',7,'image/png',7941,'sliders/slider-bg-04.png','[]','2025-11-18 21:22:41','2025-11-18 21:22:41',NULL,'public'),(129,0,'slider-bg-05','slider-bg-05',7,'image/png',7941,'sliders/slider-bg-05.png','[]','2025-11-18 21:22:41','2025-11-18 21:22:41',NULL,'public'),(130,0,'slider-bg-06','slider-bg-06',7,'image/png',7941,'sliders/slider-bg-06.png','[]','2025-11-18 21:22:41','2025-11-18 21:22:41',NULL,'public'),(131,0,'video-bg-01','video-bg-01',7,'image/jpeg',14217,'sliders/video-bg-01.jpg','[]','2025-11-18 21:22:41','2025-11-18 21:22:41',NULL,'public'),(132,0,'brand-01','brand-01',8,'image/png',630,'brands/brand-01.png','[]','2025-11-18 21:22:41','2025-11-18 21:22:41',NULL,'public'),(133,0,'brand-02','brand-02',8,'image/png',630,'brands/brand-02.png','[]','2025-11-18 21:22:41','2025-11-18 21:22:41',NULL,'public'),(134,0,'brand-03','brand-03',8,'image/png',630,'brands/brand-03.png','[]','2025-11-18 21:22:41','2025-11-18 21:22:41',NULL,'public'),(135,0,'brand-04','brand-04',8,'image/png',630,'brands/brand-04.png','[]','2025-11-18 21:22:41','2025-11-18 21:22:41',NULL,'public'),(136,0,'brand-05','brand-05',8,'image/png',630,'brands/brand-05.png','[]','2025-11-18 21:22:41','2025-11-18 21:22:41',NULL,'public'),(137,0,'brand-06','brand-06',8,'image/png',630,'brands/brand-06.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(138,0,'brand-w-01','brand-w-01',8,'image/png',630,'brands/brand-w-01.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(139,0,'brand-w-02','brand-w-02',8,'image/png',630,'brands/brand-w-02.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(140,0,'brand-w-03','brand-w-03',8,'image/png',630,'brands/brand-w-03.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(141,0,'brand-w-04','brand-w-04',8,'image/png',630,'brands/brand-w-04.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(142,0,'brand-w-05','brand-w-05',8,'image/png',630,'brands/brand-w-05.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(143,0,'brand-w-06','brand-w-06',8,'image/png',630,'brands/brand-w-06.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(144,0,'pla-brand-01','pla-brand-01',8,'image/png',630,'brands/pla-brand-01.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(145,0,'pla-brand-02','pla-brand-02',8,'image/png',630,'brands/pla-brand-02.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(146,0,'pla-brand-03','pla-brand-03',8,'image/png',630,'brands/pla-brand-03.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(147,0,'pla-brand-04','pla-brand-04',8,'image/png',630,'brands/pla-brand-04.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(148,0,'pla-brand-05','pla-brand-05',8,'image/png',630,'brands/pla-brand-05.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(149,0,'pla-brand-06','pla-brand-06',8,'image/png',630,'brands/pla-brand-06.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(150,0,'feature-icon-01','feature-icon-01',9,'image/png',2082,'features/feature-icon-01.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(151,0,'feature-icon-02','feature-icon-02',9,'image/png',1941,'features/feature-icon-02.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(152,0,'feature-icon-03','feature-icon-03',9,'image/png',2535,'features/feature-icon-03.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(153,0,'feature-icon-04','feature-icon-04',9,'image/png',1158,'features/feature-icon-04.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(154,0,'feature-icon-05','feature-icon-05',9,'image/png',1887,'features/feature-icon-05.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(155,0,'feature-icon-06','feature-icon-06',9,'image/png',1666,'features/feature-icon-06.png','[]','2025-11-18 21:22:42','2025-11-18 21:22:42',NULL,'public'),(156,0,'pla-product-01','pla-product-01',10,'image/jpeg',9803,'products/pla-product-01.jpg','[]','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL,'public'),(157,0,'pla-product-02','pla-product-02',10,'image/jpeg',9803,'products/pla-product-02.jpg','[]','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL,'public'),(158,0,'pla-product-03','pla-product-03',10,'image/jpeg',9803,'products/pla-product-03.jpg','[]','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL,'public'),(159,0,'pla-product-04','pla-product-04',10,'image/jpeg',9803,'products/pla-product-04.jpg','[]','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL,'public'),(160,0,'product-1','product-1',10,'image/jpeg',9803,'products/product-1.jpg','[]','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL,'public'),(161,0,'product-10','product-10',10,'image/jpeg',9803,'products/product-10.jpg','[]','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL,'public'),(162,0,'product-11','product-11',10,'image/jpeg',9803,'products/product-11.jpg','[]','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL,'public'),(163,0,'product-12','product-12',10,'image/jpeg',9803,'products/product-12.jpg','[]','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL,'public'),(164,0,'product-13','product-13',10,'image/jpeg',9803,'products/product-13.jpg','[]','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL,'public'),(165,0,'product-14','product-14',10,'image/jpeg',9803,'products/product-14.jpg','[]','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL,'public'),(166,0,'product-15','product-15',10,'image/jpeg',9803,'products/product-15.jpg','[]','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL,'public'),(167,0,'product-16','product-16',10,'image/jpeg',9803,'products/product-16.jpg','[]','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL,'public'),(168,0,'product-17','product-17',10,'image/jpeg',9803,'products/product-17.jpg','[]','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL,'public'),(169,0,'product-18','product-18',10,'image/jpeg',9803,'products/product-18.jpg','[]','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL,'public'),(170,0,'product-19','product-19',10,'image/jpeg',9803,'products/product-19.jpg','[]','2025-11-18 21:22:43','2025-11-18 21:22:43',NULL,'public'),(171,0,'product-2','product-2',10,'image/jpeg',9803,'products/product-2.jpg','[]','2025-11-18 21:22:44','2025-11-18 21:22:44',NULL,'public'),(172,0,'product-20','product-20',10,'image/jpeg',9803,'products/product-20.jpg','[]','2025-11-18 21:22:44','2025-11-18 21:22:44',NULL,'public'),(173,0,'product-21','product-21',10,'image/jpeg',9803,'products/product-21.jpg','[]','2025-11-18 21:22:44','2025-11-18 21:22:44',NULL,'public'),(174,0,'product-22','product-22',10,'image/jpeg',9803,'products/product-22.jpg','[]','2025-11-18 21:22:44','2025-11-18 21:22:44',NULL,'public'),(175,0,'product-23','product-23',10,'image/jpeg',9803,'products/product-23.jpg','[]','2025-11-18 21:22:44','2025-11-18 21:22:44',NULL,'public'),(176,0,'product-24','product-24',10,'image/jpeg',9803,'products/product-24.jpg','[]','2025-11-18 21:22:44','2025-11-18 21:22:44',NULL,'public'),(177,0,'product-25','product-25',10,'image/jpeg',9803,'products/product-25.jpg','[]','2025-11-18 21:22:44','2025-11-18 21:22:44',NULL,'public'),(178,0,'product-26','product-26',10,'image/jpeg',9803,'products/product-26.jpg','[]','2025-11-18 21:22:44','2025-11-18 21:22:44',NULL,'public'),(179,0,'product-27','product-27',10,'image/jpeg',9803,'products/product-27.jpg','[]','2025-11-18 21:22:44','2025-11-18 21:22:44',NULL,'public'),(180,0,'product-28','product-28',10,'image/jpeg',9803,'products/product-28.jpg','[]','2025-11-18 21:22:44','2025-11-18 21:22:44',NULL,'public'),(181,0,'product-29','product-29',10,'image/jpeg',9803,'products/product-29.jpg','[]','2025-11-18 21:22:44','2025-11-18 21:22:44',NULL,'public'),(182,0,'product-3','product-3',10,'image/jpeg',9803,'products/product-3.jpg','[]','2025-11-18 21:22:44','2025-11-18 21:22:44',NULL,'public'),(183,0,'product-30','product-30',10,'image/jpeg',9803,'products/product-30.jpg','[]','2025-11-18 21:22:44','2025-11-18 21:22:44',NULL,'public'),(184,0,'product-31','product-31',10,'image/jpeg',9803,'products/product-31.jpg','[]','2025-11-18 21:22:44','2025-11-18 21:22:44',NULL,'public'),(185,0,'product-32','product-32',10,'image/jpeg',9803,'products/product-32.jpg','[]','2025-11-18 21:22:44','2025-11-18 21:22:44',NULL,'public'),(186,0,'product-33','product-33',10,'image/jpeg',9803,'products/product-33.jpg','[]','2025-11-18 21:22:45','2025-11-18 21:22:45',NULL,'public'),(187,0,'product-34','product-34',10,'image/jpeg',9803,'products/product-34.jpg','[]','2025-11-18 21:22:45','2025-11-18 21:22:45',NULL,'public'),(188,0,'product-35','product-35',10,'image/jpeg',9803,'products/product-35.jpg','[]','2025-11-18 21:22:45','2025-11-18 21:22:45',NULL,'public'),(189,0,'product-36','product-36',10,'image/jpeg',9803,'products/product-36.jpg','[]','2025-11-18 21:22:45','2025-11-18 21:22:45',NULL,'public'),(190,0,'product-37','product-37',10,'image/jpeg',9803,'products/product-37.jpg','[]','2025-11-18 21:22:45','2025-11-18 21:22:45',NULL,'public'),(191,0,'product-38','product-38',10,'image/jpeg',9803,'products/product-38.jpg','[]','2025-11-18 21:22:45','2025-11-18 21:22:45',NULL,'public'),(192,0,'product-39','product-39',10,'image/jpeg',9803,'products/product-39.jpg','[]','2025-11-18 21:22:45','2025-11-18 21:22:45',NULL,'public'),(193,0,'product-4','product-4',10,'image/jpeg',9803,'products/product-4.jpg','[]','2025-11-18 21:22:45','2025-11-18 21:22:45',NULL,'public'),(194,0,'product-40','product-40',10,'image/jpeg',9803,'products/product-40.jpg','[]','2025-11-18 21:22:45','2025-11-18 21:22:45',NULL,'public'),(195,0,'product-41','product-41',10,'image/jpeg',9803,'products/product-41.jpg','[]','2025-11-18 21:22:45','2025-11-18 21:22:45',NULL,'public'),(196,0,'product-42','product-42',10,'image/jpeg',9803,'products/product-42.jpg','[]','2025-11-18 21:22:45','2025-11-18 21:22:45',NULL,'public'),(197,0,'product-43','product-43',10,'image/jpeg',9803,'products/product-43.jpg','[]','2025-11-18 21:22:45','2025-11-18 21:22:45',NULL,'public'),(198,0,'product-44','product-44',10,'image/jpeg',9803,'products/product-44.jpg','[]','2025-11-18 21:22:45','2025-11-18 21:22:45',NULL,'public'),(199,0,'product-45','product-45',10,'image/jpeg',9803,'products/product-45.jpg','[]','2025-11-18 21:22:45','2025-11-18 21:22:45',NULL,'public'),(200,0,'product-46','product-46',10,'image/jpeg',9803,'products/product-46.jpg','[]','2025-11-18 21:22:45','2025-11-18 21:22:45',NULL,'public'),(201,0,'product-47','product-47',10,'image/jpeg',9803,'products/product-47.jpg','[]','2025-11-18 21:22:45','2025-11-18 21:22:45',NULL,'public'),(202,0,'product-48','product-48',10,'image/jpeg',9803,'products/product-48.jpg','[]','2025-11-18 21:22:46','2025-11-18 21:22:46',NULL,'public'),(203,0,'product-49','product-49',10,'image/jpeg',9803,'products/product-49.jpg','[]','2025-11-18 21:22:46','2025-11-18 21:22:46',NULL,'public'),(204,0,'product-5','product-5',10,'image/jpeg',9803,'products/product-5.jpg','[]','2025-11-18 21:22:46','2025-11-18 21:22:46',NULL,'public'),(205,0,'product-50','product-50',10,'image/jpeg',9803,'products/product-50.jpg','[]','2025-11-18 21:22:46','2025-11-18 21:22:46',NULL,'public'),(206,0,'product-51','product-51',10,'image/jpeg',9803,'products/product-51.jpg','[]','2025-11-18 21:22:46','2025-11-18 21:22:46',NULL,'public'),(207,0,'product-52','product-52',10,'image/jpeg',9803,'products/product-52.jpg','[]','2025-11-18 21:22:46','2025-11-18 21:22:46',NULL,'public'),(208,0,'product-53','product-53',10,'image/jpeg',9803,'products/product-53.jpg','[]','2025-11-18 21:22:46','2025-11-18 21:22:46',NULL,'public'),(209,0,'product-54','product-54',10,'image/jpeg',9803,'products/product-54.jpg','[]','2025-11-18 21:22:46','2025-11-18 21:22:46',NULL,'public'),(210,0,'product-55','product-55',10,'image/jpeg',9803,'products/product-55.jpg','[]','2025-11-18 21:22:46','2025-11-18 21:22:46',NULL,'public'),(211,0,'product-56','product-56',10,'image/jpeg',9803,'products/product-56.jpg','[]','2025-11-18 21:22:46','2025-11-18 21:22:46',NULL,'public'),(212,0,'product-57','product-57',10,'image/jpeg',9803,'products/product-57.jpg','[]','2025-11-18 21:22:46','2025-11-18 21:22:46',NULL,'public'),(213,0,'product-58','product-58',10,'image/jpeg',9803,'products/product-58.jpg','[]','2025-11-18 21:22:46','2025-11-18 21:22:46',NULL,'public'),(214,0,'product-59','product-59',10,'image/jpeg',9803,'products/product-59.jpg','[]','2025-11-18 21:22:46','2025-11-18 21:22:46',NULL,'public'),(215,0,'product-6','product-6',10,'image/jpeg',9803,'products/product-6.jpg','[]','2025-11-18 21:22:46','2025-11-18 21:22:46',NULL,'public'),(216,0,'product-60','product-60',10,'image/jpeg',9803,'products/product-60.jpg','[]','2025-11-18 21:22:46','2025-11-18 21:22:46',NULL,'public'),(217,0,'product-61','product-61',10,'image/jpeg',9803,'products/product-61.jpg','[]','2025-11-18 21:22:47','2025-11-18 21:22:47',NULL,'public'),(218,0,'product-62','product-62',10,'image/jpeg',9803,'products/product-62.jpg','[]','2025-11-18 21:22:47','2025-11-18 21:22:47',NULL,'public'),(219,0,'product-63','product-63',10,'image/jpeg',9803,'products/product-63.jpg','[]','2025-11-18 21:22:47','2025-11-18 21:22:47',NULL,'public'),(220,0,'product-64','product-64',10,'image/jpeg',9803,'products/product-64.jpg','[]','2025-11-18 21:22:47','2025-11-18 21:22:47',NULL,'public'),(221,0,'product-65','product-65',10,'image/jpeg',9803,'products/product-65.jpg','[]','2025-11-18 21:22:47','2025-11-18 21:22:47',NULL,'public'),(222,0,'product-66','product-66',10,'image/jpeg',9803,'products/product-66.jpg','[]','2025-11-18 21:22:47','2025-11-18 21:22:47',NULL,'public'),(223,0,'product-67','product-67',10,'image/jpeg',9803,'products/product-67.jpg','[]','2025-11-18 21:22:47','2025-11-18 21:22:47',NULL,'public'),(224,0,'product-68','product-68',10,'image/jpeg',9803,'products/product-68.jpg','[]','2025-11-18 21:22:47','2025-11-18 21:22:47',NULL,'public'),(225,0,'product-69','product-69',10,'image/jpeg',9803,'products/product-69.jpg','[]','2025-11-18 21:22:47','2025-11-18 21:22:47',NULL,'public'),(226,0,'product-7','product-7',10,'image/jpeg',9803,'products/product-7.jpg','[]','2025-11-18 21:22:47','2025-11-18 21:22:47',NULL,'public'),(227,0,'product-70','product-70',10,'image/jpeg',9803,'products/product-70.jpg','[]','2025-11-18 21:22:47','2025-11-18 21:22:47',NULL,'public'),(228,0,'product-71','product-71',10,'image/jpeg',9803,'products/product-71.jpg','[]','2025-11-18 21:22:47','2025-11-18 21:22:47',NULL,'public'),(229,0,'product-72','product-72',10,'image/jpeg',9803,'products/product-72.jpg','[]','2025-11-18 21:22:47','2025-11-18 21:22:47',NULL,'public'),(230,0,'product-73','product-73',10,'image/jpeg',9803,'products/product-73.jpg','[]','2025-11-18 21:22:47','2025-11-18 21:22:47',NULL,'public'),(231,0,'product-74','product-74',10,'image/jpeg',9803,'products/product-74.jpg','[]','2025-11-18 21:22:47','2025-11-18 21:22:47',NULL,'public'),(232,0,'product-75','product-75',10,'image/jpeg',9803,'products/product-75.jpg','[]','2025-11-18 21:22:47','2025-11-18 21:22:47',NULL,'public'),(233,0,'product-76','product-76',10,'image/jpeg',9803,'products/product-76.jpg','[]','2025-11-18 21:22:48','2025-11-18 21:22:48',NULL,'public'),(234,0,'product-77','product-77',10,'image/jpeg',9803,'products/product-77.jpg','[]','2025-11-18 21:22:48','2025-11-18 21:22:48',NULL,'public'),(235,0,'product-78','product-78',10,'image/jpeg',9803,'products/product-78.jpg','[]','2025-11-18 21:22:48','2025-11-18 21:22:48',NULL,'public'),(236,0,'product-79','product-79',10,'image/jpeg',9803,'products/product-79.jpg','[]','2025-11-18 21:22:48','2025-11-18 21:22:48',NULL,'public'),(237,0,'product-8','product-8',10,'image/jpeg',9803,'products/product-8.jpg','[]','2025-11-18 21:22:48','2025-11-18 21:22:48',NULL,'public'),(238,0,'product-80','product-80',10,'image/jpeg',9803,'products/product-80.jpg','[]','2025-11-18 21:22:48','2025-11-18 21:22:48',NULL,'public'),(239,0,'product-81','product-81',10,'image/jpeg',9803,'products/product-81.jpg','[]','2025-11-18 21:22:48','2025-11-18 21:22:48',NULL,'public'),(240,0,'product-82','product-82',10,'image/jpeg',9803,'products/product-82.jpg','[]','2025-11-18 21:22:48','2025-11-18 21:22:48',NULL,'public'),(241,0,'product-83','product-83',10,'image/jpeg',9803,'products/product-83.jpg','[]','2025-11-18 21:22:48','2025-11-18 21:22:48',NULL,'public'),(242,0,'product-84','product-84',10,'image/jpeg',9803,'products/product-84.jpg','[]','2025-11-18 21:22:48','2025-11-18 21:22:48',NULL,'public'),(243,0,'product-85','product-85',10,'image/jpeg',9803,'products/product-85.jpg','[]','2025-11-18 21:22:48','2025-11-18 21:22:48',NULL,'public'),(244,0,'product-86','product-86',10,'image/jpeg',9803,'products/product-86.jpg','[]','2025-11-18 21:22:48','2025-11-18 21:22:48',NULL,'public'),(245,0,'product-87','product-87',10,'image/jpeg',9803,'products/product-87.jpg','[]','2025-11-18 21:22:48','2025-11-18 21:22:48',NULL,'public'),(246,0,'product-88','product-88',10,'image/jpeg',9803,'products/product-88.jpg','[]','2025-11-18 21:22:48','2025-11-18 21:22:48',NULL,'public'),(247,0,'product-89','product-89',10,'image/jpeg',9803,'products/product-89.jpg','[]','2025-11-18 21:22:48','2025-11-18 21:22:48',NULL,'public'),(248,0,'product-9','product-9',10,'image/jpeg',9803,'products/product-9.jpg','[]','2025-11-18 21:22:49','2025-11-18 21:22:49',NULL,'public'),(249,0,'product-90','product-90',10,'image/jpeg',9803,'products/product-90.jpg','[]','2025-11-18 21:22:49','2025-11-18 21:22:49',NULL,'public'),(250,0,'product-91','product-91',10,'image/jpeg',9803,'products/product-91.jpg','[]','2025-11-18 21:22:49','2025-11-18 21:22:49',NULL,'public'),(251,0,'product-92','product-92',10,'image/jpeg',9803,'products/product-92.jpg','[]','2025-11-18 21:22:49','2025-11-18 21:22:49',NULL,'public'),(252,0,'product-93','product-93',10,'image/jpeg',9803,'products/product-93.jpg','[]','2025-11-18 21:22:49','2025-11-18 21:22:49',NULL,'public'),(253,0,'product-94','product-94',10,'image/jpeg',9803,'products/product-94.jpg','[]','2025-11-18 21:22:49','2025-11-18 21:22:49',NULL,'public'),(254,0,'product-95','product-95',10,'image/jpeg',9803,'products/product-95.jpg','[]','2025-11-18 21:22:49','2025-11-18 21:22:49',NULL,'public'),(255,0,'1','1',11,'image/jpeg',9803,'customers/1.jpg','[]','2025-11-18 21:23:00','2025-11-18 21:23:00',NULL,'public'),(256,0,'10','10',11,'image/jpeg',9803,'customers/10.jpg','[]','2025-11-18 21:23:00','2025-11-18 21:23:00',NULL,'public'),(257,0,'2','2',11,'image/jpeg',9803,'customers/2.jpg','[]','2025-11-18 21:23:00','2025-11-18 21:23:00',NULL,'public'),(258,0,'3','3',11,'image/jpeg',9803,'customers/3.jpg','[]','2025-11-18 21:23:00','2025-11-18 21:23:00',NULL,'public'),(259,0,'4','4',11,'image/jpeg',9803,'customers/4.jpg','[]','2025-11-18 21:23:00','2025-11-18 21:23:00',NULL,'public'),(260,0,'5','5',11,'image/jpeg',9803,'customers/5.jpg','[]','2025-11-18 21:23:00','2025-11-18 21:23:00',NULL,'public'),(261,0,'6','6',11,'image/jpeg',9803,'customers/6.jpg','[]','2025-11-18 21:23:00','2025-11-18 21:23:00',NULL,'public'),(262,0,'7','7',11,'image/jpeg',9803,'customers/7.jpg','[]','2025-11-18 21:23:00','2025-11-18 21:23:00',NULL,'public'),(263,0,'8','8',11,'image/jpeg',9803,'customers/8.jpg','[]','2025-11-18 21:23:00','2025-11-18 21:23:00',NULL,'public'),(264,0,'9','9',11,'image/jpeg',9803,'customers/9.jpg','[]','2025-11-18 21:23:00','2025-11-18 21:23:00',NULL,'public'),(265,0,'1','1',12,'image/jpeg',9803,'galleries/1.jpg','[]','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL,'public'),(266,0,'2','2',12,'image/jpeg',9803,'galleries/2.jpg','[]','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL,'public'),(267,0,'3','3',12,'image/jpeg',9803,'galleries/3.jpg','[]','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL,'public'),(268,0,'4','4',12,'image/jpeg',9803,'galleries/4.jpg','[]','2025-11-18 21:23:05','2025-11-18 21:23:05',NULL,'public'),(269,0,'5','5',12,'image/jpeg',9803,'galleries/5.jpg','[]','2025-11-18 21:23:06','2025-11-18 21:23:06',NULL,'public'),(270,0,'6','6',12,'image/jpeg',9803,'galleries/6.jpg','[]','2025-11-18 21:23:06','2025-11-18 21:23:06',NULL,'public'),(278,0,'avatar-1','avatar-1',14,'image/png',674,'testimonials/avatar-1.png','[]','2025-11-18 21:23:06','2025-11-18 21:23:06',NULL,'public'),(279,0,'avatar-2','avatar-2',14,'image/png',674,'testimonials/avatar-2.png','[]','2025-11-18 21:23:06','2025-11-18 21:23:06',NULL,'public'),(280,0,'avatar-3','avatar-3',14,'image/png',674,'testimonials/avatar-3.png','[]','2025-11-18 21:23:06','2025-11-18 21:23:06',NULL,'public'),(281,0,'team-1','team-1',14,'image/jpeg',6202,'testimonials/team-1.jpg','[]','2025-11-18 21:23:06','2025-11-18 21:23:06',NULL,'public'),(282,0,'team-2','team-2',14,'image/jpeg',6202,'testimonials/team-2.jpg','[]','2025-11-18 21:23:06','2025-11-18 21:23:06',NULL,'public'),(283,0,'team-3','team-3',14,'image/jpeg',6202,'testimonials/team-3.jpg','[]','2025-11-18 21:23:06','2025-11-18 21:23:06',NULL,'public'),(284,0,'team-4','team-4',14,'image/jpeg',6202,'testimonials/team-4.jpg','[]','2025-11-18 21:23:06','2025-11-18 21:23:06',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'general',NULL,'general',0,'2025-11-18 21:22:33','2025-11-18 21:22:33',NULL),(2,0,'payments',NULL,'payments',0,'2025-11-18 21:22:34','2025-11-18 21:22:34',NULL),(3,0,'blog',NULL,'blog',0,'2025-11-18 21:22:34','2025-11-18 21:22:34',NULL),(4,0,'shop',NULL,'shop',0,'2025-11-18 21:22:36','2025-11-18 21:22:36',NULL),(5,0,'banners',NULL,'banners',0,'2025-11-18 21:22:37','2025-11-18 21:22:37',NULL),(6,0,'icons',NULL,'icons',0,'2025-11-18 21:22:39','2025-11-18 21:22:39',NULL),(7,0,'sliders',NULL,'sliders',0,'2025-11-18 21:22:40','2025-11-18 21:22:40',NULL),(8,0,'brands',NULL,'brands',0,'2025-11-18 21:22:41','2025-11-18 21:22:41',NULL),(9,0,'features',NULL,'features',0,'2025-11-18 21:22:42','2025-11-18 21:22:42',NULL),(10,0,'products',NULL,'products',0,'2025-11-18 21:22:43','2025-11-18 21:22:43',NULL),(11,0,'customers',NULL,'customers',0,'2025-11-18 21:22:59','2025-11-18 21:22:59',NULL),(12,0,'galleries',NULL,'galleries',0,'2025-11-18 21:23:05','2025-11-18 21:23:05',NULL),(14,0,'testimonials',NULL,'testimonials',0,'2025-11-18 21:23:06','2025-11-18 21:23:06',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-11-18 21:23:05','2025-11-18 21:23:05'),(2,2,'information','2025-11-18 21:23:05','2025-11-18 21:23:05'),(3,3,'my-account','2025-11-18 21:23:05','2025-11-18 21:23:05'),(4,4,'social-network','2025-11-18 21:23:05','2025-11-18 21:23:05');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',1,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(2,1,1,1,'Botble\\Page\\Models\\Page','/',NULL,0,'Wooden Home',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(3,1,1,2,'Botble\\Page\\Models\\Page','/fashion-home',NULL,1,'Fashion Home',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(4,1,1,3,'Botble\\Page\\Models\\Page','/furniture-home',NULL,2,'Furniture Home',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(5,1,1,4,'Botble\\Page\\Models\\Page','/cosmetics-home',NULL,3,'Cosmetics Home',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(6,1,1,5,'Botble\\Page\\Models\\Page','/food-grocery-home',NULL,4,'Food Grocery',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(7,1,0,NULL,NULL,'/',NULL,1,'Shop',NULL,'_self',1,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(8,1,7,NULL,NULL,'/products',NULL,0,'Shop Grid',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(9,1,7,NULL,NULL,'/products?layout=list',NULL,1,'Shop List',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(10,1,7,NULL,NULL,'',NULL,2,'Shop Detail',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(11,1,7,10,'Botble\\Page\\Models\\Page','/store-locator',NULL,3,'Shop Location',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(12,1,7,NULL,NULL,'/cart',NULL,4,'Cart',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(13,1,7,NULL,NULL,'/wishlist',NULL,5,'Wishlist',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(14,1,0,NULL,NULL,'/',NULL,2,'Pages',NULL,'_self',1,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(15,1,14,NULL,NULL,'/orders/tracking',NULL,0,'Order Tracking',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(16,1,14,7,'Botble\\Page\\Models\\Page','/about',NULL,1,'About',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(17,1,14,NULL,NULL,'/register',NULL,2,'Sign up',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(18,1,14,NULL,NULL,'/login',NULL,3,'Login',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(19,1,14,NULL,NULL,'/404',NULL,4,'404 / Error',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(20,1,14,9,'Botble\\Page\\Models\\Page','/coming-soon',NULL,5,'Coming soon',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(21,1,0,NULL,NULL,'/',NULL,3,'Blog',NULL,'_self',1,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(22,1,21,6,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Blog',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(23,1,21,NULL,NULL,'',NULL,1,'Blog Detail',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(24,1,0,8,'Botble\\Page\\Models\\Page','/contact',NULL,4,'Contact',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(25,2,0,NULL,NULL,'/',NULL,0,'Custom Service',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(26,2,0,11,'Botble\\Page\\Models\\Page','/faqs',NULL,1,'FAQs',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(27,2,0,NULL,NULL,'orders/tracking',NULL,2,'Order Tracking',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(28,2,0,8,'Botble\\Page\\Models\\Page','/contact',NULL,3,'Contact',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(29,2,0,NULL,NULL,'/',NULL,4,'Events',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(30,3,0,NULL,NULL,'/',NULL,0,'Delivery Information',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(31,3,0,NULL,NULL,'/',NULL,1,'Privacy Policy',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(32,3,0,NULL,NULL,'/',NULL,2,'Discount',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(33,3,0,NULL,NULL,'/',NULL,3,'Custom Service',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(34,3,0,NULL,NULL,'/',NULL,4,'Terms & Condition',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(35,4,0,NULL,NULL,'https://facebook.com','ti ti-brand-facebook',0,'Facebook',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(36,4,0,NULL,NULL,'https://dribbble.com','ti ti-brand-dribbble',1,'Dribble',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(37,4,0,NULL,NULL,'https://x.com','ti ti-brand-x',2,'X (Twitter)',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(38,4,0,NULL,NULL,'https://behance.com','ti ti-brand-behance',3,'Behance',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05'),(39,4,0,NULL,NULL,'https://youtube.com','ti ti-brand-youtube',4,'YouTube',NULL,'_self',0,'2025-11-18 21:23:05','2025-11-18 21:23:05');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-11-18 21:23:05','2025-11-18 21:23:05'),(2,'Information','information','published','2025-11-18 21:23:05','2025-11-18 21:23:05'),(3,'My Account','my-account','published','2025-11-18 21:23:05','2025-11-18 21:23:05'),(4,'Social Network','social-network','published','2025-11-18 21:23:05','2025-11-18 21:23:05');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'header_style','[\"collapsed\"]',1,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(2,'customize_footer','[\"custom\"]',2,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(3,'footer_background_color','[\"#040404\"]',2,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(4,'footer_text_color','[\"#fff\"]',2,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(5,'footer_text_muted_color','[\"#a0a0a0\"]',2,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(6,'footer_logo','[\"general\\/logo-white.png\"]',2,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(7,'footer_border_color','[\"#282828\"]',2,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(8,'footer_bottom_background_color','[\"#040404\"]',2,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(9,'customize_footer','[\"custom\"]',3,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(10,'footer_bottom_background_color','[\"#f8f8f8\"]',3,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(11,'header_style','[\"centered-logo\"]',4,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(12,'customize_footer','[\"custom\"]',4,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(13,'footer_background_color','[\"#F7EFEC\"]',4,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(14,'footer_bottom_background_color','[\"#F7EFEC\"]',4,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(15,'customize_footer','[\"custom\"]',5,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(16,'footer_background_color','[\"#F7EFEC\"]',5,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(17,'footer_bottom_background_color','[\"#F7EFEC\"]',5,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(18,'customize_footer','[\"custom\"]',7,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(19,'footer_background_color','[\"#040404\"]',7,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(20,'footer_text_color','[\"#fff\"]',7,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(21,'footer_text_muted_color','[\"#a0a0a0\"]',7,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(22,'footer_logo','[\"general\\/logo-white.png\"]',7,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(23,'footer_border_color','[\"#282828\"]',7,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(24,'footer_bottom_background_color','[\"#040404\"]',7,'Botble\\Page\\Models\\Page','2025-11-18 21:22:37','2025-11-18 21:22:37'),(25,'subtitle','[\"Accessories\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(26,'action_label','[\"Shop Now\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(27,'subtitle','[\"Accessories\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(28,'action_label','[\"Shop Now\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(29,'subtitle','[\"Accessories\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(30,'action_label','[\"Shop Now\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(31,'subtitle','[\"Winter\"]',4,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(32,'action_label','[\"Shop Now\"]',4,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(33,'subtitle','[\"Winter\"]',5,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(34,'action_label','[\"Shop Now\"]',5,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(35,'subtitle','[\"Winter\"]',6,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(36,'action_label','[\"Shop Now\"]',6,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(37,'subtitle','[null]',7,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(38,'action_label','[\"Shop Now\"]',7,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(39,'subtitle','[\"New Modern Stylist Fashionable Women\'s Wear holder\"]',8,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(40,'action_label','[\"Shop Now\"]',8,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(41,'subtitle','[\"New Modern Stylist Fashionable Women\'s Wear holder\"]',9,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(42,'action_label','[\"Shop Now\"]',9,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(43,'subtitle','[null]',10,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(44,'action_label','[\"Shop Now\"]',10,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(45,'subtitle','[null]',11,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(46,'action_label','[\"Shop Now\"]',11,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(47,'subtitle','[null]',12,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(48,'action_label','[\"Shop Now\"]',12,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(49,'subtitle','[null]',13,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(50,'action_label','[\"Shop Now\"]',13,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(51,'subtitle','[null]',14,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(52,'action_label','[\"Shop Now\"]',14,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(53,'subtitle','[null]',15,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(54,'action_label','[\"Shop Now\"]',15,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-11-18 21:22:41','2025-11-18 21:22:41'),(55,'subtitle','[\"Collection\"]',3,'Botble\\Ads\\Models\\Ads','2025-11-18 21:22:41','2025-11-18 21:22:41'),(56,'subtitle','[\"New Modern Stylist Fashionable <br> Women\'s Wear holder\"]',4,'Botble\\Ads\\Models\\Ads','2025-11-18 21:22:41','2025-11-18 21:22:41'),(57,'subtitle','[\"Furniture\"]',5,'Botble\\Ads\\Models\\Ads','2025-11-18 21:22:41','2025-11-18 21:22:41'),(58,'subtitle','[\"100 Added\"]',6,'Botble\\Ads\\Models\\Ads','2025-11-18 21:22:41','2025-11-18 21:22:41'),(59,'subtitle','[\"-60% Offer\"]',7,'Botble\\Ads\\Models\\Ads','2025-11-18 21:22:41','2025-11-18 21:22:41'),(60,'subtitle','[\"Best Bakery Products\"]',8,'Botble\\Ads\\Models\\Ads','2025-11-18 21:22:41','2025-11-18 21:22:41'),(61,'subtitle','[\"Best Bakery Products\"]',9,'Botble\\Ads\\Models\\Ads','2025-11-18 21:22:41','2025-11-18 21:22:41'),(62,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',1,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(63,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',2,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(64,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',3,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(65,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',4,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(66,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',5,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(67,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',6,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(68,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',7,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(69,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',8,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(70,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',9,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(71,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',10,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(72,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',11,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(73,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',12,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(74,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',13,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(75,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',14,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(76,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',15,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(77,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',16,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(78,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',17,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(79,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',18,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(80,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',19,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(81,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',20,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(82,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',21,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(83,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',22,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(84,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',23,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(85,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',24,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(86,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',25,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(87,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',26,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(88,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',27,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(89,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',28,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:49','2025-11-18 21:22:49'),(90,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',29,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(91,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',30,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(92,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',31,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(93,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',32,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(94,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',33,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(95,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',34,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(96,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',35,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(97,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',36,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(98,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',37,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(99,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',38,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(100,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',39,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(101,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',40,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(102,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',41,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(103,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',42,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(104,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',43,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(105,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',44,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(106,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',45,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(107,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',46,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(108,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',47,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(109,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',48,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(110,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',49,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(111,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',50,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(112,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',51,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(113,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',52,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(114,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',53,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(115,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',54,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(116,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',55,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(117,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',56,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(118,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',57,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(119,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',58,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(120,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',59,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(121,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',60,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(122,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',61,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(123,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',62,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(124,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',63,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(125,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',64,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(126,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',65,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(127,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',66,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(128,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',67,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(129,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',68,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(130,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',69,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(131,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',70,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(132,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',71,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(133,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',72,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(134,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',73,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(135,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',74,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(136,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',75,'Botble\\Ecommerce\\Models\\Product','2025-11-18 21:22:50','2025-11-18 21:22:50'),(137,'title','[\"Satisfied client testimonial\"]',1,'Botble\\Testimonial\\Models\\Testimonial','2025-11-18 21:23:06','2025-11-18 21:23:06'),(138,'star','[5]',1,'Botble\\Testimonial\\Models\\Testimonial','2025-11-18 21:23:06','2025-11-18 21:23:06'),(139,'title','[\"98% of residents recommend us\"]',2,'Botble\\Testimonial\\Models\\Testimonial','2025-11-18 21:23:06','2025-11-18 21:23:06'),(140,'star','[5]',2,'Botble\\Testimonial\\Models\\Testimonial','2025-11-18 21:23:06','2025-11-18 21:23:06'),(141,'title','[\"Our success stories\"]',3,'Botble\\Testimonial\\Models\\Testimonial','2025-11-18 21:23:06','2025-11-18 21:23:06'),(142,'star','[5]',3,'Botble\\Testimonial\\Models\\Testimonial','2025-11-18 21:23:06','2025-11-18 21:23:06'),(143,'title','[\"This is simply unbelievable\"]',4,'Botble\\Testimonial\\Models\\Testimonial','2025-11-18 21:23:06','2025-11-18 21:23:06'),(144,'star','[5]',4,'Botble\\Testimonial\\Models\\Testimonial','2025-11-18 21:23:06','2025-11-18 21:23:06');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2016_06_10_230148_create_acl_tables',1),(7,'2016_06_14_230857_create_menus_table',1),(8,'2016_06_28_221418_create_pages_table',1),(9,'2016_10_05_074239_create_setting_table',1),(10,'2016_11_28_032840_create_dashboard_widget_tables',1),(11,'2016_12_16_084601_create_widgets_table',1),(12,'2017_05_09_070343_create_media_tables',1),(13,'2017_11_03_070450_create_slug_table',1),(14,'2019_01_05_053554_create_jobs_table',1),(15,'2019_08_19_000000_create_failed_jobs_table',1),(16,'2019_12_14_000001_create_personal_access_tokens_table',1),(17,'2022_04_20_100851_add_index_to_media_table',1),(18,'2022_04_20_101046_add_index_to_menu_table',1),(19,'2022_07_10_034813_move_lang_folder_to_root',1),(20,'2022_08_04_051940_add_missing_column_expires_at',1),(21,'2022_09_01_000001_create_admin_notifications_tables',1),(22,'2022_10_14_024629_drop_column_is_featured',1),(23,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(24,'2022_12_02_093615_update_slug_index_columns',1),(25,'2023_01_30_024431_add_alt_to_media_table',1),(26,'2023_02_16_042611_drop_table_password_resets',1),(27,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(28,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(29,'2023_08_21_090810_make_page_content_nullable',1),(30,'2023_08_26_080444_fix_missing_copyright_widget',1),(31,'2023_09_07_025340_activate_mollie_and_sale_popup_plugin',1),(32,'2023_09_14_021936_update_index_for_slugs_table',1),(33,'2023_10_27_023808_update_page_metabox',1),(34,'2023_11_22_071805_migrate_header_messages_to_announcements_table',1),(35,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(36,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(37,'2024_03_25_000000_migrate_rename_shortcode_contact_box_to_contact_form',1),(38,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(39,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(40,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(41,'2024_07_12_100000_change_random_hash_for_media',1),(42,'2024_09_30_024515_create_sessions_table',1),(43,'2024_12_19_000001_create_device_tokens_table',1),(44,'2024_12_19_000002_create_push_notifications_table',1),(45,'2024_12_19_000003_create_push_notification_recipients_table',1),(46,'2024_12_30_000001_create_user_settings_table',1),(47,'2025_07_06_030754_add_phone_to_users_table',1),(48,'2025_07_31_add_performance_indexes_to_slugs_table',1),(49,'2025_10_29_100000_add_sessions_invalidated_at_to_users_table',1),(50,'2025_11_10_000000_cleanup_duplicate_widgets',1),(51,'2020_11_18_150916_ads_create_ads_table',2),(52,'2021_12_02_035301_add_ads_translations_table',2),(53,'2023_04_17_062645_add_open_in_new_tab',2),(54,'2023_11_07_023805_add_tablet_mobile_image',2),(55,'2024_04_01_043317_add_google_adsense_slot_id_to_ads_table',2),(56,'2025_04_21_000000_add_tablet_mobile_image_to_ads_translations_table',2),(57,'2024_04_27_100730_improve_analytics_setting',3),(58,'2023_08_11_060908_create_announcements_table',4),(59,'2025_02_11_153025_add_action_label_to_announcement_translations',4),(60,'2015_06_29_025744_create_audit_history',5),(61,'2023_11_14_033417_change_request_column_in_table_audit_histories',5),(62,'2025_05_05_000001_add_user_type_to_audit_histories_table',5),(63,'2025_11_07_000001_add_actor_type_to_audit_histories_table',5),(64,'2015_06_18_033822_create_blog_table',6),(65,'2021_02_16_092633_remove_default_value_for_author_type',6),(66,'2021_12_03_030600_create_blog_translations',6),(67,'2022_04_19_113923_add_index_to_table_posts',6),(68,'2023_08_29_074620_make_column_author_id_nullable',6),(69,'2024_07_30_091615_fix_order_column_in_categories_table',6),(70,'2025_01_06_033807_add_default_value_for_categories_author_type',6),(71,'2016_06_17_091537_create_contacts_table',7),(72,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',7),(73,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',7),(74,'2024_03_25_000001_update_captcha_settings_for_contact',7),(75,'2024_04_19_063914_create_custom_fields_table',7),(76,'2020_03_05_041139_create_ecommerce_tables',8),(77,'2021_01_01_044147_ecommerce_create_flash_sale_table',8),(78,'2021_01_17_082713_add_column_is_featured_to_product_collections_table',8),(79,'2021_01_18_024333_add_zip_code_into_table_customer_addresses',8),(80,'2021_02_18_073505_update_table_ec_reviews',8),(81,'2021_03_10_024419_add_column_confirmed_at_to_table_ec_customers',8),(82,'2021_03_10_025153_change_column_tax_amount',8),(83,'2021_03_20_033103_add_column_availability_to_table_ec_products',8),(84,'2021_04_28_074008_ecommerce_create_product_label_table',8),(85,'2021_05_31_173037_ecommerce_create_ec_products_translations',8),(86,'2021_08_17_105016_remove_column_currency_id_in_some_tables',8),(87,'2021_08_30_142128_add_images_column_to_ec_reviews_table',8),(88,'2021_10_04_030050_add_column_created_by_to_table_ec_products',8),(89,'2021_10_05_122616_add_status_column_to_ec_customers_table',8),(90,'2021_11_03_025806_nullable_phone_number_in_ec_customer_addresses',8),(91,'2021_11_23_071403_correct_languages_for_product_variations',8),(92,'2021_11_28_031808_add_product_tags_translations',8),(93,'2021_12_01_031123_add_featured_image_to_ec_products',8),(94,'2022_01_01_033107_update_table_ec_shipments',8),(95,'2022_02_16_042457_improve_product_attribute_sets',8),(96,'2022_03_22_075758_correct_product_name',8),(97,'2022_04_19_113334_add_index_to_ec_products',8),(98,'2022_04_28_144405_remove_unused_table',8),(99,'2022_05_05_115015_create_ec_customer_recently_viewed_products_table',8),(100,'2022_05_18_143720_add_index_to_table_ec_product_categories',8),(101,'2022_06_16_095633_add_index_to_some_tables',8),(102,'2022_06_30_035148_create_order_referrals_table',8),(103,'2022_07_24_153815_add_completed_at_to_ec_orders_table',8),(104,'2022_08_14_032836_create_ec_order_returns_table',8),(105,'2022_08_14_033554_create_ec_order_return_items_table',8),(106,'2022_08_15_040324_add_billing_address',8),(107,'2022_08_30_091114_support_digital_products_table',8),(108,'2022_09_13_095744_create_options_table',8),(109,'2022_09_13_104347_create_option_value_table',8),(110,'2022_10_05_163518_alter_table_ec_order_product',8),(111,'2022_10_12_041517_create_invoices_table',8),(112,'2022_10_12_142226_update_orders_table',8),(113,'2022_10_13_024916_update_table_order_returns',8),(114,'2022_10_21_030830_update_columns_in_ec_shipments_table',8),(115,'2022_10_28_021046_update_columns_in_ec_shipments_table',8),(116,'2022_11_16_034522_update_type_column_in_ec_shipping_rules_table',8),(117,'2022_11_19_041643_add_ec_tax_product_table',8),(118,'2022_12_12_063830_update_tax_defadult_in_ec_tax_products_table',8),(119,'2022_12_17_041532_fix_address_in_order_invoice',8),(120,'2022_12_26_070329_create_ec_product_views_table',8),(121,'2023_01_04_033051_fix_product_categories',8),(122,'2023_01_09_050400_add_ec_global_options_translations_table',8),(123,'2023_01_10_093754_add_missing_option_value_id',8),(124,'2023_01_17_082713_add_column_barcode_and_cost_per_item_to_product_table',8),(125,'2023_01_26_021854_add_ec_customer_used_coupons_table',8),(126,'2023_02_08_015900_update_options_column_in_ec_order_product_table',8),(127,'2023_02_27_095752_remove_duplicate_reviews',8),(128,'2023_03_20_115757_add_user_type_column_to_ec_shipment_histories_table',8),(129,'2023_04_21_082427_create_ec_product_categorizables_table',8),(130,'2023_05_03_011331_add_missing_column_price_into_invoice_items_table',8),(131,'2023_05_17_025812_fix_invoice_issue',8),(132,'2023_05_26_073140_move_option_make_phone_field_optional_at_checkout_page_to_mandatory_fields',8),(133,'2023_05_27_144611_fix_exchange_rate_setting',8),(134,'2023_06_22_084331_add_generate_license_code_to_ec_products_table',8),(135,'2023_06_30_042512_create_ec_order_tax_information_table',8),(136,'2023_07_14_022724_remove_column_id_from_ec_product_collection_products',8),(137,'2023_08_09_012940_remove_column_status_in_ec_product_attributes',8),(138,'2023_08_15_064505_create_ec_tax_rules_table',8),(139,'2023_08_21_021819_make_column_address_in_ec_customer_addresses_nullable',8),(140,'2023_08_22_094114_drop_unique_for_barcode',8),(141,'2023_08_30_031811_add_apply_via_url_column_to_ec_discounts_table',8),(142,'2023_09_07_094312_add_index_to_product_sku_and_translations',8),(143,'2023_09_19_024955_create_discount_product_categories_table',8),(144,'2023_10_17_070728_add_icon_and_icon_image_to_product_categories_table',8),(145,'2023_11_22_154643_add_unique_in_table_ec_products_variations',8),(146,'2023_11_27_032313_add_price_columns_to_ec_product_cross_sale_relations_table',8),(147,'2023_12_06_023945_add_display_on_checkout_column_to_ec_discounts_table',8),(148,'2023_12_25_040604_ec_create_review_replies_table',8),(149,'2023_12_26_090340_add_private_notes_column_to_ec_customers_table',8),(150,'2024_01_16_070706_fix_translation_tables',8),(151,'2024_01_23_075227_add_proof_file_to_ec_orders_table',8),(152,'2024_03_26_041531_add_cancel_reason_to_ec_orders_table',8),(153,'2024_03_27_062402_create_ec_customer_deletion_requests_table',8),(154,'2024_03_29_042242_migrate_old_captcha_settings',8),(155,'2024_03_29_093946_create_ec_order_return_histories_table',8),(156,'2024_04_01_063523_add_customer_columns_to_ec_reviews_table',8),(157,'2024_04_15_092654_migrate_ecommerce_google_tag_manager_code_setting',8),(158,'2024_04_16_035713_add_min_max_order_quantity_columns_to_products_table',8),(159,'2024_05_07_073153_improve_table_wishlist',8),(160,'2024_05_07_093703_add_missing_zip_code_into_table_store_locators',8),(161,'2024_05_15_021503_fix_invoice_path',8),(162,'2024_06_20_160724_create_ec_shared_wishlists_table',8),(163,'2024_06_28_025104_add_notify_attachment_updated_column_to_ec_products_table',8),(164,'2024_07_03_030900_add_downloaded_at_column_to_ec_order_product_table',8),(165,'2024_07_14_071826_make_customer_email_nullable',8),(166,'2024_07_15_104916_add_video_media_column_to_ec_products_table',8),(167,'2024_07_26_052530_add_percentage_to_tax_rules_table',8),(168,'2024_08_14_123028_add_customer_delivered_confirmed_at_column_to_ec_shipments_table',8),(169,'2024_08_19_132849_create_specification_tables',8),(170,'2024_09_07_060744_add_author_column_to_specification_tables',8),(171,'2024_09_14_064023_add_can_use_with_flash_sale_column_to_ec_discounts_table',8),(172,'2024_09_25_073928_remove_wrong_product_slugs',8),(173,'2025_01_10_000000_fix_order_invoice_rounding_issues',8),(174,'2025_01_15_050230_migrate_old_theme_options',8),(175,'2025_01_15_optimize_products_export_index',8),(176,'2025_01_17_082713_correct_column_barcode_and_cost_per_item_to_product_table',8),(177,'2025_01_24_044641_migrate_old_country_data',8),(178,'2025_01_28_233602_add_private_notes_into_ec_orders_table',8),(179,'2025_02_13_021247_add_tax_translations',8),(180,'2025_02_24_152621_add_text_color_to_product_labels_table',8),(181,'2025_04_12_000001_add_payment_fee_to_ec_orders_table',8),(182,'2025_04_12_000002_add_payment_fee_to_ec_invoices_table',8),(183,'2025_05_05_092036_make_user_id_and_tax_amount_nullable',8),(184,'2025_05_15_082342_drop_email_unique_index_in_ec_customers_table',8),(185,'2025_06_07_081731_add_translations_for_specification_groups_and_tables',8),(186,'2025_06_17_091813_increase_note_in_shipments_table',8),(187,'2025_06_24_000001_create_ec_product_license_codes_table',8),(188,'2025_06_24_080427_add_license_code_type_to_products_table',8),(189,'2025_07_06_062402_create_ec_customer_deletion_requests_table',8),(190,'2025_07_07_161729_change_license_code_to_text_in_ec_product_license_codes_table',8),(191,'2025_07_08_162756_increase_license_code_column_size_in_ec_order_product_table',8),(192,'2025_07_09_000001_add_customer_address_fields_to_ec_invoices_table',8),(193,'2025_07_15_090809_create_ec_abandoned_carts_table',8),(194,'2025_07_24_120510_increase_barcode_column_length_in_ec_products_table',8),(195,'2025_07_31_133600_add_performance_indexes_to_ec_product_categories_table',8),(196,'2025_08_01_161205_optimize_product_variation_query_indexes',8),(197,'2025_08_08_145059_correct_tax_amount_in_order_and_invoice_tables',8),(198,'2025_09_05_025247_create_ec_product_specification_attribute_translations_table',8),(199,'2025_09_08_025516_add_variations_count_to_ec_products_table',8),(200,'2025_09_08_080248_add_slug_column_to_ec_product_categories_table',8),(201,'2025_09_08_080330_add_slug_column_to_ec_product_categories_translations_table',8),(202,'2025_09_08_080443_populate_slug_column_for_product_categories',8),(203,'2025_09_08_081216_add_slug_column_to_ec_products_table',8),(204,'2025_09_08_081237_add_slug_column_to_ec_products_translations_table',8),(205,'2025_09_08_081321_populate_slug_column_for_products',8),(206,'2025_09_10_073321_add_performance_indexes_to_ecommerce_tables',8),(207,'2025_09_18_093922_fix_tax_rounding_in_order_products_and_invoices',8),(208,'2025_09_21_030756_add_reviews_cache_to_ec_products_table',8),(209,'2025_09_30_090432_add_performance_indexes_to_ec_product_categories_table',8),(210,'2025_10_10_090331_add_number_format_style_to_ec_currencies_table',8),(211,'2025_10_10_092235_add_space_between_price_and_currency_to_ec_currencies_table',8),(212,'2025_10_11_074318_add_price_includes_tax_to_ec_products_table',8),(213,'2025_10_13_043527_generate_slugs_for_product_collections',8),(214,'2025_10_22_020518_add_verification_code_to_ec_customer_deletion_requests_table',8),(215,'2025_10_22_090000_remove_duplicate_order_addresses',8),(216,'2025_10_28_133220_add_unique_order_id_to_shipments_table',8),(217,'2025_10_28_134738_fix_order_payment_shipment_discount_data_issues',8),(218,'2025_11_05_032148_add_performance_indexes_to_ecommerce_tables',8),(219,'2025_11_10_100000_create_ec_order_metadata_table',8),(220,'2025_11_12_100000_improve_ec_customer_recently_viewed_products_table',8),(221,'2025_11_18_214150_add_covering_indexes_to_product_relation_tables',8),(222,'2018_07_09_221238_create_faq_table',9),(223,'2021_12_03_082134_create_faq_translations',9),(224,'2023_11_17_063408_add_description_column_to_faq_categories_table',9),(225,'2016_10_13_150201_create_galleries_table',10),(226,'2021_12_03_082953_create_gallery_translations',10),(227,'2022_04_30_034048_create_gallery_meta_translations_table',10),(228,'2023_08_29_075308_make_column_user_id_nullable',10),(229,'2016_10_03_032336_create_languages_table',11),(230,'2023_09_14_022423_add_index_for_language_table',11),(231,'2021_10_25_021023_fix-priority-load-for-language-advanced',12),(232,'2021_12_03_075608_create_page_translations',12),(233,'2023_07_06_011444_create_slug_translations_table',12),(234,'2019_11_18_061011_create_country_table',13),(235,'2021_12_03_084118_create_location_translations',13),(236,'2021_12_03_094518_migrate_old_location_data',13),(237,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',13),(238,'2022_01_16_085908_improve_plugin_location',13),(239,'2022_08_04_052122_delete_location_backup_tables',13),(240,'2023_04_23_061847_increase_state_translations_abbreviation_column',13),(241,'2023_07_26_041451_add_more_columns_to_location_table',13),(242,'2023_07_27_041451_add_more_columns_to_location_translation_table',13),(243,'2023_08_15_073307_drop_unique_in_states_cities_translations',13),(244,'2023_10_21_065016_make_state_id_in_table_cities_nullable',13),(245,'2024_08_17_094600_add_image_into_countries',13),(246,'2025_01_08_093652_add_zip_code_to_cities',13),(247,'2025_07_31_083459_add_indexes_for_location_search_performance',13),(248,'2017_10_24_154832_create_newsletter_table',14),(249,'2024_03_25_000001_update_captcha_settings_for_newsletter',14),(250,'2017_05_18_080441_create_payment_tables',15),(251,'2021_03_27_144913_add_customer_type_into_table_payments',15),(252,'2021_05_24_034720_make_column_currency_nullable',15),(253,'2021_08_09_161302_add_metadata_column_to_payments_table',15),(254,'2021_10_19_020859_update_metadata_field',15),(255,'2022_06_28_151901_activate_paypal_stripe_plugin',15),(256,'2022_07_07_153354_update_charge_id_in_table_payments',15),(257,'2024_07_04_083133_create_payment_logs_table',15),(258,'2025_04_12_000003_add_payment_fee_to_payments_table',15),(259,'2025_05_22_000001_add_payment_fee_type_to_settings_table',15),(260,'2017_07_11_140018_create_simple_slider_table',16),(261,'2025_04_08_040931_create_social_logins_table',17),(262,'2022_11_02_092723_team_create_team_table',18),(263,'2023_08_11_094574_update_team_table',18),(264,'2023_11_30_085354_add_missing_description_to_team',18),(265,'2024_10_02_030027_add_more_columns_to_teams_translations_table',18),(266,'2018_07_09_214610_create_testimonial_table',19),(267,'2021_12_03_083642_create_testimonials_translations',19),(268,'2016_10_07_193005_create_translations_table',20),(269,'2023_12_12_105220_drop_translations_table',20);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Wooden Home','[simple-slider key=\"slider-home-1\" style=\"wooden\" ads_1=\"IYHICPADQD5X\" ads_2=\"R4YAV9FECJUS\"][/simple-slider][product-categories title=&quot;Top &lt;span&gt;Categories&lt;/span&gt;&quot; category_ids=&quot;10,11,12,13,14,15&quot; style=&quot;wooden&quot; enable_lazy_loading=&quot;yes&quot;][/product-categories][products style=&quot;wooden&quot; title=&quot;Popular &lt;span&gt;Products&lt;/span&gt;&quot; limit=&quot;10&quot; enable_lazy_loading=&quot;yes&quot;][/products][deal-product flash_sale_id=\"1\" style=\"wooden\" enable_lazy_loading=\"yes\"][/deal-product][gallery title=\"ninico-shop\" limit=\"6\" subtitle=\"Follow On\" enable_lazy_loading=\"yes\"][/gallery]',1,NULL,'full-width',NULL,'published','2025-11-18 21:22:37','2025-11-18 21:22:37'),(2,'Fashion Home','[simple-slider key=\"slider-home-2\" style=\"fashion\"][/simple-slider][product-categories title=&quot;Top &lt;span&gt;Categories&lt;/span&gt;&quot; category_ids=&quot;1,2,3,4&quot; style=&quot;fashion&quot; enable_lazy_loading=&quot;yes&quot;][/product-categories][products style=&quot;fashion&quot; title=&quot;Popular &lt;span&gt;Products&lt;/span&gt;&quot; limit=&quot;10&quot; enable_lazy_loading=&quot;yes&quot;][/products][theme-ads key_1=\"QPTCBJBOJOSY\" key_2=\"T2VFLDYYIJEH\" enable_lazy_loading=\"yes\"][/theme-ads][featured-posts title=\"Popular Posts\" limit=\"4\" enable_lazy_loading=\"yes\"][/featured-posts][brands title=\"Happy Sponsors\" quantity=\"6\" name_1=\"Bustle\" image_1=\"brands/brand-01.png\" link_1=\"#\" name_2=\"Bazaar\" image_2=\"brands/brand-02.png\" link_2=\"#\" name_3=\"goop\" image_3=\"brands/brand-03.png\" link_3=\"#\" name_4=\"Brit + Co\" image_4=\"brands/brand-04.png\" link_4=\"#\" name_5=\"The Coveteur\" image_5=\"brands/brand-05.png\" link_5=\"#\" name_6=\"allure\" image_6=\"brands/brand-06.png\" link_6=\"#\" enable_lazy_loading=\"yes\"][/brands]',1,NULL,'full-width',NULL,'published','2025-11-18 21:22:37','2025-11-18 21:22:37'),(3,'Furniture Home','[simple-slider key=\"slider-furniture\" style=\"furniture\"][/simple-slider][services quantity=\"4\" title_1=\"Free shipping\" description_1=\"Free shipping on orders over.\" image_1=\"icons/box.png\" title_2=\"Free Returns\" description_2=\"30-days free return policy\" image_2=\"icons/car.png\" title_3=\"Secured Payments\" description_3=\"We accept all major credit cards\" image_3=\"icons/payment.png\" title_4=\"Customer Service\" description_4=\"Top notch customer service\" image_4=\"icons/hours.png\" enable_lazy_loading=\"yes\"][/services][products style=&quot;wooden&quot; title=&quot;Popular &lt;span&gt;Products&lt;/span&gt;&quot; limit=&quot;10&quot; enable_lazy_loading=&quot;yes&quot;][/products][theme-ads style=\"furniture\" key_1=\"JO7LLJHFH1RO\" key_2=\"L8GDJUBVD2TQ\" key_3=\"PXJPAXLOCVRS\" enable_lazy_loading=\"yes\"][/theme-ads][deal-product flash_sale_id=\"1\" enable_lazy_loading=\"yes\"][/deal-product][products-slide title=\"Top Sell In Month\" limit=\"5\" type=\"trending\" enable_lazy_loading=\"yes\"][/products-slide][brands title=\"Happy Sponsors\" background_color=\"#040404\" quantity=\"6\" name_1=\"Bustle\" image_1=\"brands/brand-w-01.png\" link_1=\"https://www.bustle.com\" name_2=\"Bazaar\" image_2=\"brands/brand-w-02.png\" link_2=\"https://www.harpersbazaar.com\" name_3=\"Goop\" image_3=\"brands/brand-w-03.png\" link_3=\"https://goop.com/\" name_4=\"Brit + Co\" image_4=\"brands/brand-w-04.png\" link_4=\"https://www.brit.co\" name_5=\"The Couture Club\" image_5=\"brands/brand-w-05.png\" link_5=\"https://www.thecoutureclub.com\" name_6=\"Allure\" image_6=\"brands/brand-w-06.png\" link_6=\"https://www.allure.com\" enable_lazy_loading=\"yes\"][/brands][featured-posts title=\"Blog & Insights\" limit=\"4\" type=\"popular\" url=\"/blog\" enable_lazy_loading=\"yes\"][/featured-posts]',1,NULL,'full-width',NULL,'published','2025-11-18 21:22:37','2025-11-18 21:22:37'),(4,'Cosmetics Home','[simple-slider key=\"slider-cosmetics\" style=\"cosmetics\"][/simple-slider][brands background_color=\"#F7EFEC\" quantity=\"6\" name_1=\"Bustle\" image_1=\"brands/pla-brand-01.png\" link_1=\"https://www.bustle.com\" name_2=\"Bazaar\" image_2=\"brands/pla-brand-02.png\" link_2=\"https://www.harpersbazaar.com\" name_3=\"Goop\" image_3=\"brands/pla-brand-03.png\" link_3=\"https://goop.com/\" name_4=\"Brit + Co\" image_4=\"brands/pla-brand-04.png\" link_4=\"https://www.brit.co\" name_5=\"The Couture Club\" image_5=\"brands/pla-brand-05.png\" link_5=\"https://www.thecoutureclub.com\" name_6=\"Allure\" image_6=\"brands/pla-brand-06.png\" link_6=\"https://www.allure.com\" enable_lazy_loading=\"yes\"][/brands][product-collections collection_ids=\"4,5,6,7\" enable_lazy_loading=\"yes\"][/product-collections][products style=&quot;wooden&quot; title=&quot;Popular &lt;span&gt;Products&lt;/span&gt;&quot; limit=&quot;4&quot; enable_lazy_loading=&quot;yes&quot;][/products][product-categories category_ids=\"10,11,12,13,14,15\" style=\"cosmetics\" enable_lazy_loading=\"yes\"][/product-categories][deal-product flash_sale_id=\"1\" style=\"cosmetics\" marque_text=\"Great Deal Of The Day Shop Now\" marque_highlight_text=\"Shop Now\" marque_highlight_url=\"/products\" highlight_background=\"blog/9.jpg\" enable_lazy_loading=\"yes\"][/deal-product][testimonials title=\"User Feedbacks\" limit=\"3\" enable_lazy_loading=\"yes\"][/testimonials][featured-posts title=\"Blog & Insights\" limit=\"4\" type=\"popular\" url=\"/blog\" enable_lazy_loading=\"yes\"][/featured-posts]',1,NULL,'full-width',NULL,'published','2025-11-18 21:22:37','2025-11-18 21:22:37'),(5,'Food Grocery Home','[simple-slider key=\"slider-grocery\" style=\"grocery\" ads_1=\"EMRCINED6AX9\" ads_2=\"JVMDAIB9HO2I\" background_image=\"banners/banner-bg-05.jpg\"][/simple-slider][services quantity=\"4\" title_1=\"Free shipping\" description_1=\"Free shipping on orders over.\" image_1=\"icons/box.png\" title_2=\"Free Returns\" description_2=\"30-days free return policy\" image_2=\"icons/car.png\" title_3=\"Secured Payments\" description_3=\"We accept all major credit cards\" image_3=\"icons/payment.png\" title_4=\"Customer Service\" description_4=\"Top notch customer service\" image_4=\"icons/hours.png\" enable_lazy_loading=\"yes\"][/services][products style=&quot;wooden&quot; title=&quot;Popular &lt;span&gt;Products&lt;/span&gt;&quot; limit=&quot;10&quot; enable_lazy_loading=&quot;yes&quot;][/products][deal-product flash_sale_id=\"1\" style=\"cosmetics\" enable_lazy_loading=\"yes\"][/deal-product][products-by-categories category_ids=\"2,3,6,11\" number_of_products=\"4\" enable_lazy_loading=\"yes\"][/products-by-categories][testimonials title=\"User Feedbacks\" limit=\"3\" background_color=\"#F7EFEC\" card_color=\"#FFFFFF\" enable_lazy_loading=\"yes\"][/testimonials][featured-posts title=\"Blog & Insights\" limit=\"4\" url=\"/blog\" enable_lazy_loading=\"yes\"][/featured-posts]',1,NULL,'full-width',NULL,'published','2025-11-18 21:22:37','2025-11-18 21:22:37'),(6,'Blog',NULL,1,NULL,NULL,NULL,'published','2025-11-18 21:22:37','2025-11-18 21:22:37'),(7,'About','[about image_1=\"banners/about-img-1.jpg\" image_2=\"banners/about-img-2.jpg\" logo=\"banners/about-img-3.png\" title=\"About Our Story\" subtitle=\"About Us\" story_text_1=\"Publish your eCommerce site quickly with our easy-to-use store builder— no coding required. Migrate your items from your point of sale system or turn your Instagram feed into a shopping site and start selling fast. Square Online works for all kinds of businesses—retail, restaurants, services without costly customization or add ons. Get orders to your customers in lots of ways by offering shipping, pickup, delivery, and even QR code ordering.\" story_text_2=\"Expand your reach and sell more using seamless integrations with Google, Instagram, Facebook, and more. Built- in SEO tools make it easy for shoppers to find your business on search engines. Get access to the entire suite of integrated Square solutions to help you run your business. Integration between Square Online and all Square point of sale systems makes inventory management easy. Subscribe to Square Marketing and easily send email promotions to your customers using the contact information.\" list_item_1=\"Orders go right to your restaurant point of sale, KDS, and kitchen\" list_item_url_1=\"#\" list_item_2=\"Provide in-person pickup, & delivery by professional couriers\" list_item_url_2=\"#\" list_item_3=\"Offer in-person diners self-serve, contactless ordering via QR codes.\" list_item_url_3=\"#\" enable_lazy_loading=\"yes\"][/about][team title=\"Meet With Team\" subtitle=\"Team\" team_ids=\"1,2,3,4\"][/team][features quantity=\"2\" title_1=\"Solutions that work together\" subtitle_1=\"Features #01\" description_1=\"Publish your eCommerce site quickly with our easy-to-use store builder— no coding required. Migrate your items from your point of sale system or turn your Instagram feed into a shopping site and start selling fast. Square Online works for all kinds of businesses—retail, restaurants, services.\" image_1=\"banners/about-banner-1.jpg\" button_label_1=\"Get In Touch\" button_url_1=\"#\" title_2=\"All kinds of payments securely\" subtitle_2=\"Features #02\" description_2=\"Publish your eCommerce site quickly with our easy-to-use store builder— no coding required. Migrate your items from your point of sale system or turn your Instagram feed into a shopping site and start selling fast. Square Online works for all kinds of businesses—retail, restaurants, services.\" image_2=\"banners/about-banner-2.jpg\" button_label_2=\"Contact With Us\" button_url_2=\"#\" enable_lazy_loading=\"yes\"][/features]',1,NULL,'default',NULL,'published','2025-11-18 21:22:37','2025-11-18 21:22:37'),(8,'Contact','[contact-box title=\"Get In Touch\" address=\"24/26 Strait Bargate, Boston, PE21, United Kingdom\" phone=\" +098 (905) 786 897 8\" email=\"ninico@example.com\" hours=\"10 am - 10 pm EST, 7 days a week\" show_contact_form=\"1\" button_label_1=\"Get Support On Call\" button_url_1=\"#\" button_icon_1=\"fa fa-headphones-alt\" button_label_2=\"Get Direction\" button_url_2=\"#\" button_icon_2=\"fa fa-map-marker-alt\"][/contact-box][google-map]24/26 Strait Bargate, Boston, PE21, United Kingdom[/google-map]',1,NULL,NULL,NULL,'published','2025-11-18 21:22:37','2025-11-18 21:22:37'),(9,'Coming soon','[coming-soon title=\"We are Coming Soon\" subtitle=\"Coming Soon!\" time=\"2025-10-24\" background_image=\"banners/coming-soon.jpg\" logo_style=\"general/logo-white.png\" show_subscribe_form=\"1\"][/coming-soon]',1,NULL,'blank',NULL,'published','2025-11-18 21:22:37','2025-11-18 21:22:37'),(10,'Store Locator','[shop-location quantity=\"4\" name_1=\"Baldwin Hills Crenshaw Plaza\" address_1=\"24/26 Strait Bargate, Boston, PE21, United Kingdom\" phone_1=\"+098 (905) 786 897 8\" hours_1=\"10 am - 10 pm EST, 7 days a week\" image_1=\"shop/location-1.png\" name_2=\"Ninico Hills Crenshaw Plaza\" address_2=\" 36/26 Strait Bargate, Boston, PE21, United Kingdom\" phone_2=\"+098 112 786 897 8\" hours_2=\"9 am - 10 pm EST, 5 days a week\" image_2=\"shop/location-2.png\" name_3=\"Vegas BGM Crenshaw Plaza\" address_3=\"40/26 Strait Bargate, Vegas, PE21, United Kingdom\" phone_3=\" +098 (905) 786 897 8\" hours_3=\"10 am - 10 pm EST, 7 days a week\" image_3=\"shop/location-3.png\" name_4=\"Bargate Cine Crenshaw Plaza\" address_4=\"38/26 Strait Bargate, Point, PE21, United Kingdom\" phone_4=\"6 - 146 - 389 - 5748\" hours_4=\"10 am - 10 pm EST, 7 days a week\" image_4=\"shop/location-4.png\" enable_lazy_loading=\"yes\"][/shop-location][google-map]New York, USA[/google-map]',1,NULL,NULL,NULL,'published','2025-11-18 21:22:37','2025-11-18 21:22:37'),(11,'FAQs','[faqs category_ids=\"1,2,3\"][/faqs]',1,NULL,NULL,NULL,'published','2025-11-18 21:22:37','2025-11-18 21:22:37');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (4,1),(3,1),(1,2),(4,2),(1,3),(3,3),(1,4),(2,5),(1,5),(3,6),(2,7),(2,8),(4,8),(1,9),(3,9),(2,10),(1,10),(4,11);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (5,1),(4,1),(2,1),(2,2),(4,2),(5,3),(2,3),(4,3),(1,4),(5,4),(2,4),(2,5),(1,5),(3,5),(1,6),(2,6),(3,6),(4,7),(5,7),(3,7),(4,8),(5,8),(2,9),(4,9),(3,10),(5,11),(4,11),(2,11);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP T