<?php

return [
    'name' => '위치',
    'all_states' => '모든 주/도',
    'abbreviation' => '약어',
    'abbreviation_placeholder' => 'E.g: CA',
    'import_type' => [
        'country' => '국가',
        'state' => '주/도',
        'city' => '도시',
    ],
    'enums' => [
        'import_type' => [
            'country' => '국가',
            'state' => '주/도',
            'city' => '도시',
        ],
    ],
    'export' => [
        'total' => '총 위치',
        'total_countries' => '총 국가',
        'total_states' => '총 주/도',
        'total_cities' => '총 도시',
        'description' => '국가, 주/도, 도시와 같은 위치 데이터를 내보냅니다.',
        'import_type' => '위치 유형',
        'all_types' => '모든 유형',
        'all_status' => '모든 상태',
        'use_chunked_export' => '청크 내보내기 사용',
        'use_chunked_export_helper' => '대규모 데이터셋의 메모리 문제를 방지하기 위해 데이터를 작은 배치로 처리합니다.',
        'optimize_memory' => '메모리 사용 최적화',
        'optimize_memory_helper' => '필요한 열만 로드하고 내보내기 중에 주기적으로 메모리를 해제합니다.',
        'use_streaming' => '스트리밍 모드 사용',
        'use_streaming_helper' => '모든 것을 메모리에 로드하지 않고 데이터를 파일로 직접 스트리밍합니다. 매우 큰 데이터셋에 권장됩니다.',
        'streaming_enabled_title' => '스트리밍 모드 활성화됨',
        'streaming_enabled_message' => '최적의 메모리 사용을 위해 데이터가 파일로 직접 스트리밍됩니다.',
        'chunk_size' => '청크 크기',
        'chunk_size_helper' => '각 배치에서 처리할 레코드 수입니다. 낮은 값은 메모리를 덜 사용하지만 더 오래 걸립니다.',
        'recommended_range' => '권장 범위',
        'optimal_range' => '최적',
        'too_small_slow' => '너무 작음 (느림)',
        'too_large_timeouts' => '너무 큼 (시간 초과 가능)',
        'range_large_export' => '150-300 레코드',
        'range_medium_export' => '200-500 레코드',
        'range_small_export' => '300-700 레코드',
        'large_dataset_title' => '대규모 데이터셋 감지됨',
        'large_dataset_message' => '더 나은 성능을 위해 최적화된 내보내기 모드가 자동으로 활성화되었습니다.',
        'large_dataset_warning_title' => '대규모 데이터셋 내보내기 권장 사항',
        'large_dataset_specific_message' => ':count개의 위치를 내보내고 있습니다. 최적의 성능을 위해 청크 내보내기와 함께 CSV 형식을 사용하는 것이 좋습니다.',
        'format_label' => '형식',
        'csv_recommended' => 'CSV (권장)',
        'chunk_label' => '청크 크기',
        'chunk_recommended' => '150-300 레코드',
        'time_label' => '예상 시간',
        'time_estimate' => '2-5분',
        'pro_tip' => '프로 팁:',
        'pro_tip_message' => '특정 데이터를 내보내기 위해 위치 유형(국가/주/도시)별로 필터링할 수 있습니다.',
        'medium_dataset_detected' => '중간 규모 데이터셋 감지됨',
        'medium_dataset_message' => ':count개의 위치를 내보내는 중입니다. 내보내기는 1-2분 이내에 완료됩니다.',
        'excel_disabled_warning' => 'Excel 형식은 대규모 데이터셋(:count+ 레코드)에는 권장되지 않습니다. 대신 CSV를 사용하세요.',
    ],
    'import' => [
        'description' => '사용 가능한 데이터에서 또는 CSV/Excel 파일을 업로드하여 위치 데이터를 쉽게 가져옵니다.',
        'rules' => [
            'name' => '위치 이름은 필수이며 120자를 초과할 수 없습니다.',
            'slug' => '위치 슬러그가 제공된 경우 120자를 초과할 수 없습니다.',
            'import_type' => '가져오기 유형은 필수이며 미리 정의된 값 중 하나여야 합니다.',
            'order' => '위치 순서가 제공된 경우 0에서 127 사이의 양의 정수여야 합니다.',
            'abbreviation' => '위치 약어가 제공된 경우 10자를 초과할 수 없습니다.',
            'status' => '위치 상태는 필수이며 미리 정의된 값 중 하나여야 합니다.',
            'country' => '가져오기 유형이 주/도 또는 도시인 경우 국가 필드는 필수입니다.',
            'state' => '가져오기 유형이 도시인 경우 주/도 필드는 필수입니다.',
            'nationality' => '위치 국적이 제공된 경우 120자를 초과할 수 없습니다.',
        ],
    ],
];
