<?php

return [
    'save_settings' => 'حفظ الإعدادات',
    'ecommerce' => 'التجارة الإلكترونية',
    'general' => [
        'name' => 'عام',
        'description' => 'عرض وتحديث إعداداتك العامة',
    ],
    'currency' => [
        'name' => 'العملات',
        'description' => 'عرض وتحديث إعدادات العملة',
        'currency_setting_description' => 'عرض وتحديث العملات المستخدمة في الموقع',
        'form' => [
            'enable_auto_detect_visitor_currency' => 'تمكين الكشف التلقائي عن عملة الزائر',
            'enable_auto_detect_visitor_currency_helper' => 'اكتشاف العملة المحلية للزائر تلقائيًا وعرض الأسعار بها بناءً على موقعه. يوفر هذا تجربة تسوق أكثر تخصيصًا.',
            'add_space_between_price_and_currency' => 'إضافة مسافة بين السعر والعملة',
            'add_space_between_price_and_currency_helper' => 'عند التمكين، يضيف مسافة بين قيمة السعر ورمز العملة (مثلاً، \"100 USD\" بدلاً من \"100USD\").',
            'thousands_separator' => 'فاصل الآلاف',
            'thousands_separator_helper' => 'اختر الحرف لفصل الآلاف في عرض السعر (مثلاً، 1,000 أو 1.000 أو 1 000).',
            'decimal_separator' => 'فاصل الأعشار',
            'decimal_separator_helper' => 'اختر الحرف لفصل القيم العشرية في الأسعار (مثلاً، 10.99 أو 10,99).',
            'separator_period' => 'نقطة (.)',
            'separator_comma' => 'فاصلة (,)',
            'separator_space' => 'مسافة ( )',
            'api_key' => 'مفتاح API لأسعار الصرف',
            'api_key_helper' => 'احصل على مفتاح API لأسعار الصرف من :link',
            'update_currency_rates' => 'تحديث أسعار الصرف',
            'use_exchange_rate_from_api' => 'استخدام سعر الصرف من API',
            'use_exchange_rate_from_api_helper' => 'تمكين تحديثات أسعار صرف العملات التلقائية من موفر API المُعد. يضمن هذا أن تكون أسعارك محدثة دائمًا بأسعار السوق الحالية.',
            'clear_cache_rates' => 'مسح ذاكرة التخزين المؤقت للأسعار',
            'auto_detect_visitor_currency_description' => 'يكتشف عملة الزائر بناءً على لغة المتصفح. سيؤثر على اختيار العملة الافتراضية.',
            'exchange_rate' => [
                'api_provider' => 'مزود API',
                'select' => '-- اختر --',
                'none' => 'لا شيء',
                'provider' => [
                    'api_layer' => 'طبقة API (API Layer)',
                    'open_exchange_rate' => 'أسعار الصرف المفتوحة (Open Exchange Rates)',
                ],
                'open_exchange_app_id' => 'معرف تطبيق Open Exchange Rates',
            ],
            'default_currency_warning' => 'للعملة الافتراضية، يجب أن يكون سعر الصرف 1.',
        ],
    ],
    'product' => [
        'name' => 'المنتجات',
        'description' => 'عرض وتحديث إعدادات منتجاتك',
        'product_settings' => 'إعدادات المنتج',
        'product_settings_description' => 'تكوين قواعد المنتج',
        'form' => [
            'show_number_of_products' => 'عرض عدد المنتجات في صفحة المنتج الواحد',
            'show_number_of_products_helper' => 'عرض العدد الإجمالي للمنتجات في صفحة تفاصيل المنتج.',
            'show_out_of_stock_products' => 'عرض المنتجات غير المتوفرة',
            'show_out_of_stock_products_helper' => 'إذا تم تمكينه، ستظهر المنتجات غير المتوفرة في صفحة قائمة المنتجات.',
            'how_to_display_product_variation_images' => 'كيفية عرض صور تنويعات المنتج',
            'how_to_display_product_variation_images_helper' => 'اختر ما إذا كنت تريد عرض صور التنويعات فقط أو تضمين صور التنويعات والمنتج الرئيسي معاً.',
            'only_variation_images' => 'صور التنويعات فقط',
            'variation_images_and_main_product_images' => 'صور التنويعات وصور المنتج الرئيسي',
            'enable_product_options' => 'تمكين خيارات المنتج',
            'enable_product_options_helper' => 'السماح للمنتجات بالحصول على خيارات قابلة للتخصيص مثل الحجم واللون وما إلى ذلك.',
            'is_enabled_cross_sale_products' => 'تمكين منتجات البيع المتقاطع',
            'is_enabled_cross_sale_products_helper' => 'عرض اقتراحات منتجات البيع المتقاطع لتشجيع المشتريات الإضافية.',
            'is_enabled_related_products' => 'تمكين المنتجات ذات الصلة',
            'is_enabled_related_products_helper' => 'عرض المنتجات ذات الصلة بناءً على الفئة، أو المحددة من قبل المدير في نموذج المنتج.',
            'related_products_source' => 'مصدر المنتجات ذات الصلة',
            'related_products_source_helper' => 'عندما لا يختار المدير منتجات ذات صلة في نموذج المنتج، عرض المنتجات ذات الصلة بناءً على هذا المصدر.',
            'related_products_source_category' => 'نفس الفئة',
            'related_products_source_brand' => 'نفس العلامة التجارية',
            'trending_products_period' => 'فترة المنتجات الرائجة',
            'trending_products_period_helper' => 'اختر الفترة الزمنية لحساب المنتجات الرائجة بناءً على عدد المشاهدات.',
            'trending_products_period_1_day' => 'آخر 24 ساعة',
            'trending_products_period_3_days' => 'آخر 3 أيام',
            'trending_products_period_7_days' => 'آخر 7 أيام (أسبوع واحد)',
            'trending_products_period_14_days' => 'آخر 14 يوم (أسبوعين)',
            'trending_products_period_30_days' => 'آخر 30 يوم (شهر واحد)',
            'trending_products_period_60_days' => 'آخر 60 يوم (شهرين)',
            'trending_products_period_90_days' => 'آخر 90 يوم (3 أشهر)',
            'auto_generate_product_sku' => 'إنشاء SKU تلقائياً عند إنشاء المنتج',
            'auto_generate_product_sku_helper' => 'إنشاء SKU فريد تلقائياً للمنتجات الجديدة بناءً على التنسيق أدناه.',
            'product_sku_format' => 'تنسيق SKU',
            'product_sku_format_helper' => 'يمكنك استخدام %s (حرف نصي واحد) أو %d (رقم واحد) في التنسيق لإنشاء نص عشوائي. مثال: SKU-%s%s%s-HN-%d%d%d',
            'enable_product_specification' => 'تمكين مواصفات المنتج',
            'enable_product_specification_help' => 'إذا تم تمكينه، ستظهر جدول مواصفات المنتج في صفحة تفاصيل المنتج.',
            'make_product_barcode_required' => 'جعل باركود المنتج مطلوباً',
            'make_product_barcode_required_helper' => 'إذا تم تمكينه، سيكون باركود المنتج مطلوباً عند إنشاء منتج.',
        ],
    ],
    'product_search' => [
        'name' => 'البحث عن المنتجات',
        'description' => 'عرض وتحديث إعدادات البحث عن المنتجات',
        'product_search_settings' => 'البحث عن المنتجات',
        'product_search_settings_description' => 'تكوين قواعد البحث عن المنتجات',
        'form' => [
            'search_for_an_exact_phrase' => 'البحث عن عبارة دقيقة',
            'search_products_by' => 'البحث عن المنتجات بواسطة:',
            'enable_filter_products_by_categories' => 'تمكين تصفية المنتجات حسب الفئات',
            'enable_filter_products_by_brands' => 'تمكين تصفية المنتجات حسب العلامات التجارية',
            'enable_filter_products_by_tags' => 'تمكين تصفية المنتجات حسب العلامات',
            'number_of_popular_tags_for_filter' => 'عدد العلامات الشائعة للتصفية',
            'number_of_popular_tags_for_filter_placeholder' => 'أدخل عدد العلامات الشائعة للعرض',
            'number_of_popular_tags_for_filter_helper' => 'تعيين الحد الأقصى لعدد العلامات الشائعة للعرض في المرشح. الافتراضي هو 10.',
            'enable_filter_products_by_attributes' => 'تمكين تصفية المنتجات حسب الخصائص',
            'enable_filter_products_by_price' => 'تمكين تصفية المنتجات حسب السعر',
            'max_product_price_for_filter' => 'أقصى سعر للمنتج للتصفية',
            'max_product_price_for_filter_placeholder' => 'إذا كان فارغاً أو صفر، سيحصل على أقصى سعر للمنتج من منتجاتك الحالية.',
            'max_product_price_for_filter_helper' => 'يمكنك تعيين سعر ثابت لهذا أو سيحصل ديناميكياً على أقصى سعر للمنتج من منتجاتك الحالية. حالياً هو :price.',
        ],
    ],
    'digital_product' => [
        'name' => 'المنتجات الرقمية',
        'description' => 'عرض وتحديث إعدادات المنتجات الرقمية',
        'digital_products_settings' => 'المنتجات الرقمية',
        'digital_products_settings_description' => 'تكوين قواعد المنتجات الرقمية',
        'form' => [
            'enable_support_digital_product' => 'هل تم تمكين دعم المنتجات الرقمية',
            'enable_support_digital_product_helper' => 'عند التمكين، سيدعم النظام بيع المنتجات الرقمية مثل البرامج والكتب الإلكترونية والموسيقى والمحتوى الآخر القابل للتحميل.',
            'allow_guest_checkout_for_digital_products' => 'السماح للضيوف بالدفع للمنتجات الرقمية',
            'allow_guest_checkout_for_digital_products_helper' => 'عند التمكين، يمكن للعملاء شراء المنتجات الرقمية دون إنشاء حساب. سيتلقون روابط التحميل عبر البريد الإلكتروني.',
            'disable_physical_product' => 'تعطيل المنتج المادي',
            'disable_physical_product_helper' => 'عند التمكين، سيبيع المتجر المنتجات الرقمية فقط. ستختفي خيارات المنتج المادي من نماذج المنتج والدفع.',
            'enable_license_codes_for_digital_products' => 'تمكين رموز الترخيص للمنتجات الرقمية',
            'auto_complete_digital_orders_after_payment' => 'إكمال الطلبات الرقمية تلقائياً بعد الدفع',
            'auto_complete_digital_orders_after_payment_helper' => 'عند التمكين، ستُكمل الطلبات التي تحتوي على منتجات رقمية فقط تلقائياً بمجرد استلام الدفع.',
            'enable_license_codes_for_digital_products_helper' => 'عند التمكين، يمكنك إضافة رموز ترخيص للمنتجات الرقمية. عند التعطيل، ستختفي وظائف رمز الترخيص من نماذج المنتج.',
            'hide_used_license_codes_in_product_form' => 'إخفاء رموز الترخيص المستخدمة في نموذج المنتج',
            'hide_used_license_codes_in_product_form_helper' => 'عند التمكين، ستختفي رموز الترخيص المستخدمة من جدول رموز الترخيص في نموذج تحرير المنتج. هذا يساعد في الحفاظ على واجهة نظيفة عندما يكون لديك العديد من الرموز المستخدمة.',
        ],
    ],
    'product_review' => [
        'name' => 'مراجعات المنتجات',
        'description' => 'عرض وتحديث إعدادات مراجعات منتجاتك',
        'form' => [
            'enable_review' => 'تمكين مراجعات المنتجات',
            'enable_review_help' => 'السماح للعملاء بترك مراجعات وتقييمات على المنتجات. عند التعطيل، ستختفي جميع ميزات المراجعة من المتجر.',
            'allow_customer_upload_image_in_review' => 'السماح للعملاء برفع الصور في المراجعات',
            'allow_customer_upload_image_in_review_help' => 'عند التعطيل، لا يمكن للعملاء رفع الصور عند تقديم المراجعات',
            'review' => [
                'max_file_size' => 'الحد الأقصى لحجم ملف المراجعة (ميجابايت)',
                'max_file_number' => 'الحد الأقصى لعدد ملفات المراجعة',
            ],
            'only_allow_customers_purchased_to_review' => 'فقط العملاء الذين اشتروا المنتج يمكنهم مراجعة المنتج',
            'review_need_to_be_approved' => 'المراجعة تحتاج إلى موافقة قبل الظهور في صفحة المنتج',
            'show_customer_full_name' => 'عرض الاسم الكامل للعميل',
            'show_customer_full_name_help' => 'إذا لم يتم تحديده، سيختفي اسم العميل المراجع ويُستبدل بنجوم (***)',
            'hide_rating_when_no_reviews' => 'إخفاء التقييم عندما لا توجد مراجعات',
            'hide_rating_when_no_reviews_help' => 'عند التمكين، ستختفي تقييمات المنتج في قوائم المنتجات وصفحات تفاصيل المنتج عندما لا يحتوي المنتج على مراجعات',
            'display_uploaded_customer_review_images_list' => 'عرض قسم "صور من العملاء"',
            'display_uploaded_customer_review_images_list_help' => 'عند التمكين، يعرض معرض لجميع الصور المرفوعة من العملاء في أعلى قسم المراجعات',
        ],
    ],
    'shopping' => [
        'name' => 'التسوق',
        'description' => 'عرض وتحديث إعدادات التسوق الخاصة بك',
        'general_setting' => 'الإعدادات العامة',
        'return_settings' => 'إعدادات الإرجاع',
        'return_settings_description' => 'تكوين قواعد إعدادات الإرجاع',
        'form' => [
            'enable_cart' => 'تمكين سلة التسوق',
            'enable_cart_helper' => 'إذا تم تعطيلها، ستُزال زر السلة، مما يحول موقعك إلى عرض كتالوج فقط.',
            'enable_wishlist' => 'تمكين قائمة الأمنيات',
            'enable_wishlist_helper' => 'إذا تم تعطيلها، ستُزال زر قائمة الأمنيات من الموقع.',
            'enable_wishlist_sharing' => 'تمكين مشاركة قائمة الأمنيات',
            'shared_wishlist_lifetime' => 'مدة قائمة الأمنيات المشتركة (أيام)',
            'shared_wishlist_lifetime_helper' => 'مدة قائمة الأمنيات المشتركة بالأيام. بعد هذا الوقت، ستُحذف قائمة الأمنيات المشتركة.',
            'enable_compare' => 'تمكين المقارنة',
            'enable_compare_helper' => 'إذا تم تعطيلها، ستُزال زر المقارنة من الموقع.',
            'enable_order_tracking' => 'تمكين تتبع الطلب',
            'enable_order_tracking_helper' => 'يمكن للعملاء تتبع طلباتهم عن طريق إدخال رمز الطلب والبريد الإلكتروني/الهاتف على :url',
            'order_tracking_method' => 'طريقة تتبع الطلب',
            'order_tracking_method_helper' => 'اختر كيف سيتتبع العملاء طلباتهم: باستخدام معرف الطلب + البريد الإلكتروني أو معرف الطلب + رقم الهاتف.',
            'order_tracking_method_email' => 'معرف الطلب + البريد الإلكتروني',
            'order_tracking_method_phone' => 'معرف الطلب + رقم الهاتف',
            'enable_quick_buy_button' => 'تمكين زر الشراء السريع',
            'enable_quick_buy_button_helper' => 'سيعرض زر "اشتري الآن" في قائمة المنتجات وصفحة التفاصيل. عندما ينقر العملاء على هذا الزر، سيُضاف المنتج إلى السلة وسيُعاد توجيههم إلى صفحة السلة/الدفع.',
            'enable_order_auto_confirmed' => 'تأكيد الطلب تلقائياً',
            'enable_order_auto_confirmed_helper' => 'إذا تم تمكينه، سيُؤكد الطلب تلقائياً بعد أن يضع العميل طلباً.',
            'quick_buy_target' => 'صفحة هدف الشراء السريع',
            'checkout_page' => 'صفحة الدفع',
            'cart_page' => 'صفحة السلة',
            'cart_destroy_on_logout' => 'تدمير السلة عند تسجيل الخروج',
            'cart_destroy_on_logout_helper' => 'ستُدمر السلة عندما يسجل العميل الخروج.',
            'hide_product_price' => 'إخفاء سعر المنتج',
            'hide_product_price_helper' => 'هذا الخيار يعمل فقط إذا عطلت سلة التسوق، مما يحول موقعك إلى عرض كتالوج فقط. إذا تم تمكينه، سيختفي سعر المنتج. مفيد عندما تريد إخفاء السعر وتتطلب من العملاء التواصل معك للسعر.',
            'enable_payment_proof' => 'تمكين رفع إثبات الدفع',
            'enable_payment_proof_helper' => 'السماح للعملاء برفع إثبات الدفع لطلباتهم. مفيد لطرق الدفع اليدوية.',
            'enable_guest_payment_proof' => 'السماح للعملاء الضيوف برفع إثبات الدفع',
            'enable_guest_payment_proof_helper' => 'عند التمكين، يمكن للعملاء الضيوف رفع إثبات الدفع باستخدام رمز طلبهم دون تسجيل الدخول. سيتلقون رابط الرفع في بريد تأكيد الطلب الإلكتروني.',
            'payment_proof_payment_methods' => 'طرق الدفع التي تتطلب إثبات الدفع',
            'payment_proof_payment_methods_helper' => 'حدد طرق الدفع التي يجب أن تسمح للعملاء بتحميل إثبات الدفع. يستخدم عادةً لطرق الدفع اليدوية مثل الدفع عند الاستلام والتحويل البنكي.',
        ],
    ],
    'checkout' => [
        'name' => 'الدفع',
        'panel_description' => 'عرض وتحديث إعدادات الدفع',
        'description' => 'تكوين قواعد إعدادات الدفع',
        'form' => [
            'display_bank_info_at_the_checkout_success_page' => 'عرض معلومات البنك في صفحة نجاح الدفع',
            'mandatory_form_fields_at_checkout' => 'الحقول الإجبارية في صفحة الدفع:',
            'mandatory_form_fields_at_checkout_helper' => 'اختر الحقول المطلوبة أثناء الدفع. يجب على العملاء ملء هذه الحقول لإكمال طلبهم.',
            'hide_form_fields_at_checkout' => 'إخفاء حقول العميل في صفحة الدفع:',
            'hide_form_fields_at_checkout_helper' => 'اختر الحقول التي يجب إخفاؤها في صفحة الدفع. لن تكون هذه الحقول مرئية للعملاء.',
            'load_countries_states_cities_from_location_plugin' => 'تحميل البلدان والولايات والمدن من مكون الموقع',
            'load_countries_states_cities_from_location_plugin_placeholder' => 'بعد تغيير هذا الخيار، تحتاج إلى تحديث جميع العناوين مرة أخرى. يجب تعيينه مرة واحدة.',
            'load_countries_states_cities_from_location_plugin_placeholder_2' => 'ثم تحتاج إلى الذهاب إلى الأدوات -> استيراد/تصدير البيانات لاستيراد بيانات الموقع.',
            'minimum_order_amount' => 'الحد الأدنى لمبلغ الطلب لتقديم طلب (:currency).',
            'minimum_order_amount_helper' => 'تعيين الحد الأدنى للمبلغ الإجمالي المطلوب لمعالجة الطلب. لن تُقبل الطلبات أقل من هذا المبلغ.',
            'zip_code_enabled' => 'تمكين الرمز البريدي',
            'zip_code_enabled_helper' => 'تمكين أو تعطيل حقل الرمز البريدي في نموذج عنوان الشحن.',
            'billing_address_enabled' => 'تمكين عنوان الفاتورة',
            'billing_address_enabled_helper' => 'السماح للعملاء بإدخال عنوان فاتورة منفصل يختلف عن عنوان الشحن.',
            'display_tax_fields_at_checkout_page' => 'عرض حقول معلومات الضريبة في صفحة الدفع',
            'display_tax_fields_at_checkout_page_helper' => 'إذا تم تمكينه، ستظهر حقول معلومات الضريبة لإدخال تفاصيل ضريبة الشركة لاستلام فاتورة.',
            'use_city_field_as_field_text' => 'استخدام حقل المدينة كحقل نص حر',
            'available_countries' => 'البلدان المتاحة',
            'all' => 'الكل',
            'all_helper_text' => 'إذا ألغيت تحديد جميع البلدان، فستنطبق على جميع البلدان.',
            'enable_guest_checkout' => 'تمكين دفع الضيوف',
            'enable_guest_checkout_helper' => 'إذا تم تمكينه، يمكن للعملاء تقديم طلب دون إنشاء حساب.',
            'recently_viewed' => [
                'enable' => 'تمكين المنتجات المشاهدة مؤخراً للعميل',
                'enable_helper' => 'تتبع وعرض المنتجات التي شاهدها العملاء مؤخراً. هذا يساعد العملاء في العثور بسهولة على المنتجات التي كانوا مهتمين بها.',
                'max' => 'الحد الأقصى لعدد المنتجات المشاهدة مؤخراً للعميل',
                'max_helper_text' => 'إذا تم تعيينه إلى 0، فلن يكون هناك حد.',
            ],
            'minimum_order_quantity' => 'الحد الأدنى لكمية الطلب',
            'minimum_order_quantity_helper' => 'الحد الأدنى للكمية لتقديم طلب. اتركه 0 إذا كنت لا تريد تعيينه.',
            'maximum_order_quantity' => 'الحد الأقصى لكمية الطلب',
            'maximum_order_quantity_helper' => 'الحد الأقصى للكمية لتقديم طلب. اتركه 0 إذا كنت لا تريد تعيينه.',
            'default_country_at_checkout_page' => 'البلد الافتراضي في صفحة الدفع',
            'default_country_at_checkout_page_placeholder' => 'اختر بلداً',
            'default_country_at_checkout_page_help' => 'إذا اخترت بلداً، سيُختار البلد افتراضياً في صفحة الدفع.',
            'checkout_product_quantity_editable' => 'السماح للعملاء بتغيير كمية المنتج في صفحة الدفع',
            'checkout_product_quantity_editable_helper' => 'عند التمكين، يمكن للعملاء تعديل كمية المنتجات مباشرة في صفحة الدفع دون العودة إلى السلة.',
            'show_terms_and_policy_checkbox' => 'عرض مربع اختيار الشروط والسياسة',
            'show_terms_and_policy_checkbox_helper' => 'إذا تم تمكينه، يجب على العملاء الموافقة على الشروط والسياسة قبل تقديم الطلب. يرجى إعداد رابط الشروط وسياسة الخصوصية في المظهر -> خيارات القالب أولاً.',
            'terms_and_policy_checkbox_checked_by_default' => 'مربع اختيار الشروط والسياسة محدد افتراضياً',
            'terms_and_policy_checkbox_checked_by_default_helper' => 'إذا تم تمكينه، سيُحدد مربع اختيار الشروط والسياسة مسبقاً عند تحميل نموذج الدفع.',
            'checkout_acceptance_message_enabled' => 'عرض رسالة قبول الدفع',
            'checkout_acceptance_message_enabled_helper' => 'عرض رسالة إعلامية تخبر العملاء بالشروط التي يوافقون عليها بتقديم طلب.',
            'hide_customer_info_at_checkout' => 'إخفاء معلومات العميل في الدفع',
            'hide_customer_info_at_checkout_helper' => 'إخفاء معلومات حساب العميل وزر تسجيل الخروج من صفحة الدفع. عند التمكين، لن يرى العملاء المسجلون تفاصيل حسابهم المعروضة.',
        ],
    ],
    'return' => [
        'name' => 'الإرجاع',
        'description' => 'تكوين قواعد إعدادات الإرجاع',
        'panel_description' => 'عرض وتحديث إعدادات الإرجاع',
        'form' => [
            'is_enabled_order_return' => 'هل تم تمكين إرجاع الطلب',
            'allow_partial_return' => 'السماح بالإرجاع الجزئي',
            'allow_partial_return_description' => 'يمكن للعميل إرجاع بعض المنتجات، ولا يحتاج لإرجاع جميع المنتجات في الطلب.',
            'returnable_days' => 'أيام الإرجاع',
            'return_settings_helper' => 'عدد الأيام التي يمكن للعميل طلب الإرجاع بعد إكمال الطلب.',
        ],
    ],
    'invoice' => [
        'name' => 'الفواتير',
        'description' => 'عرض وتحديث إعدادات الفواتير الخاصة بك',
        'company_settings' => 'إعدادات الشركة',
        'company_settings_description' => 'إعدادات معلومات الشركة للفواتير',
        'form' => [
            'company_name' => 'اسم الشركة',
            'company_name_helper' => 'اسم شركتك أو عملك الذي سيظهر على جميع الفواتير المرسلة للعملاء.',
            'company_name_placeholder' => 'شركة أكمي المحدودة',
            'company_address' => 'عنوان الشركة',
            'company_address_helper' => 'العنوان الكامل لشركتك بما في ذلك الشارع والمدينة والمنطقة والدولة. سيظهر هذا على الفواتير.',
            'company_address_placeholder' => 'شارع الملك فهد 123، الرياض 11564، المملكة العربية السعودية',
            'company_zipcode' => 'الرمز البريدي للشركة',
            'company_zipcode_helper' => 'الرمز البريدي لعنوان شركتك.',
            'company_zipcode_placeholder' => '11564',
            'company_email' => 'بريد الشركة الإلكتروني',
            'company_email_helper' => 'عنوان البريد الإلكتروني للاستفسارات التجارية. يمكن للعملاء استخدامه للأسئلة المتعلقة بالفواتير.',
            'company_email_placeholder' => 'invoice@company.sa',
            'company_phone' => 'هاتف الشركة',
            'company_phone_helper' => 'رقم الهاتف للاتصال الذي سيتم عرضه على الفواتير لدعم العملاء.',
            'company_phone_placeholder' => '+966 11 123 4567',
            'company_logo' => 'شعار الشركة',
            'company_logo_helper' => 'شعار شركتك الذي سيتم عرضه في أعلى الفواتير. الحجم الموصى به: 200×60 بكسل.',
            'company_tax_id' => 'الرقم الضريبي للشركة',
            'company_tax_id_helper' => 'رقم التعريف الضريبي لشركتك (الرقم الضريبي، رقم السجل التجاري، إلخ) للامتثال الضريبي.',
            'company_tax_id_placeholder' => 'الرقم الضريبي: 1234567890',
            'invoice_code_prefix' => 'بادئة رمز الفاتورة',
            'invoice_code_prefix_helper' => 'البادئة المضافة قبل أرقام الفواتير (مثال: \"فاتورة-\" ستنشئ رموز فواتير مثل فاتورة-001، فاتورة-002).',
            'invoice_code_prefix_placeholder' => 'فاتورة-',
            'using_custom_font_for_invoice' => 'استخدام خط مخصص للفاتورة',
            'using_custom_font_for_invoice_helper' => 'تفعيل لاستخدام خط Google مخصص لملفات PDF الفواتير بدلاً من الخط الافتراضي.',
            'invoice_font_family' => 'عائلة خط الفاتورة (يعمل فقط للغة اللاتينية)',
            'invoice_font_family_helper' => 'حدد خط Google لاستخدامه في ملفات PDF الفواتير. يعمل فقط مع مجموعات الأحرف اللاتينية.',
            'enable_invoice_stamp' => 'تمكين ختم الفاتورة',
            'enable_invoice_stamp_helper' => 'إضافة ختم \"مدفوع\" إلى الفواتير عند اكتمال دفع الطلب.',
            'add_language_support' => 'إضافة دعم اللغة',
            'add_language_support_helper' => 'اختر دعم مجموعة الأحرف الإضافية للغات غير اللاتينية في ملفات PDF الفواتير.',
            'invoice_processing_library' => 'مكتبة معالجة الفاتورة',
            'invoice_processing_library_helper' => 'اختر مكتبة إنشاء PDF. DomPDF أسرع ولكن لديه ميزات محدودة. mPDF يدعم المزيد من اللغات والميزات ولكن قد يكون أبطأ.',
            'only_latin_languages' => 'اللغات اللاتينية فقط',
            'disable_order_invoice_until_order_confirmed' => 'تعطيل فاتورة الطلب حتى تأكيد الطلب',
            'disable_order_invoice_until_order_confirmed_helper' => 'عند التفعيل، ستكون الفواتير متاحة فقط بعد تأكيد الطلبات، وليس فوراً بعد تقديم الطلب.',
            'date_format' => 'تنسيق التاريخ',
            'date_format_helper' => 'اختر كيفية عرض التواريخ على الفواتير (مثال: \"F d, Y\" يعرض \"يناير 01، 2024\").',
            'languages' => [
                'arabic' => 'العربية',
                'bangladesh' => 'البنغالية',
                'chinese' => 'الصينية',
            ],
        ],
    ],
    'tax' => [
        'name' => 'الضريبة',
        'description' => 'إعدادات الضريبة',
        'enable' => 'تمكين الضريبة؟',
        'display_product_price_including_taxes' => 'عرض سعر المنتج شامل الضرائب؟',
        'display_tax_description' => 'عرض معلومات الضريبة على سعر المنتج؟',
        'display_tax_description_help' => 'عرض نص مثل "(شامل ضريبة القيمة المضافة X%)" أو "(غير شامل ضريبة القيمة المضافة X%)" بجانب أسعار المنتجات في صفحة تفاصيل المنتج.',
        'tax_included_in_products_price' => 'الضريبة مشمولة في أسعار المنتجات',
        'tax_included_in_products_price_description' => 'ستُشمل الضريبة في أسعار المنتجات',
        'tax_setting' => 'إعدادات الضريبة',
        'tax_setting_description' => 'تكوين إعدادات الضريبة',
        'tax_management' => 'إدارة الضرائب',
        'tax_management_description' => 'عرض وإدارة ضرائبك',
        'form' => [
            'enable_tax' => 'تمكين الضريبة',
            'display_company_invoice_information_fields_at_checkout_page' => 'عرض حقول معلومات فاتورة الشركة في صفحة الدفع',
            'display_company_invoice_information_fields_at_checkout_page_helper' => 'إذا تم تمكينه، ستظهر حقول معلومات فاتورة الشركة في صفحة الدفع. مطلوب ملء حقول معلومات فاتورة الشركة.',
            'default_tax_rate' => 'معدل الضريبة الافتراضي',
            'default_tax_rate_description' => 'مهم: سيُطبق إذا لم يتم اختيار ضريبة في المنتج.',
            'select_tax' => '-- اختر --',
            'display_product_price_including_taxes' => 'عرض سعر المنتج شامل الضرائب',
        ],
    ],
    'customer' => [
        'name' => 'العملاء',
        'description' => 'عرض وتحديث إعدادات عملائك',
        'customer_setting' => 'إعدادات العميل',
        'customer_setting_description' => 'تكوين إعدادات العميل',
        'form' => [
            'enable_customer_registration' => 'تمكين تسجيل العملاء',
            'enable_customer_registration_helper' => 'إذا تم تعطيلها، لن يتمكن العملاء من تسجيل حسابات جديدة. يمكن للعملاء الحاليين تسجيل الدخول.',
            'verify_customer_email' => 'تأكيد بريد العميل الإلكتروني',
            'verify_customer_email_helper' => 'عند تمكينه، سيُرسل رابط تأكيد إلى بريد العميل الإلكتروني، يحتاج العملاء للنقر على هذا الرابط لتأكيد بريدهم الإلكتروني قبل تسجيل الدخول. يحتاج إلى تكوين البريد الإلكتروني في المدير -> الإعدادات -> البريد الإلكتروني لإرسال تأكيد البريد الإلكتروني.',
            'verification_expire_minutes' => 'وقت انتهاء صلاحية رابط التأكيد',
            'verification_expire_minutes_helper' => 'الوقت بالدقائق الذي سيكون فيه رابط تأكيد البريد الإلكتروني صالحاً. الافتراضي 60 دقيقة (ساعة واحدة). الحد الأقصى 10080 دقيقة (7 أيام).',
            'login_using_phone' => 'تسجيل الدخول برقم الهاتف بدلاً من البريد الإلكتروني',
            'login_option' => 'خيار تسجيل الدخول',
            'login_with_email' => 'تسجيل الدخول بالبريد الإلكتروني',
            'login_with_phone' => 'تسجيل الدخول بالهاتف',
            'login_with_email_or_phone' => 'تسجيل الدخول بالبريد الإلكتروني أو الهاتف',
            'enabled_customer_account_deletion' => 'تمكين حذف حساب العميل',
            'enabled_customer_account_deletion_helper' => 'عند تمكينه، يمكن للعملاء حذف حسابهم في لوحة العميل → إعدادات الحساب.',
            'enabled_customer_dob_field' => 'تمكين حقل تاريخ ميلاد العميل',
            'enabled_customer_dob_field_helper' => 'عند تمكينه، يمكن للعملاء إدخال تاريخ ميلادهم في لوحة العميل → إعدادات الحساب.',
            'enabled_phone_field_in_registration_form' => 'تمكين حقل الهاتف في نموذج التسجيل',
            'enabled_phone_field_in_registration_form_helper' => 'عند تمكينه، سيُضاف حقل الهاتف إلى نموذج التسجيل.',
            'make_customer_phone_number_required' => 'جعل رقم هاتف العميل مطلوباً',
            'make_customer_phone_number_required_helper' => 'عند التمكين، يجب على العملاء إدخال رقم هاتفهم أثناء التسجيل. مطلوب دائماً للعملاء الذين يسجلون الدخول برقم الهاتف.',
            'default_avatar' => 'الصورة الرمزية الافتراضية',
            'default_avatar_helper' => 'الصورة الرمزية الافتراضية للعميل عندما لا يملكون صورة رمزية. إذا لم تختر أي صورة، ستُنشأ باستخدام شعارك أو الحرف الأول من اسم العميل.',
            'keep_email_field_in_registration_form' => 'الاحتفاظ بحقل البريد الإلكتروني في نموذج التسجيل',
            'keep_email_field_in_registration_form_helper' => 'عند تعطيله، سيختفي حقل البريد الإلكتروني في نموذج التسجيل عندما يكون خيار تسجيل الدخول "تسجيل الدخول بالهاتف".',
        ],
    ],
    'shipping' => [
        'name' => 'الشحن',
        'description' => 'عرض وتحديث إعدادات الشحن',
        'shipping_rule' => 'قواعد الشحن',
        'shipping_rule_description' => 'تكوين قواعد حساب رسوم الشحن',
        'shipping_setting' => 'إعدادات الشحن',
        'shipping_setting_description' => 'تكوين إعدادات الشحن',
        'form' => [
            'hide_other_shipping_options_if_it_has_free_shipping' => 'إخفاء خيارات الشحن الأخرى إذا كان هناك شحن مجاني في القائمة',
            'disable_shipping_options' => 'تعطيل خيارات الشحن',
            'disable_shipping_options_helper' => 'ستُزال خيارات الشحن من صفحة الدفع، لن يتمكن العميل من اختيار خيارات الشحن.',
            'sort_shipping_options_direction' => 'اتجاه ترتيب خيارات الشحن',
            'sort_shipping_options_direction_helper' => 'ترتيب خيارات الشحن حسب السعر من الأقل للأعلى أو من الأعلى للأقل.',
            'price_lower_to_higher' => 'السعر من الأقل للأعلى',
            'price_higher_to_lower' => 'السعر من الأعلى للأقل',
        ],
    ],
    'webhook' => [
        'name' => 'Webhook',
        'description' => 'تكوين إعدادات webhook',
        'webhook_setting' => 'Webhook',
        'webhook_setting_description' => 'تكوين روابط webhook لاستقبال إشعارات لأحداث الطلبات المختلفة',
        'form' => [
            'order_placed_webhook_url' => 'رابط webhook تقديم الطلب (الطريقة: POST)',
            'order_placed_webhook_url_placeholder' => 'https://...',
            'order_placed_webhook_url_helper' => 'لاستقبال إشعارات عند تقديم طلب، يمكنك إعداد رابط webhook خارجي. إذا كان لديك رابط webhook خارجي، يمكنك إدخال هذا الرابط، أو تركه فارغاً.',
            'order_updated_webhook_url' => 'رابط webhook تحديث الطلب (الطريقة: POST)',
            'order_updated_webhook_url_placeholder' => 'https://...',
            'order_updated_webhook_url_helper' => 'لاستقبال إشعارات عند تحديث طلب، يمكنك إعداد رابط webhook خارجي. يشمل هذا تغييرات الحالة وتحديثات العنوان وتعديلات الطلب الأخرى.',
            'shipping_status_updated_webhook_url' => 'رابط webhook تحديث حالة الشحن (الطريقة: POST)',
            'shipping_status_updated_webhook_url_placeholder' => 'https://...',
            'shipping_status_updated_webhook_url_helper' => 'لاستقبال إشعارات عند تغيير حالة الشحن (مثل شُحن، وُصل، أُلغي)، يمكنك إعداد رابط webhook خارجي.',
            'order_completed_webhook_url' => 'رابط webhook إكمال الطلب (الطريقة: POST)',
            'order_completed_webhook_url_placeholder' => 'https://...',
            'order_completed_webhook_url_helper' => 'لاستقبال إشعارات عند إكمال طلب، يمكنك إعداد رابط webhook خارجي.',
            'order_cancelled_webhook_url' => 'رابط webhook إلغاء الطلب (الطريقة: POST)',
            'order_cancelled_webhook_url_placeholder' => 'https://...',
            'order_cancelled_webhook_url_helper' => 'لاستقبال إشعارات عند إلغاء طلب، يمكنك إعداد رابط webhook خارجي.',
            'payment_status_updated_webhook_url' => 'رابط webhook تحديث حالة الدفع (الطريقة: POST)',
            'payment_status_updated_webhook_url_placeholder' => 'https://...',
            'payment_status_updated_webhook_url_helper' => 'لاستقبال إشعارات عند تغيير حالة الدفع (مثل دُفع، فشل، اُسترد)، يمكنك إعداد رابط webhook خارجي.',
            'abandoned_cart_webhook_url' => 'رابط webhook السلة المهجورة (الطريقة: POST)',
            'abandoned_cart_webhook_url_placeholder' => 'https://...',
            'abandoned_cart_webhook_url_helper' => 'لاستقبال إشعارات عند هجر السلال ومتابعة العملاء، يمكنك إعداد رابط webhook خارجي. تُرسل الإشعارات بعد فترة زمنية قابلة للتكوين.',
        ],
        'test_button' => 'اختبار Webhook',
        'test_success' => 'اختبار webhook نجح! النقطة النهائية استجابت بشكل صحيح.',
        'test_failed' => 'اختبار webhook فشل. النقطة النهائية لم تستجب كما متوقع.',
        'test_error' => 'خطأ في اختبار webhook: :error',
        'please_enter_url' => 'يرجى إدخال رابط webhook أولاً',
        'testing' => 'جاري الاختبار...',
        'test_failed_title' => 'فشل الاختبار!',
        'test_success_title' => 'نجح الاختبار!',
        'status_code' => 'رمز الحالة',
        'error_occurred' => 'حدث خطأ أثناء اختبار webhook',
    ],
    'store_locator' => [
        'name' => 'محددات المتجر',
        'description' => 'عرض وتحديث قوائم سلاسلك',
        'store_locator_description' => 'جميع قوائم سلاسلك، والمتاجر الرئيسية، والفروع، إلخ. يمكن استخدام المواقع لتتبع المبيعات ومساعدتنا في تكوين معدلات الضرائب للتحصيل عند بيع المنتجات.',
        'form' => [
            'change_primary_store' => 'تغيير محدد المتجر الافتراضي',
            'add_location' => 'إضافة موقع',
            'edit_location' => 'تعديل الموقع',
            'delete_location' => 'حذف الموقع',
            'delete_location_confirmation' => 'هل أنت متأكد من أنك تريد حذف هذا الموقع؟ لا يمكن التراجع عن هذا الإجراء.',
            'change_primary_location' => 'تغيير الموقع الأساسي',
            'save_location' => 'حفظ الموقع',
            'add_new' => 'إضافة جديد',
        ],
    ],
    'tracking' => [
        'name' => 'التتبع',
        'description' => 'عرض وتحديث إعدادات التتبع',
        'manage_tracking' => 'إدارة التتبع',
        'manage_tracking_description' => 'إدارة التتبع: UTM، Facebook، Google Tag Manager...',
        'form' => [
            'enable_facebook_pixel' => 'تمكين Facebook Pixel (Meta Pixel)',
            'facebook_pixel_helper' => 'اذهب إلى https://developers.facebook.com/docs/meta-pixel لإنشاء Facebook Pixel. تأكد من أن البكسل نشط ومكون بشكل صحيح.',
            'facebook_pixel_id' => 'معرف Facebook Pixel',
            'facebook_pixel_id_placeholder' => 'مثال: 1234567890123456',
            'facebook_pixel_debug_mode' => 'تمكين وضع تصحيح Facebook Pixel',
            'facebook_pixel_debug_mode_helper' => 'تمكين وضع التصحيح لتسجيل أحداث Facebook Pixel في وحدة تحكم المتصفح واستكشاف مشاكل التتبع',
            'enable_google_tag_manager_tracking_events' => 'تمكين أحداث تتبع Google Tag Manager',
            'google_tag_manager_tracking_info' => 'عند التمكين، ستُتتبع أحداث التجارة الإلكترونية من خلال Google Tag Manager. تأكد من تكوين Google Tag Manager أعلاه.',
            'google_ads_conversion_id' => 'معرف تحويل إعلانات Google',
            'google_ads_conversion_id_helper' => 'أدخل معرف تحويل إعلانات Google (التنسيق: AW-123456789/AbC-D_efG-h1_ijk-lmN) لتتبع تحويلات الشراء في صفحة الشكر.',
        ],
        'validation' => [
            'facebook_pixel_id_format' => 'يجب أن يكون معرف Facebook Pixel 15-16 رقم (مثل 1234567890123456)',
        ],
    ],
    'marketplace' => [
        'name' => 'السوق',
        'description' => 'عرض وتحديث إعدادات السوق',
    ],
    'standard_and_format' => [
        'name' => 'المعيار والتنسيق',
        'panel_description' => 'عرض وتحديث إعدادات المعيار والتنسيق',
        'description' => 'المعايير والتنسيقات تُستخدم لحساب أشياء مثل أسعار المنتجات وأوزان الشحن وأوقات الطلبات.',
        'form' => [
            'change_order_format' => 'تحرير تنسيق رمز الطلب (اختياري)',
            'change_order_format_description' => 'رمز الطلب الافتراضي يبدأ بـ: رقم. يمكنك تغيير النص البادئ أو النهائي لإنشاء رمز الطلب الذي تريده، مثل "DH-: رقم" أو ": رقم-A"',
            'start_with' => 'يبدأ بـ',
            'end_with' => 'ينتهي بـ',
            'order_will_be_shown' => 'سيظهر رمز طلبك',
            'weight_unit' => 'وحدة الوزن',
            'height_unit' => 'وحدة الطول / الارتفاع',
            'weight_unit_gram' => 'غرام (g)',
            'weight_unit_kilogram' => 'كيلوغرام (kg)',
            'weight_unit_lb' => 'باوند (lb)',
            'weight_unit_oz' => 'أونصة (oz)',
            'height_unit_cm' => 'سنتيمتر (cm)',
            'height_unit_m' => 'متر (m)',
            'height_unit_inch' => 'بوصة',
        ],
    ],
    'sale_popup' => [
        'name' => 'نافذة البيع المنبثقة',
        'description' => 'خصص إعدادات نافذة البيع المنبثقة بسهولة',
    ],
    'flash_sale' => [
        'name' => 'التخفيضات السريعة',
        'description' => 'تكوين إعدادات التخفيضات السريعة لتقديم خصومات ترويجية محدودة الوقت',
        'enable' => 'تمكين وظيفة التخفيضات السريعة',
        'enable_helper' => 'عند التمكين، يمكنك إنشاء وإدارة تخفيضات سريعة بأسعار مخفضة خاصة لفترة زمنية محدودة.',
        'show_sale_count_left' => 'عرض متتبع المخزون',
        'show_sale_count_left_description' => 'عرض شريط تقدم مع "X بيع من Y" لخلق إلحاح وتشجيع الشراء السريع أثناء التخفيضات السريعة.',
    ],
    'payment_method_cod_minimum_amount' => 'الحد الأدنى لمبلغ الطلب - :currency (اختياري)',
    'payment_method_minimum_amount' => 'الحد الأدنى لمبلغ الطلب - :currency (اختياري)',
    'display_bank_info_at_the_checkout_success_page' => 'عرض معلومات البنك في صفحة نجاح الدفع؟',
    'invoice_templates' => 'قوالب الفواتير',
];
