<?php

return [
    'name' => 'Товары',
    'description' => 'Просмотр и обновление настроек товаров',
    'create' => 'Новый товар',
    'create_product_type' => [
        'physical' => 'Новый физический товар',
        'digital' => 'Новый цифровой товар',
    ],
    'edit' => 'Редактировать товар - :name',
    'form' => [
        'name' => 'Название',
        'name_placeholder' => 'Название товара (максимум 120 символов)',
        'description' => 'Описание',
        'description_placeholder' => 'Краткое описание товара (максимум 400 символов)',
        'categories' => 'Категории',
        'content' => 'Содержимое',
        'price' => 'Цена',
        'quantity' => 'Количество',
        'brand' => 'Бренд',
        'width' => 'Ширина',
        'height' => 'Высота',
        'weight' => 'Вес',
        'date' => [
            'start' => 'С даты',
            'end' => 'По дату',
        ],
        'image' => 'Изображения',
        'collections' => 'Коллекции товаров',
        'labels' => 'Ярлыки',
        'price_sale' => 'Цена со скидкой',
        'product_type' => [
            'title' => 'Тип товара',
        ],
        'product' => 'Товар',
        'total' => 'Итого',
        'sub_total' => 'Промежуточная сумма',
        'shipping_fee' => 'Стоимость доставки',
        'discount' => 'Скидка',
        'options' => 'Опции',
        'shipping' => [
            'height' => 'Высота',
            'length' => 'Длина',
            'title' => 'Доставка',
            'weight' => 'Вес',
            'wide' => 'Ширина',
        ],
        'barcode' => 'Штрихкод (ISBN, UPC, GTIN и т.д.)',
        'barcode_placeholder' => 'Введите штрихкод',
        'cost_per_item' => 'Себестоимость за единицу',
        'cost_per_item_placeholder' => 'Введите себестоимость за единицу',
        'cost_per_item_helper' => 'Клиенты не увидят эту цену.',
        'price_includes_tax' => 'Цена включает налог',
        'price_includes_tax_helper' => 'Отметьте это, если введенная цена уже включает налоги. Система рассчитает базовую цену, вычтя сумму налога.',
        'stock' => [
            'allow_order_when_out' => 'Разрешить клиентам заказывать при отсутствии на складе',
            'in_stock' => 'В наличии',
            'out_stock' => 'Нет в наличии',
            'title' => 'Статус наличия',
        ],
        'storehouse' => [
            'no_storehouse' => 'Без управления складом',
            'storehouse' => 'С управлением складом',
            'title' => 'Склад',
            'quantity' => 'Количество',
        ],
        'tax' => 'Налог',
        'taxes' => 'Налоги',
        'taxes_helper' => 'Налоговая ставка по умолчанию настроена в <a href=":url">Настройки -> Налоги</a>. Если для этого товара не выбран конкретный налог, будет применена ставка по умолчанию. Чтобы отключить налог для этого товара, удалите налоговую ставку по умолчанию из налоговых настроек.',
        'is_default' => 'По умолчанию',
        'action' => 'Действие',
        'restock_quantity' => 'Количество для пополнения',
        'remain' => 'Остаток',
        'choose_discount_period' => 'Выберите период скидки',
        'cancel' => 'Отменить',
        'no_results' => 'Нет результатов!',
        'value' => 'Значение',
        'attribute_name' => 'Название атрибута',
        'add_more_attribute' => 'Добавить еще атрибут',
        'continue' => 'Продолжить',
        'add_new_attributes' => 'Добавить новые атрибуты',
        'add_new_attributes_description' => 'Добавление новых атрибутов помогает товару иметь множество опций, таких как размер или цвет.',
        'create_product_variations' => ':link для создания вариаций товара!',
        'tags' => 'Теги',
        'write_some_tags' => 'Напишите несколько тегов',
        'variation_existed' => 'Эта вариация уже существует.',
        'no_attributes_selected' => 'Атрибуты не выбраны!',
        'added_variation_success' => 'Вариация успешно добавлена!',
        'updated_variation_success' => 'Вариация успешно обновлена!',
        'created_all_variation_success' => 'Все вариации успешно созданы!',
        'updated_product_attributes_success' => 'Атрибуты товара успешно обновлены!',
        'stock_status' => 'Статус наличия',
        'auto_generate_sku' => 'Автоматически генерировать SKU?',
        'featured_image' => 'Основное изображение (необязательно)',
        'product_id' => 'ID товара',
        'price_sale_percent_helper' => 'Скидка :percent от первоначальной цены.',
        'minimum_order_quantity' => 'Минимальное количество для заказа',
        'minimum_order_quantity_helper' => 'Минимальное количество для размещения заказа, если значение 0, то ограничений нет.',
        'maximum_order_quantity' => 'Максимальное количество для заказа',
        'maximum_order_quantity_helper' => 'Максимальное количество для размещения заказа, если значение 0, то ограничений нет.',
        'video' => 'Видео',
        'video_file' => 'Файл',
        'video_url' => 'Или внешний URL видео',
        'video_url_help' => 'Введите URL видео с YouTube или Vimeo',
        'enter_video_url' => 'Введите URL видео',
        'video_thumbnail' => 'Миниатюра видео',
        'video_thumbnail_help' => 'Выберите миниатюру для видео. Если не выбрана, она будет автоматически получена из URL видео, если доступно.',
        'barcode_existed' => 'Этот штрихкод используется другим товаром. Пожалуйста, введите другой штрихкод.',
        'barcode_helper' => 'Должен быть уникальным для каждого товара.',
    ],
    'price' => 'Цена',
    'quantity' => 'Количество',
    'type' => 'Тип',
    'image' => 'Миниатюра',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'SKU вариации',
    'brand' => 'Бренд',
    'cannot_delete' => 'Товар не может быть удален',
    'product_deleted' => 'Товар удален',
    'product_collections' => 'Коллекции товаров',
    'products' => 'Товары',
    'menu' => 'Товары',
    'control' => [
        'button_add_image' => 'Добавить изображение',
    ],
    'price_sale' => 'Цена со скидкой',
    'price_group_title' => 'Управление ценой товара',
    'store_house_group_title' => 'Управление складом',
    'shipping_group_title' => 'Управление доставкой',
    'overview' => 'Обзор',
    'attributes' => 'Атрибуты',
    'product_has_variations' => 'Товар имеет вариации',
    'manage_products' => 'Управление товарами',
    'add_new_product' => 'Добавить новый товар',
    'start_by_adding_new_product' => 'Начните с добавления новых товаров.',
    'edit_this_product' => 'Редактировать этот товар',
    'delete' => 'Удалить',
    'related_products' => 'Сопутствующие товары',
    'cross_selling_products' => 'Товары для перекрестных продаж',
    'up_selling_products' => 'Товары для дополнительных продаж',
    'grouped_products' => 'Сгруппированные товары',
    'search_products' => 'Поиск товаров',
    'selected_products' => 'Выбранные товары',
    'edit_variation_item' => 'Редактировать',
    'variations_box_description' => 'Нажмите "Редактировать атрибут" для добавления/удаления атрибутов вариации или нажмите "Добавить новую вариацию" для добавления вариации.',
    'save_changes' => 'Сохранить изменения',
    'continue' => 'Продолжить',
    'edit_attribute' => 'Редактировать атрибут',
    'select_attribute' => 'Выбрать атрибут',
    'add_new_variation' => 'Добавить новую вариацию',
    'edit_variation' => 'Редактировать вариацию',
    'generate_variations' => 'Генерировать вариации',
    'generate_variations_confirmation' => 'Вы уверены, что хотите сгенерировать вариации для этого товара?',
    'delete_variation' => 'Удалить вариацию?',
    'delete_variation_confirmation' => 'Вы уверены, что хотите удалить эту вариацию? Это действие нельзя отменить.',
    'delete_variations_confirmation' => 'Вы уверены, что хотите удалить эти вариации? Это действие нельзя отменить.',
    'product_create_validate_name_required' => 'Пожалуйста, введите название товара',
    'product_create_validate_sale_price_max' => 'Скидка должна быть меньше первоначальной цены',
    'product_create_validate_cost_per_item_max' => 'Себестоимость за единицу должна быть меньше первоначальной цены',
    'product_create_validate_sale_price_required_if' => 'Необходимо ввести скидку, когда вы хотите запланировать акцию',
    'product_create_validate_end_date_after' => 'Дата окончания должна быть после даты начала',
    'product_create_validate_start_date_required_if' => 'Дата начала скидки не может быть пустой при выборе планирования',
    'product_create_validate_sale_price' => 'Скидки не могут быть пустыми при выборе планирования',
    'stock_statuses' => [
        'in_stock' => 'В наличии',
        'out_of_stock' => 'Нет в наличии',
        'on_backorder' => 'В ожидании поставки',
    ],
    'stock_status' => 'Статус наличия',
    'processing' => 'Обработка...',
    'delete_selected_variations' => 'Удалить выбранные вариации',
    'delete_variations' => 'Удалить вариации',
    'category' => 'Категория',
    'categories' => 'Категории',
    'tags' => 'Теги',
    'product_price_flash_sale_warning' => 'Этот товар участвует в скидке-молнии <strong>:name</strong>, поэтому его цена <strong>:price</strong>.',
    'product_price_discount_warning' => 'Этот товар участвует в скидке <strong>:name</strong>, поэтому его цена <strong>:price</strong>.',
    'product_image' => 'Изображение товара',
    'product_name' => 'Название товара',
    'product_link' => 'Ссылка на товар',
    'types' => [
        'physical' => 'Физический',
        'digital' => 'Цифровой',
    ],
    'digital_attachments' => [
        'title' => 'Цифровые вложения',
        'add' => 'Добавить вложение',
        'file_name' => 'Имя файла',
        'file_size' => 'Размер файла',
        'unsaved' => 'Не сохранено',
        'add_external_link' => 'Добавить внешнюю ссылку',
        'enter_file_name' => 'Введите имя файла',
        'enter_external_link_download' => 'Введите внешнюю ссылку для скачивания',
        'enter_file_size' => 'Введите размер файла',
        'external_link_download' => 'Внешняя ссылка для скачивания',
        'generate_license_code_after_purchasing_product' => 'Включить назначение лицензионного кода для этого товара',
        'notify_attachment_updated' => 'Отправить email клиенту при обновлении вложения',
    ],
    'license_codes' => [
        'title' => 'Лицензионные коды',
        'add' => 'Добавить лицензионный код',
        'back' => 'Вернуться к товару',
        'edit' => 'Редактировать лицензионный код',
        'generate' => 'Генерировать коды',
        'manage_codes' => 'Управление лицензионными кодами',
        'management' => 'Управление лицензионными кодами',
        'variation_breadcrumb' => 'Вариация: :name',
        'variation_label' => 'Вариация товара',
        'variation_specific_note' => 'Эти лицензионные коды специфичны для этой вариации товара. Клиенты, покупающие эту вариацию, получат коды из этого пула.',
        'main_product_note' => 'Этот товар имеет вариации. Каждая вариация может иметь свои лицензионные коды, или клиенты могут получить коды из этого основного пула товара, если у вариации нет кодов.',
        'code' => 'Лицензионный код',
        'codes' => 'Лицензионные коды',
        'status' => 'Статус',
        'assigned_at' => 'Назначен в',
        'status_available' => 'Доступен',
        'status_used' => 'Использован',
        'statuses' => [
            'available' => 'Доступен',
            'used' => 'Использован',
        ],
        'no_codes' => 'Лицензионные коды не найдены. Добавьте коды или сгенерируйте их автоматически.',
        'no_codes_warning_title' => 'Нет доступных лицензионных кодов!',
        'no_codes_warning_message' => 'Этот товар настроен на "Выбор из списка", но не имеет доступных лицензионных кодов. Клиенты, покупающие этот товар, получат автоматически сгенерированные коды. Пожалуйста, добавьте лицензионные коды для обеспечения правильной функциональности.',
        'no_codes_auto_generate' => 'Этот товар настроен на автоматическую генерацию лицензионных кодов. Ручные коды не нужны.',
        'used_code_no_actions' => 'Использованный код - действия недоступны',
        'created_successfully' => 'Лицензионный код успешно создан!',
        'updated_successfully' => 'Лицензионный код успешно обновлен!',
        'deleted_successfully' => 'Лицензионный код успешно удален!',
        'generated_successfully' => 'Успешно сгенерировано :count лицензионных кодов!',
        'duplicates_skipped' => ':count дублирующихся кодов было пропущено.',
        'generation_incomplete' => 'Предупреждение: Удалось сгенерировать только :generated из :requested запрошенных кодов из-за конфликтов дубликатов.',
        'cannot_edit_used_code' => 'Нельзя редактировать использованный лицензионный код.',
        'cannot_delete_used_code' => 'Нельзя удалить использованный лицензионный код.',
        'show_all' => 'Показать все',
        'show_less' => 'Показать меньше',
        'more' => 'еще',
        'used_codes_hidden' => ':count использованных лицензионных кодов скрыто. Вы можете просмотреть все коды на странице управления лицензионными кодами.',
        'low_stock_title' => 'Низкий запас лицензионных кодов',
        'low_stock_message' => 'Осталось только :count лицензионных кодов. Рассмотрите возможность добавления дополнительных кодов, чтобы избежать их исчерпания.',
        'out_of_stock_title' => 'Нет лицензионных кодов!',
        'out_of_stock_message' => 'Нет доступных лицензионных кодов. Клиенты будут получать автоматически сгенерированные коды, пока вы не добавите больше.',
        'type' => [
            'title' => 'Метод назначения лицензионного кода',
            'auto_generate' => 'Автоматическая генерация (система генерирует коды автоматически)',
            'pick_from_list' => 'Выбор из списка (использовать предварительно введенные коды)',
            'description' => 'Выберите, как лицензионные коды должны назначаться клиентам при покупке этого товара.',
        ],
        'generate_modal' => [
            'title' => 'Генерировать лицензионные коды',
            'quantity' => 'Количество',
            'format' => 'Формат',
            'custom_pattern' => 'Пользовательский шаблон',
            'pattern_help' => 'Используйте # для цифр, A для заглавных букв, a для строчных букв',
            'generate' => 'Генерировать',
        ],
        'errors' => [
            'feature_not_enabled' => 'Функция лицензионных кодов не включена. Пожалуйста, включите ее в Настройки электронной коммерции > Цифровые товары.',
            'digital_products_not_enabled' => 'Цифровые товары не включены. Пожалуйста, сначала включите поддержку цифровых товаров.',
            'product_not_found' => 'Товар не найден.',
            'not_digital_product' => 'Лицензионные коды доступны только для цифровых товаров. Этот товар установлен как физический товар.',
            'license_codes_not_enabled_for_product' => 'Управление лицензионными кодами не включено для этого товара. Пожалуйста, включите "Генерировать лицензионный код после покупки товара" в настройках товара.',
            'cannot_add_codes_auto_generate' => 'Нельзя вручную добавлять лицензионные коды к товарам, настроенным на автоматическую генерацию. Сначала измените тип лицензионного кода на "Выбор из списка".',
            'cannot_generate_codes_auto_generate' => 'Нельзя вручную генерировать лицензионные коды для товаров, настроенных на автоматическую генерацию. Сначала измените тип лицензионного кода на "Выбор из списка".',
        ],
        'copied' => 'Лицензионный код скопирован в буфер обмена!',
    ],
    'this_action_will_reload_page' => 'Это действие перезагрузит страницу для обновления данных!',
    'select' => 'Выбрать',
    'set_this_variant_as_default' => 'Установить этот вариант по умолчанию',
    'download' => 'Скачать',
    'cross_sell_price_type' => [
        'title' => 'Тип цены',
        'fixed' => 'Фиксированная',
        'percent' => 'Процент',
    ],
    'cross_sell_help' => [
        'price' => 'Цена',
        'price_description' => 'Введите сумму, которую вы хотите уменьшить от первоначальной цены. Пример: Если первоначальная цена $100, введите 20, чтобы уменьшить цену до $80.',
        'type' => '* Поле типа',
        'type_description' => 'Выберите тип скидки: Фиксированная (уменьшить на определенную сумму) или Процент (уменьшить на процент).',
    ],
    'apply_for_all_variations' => 'Применить ко всем вариациям',
    'export' => [
        'description' => 'Экспорт данных товаров в файлы CSV или Excel.',
        'total_items' => 'Всего элементов',
        'total_products' => 'Всего товаров',
        'total_variations' => 'Всего вариаций',
        'advanced_options' => 'Расширенные опции',
        'use_chunked_export' => 'Использовать фрагментированный экспорт',
        'use_chunked_export_helper' => 'Обрабатывать данные фрагментами для эффективной работы с большими наборами данных',
        'include_variations' => 'Включить вариации товаров',
        'include_variations_helper' => 'Экспортировать вариации товаров вместе с основными товарами',
        'optimize_memory' => 'Оптимизировать использование памяти',
        'optimize_memory_helper' => 'Включить оптимизацию памяти для очень больших экспортов',
        'chunk_size' => 'Размер фрагмента',
        'chunk_size_helper' => 'Количество товаров для обработки за раз (50-5000)',
        'use_streaming' => 'Использовать потоковый экспорт',
        'use_streaming_helper' => 'Включить потоковую передачу для очень больших наборов данных (автоматически включается для >10,000 элементов)',
        'large_dataset_warning_title' => 'Обнаружен большой каталог товаров',
        'large_dataset_warning_message' => 'Ваш каталог содержит :count элементов. Из-за большого размера некоторые опции экспорта были оптимизированы для лучшей производительности.',
        'large_dataset_specific_message' => 'Для ваших :count товаров используйте формат CSV с включенной потоковой передачей. Система теперь может эффективно обрабатывать ваш большой каталог товаров без тайм-аутов или проблем с памятью.',
        'format_label' => 'Формат',
        'csv_recommended' => 'CSV (рекомендуется)',
        'chunk_label' => 'Обработка',
        'chunk_recommended' => '300 товаров/пакет',
        'time_label' => 'Ориентировочное время',
        'time_estimate' => '1-3 минуты',
        'pro_tip' => 'Совет:',
        'pro_tip_message' => 'Экспорт будет продолжаться даже если ваш браузер показывает индикатор загрузки. После запуска загрузка начнется автоматически.',
        'large_dataset_tip_1' => 'Формат Excel был отключен - используйте формат CSV для более быстрого и надежного экспорта',
        'large_dataset_tip_2' => 'Потоковый режим был автоматически включен для предотвращения тайм-аутов',
        'large_dataset_tip_3' => 'Процесс экспорта может занять 1-3 минуты в зависимости от вашего сервера',
        'large_dataset_recommendation' => 'Рекомендуется: Используйте формат CSV с размером фрагмента 200-500 для оптимальной производительности.',
        'excel_disabled_for_large_export' => 'Формат Excel недоступен для каталогов более 10,000 элементов',
        'streaming_auto_enabled' => 'Потоковый режим был автоматически включен для оптимальной производительности с большими наборами данных.',
        'streaming_enabled_title' => 'Оптимизировано для большого экспорта',
        'streaming_enabled_message' => 'Потоковый режим активен для обеспечения плавного экспорта без проблем с памятью.',
        'use_multi_file' => 'Использовать многофайловый экспорт',
        'use_multi_file_helper' => 'Разделить экспорт на несколько файлов, упакованных в ZIP для очень больших наборов данных',
        'multi_file_enabled_title' => 'Многофайловый экспорт включен',
        'multi_file_enabled_message' => 'Ваш экспорт будет разделен на :count файлов, упакованных в ZIP для оптимальной производительности.',
        'records_per_file' => 'Записей на файл',
        'records_per_file_helper' => 'Количество записей в каждом файле при использовании многофайлового экспорта',
        'estimated_files' => 'Предполагаемые файлы',
        'recommended_range' => 'Рекомендуемый диапазон',
        'range_large_export' => '200-500 элементов',
        'range_medium_export' => '300-800 элементов',
        'range_small_export' => '500-1000 элементов',
        'export_progress' => 'Прогресс экспорта',
        'preparing_export' => 'Подготовка экспорта...',
        'items_processed' => ':count элементов обработано',
        'estimated_time_calculating' => 'Ориентировочное время: рассчитывается...',
        'medium_dataset_detected' => 'Обнаружен средний набор данных',
        'medium_dataset_message' => 'Вы экспортируете :count товаров. Рассмотрите использование фрагментированного экспорта для лучшей производительности.',
        'optimal_range' => 'Оптимальный диапазон',
        'too_small_slow' => 'Слишком мало - может быть медленно',
        'too_large_timeouts' => 'Слишком много - может вызвать тайм-ауты',
        'excel_disabled_warning' => 'Формат Excel отключен для больших экспортов (:count элементов)',
        'starting_export' => 'Начало экспорта...',
        'processing_data' => 'Обработка данных...',
        'finalizing_export' => 'Завершение экспорта...',
        'items_processed_suffix' => 'элементов обработано',
        'estimated_time_prefix' => 'Ориентировочное время:',
        'seconds_remaining' => 'с осталось',
        'export_completed' => 'Экспорт завершен!',
        'download_starting' => 'Загрузка начинается...',
    ],
    'import' => [
        'description' => 'Импорт данных товаров из файлов CSV или Excel.',
        'rules' => [
            'in' => ':attribute должен быть одним из определенных значений: :values.',
            'required_string_max' => ':attribute обязателен и должен быть строкой с максимальной длиной :max символов.',
            'nullable_string' => ':attribute может быть оставлен пустым или должен быть строкой, если предоставлен.',
            'nullable_string_max' => ':attribute может быть оставлен пустым или должен быть строкой с максимальной длиной :max символов, если предоставлен',
            'nullable_bool' => ':attribute может быть оставлен пустым или должен быть логическим значением, если предоставлен.',
            'nullable_numeric_min' => ':attribute может быть оставлен пустым или должен быть неотрицательным числом, если предоставлен.',
            'nullable_numeric_min_max' => ':attribute может быть оставлен пустым или должен быть числом между :min и :max, если предоставлен.',
            'nullable_array' => ':attribute может быть оставлен пустым или должен быть предоставлен как массив, если указан.',
            'nullable_date_required_if' => ':attribute может быть оставлен пустым или должен быть действительной датой, если предоставлен, обязателен если указан :required.',
            'nullable_date_after' => ':attribute может быть оставлен пустым или должен быть действительной датой после :after, если предоставлен.',
        ],
        'updated_message' => 'Успешно обновлено :count товаров!',
    ],
    'import_products_intro' => 'Или импортировать товары из CSV/Excel',
    'select_attributes' => 'Выберите атрибуты для создания вариаций:',
    'all' => 'Все',
    'copy' => 'Копировать',
    'product_translations' => 'Переводы товаров',
    'view' => 'Просмотр продукта - :name',
    'product_information' => 'Информация о Продукте',
    'total_views' => 'Всего Просмотров',
    'total_orders' => 'Завершенные Заказы',
    'total_sold' => 'Всего Продано',
    'total_revenue' => 'Общий Доход',
    'total_reviews' => 'Всего Отзывов',
    'average_rating' => 'Средний Рейтинг',
    'views_by_date' => 'Просмотры по Датам (Последние 30 Дней)',
    'recent_orders' => 'Последние Заказы',
    'no_views_data' => 'Нет данных о просмотрах за последние 30 дней.',
    'no_orders' => 'Пока нет заказов.',
    'date' => 'Дата',
    'views' => 'Просмотры',
    'total' => 'Всего',
    'view_on_frontend' => 'Посмотреть на сайте',
    'select_attribute' => 'Выберите :name',
    'all_categories' => 'Все категории',
    'brands' => 'Бренды',
    'browse_products' => 'Просмотр товаров',
    'sku_1' => 'SKU:',
    'select_products_to_return' => 'Выбрать товары для возврата',
    'show_only_discounted_products' => 'Показать только товары со скидкой',
    'specification' => 'Спецификация',
    'download_product_with_external_links' => 'Скачать товар ":name" с внешними ссылками',
    'number_product_available_singular' => ':number товар доступен',
    'number_products_available_plural' => ':number товаров доступно',
];
