<?php

return [
    'settings' => 'API Settings',
    'settings_description' => 'View and update your API settings',
    'save_settings' => 'Save settings',
    'setting_title' => 'API settings',
    'setting_description' => 'Configure your API access and security settings',
    'api_enabled' => 'Enable API',
    'api_enabled_description' => 'Enable or disable the REST API for your website. When disabled, all API endpoints will be inaccessible.',
    'api_key' => 'API Key',
    'api_key_description' => 'Optional security key for API access. When set, all API requests must include this key in the X-API-KEY header.',
    'api_key_placeholder' => 'Enter your API key (leave empty to disable)',
    'generate_api_key' => 'Generate Random Key',
    'edit_api_key' => 'Edit API Key',
    'copy_api_key' => 'Copy to Clipboard',
    'api_key_generated' => 'New API key generated successfully!',
    'api_key_copied' => 'API key copied to clipboard!',
    'api_key_edit_enabled' => 'API key field is now editable.',
    'api_documentation' => 'API Documentation',
    'api_documentation_description' => 'View the complete API documentation with examples and endpoint details.',
    'view_documentation' => 'View API Docs',
    'generate_docs_title' => 'Generate API Documentation',
    'generate_docs_description' => 'To generate API documentation for your Botble CMS application, follow these simple steps:',
    'generate_docs_step_1' => '1. Install the Scribe package:',
    'generate_docs_step_2' => '2. Generate the API documentation:',
    'generate_docs_step_3' => '3. Access your API documentation at:',
    'api_usage_examples' => 'Usage Examples',
    'api_usage_curl_example' => 'Example cURL request with API key:',
    'api_usage_javascript_example' => 'Example JavaScript request:',
    'api_security_section' => 'Security Settings',
    'api_help_section' => 'Help & Documentation',
    'push_notifications_section' => 'Push Notifications (FCM v1 API)',
    'push_notifications_enabled' => 'Enable Push Notifications',
    'push_notifications_enabled_description' => 'Enable or disable push notifications for mobile apps. When disabled, no notifications will be sent to devices.',
    'fcm_project_id' => 'Firebase Project ID',
    'fcm_project_id_description' => 'Your Firebase project ID. You can find this in your Firebase project settings.',
    'fcm_project_id_placeholder' => 'Enter your Firebase project ID',
    'fcm_service_account_path' => 'Service Account JSON File',
    'fcm_service_account_path_description' => 'Path to your Firebase service account JSON file (relative to storage/app/ or absolute path).',
    'fcm_service_account_upload_description' => 'Upload your Firebase service account JSON file. The file will be securely stored in storage/app/firebase/ directory.',
    'fcm_service_account_path_placeholder' => 'firebase/service-account.json',
    'upload_file' => 'Upload File',
    'remove_file' => 'Remove File',
    'uploaded_at' => 'Uploaded at',
    'upload_json_file' => 'Please upload your service account JSON file.',
    'uploading_file' => 'Uploading file',
    'file_uploaded_successfully' => 'File uploaded successfully!',
    'file_removed_successfully' => 'File removed successfully!',
    'invalid_json_file' => 'Please select a valid JSON file.',
    'file_upload_error' => 'Error uploading file. Please try again.',
    'file_remove_error' => 'Error removing file. Please try again.',
    'send_custom_notification' => 'Send Custom Notification',
    'notification_title' => 'Title',
    'notification_title_placeholder' => 'Enter notification title',
    'notification_message' => 'Message',
    'notification_message_placeholder' => 'Enter notification message',
    'notification_message_help' => 'Maximum 500 characters',
    'notification_target' => 'Target Devices',
    'notification_action_url' => 'Action URL (Optional)',
    'notification_action_url_placeholder' => 'https://example.com/page',
    'notification_action_url_help' => 'URL to open when notification is tapped',
    'notification_image_url' => 'Image URL (Optional)',
    'notification_image_url_placeholder' => 'https://example.com/image.jpg',
    'notification_image_url_help' => 'Image to display in the notification',
    'notification_send_info' => 'Notifications will be sent to all active device tokens',
    'send_notification' => 'Send Notification',
    'all_devices' => 'All Devices',
    'android_devices' => 'Android Devices Only',
    'ios_devices' => 'iOS Devices Only',
    'customer_devices' => 'Customer Devices Only',
    'notification_sending' => 'Sending notification...',
    'notification_sent_success' => 'Notification sent successfully!',
    'notification_sent_error' => 'Failed to send notification. Please try again.',
    'fcm_setup_title' => 'Firebase Cloud Messaging Setup Instructions',
    'fcm_step_1_title' => '1. Create Firebase Project',
    'fcm_step_1_1' => 'Go to Firebase Console (console.firebase.google.com)',
    'fcm_step_1_2' => 'Create a new project or select existing one',
    'fcm_step_1_3' => 'Copy the Project ID from project settings',
    'fcm_step_2_title' => '2. Generate Service Account',
    'fcm_step_2_1' => 'Go to Project Settings > Service Accounts',
    'fcm_step_2_2' => 'Click "Generate new private key"',
    'fcm_step_2_3' => 'Download the JSON file',
    'fcm_step_2_4' => 'Upload it to your server storage/app/firebase/ folder',
    'fcm_step_3_title' => '3. Enable FCM API',
    'fcm_step_3_1' => 'Go to Google Cloud Console',
    'fcm_step_3_2' => 'Enable Firebase Cloud Messaging API',
    'fcm_step_3_3' => 'Make sure billing is enabled for your project',
    'fcm_step_4_title' => '4. Configure Settings',
    'fcm_step_4_1' => 'Enter your Project ID above',
    'fcm_step_4_2' => 'Enter the path to your service account JSON file',
    'fcm_security_note_title' => 'Security Note:',
    'fcm_security_note' => 'Keep your service account JSON file secure and never commit it to version control. Store it in a secure location on your server.',

    // Additional JavaScript translations
    'your_api_key_here' => 'your-api-key-here',
    'file_size_too_large' => 'File size must be less than 2MB.',
    'confirm_remove_service_account' => 'Are you sure you want to remove the service account file?',
    'service_account_file_label' => 'Service account file:',
    'just_uploaded' => '(Just uploaded)',
    'service_account_not_uploaded' => 'Service account file is <strong>not uploaded</strong>. Please upload your service account JSON file.',
    'please_enter_notification_title' => 'Please enter a notification title.',
    'please_enter_notification_message' => 'Please enter a notification message.',
    'notification_error_occurred' => 'An error occurred while sending the notification.',
    'sent_to_devices' => 'Sent to: :count devices',
    'failed_devices' => 'Failed: :count devices',
    'will_send_to_devices' => 'Will send to :total active devices (:android Android, :ios iOS, :customers customers)',
    'close' => 'Close',
];
