<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/analytics/data/v1alpha/analytics_data_api.proto

namespace Google\Analytics\Data\V1alpha;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configures a long-running operation resource to send a webhook notification
 * from the Google Analytics Data API to your webhook server when the resource
 * updates.
 * Notification configurations contain private values & are only visible to your
 * GCP project. Different GCP projects may attach different webhook
 * notifications to the same long-running operation resource.
 *
 * Generated from protobuf message <code>google.analytics.data.v1alpha.WebhookNotification</code>
 */
class WebhookNotification extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. The web address that will receive the webhook notification. This
     * address will receive POST requests as the state of the long running
     * operation resource changes. The POST request will contain both a JSON
     * version of the long running operation resource in the body and a
     * `sentTimestamp` field. The sent timestamp will specify the unix
     * microseconds since the epoch that the request was sent; this lets you
     * identify replayed notifications.
     * An example URI is
     * `https://us-central1-example-project-id.cloudfunctions.net/example-function-1`.
     * The URI must use HTTPS and point to a site with a valid SSL certificate on
     * the web server. The URI must have a maximum string length of 128 characters
     * & use only the allowlisted characters from [RFC
     * 1738](https://www.rfc-editor.org/rfc/rfc1738).
     * When your webhook server receives a notification, it is expected to reply
     * with an HTTP response status code of 200 within 5 seconds.
     * A URI is required to use webhook notifications.
     * Requests to this webhook server will contain an ID token authenticating the
     * service account
     * `google-analytics-audience-export&#64;system.gserviceaccount.com`. To learn
     * more about ID tokens, see
     * https://cloud.google.com/docs/authentication/token-types#id. For Google
     * Cloud Functions, this lets you configure your function to require
     * authentication. In Cloud IAM, you will need to grant the service account
     * permissions to the Cloud Run Invoker (`roles/run.invoker`) & Cloud
     * Functions Invoker (`roles/cloudfunctions.invoker`) roles for the webhook
     * post request to pass Google Cloud Functions authentication. This API can
     * send webhook notifications to arbitrary URIs; for webhook servers other
     * than Google Cloud Functions, this ID token in the authorization bearer
     * header should be ignored if it is not needed.
     *
     * Generated from protobuf field <code>optional string uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $uri = null;
    /**
     * Optional. The channel token is an arbitrary string value and must have a
     * maximum string length of 64 characters. Channel tokens allow you to verify
     * the source of a webhook notification. This guards against the message being
     * spoofed. The channel token will be specified in the `X-Goog-Channel-Token`
     * HTTP header of the webhook POST request.
     * A channel token is not required to use webhook notifications.
     *
     * Generated from protobuf field <code>optional string channel_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $channel_token = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $uri
     *           Optional. The web address that will receive the webhook notification. This
     *           address will receive POST requests as the state of the long running
     *           operation resource changes. The POST request will contain both a JSON
     *           version of the long running operation resource in the body and a
     *           `sentTimestamp` field. The sent timestamp will specify the unix
     *           microseconds since the epoch that the request was sent; this lets you
     *           identify replayed notifications.
     *           An example URI is
     *           `https://us-central1-example-project-id.cloudfunctions.net/example-function-1`.
     *           The URI must use HTTPS and point to a site with a valid SSL certificate on
     *           the web server. The URI must have a maximum string length of 128 characters
     *           & use only the allowlisted characters from [RFC
     *           1738](https://www.rfc-editor.org/rfc/rfc1738).
     *           When your webhook server receives a notification, it is expected to reply
     *           with an HTTP response status code of 200 within 5 seconds.
     *           A URI is required to use webhook notifications.
     *           Requests to this webhook server will contain an ID token authenticating the
     *           service account
     *           `google-analytics-audience-export&#64;system.gserviceaccount.com`. To learn
     *           more about ID tokens, see
     *           https://cloud.google.com/docs/authentication/token-types#id. For Google
     *           Cloud Functions, this lets you configure your function to require
     *           authentication. In Cloud IAM, you will need to grant the service account
     *           permissions to the Cloud Run Invoker (`roles/run.invoker`) & Cloud
     *           Functions Invoker (`roles/cloudfunctions.invoker`) roles for the webhook
     *           post request to pass Google Cloud Functions authentication. This API can
     *           send webhook notifications to arbitrary URIs; for webhook servers other
     *           than Google Cloud Functions, this ID token in the authorization bearer
     *           header should be ignored if it is not needed.
     *     @type string $channel_token
     *           Optional. The channel token is an arbitrary string value and must have a
     *           maximum string length of 64 characters. Channel tokens allow you to verify
     *           the source of a webhook notification. This guards against the message being
     *           spoofed. The channel token will be specified in the `X-Goog-Channel-Token`
     *           HTTP header of the webhook POST request.
     *           A channel token is not required to use webhook notifications.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Analytics\Data\V1Alpha\AnalyticsDataApi::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. The web address that will receive the webhook notification. This
     * address will receive POST requests as the state of the long running
     * operation resource changes. The POST request will contain both a JSON
     * version of the long running operation resource in the body and a
     * `sentTimestamp` field. The sent timestamp will specify the unix
     * microseconds since the epoch that the request was sent; this lets you
     * identify replayed notifications.
     * An example URI is
     * `https://us-central1-example-project-id.cloudfunctions.net/example-function-1`.
     * The URI must use HTTPS and point to a site with a valid SSL certificate on
     * the web server. The URI must have a maximum string length of 128 characters
     * & use only the allowlisted characters from [RFC
     * 1738](https://www.rfc-editor.org/rfc/rfc1738).
     * When your webhook server receives a notification, it is expected to reply
     * with an HTTP response status code of 200 within 5 seconds.
     * A URI is required to use webhook notifications.
     * Requests to this webhook server will contain an ID token authenticating the
     * service account
     * `google-analytics-audience-export&#64;system.gserviceaccount.com`. To learn
     * more about ID tokens, see
     * https://cloud.google.com/docs/authentication/token-types#id. For Google
     * Cloud Functions, this lets you configure your function to require
     * authentication. In Cloud IAM, you will need to grant the service account
     * permissions to the Cloud Run Invoker (`roles/run.invoker`) & Cloud
     * Functions Invoker (`roles/cloudfunctions.invoker`) roles for the webhook
     * post request to pass Google Cloud Functions authentication. This API can
     * send webhook notifications to arbitrary URIs; for webhook servers other
     * than Google Cloud Functions, this ID token in the authorization bearer
     * header should be ignored if it is not needed.
     *
     * Generated from protobuf field <code>optional string uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getUri()
    {
        return isset($this->uri) ? $this->uri : '';
    }

    public function hasUri()
    {
        return isset($this->uri);
    }

    public function clearUri()
    {
        unset($this->uri);
    }

    /**
     * Optional. The web address that will receive the webhook notification. This
     * address will receive POST requests as the state of the long running
     * operation resource changes. The POST request will contain both a JSON
     * version of the long running operation resource in the body and a
     * `sentTimestamp` field. The sent timestamp will specify the unix
     * microseconds since the epoch that the request was sent; this lets you
     * identify replayed notifications.
     * An example URI is
     * `https://us-central1-example-project-id.cloudfunctions.net/example-function-1`.
     * The URI must use HTTPS and point to a site with a valid SSL certificate on
     * the web server. The URI must have a maximum string length of 128 characters
     * & use only the allowlisted characters from [RFC
     * 1738](https://www.rfc-editor.org/rfc/rfc1738).
     * When your webhook server receives a notification, it is expected to reply
     * with an HTTP response status code of 200 within 5 seconds.
     * A URI is required to use webhook notifications.
     * Requests to this webhook server will contain an ID token authenticating the
     * service account
     * `google-analytics-audience-export&#64;system.gserviceaccount.com`. To learn
     * more about ID tokens, see
     * https://cloud.google.com/docs/authentication/token-types#id. For Google
     * Cloud Functions, this lets you configure your function to require
     * authentication. In Cloud IAM, you will need to grant the service account
     * permissions to the Cloud Run Invoker (`roles/run.invoker`) & Cloud
     * Functions Invoker (`roles/cloudfunctions.invoker`) roles for the webhook
     * post request to pass Google Cloud Functions authentication. This API can
     * send webhook notifications to arbitrary URIs; for webhook servers other
     * than Google Cloud Functions, this ID token in the authorization bearer
     * header should be ignored if it is not needed.
     *
     * Generated from protobuf field <code>optional string uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->uri = $var;

        return $this;
    }

    /**
     * Optional. The channel token is an arbitrary string value and must have a
     * maximum string length of 64 characters. Channel tokens allow you to verify
     * the source of a webhook notification. This guards against the message being
     * spoofed. The channel token will be specified in the `X-Goog-Channel-Token`
     * HTTP header of the webhook POST request.
     * A channel token is not required to use webhook notifications.
     *
     * Generated from protobuf field <code>optional string channel_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getChannelToken()
    {
        return isset($this->channel_token) ? $this->channel_token : '';
    }

    public function hasChannelToken()
    {
        return isset($this->channel_token);
    }

    public function clearChannelToken()
    {
        unset($this->channel_token);
    }

    /**
     * Optional. The channel token is an arbitrary string value and must have a
     * maximum string length of 64 characters. Channel tokens allow you to verify
     * the source of a webhook notification. This guards against the message being
     * spoofed. The channel token will be specified in the `X-Goog-Channel-Token`
     * HTTP header of the webhook POST request.
     * A channel token is not required to use webhook notifications.
     *
     * Generated from protobuf field <code>optional string channel_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setChannelToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->channel_token = $var;

        return $this;
    }

}

